function gendat!(mη, μ, X, Y)
    N = length(Y)
    rn = 0.5randn(N)
    view(X, :, 2) .= rn .+ μ
    Y .= rand(N) .< s.(rn .* b1 .+ mη)
    return X, Y
end

function genX!(mη, μ, X)
    N = length(μ)
    rn = 0.5randn(N)
    view(X, :, 2) .= rn .+ μ
    return nothing
end

function gendat!(n, case, beta0, X, Y)
    d = length(beta0)
    dz = d - 1
    corr  = 0.5
    sigmax = corr.^abs.((1:dz) .- (1:dz)')
    # σ = 1 ./ sqrt.(1:dz); sigmax = σ .* sigmax .* σ'
    _,sig = cholesky(sigmax)
    Z = view(X, :, 2:d)
    η = Array{Float64}(undef, n)
    if case == 1 # Normal
        Z .= randn.();
        rmul!(Z, sig)
    elseif case == 2 # lognormal
        Z .= randn.()
        rmul!(Z, sig)
        Z .= exp.(Z)
    elseif case == 3 # T3
        Z .= randn.()
        rmul!(Z, sig)
        df = 3
        η .= sqrt.(rand.(Chisq(df))./df) .* 3
        Z .= Z ./ η
    elseif case == 4 # exponential
        Z .= randexp.()
    elseif case == 5 # uniform
        Z .= rand.()
    # elseif case == 6 # discrete
    #     prop=quantile(Normal(), [0.01 0.01 0.5][:,1:3])
    #     dd = length(prop)
    #     Z .= randn.()
    #     rmul!(Z, sig)
    #     # Z[:,1:dd] .= rand.()
    #     Z[:,1:dd] .= Z[:,1:dd] .< prop
    #     Z[:,dd+1] .*= 0.01
    #     Z[:,dd+2:end] .*= 0.01
    #     # Z[:,dd+1:end] .+= 1
    end
    mul!(η, Z, beta0[2:end])
    η .= 1 .- 1 ./ (1 .+ exp.(beta0[1] .+ η))
    Y .= rand.() .< η
end


function genX!(n, case, beta0, X)
    d = length(beta0)
    dz = d - 1
    corr  = 0.5
    sigmax = corr.^abs.((1:dz) .- (1:dz)')
    # σ = 1 ./ sqrt.(1:dz); sigmax = σ .* sigmax .* σ'
    _,sig = cholesky(sigmax)
    Z = view(X, :, 2:d)
    η = Array{Float64}(undef, n)
    if case == 1 # Normal
        Z .= randn.();
        rmul!(Z, sig)
    elseif case == 2 # lognormal
        Z .= randn.()
        #rmul!(Z, sig)
        Z .= exp.(Z)
    elseif case == 3 # T3
        Z .= randn.()
        rmul!(Z, sig)
        df = 3
        η .= sqrt.(rand.(Chisq(df))./df) .* 3
        Z .= Z ./ η
    elseif case == 4 # exponential
        Z .= randexp.()
    elseif case == 5 # uniform
        Z .= rand.()
    elseif case == 6 # discrete
        prop = [0.051 0.051]
        qp=quantile(Normal(), prop)
        dd = length(qp)
        Z .= randn.()
        rmul!(Z, sig)
        # Z[:,1:dd] .= rand.()
        Z[:,1:dd] .= Z[:,1:dd] .< qp
        Z[:,dd+1] .*= 0.01
    end
    # mul!(η, Z, beta0[2:end])
    # η .= 1 .- 1 ./ (1 .+ exp.(beta0[1] .+ η))
    # Y .= rand.() .< η
end

# function genX!(n, case, beta0, X, prop)
#     d = length(beta0)
#     dz = d - 1
#     corr  = 0.5
#     sigmax = corr.^abs.((1:dz) .- (1:dz)')
#     # σ = 1 ./ sqrt.(1:dz); sigmax = σ .* sigmax .* σ'
#     _,sig = cholesky(sigmax)
#     Z = view(X, :, 2:d)
#     η = Array{Float64}(undef, n)
#     if case == 1 # Normal
#         Z .= randn.();
#         rmul!(Z, sig)
#     elseif case == 6 # discrete
#         qp=quantile(Normal(), prop)
#         dd = length(qp)
#         Z .= randn.()
#         rmul!(Z, sig)
#         # Z[:,1:dd] .= rand.()
#         Z[:,1:dd] .= Z[:,1:dd] .< qp
#         Z[:,dd+1] .*= 0.01
#         # Z[:,dd+2:end] .*= 0.01
#         # Z[:,dd+1:end] .+= 1
#     end
# end

function genY!(beta0, X, Y)
    Z = view(X, :, 2:d)
    η = Array{Float64}(undef, length(Y))
    mul!(η, Z, beta0[2:end])
    η .= 1 .- 1 ./ (1 .+ exp.(beta0[1] .+ η))
    Y .= rand.() .< η
end
