using Pkg; Pkg.activate(".")
using LinearAlgebra, Random, Statistics, DelimitedFiles
using Distributions, JDF, DataFrames, Plots, StatsBase, PrettyTables #, GLM
using Revise, ProgressMeter
BLAS.set_num_threads(1)
includet("gendat.jl")
includet("estimators.jl")
# ------------------------------------------------------------------

initime = time()
case = haskey(ENV, "case") ? parse(Int, ENV["case"]) : 1
Random.seed!(1);
N = 10^6 ÷ 2
if case == 1
    beta0 = [-5; -ones(2); 0.01*ones(4)]
elseif case == 2
    beta0 = [-5; -ones(1); zeros(5)]
end
d = length(beta0)
scl = ones(d);
rpt = 500
n0 = 800; n = 1000

ss = [10^(-2), 10^(-1), 1, 10, 10^2]
msepred = Vector{Any}(undef, length(ss))
for (i, sc) in enumerate(ss)
    scl = ones(d); scl[end] *= sc
    Random.seed!(1);
    @time res = simu!(X, Y, beta0, 2, rpt, n, n0, scl, P0, P_tmp);
    tmp = calRes(res, beta0, scl);
    msepred[i] = tmp
end

rec = reduce(hcat, [getfield.(msepred, :mse); getfield.(msepred, :pred)])

show(stdout, "text/plain", rec)
writedlm("simu/output/simu$(case).csv", rec)

# using Pkg; Pkg.activate(".")
using DelimitedFiles, Plots, PrettyTables
case = 1
rec = readdlm("simu/output/simu$(case).csv")

rec_p = rec[:,end÷2+1:end]'
rec_p = rec_p[:, [2, 3, 4, 1]]

mts = ["A-OS" "L-OS" "P-OS" "Uni"]


ss = [10^(-2), 10^(-1), 1, 10, 10^2]
ss = reverse(ss)
plot(ss, rec_p, label=mts,
     ylim=(0.05, 0.35),
     size = 1.2 .*(500, 300),
     #size = (600, 600), 
     lw = 3, markersize = 12,
     markershape=[:circle :rect :star5 :diamond :utriangle],
     tickfontsize=12, xguidefontsize=12, yguidefontsize=12,
     legendfontsize=10, grid=false, thickness_scaling=1, 
     ls = [:solid :dash :dashdot],
     legend=:right
     #legend=:none
     )
xaxis!("s", :log10)
yaxis!("prediction error", :log10)
savefig("output/simu-2lognor-ss.pdf")

print("\n", time() - initime)
# ---------------------------------------------------------------------
