## Exploring Diverse and Ambiguous Events for Weakly Supervised Video Anomaly Detection

### Reference
We referenced the repo below for the code.

* [URDMU](https://github.com/henrryzh1/UR-DMU)

### Setup
```
mkdir -p models list outputs
```


**Feature Files**  
We use the I3D features provided by the authors of UR-DMU. Refer to UR-DMU to make list folder and paths. 
Please download the feature files manually and update the dataset paths in:
- `list/UCF_Train.list`
- `list/UCF_Test.list`
- Login to wandb and use your key one time # wandb.login(key=" ") `utilis.py`

### Train

#### UCF-Crime

1. **Generate temporal cluster:**

```
python ucf_gen_cluster.py
```
2. **Train the ensemble model:**

```
python ucf_main_en.py

```

#### XD-Violence

1. **Generate temporal cluster:**

```
python xd_gen_cluster.py
```
2. **Train the ensemble model:**

```
python xd_main_en.py
```


