import argparse
from random import seed
import os

def parse_args():
    descript = 'Pytorch Implementation of Dual Exploration'
    parser = argparse.ArgumentParser(description = descript)
    parser.add_argument('--output_path', type = str, default = 'outputs/')
    parser.add_argument('--root_dir', type = str, default = 'outputs/')
    parser.add_argument('--log_path', type = str, default = 'logs/')
    parser.add_argument('--modal', type = str, default = 'rgb',choices = ["rgb,flow,both"])
    parser.add_argument('--model_path', type = str, default = 'models/')
    parser.add_argument('--lr', type = str, default = '[0.0001]*3000', help = 'learning rates for steps(list form)')
    parser.add_argument('--batch_size', type = int, default = 64)
    parser.add_argument('--num_workers', type = int, default = 16)
    parser.add_argument('--num_segments', type = int, default = 32)
    parser.add_argument('--seed', type = int, default = 725, help = 'random seed (-1 for no manual seed)')
    parser.add_argument('--model_file', type = str, default = "trans_{}.pkl".format(seed), help = 'the path of pre-trained model file')
    parser.add_argument('--debug', action = 'store_true')
    
    parser.add_argument('--run', type=str, default="ucf_dual_explore", help='name of the run')
    parser.add_argument('--use_cluster', default=True)
    parser.add_argument('--cluster_file', type = str, default = 'xd_temporal_cluster/xd_temporal_cluster_q_0.03_9521.pth')
    parser.add_argument('--tau_a', default=0.955, help='temporal clusterting threshold for anomaly segments')

    parser.add_argument('--use_uncertainty', default=True)
    parser.add_argument('--uncertainty_file', type = str, default = None)
    parser.add_argument('--un_th', type=float, default=0.2, help='uncertainty threshold for anomaly segments')
    parser.add_argument('--alpha', type=float, default=1, help='uncertainty loss weight')


    return init_args(parser.parse_args())


def init_args(args):
    if not os.path.exists(args.model_path):
        os.makedirs(args.model_path)
    if not os.path.exists(args.output_path):
        os.makedirs(args.output_path)

    return args
