# Code for our experimental results

We provide the code base that we used to produce our main experiments and figures. All our implementation has been done in python, tested with python `3.9`.

## Installation and automatic tests

You can create a virtual environment and install the required packages through the provided `requirements.txt` file.
````
python -m pip install -r requirements.txt
````

| :memo:        | This will install a cpu-only version of pytorch, feel free to install torch and torchvision according to your CUDA version.        |
|---------------|:------------------------|


## Tests

We provide some pytests to assess that the installation went well:
````
pip install pytest && pytest -x -vv
````
All tests should pass.

## Examples of computation of topological complexities

We provide an example of distance matrix typically generated by our experiments in the folder `results_example/distance_matrix/`, in order to compute $E_\alpha$, $\mathrm{Mag(t)}$ (by default $t = \sqrt{n}$ where $n$ is the size of the training set in the CIFAR10 dataset) and $\mathrm{PMag(t)}$, you can use the following command:
````
PYTHONPATH=$PWD python analysis/compute_all_complexities.py results_example/distance_matrix/dist_matrix_9_small.npy
````
This will create a file `results_example/distance_matrix/topological_complexities.json` containing the desired quantities.
This distance matrix corresponds to an experiment with the ViT on CIFAR10. 

**Remark:** Our experiments use trajectories of size $5000$, however, due to size restriction of the submitted file, the matrix used in the above example corresponds to a subset of a trajectory of $1000$ points.

## Main experiments and experimental procedure

The code for the main experiments can be found in the folder `PHDim`, several models, in particular Vision transformers, can be found in the folder `models`. The folder `analysis` contain the source code to compute all the quantities that appear in our work, namely $E_\alpha$, magnitude, positive magnitude as well as the persistent homology dimension.

The general command to run one experiment is the following (linux):

````
PYTHONPATH=$PWD python -m PHDim [--args ARGS]
````
As an example, the following command will run the ViT on the CIFAR10 dataset, for a $6\times 6$ grid of hyperparameters with learning rate varying in $[10^{-5}, 10^{-3}]$ and batch size varying in $[8, 256]$ (the optimizer is ADAM by default). The flag `--ripser_points 5000` indicates that the distance matrices will be computed based on the last 5000 iterations, the flag `--iterations ITERATIONS` indicates that `ITERARIONS` iterations will be done before starting the computation of the distance matrices. This run would reproduce some of our experimental results.

````
PYTHONPATH=$PWD python -m PHDim --iterations ITERATIONS --ripser_points 5000 --dataset cifar10 --model vit --lrmin 1.e-5 --lrmax 1.e-3 --bs_min 8 --bs_max 256 --num_exp_lr 6 --num_exp_bs 6 [--args ARGS]
````


**remark.** this will run the 36 experiments sequentially. We recommend running them in parallel as much as possible to avoid too long computation times.

**remark.** Our experiments are conducted near local minima, where the topology of the trajectories is the most intersting. We recommend starting the experiments from pretrained weights with very good training accuracy and use the flag `--iteration 1` (in our experiments, we started from pretrained weights achieving $95.3\%$ training accuracy).


Additional arguments can be passed to the function, they can be found in `PHDim/__main__.py`. Calling this script will launch individual trainings on a specified grid of hyperparameters. Each of these individual trainings are implemented in the script `train_risk_analysis.py`. A brief description of each hyperparameters is given in the script `PHDim/__main__.py`.

Calling this script creates a folder identified by the date and time, inside the specified `save_folder`. This folder is denoted `RESULTS_FOLDER` and contain all distance matrices as well as computed train accuracies, test accuracies and other quantities. The experimental procedure is then the following, run:


````
python analysis/merge.py RESULT_FOLDER
````
This will create a file `all_results.json`. The plots and granulated Kendall's coefficients can then be generated by the scripts in the `analysis` folder. The script `analysis/all_plots.py` computes all quantities contained in the list of callables `FUNCTIONS` (by default $E_1$ and $\mathrm{Mag}(\sqrt{n})$).
````
python analysis/all_plots.py RESULT_FOLDER/all_results.json
````
The argument stem specifies the list of distance matrices to be used:
 - if stem if `""` (default), then the data-dependent pseudo-distance $\rho_S$ is used, with:
 $$
  \rho_S (w,w') = \frac{1}{n} \sum_{i=1}^n |\ell(w,z_i) - \ell(w',z_i)|.
 $$
 - `"_euclidean"` means that the Euclidean distance in $\mathbb{R}^d$ is used.
 - `"_01"` the distance matrix described as $01$-pseudometric is used.


