from modules.args import get_args
from modules.algorithms.cd import DAS, SCORE
from modules.utils import get_data

args = get_args()
graph_type = args.graph_type
d = args.d
s0 = args.s0
N = args.N
GP = args.GP

X, A = get_data(graph_type, d, s0, N, GP)

pruning = args.pruning
if pruning == 'DAS' or pruning == "DASBoost":
    algorithm = DAS(X, A, **vars(args))
elif pruning == 'CAM':
    algorithm = SCORE(X, A, **vars(args))

algorithm.inference()