#!/bin/bash 

LOG_PATH=./logs/baseline_eval_zero_shot

if [ ! -d $LOG_PATH ]; then
    mkdir -p $LOG_PATH
    echo "Created directory: $LOG_PATH"
else
    echo "Directory already exists: $LOG_PATH"
fi

MODEL_NAME_LIST=(
    "llama-2-13b"
    "llama-1-13b"
    "llama-1-33b"
)

SPARSITY_RATIO_LIST=(
    0.25
    
    0.5
)

SPARSITY_TYPE_LIST=(
    "2:8"
    
    "4:8"
)


GPUS=(7) 


experiment_count=0


job_pids=()


gpu_to_pid=()


while true; do
    
    for gpu in "${GPUS[@]}"; do
        
        if [[ -z "${gpu_to_pid[$gpu]}" ]] || ! kill -0 "${gpu_to_pid[$gpu]}" 2>/dev/null; then
            echo "GPU $gpu is free or job exited, starting a new experiment"
            
            
            MODEL_NAME=${MODEL_NAME_LIST[$((experiment_count / 3))]}
            SPARSITY_RATIO=${SPARSITY_RATIO_LIST[$((experiment_count % 3))]}
            SPARSITY_TYPE=${SPARSITY_TYPE_LIST[$((experiment_count % 3))]}
            
            echo "Starting experiment $((experiment_count + 1)) on GPU $gpu with Model: $MODEL_NAME, Sparsity ratio: $SPARSITY_RATIO, Sparsity type: $SPARSITY_TYPE"


            CUDA_VISIBLE_DEVICES=$gpu python3 run.py /path/to/${MODEL_NAME} c4 braq --blocksize 128 \
                --salient_metric hessian \
                --prune_method si_structure \
                --reconstruction \
                --Lamda 2 \
                --Hyper_m 6 \
                --eval_zero_shot \
                --sparsity_ratio ${SPARSITY_RATIO} \
                --sparsity_type ${SPARSITY_TYPE} > $LOG_PATH/zero-shot_stbllm_${MODEL_NAME}_c4_si-structure-${SPARSITY_TYPE}-${SPARSITY_RATIO}-wrec_hessian-4mask-billm-160_main.log 2>&1 &

            
            
            job_pids+=($!)
            
            gpu_to_pid[$gpu]=$!
            
            ((experiment_count++))

            
            if ((experiment_count >= ${
                echo "All experiments completed."
                exit 0
            fi
        fi
    done

    
    sleep 1
done
