## Install environment (Python>=3.10)
```
python -m venv .venv
.venv\Scripts\activate
pip install -r requirements.txt
```
- Please, install the [PyTorch](https://pytorch.org/get-started/locally/) distribution for your hardware.

## Paper results
You can download the results of the experiments discussed in the paper at this [link](https://surfdrive.surf.nl/files/index.php/s/SxLZjMFutJfnyBG).\
Once downloaded, unzip and place the entire content in `ENFORCE\training_output`. The content provides all the raw experimental results, for function fitting and optimization problem learning.\
Every experimental run contains a descriptive `readme.txt` file, model weights, runs parameters, and (especially for function fitting) plots of the results and loss curves.\
The appendix figures about memory requirements can be reproduced from the notebook `ENFORCE\notebooks\memory.ipynb`.
### Function fitting
You can visualize and reproduce the appendix figures about function fitting and hyperparameters study from the notebook `ENFORCE\notebooks\results_analysis.ipynb`.
### Optimization problem
A summary of the results are organized in `ENFORCE\reports\opt_problem_learning.xlsx`.
The raw results from the baseline state-of-the-art [DC3: A learning method for optimization with hard constraints](https://arxiv.org/abs/2104.12225) can be downloaded [here](https://surfdrive.surf.nl/files/index.php/s/wLXWpIOFABXmZh7). Unzip the folder and place the content in the `results` directory of the cloned repository `DC3` (provided in the Supplemental Material together with this code). The results can be visualized by running the notebook `DC3\results_visualization.ipynb`.


## Dataset
### Function fitting
The data are automatically generated at runtime. The specifications for data generation (e.g., datasets size, range) can be set from `ENFORCE\configs\config.py`. We suggest not to change those parameters to reproduce the paper results.

### Optimization problem
The problem instances are generated using the benchmarking routine established by Donti et al. in [DC3: A learning method for optimization with hard constraints](https://arxiv.org/abs/2104.12225).
You can download the data [here](https://surfdrive.surf.nl/files/index.php/s/apwbDVQZkvKzv6b), unzip, and place the content in `ENFORCE\data` to reproduce the results.\
If you want to generate new data, you can do that from the `DC3` repository. A cloned version is provided in the Supplemental Material together with this code. The repository contains a new implementation to generate instances of nonconvex problems with nonlinear constraints (which was not provided in the original version).
To generate the data, please follow the instructions in the `DC3` repository to install the necessary dependencies (we suggest using Anaconda distribution here to run IPOPT in Python).
Once completed the installation, you can generate data in the following way from the `DC3` repository:
- Nonconvex with linear constraints: 
  - Set the parameters in `dataset\nonconvex\make_dataset.py`
  - Run from the root `python dataset\nonconvex\make_dataset.py`
- Nonconvex with nonlinear constraints:
  - Set the parameters in `dataset\nonconvex_nonlinear_eq\make_dataset.py`
  - Run from the root `python dataset\nonconvex_nonlinear_eq\make_dataset.py`

### Real-world engineering case study: Extraction Column
We use the extraction column dataset from the paper [Physics-Informed Neural Networks with Hard Nonlinear Equality and Inequality Constraints](https://arxiv.org/abs/2507.08124), which is shared in this repository: https://github.com/SOULS-TAMU/kkt-hardnet

## Reproduce the paper results
From the `ENFORCE` repository:
### Function fitting
Navigate to `src\config\config.py`. Set the following parameters:
```python
# Hard Constraints settings
MODEL = "ENFORCE"  # Model type, options: "ENFORCE", "MLP", "BOTH" (change to benchmark different methods)

# Problem settings
PROBLEM = "function_fitting"

# Soft Constraints settings (change for benchmarking Soft constrained method)
SOFT_CONSTRAINED = False
WEIGHT_LOSS_SOFT = 0
```
Run:
```
python main.py
```

To reproduce the constrained learning hyperparameters study:
```
bash run_combinations.sh
```

### Optimization problem
#### Nonconvex with linear constraints
Navigate to `src\config\config.py`. Set the following parameters:
```python
# Hard Constraints settings
MODEL = "ENFORCE"  # Model type, options: "ENFORCE", "MLP", "BOTH" (change to benchmark different methods)

# Problem settings
PROBLEM = "nonconvex_linear"

# Soft Constraints settings (change for benchmarking Soft constrained method)
SOFT_CONSTRAINED = False
WEIGHT_LOSS_SOFT = 0
```
Run:
```
python main.py
```

#### Nonconvex with nonlinear constraints
Navigate to `src\config\config.py`. Set the following parameters:
```python
# Hard Constraints settings
MODEL = "ENFORCE"  # Model type, options: "ENFORCE", "MLP", "BOTH" (change to benchmark different methods)

# Problem settings
PROBLEM = "nonconvex_nonlinear"

# Soft Constraints settings (change for benchmarking Soft constrained method)
SOFT_CONSTRAINED = False
WEIGHT_LOSS_SOFT = 0
```
Run:
```
python main.py
```

#### Nonconvex with linear constraints (DC3)
To reproduce the results of the baseline DC3 method, you can follow the instructions in the `DC3` repository provided in the Supplemental Material.
Before running the experiments, download the data [here](https://surfdrive.surf.nl/files/index.php/s/Fcp88z42eg5OppE), unzip, and place in `DC3\data`.

### Real-world engineering case study: Extraction Column
Navigate to `configs\config.py`. Set the following parameters:
```python
# Hard Constraints settings
MODEL = "ENFORCE"  # Model type, options: "ENFORCE", "MLP", "BOTH" (change to benchmark different methods)

# Problem settings
PROBLEM = "extraction_column"

# Soft Constraints settings (change for benchmarking Soft constrained method)
SOFT_CONSTRAINED = False
WEIGHT_LOSS_SOFT = 0
```
Run:
```
python main.py
```

The baseline results for the real-wrold case study can be found in Section 4.3 of the paper [Physics-Informed Neural Networks with Hard Nonlinear Equality and Inequality Constraints](https://arxiv.org/abs/2507.08124).