import numpy as np
import pickle
import torch
import pandas as pd
import sys
import os
sys.path.insert(1, os.path.join(sys.path[0], os.pardir, os.pardir))
from utils import NonconvexProblem

import os
os.environ['KMP_DUPLICATE_LIB_OK']='True'

torch.set_default_dtype(torch.float64)

num_var = 100
num_ineq = 0
num_eq = 70
num_examples = 10000

np.random.seed(17)

Q = np.diag(np.random.random(num_var))
p = np.random.random(num_var)
c = np.random.normal(loc=0, scale=1., size=(num_eq, num_var))
lb = -5
ub = 5
X = np.random.uniform(lb, ub, size=(num_examples, num_eq))
G = np.random.normal(loc=0, scale=1., size=(num_ineq, num_var))
h = np.sum(np.abs(G@np.linalg.pinv(c)), axis=1)

problem = NonconvexProblem(Q, p, c, G, h, X)
problem.calc_Y()
print(len(problem.Y))

# filename = f"random_nonconvex_dataset_var{num_var}_ineq{num_ineq}_eq{num_eq}_ex{num_examples}_int{lb}_{ub}.pkl"
# with open(f"./data/nonconvexlinear/{filename}", 'wb') as f:
#     pickle.dump(problem, f)

# # === Extract X and Y ===
# X = problem._X
# Y = problem._Y

# # === Create a table of the first few dimensions ===

# df = pd.DataFrame(X, columns=[f"X[{i}]" for i in range(num_eq)])
# df = pd.concat([df, pd.DataFrame(Y, columns=[f"Y[{i}]" for i in range(num_var)])], axis=1)

# # Save the dataset in csv format
# X_df = pd.DataFrame(X, columns=[f"X[{i}]" for i in range(X.shape[1])])
# Y_df = pd.DataFrame(Y, columns=[f"Y[{i}]" for i in range(Y.shape[1])])
# X_df.to_csv(f"data/nonconvexlinear/X_data_{filename.split('.')[0]}.csv", index=False)
# Y_df.to_csv(f"data/nonconvexlinear/Y_data_{filename.split('.')[0]}.csv", index=False)
# print("Saved X and Y data to csv files")

# parameters = {
#     # "A": problem._A,
#     "c": problem._c,
#     # "d": problem._d,
#     "Q": problem._Q,
#     "p": problem._p,
# }
# with open(f"data/nonconvexlinear/parameters_{filename}", 'wb') as f:
#     pickle.dump(parameters, f)

# print("Saved problem parameters to pickle file")