# General settings
PLOT = True
SAVE = True
FIX_SEED = False            # Fix seed for reproducibility (among different runs)
N = 5                       # Number of runs

# Hard Constraints settings
# (select "MLP" and config soft constraints below for soft constraints method, select "BOTH" to run both models sequentially in a single run)
MODEL = "ENFORCE"  # Model type, options: "ENFORCE", "MLP", "BOTH" 

# Problem settings
PROBLEM = "function_fitting"       # Problem type, options: "function_fitting", "nonconvex_linear", "nonconvex_nonlinear"

# Optimization settings (only relevant if PROBLEM is "nonconvex_linear" or "nonconvex_nonlinear")
N_VARIABLES_OPT = 100         # Number of variables (optimization variables)
N_CONSTRAINTS_OPT = 50          # Number of constraints (optimization constraints)

# Soft Constraints settings
SOFT_CONSTRAINED = False
WEIGHT_LOSS_SOFT = 0


################################################################################
# Do not change anything below if you want to reproduce the paper's results #
################################################################################
VERBOSE = False

# Hard Constraints settings
if PROBLEM == "function_fitting":
    WEIGHT_LOSS_DISPLACEMENT = 0.5
    EPOCH_START_HARD_CONSTRAINED = 0
    TRAINING_TOLERANCE = 0.0001
    INFERENCE_TOLERANCE = 1e-6
    MAX_IT = 100
    PROJ_WEIGHTING_OPTION = 1
elif PROBLEM == "nonconvex_linear" or PROBLEM == "nonconvex_nonlinear":
    WEIGHT_LOSS_DISPLACEMENT = 0.5
    EPOCH_START_HARD_CONSTRAINED = 0
    TRAINING_TOLERANCE = 1e-3
    INFERENCE_TOLERANCE = 1e-3
    MAX_IT = 100
    PROJ_WEIGHTING_OPTION = 1

# NN settings
if PROBLEM == "function_fitting":
    INPUT_NEURONS = 1
    HIDDEN_NEURONS = 64
    OUTPUT_NEURONS = 2
    HIDDEN_LAYERS = 1
    # Learning mode
    SUPERVISED = True  # True for supervised learning, False for unsupervised learning

elif PROBLEM == "nonconvex_linear" or PROBLEM == "nonconvex_nonlinear":
    INPUT_NEURONS = N_CONSTRAINTS_OPT
    HIDDEN_NEURONS = 200
    OUTPUT_NEURONS = N_VARIABLES_OPT
    HIDDEN_LAYERS = 2
    # Learning mode
    SUPERVISED = False  # True for supervised learning, False for unsupervised learning

if PROBLEM == "function_fitting":
    # Training settings
    EPOCHS = 50000
    LEARNING_RATE = 0.001
    BATCH_SIZE = 1000
elif PROBLEM == "nonconvex_linear" or PROBLEM == "nonconvex_nonlinear":
    EPOCHS = 1000
    LEARNING_RATE = 0.0001
    BATCH_SIZE = 200

# Data generation settings (only relevant for function fitting)
DATA_TRAINING = 1000
DATA_TEST = 100000
LEFT_LIMIT = (-2.)
RIGHT_LIMIT = (2.)

# Optimization problem data
INPUT_DATA_PATH = f"data/raw/{PROBLEM}/X_data_random_nonlinearnonconvex_dataset_dim{N_VARIABLES_OPT}_eq{N_CONSTRAINTS_OPT}_ex10000_int-5_5.csv"
OUTPUT_DATA_PATH = f"data/raw/{PROBLEM}/Y_data_random_nonlinearnonconvex_dataset_dim{N_VARIABLES_OPT}_eq{N_CONSTRAINTS_OPT}_ex10000_int-5_5.csv"
PARAMS_PATH = f"data/raw/{PROBLEM}/parameters_random_nonlinearnonconvex_dataset_dim{N_VARIABLES_OPT}_eq{N_CONSTRAINTS_OPT}_ex10000_int-5_5.pkl"

# Output directories
if PROBLEM == "function_fitting":
    TRAINING_DIR = "training_output"  # Base directory for training outputs
elif PROBLEM == "nonconvex_linear" or PROBLEM == "nonconvex_nonlinear":
    TRAINING_DIR = f"training_output/{N_CONSTRAINTS_OPT}"