#!/bin/bash

# Define the lists of values for the parameters
weight_loss_displacement_values=(0 0.001 0.1 0.25 0.5 0.75 1.0 2.0)
training_tolerance_values=(0.00001 0.0001 0.001 0.01 0.1 1)

# Base config file path
config_file="configs/config.py"

# Backup the original config file
cp $config_file "${config_file}.bak"

sed -i 's/^PLOT = True/PLOT = False/' "$config_file"
sed -i '/^if PROBLEM == "function_fitting"/,/^elif PROBLEM == "nonconvex_linear"/ s|^[[:space:]]*TRAINING_DIR = .*|    TRAINING_DIR = "training_output/lambda_epsilon_5_runs"  # Base directory for training outputs|' "$config_file"
# Iterate over all combinations of the parameter values
for weight_loss_displacement in "${weight_loss_displacement_values[@]}"; do
    for training_tolerance in "${training_tolerance_values[@]}"; do

        # Modify the config.py file with the current parameter values
        sed -i '/^if PROBLEM == "function_fitting"/,/^elif PROBLEM == "nonconvex_linear"/ s/^[[:space:]]*WEIGHT_LOSS_DISPLACEMENT = .*/    WEIGHT_LOSS_DISPLACEMENT = '"$weight_loss_displacement"'/' "$config_file"
        sed -i '/^if PROBLEM == "function_fitting"/,/^elif PROBLEM == "nonconvex_linear"/ s/^[[:space:]]*TRAINING_TOLERANCE = .*/    TRAINING_TOLERANCE = '"$training_tolerance"'/' "$config_file"


        # Optionally, save the modified config file to a unique filename
        output_config="configs/config.py"
        cp $config_file $output_config

        # Run the main.py script
        echo "Running main.py with WEIGHT_LOSS_DISPLACEMENT=$weight_loss_displacement and TRAINING_TOLERANCE=$training_tolerance"
        python main.py

    done
done

# Restore the original config.py file
mv "${config_file}.bak" $config_file
