import ray

"""Only works with ray 2.6.3"""

show_cluster_status = [False]
previous_status = ""


def patch():
    from ray.data._internal.execution.operators.actor_pool_map_operator import (
        ActorPoolMapOperator,
        _ActorPool,
    )

    from ray.data._internal.execution.interfaces import ExecutionResources

    def num_full_tasks_in_flight_workers(self):
        """Return the number of workers that cannot accept more tasks."""
        return sum(
            1 if tasks_in_flight >= self._max_tasks_in_flight else 0
            for tasks_in_flight in self._num_tasks_in_flight.values()
        )

    setattr(
        _ActorPool, "num_full_tasks_in_flight_workers", num_full_tasks_in_flight_workers
    )

    setattr(
        ActorPoolMapOperator,
        "_should_scale_up_bug_fix_old__scale_up_if_needed",
        ActorPoolMapOperator._scale_up_if_needed,
    )

    def _scale_up_if_needed(self):
        """Try to scale up the pool if the autoscaling policy allows it."""
        while self._autoscaling_policy.should_scale_up(
            num_total_workers=self._actor_pool.num_total_actors(),
            #  num_running_workers=self._actor_pool.num_running_actors(),
            num_running_workers=self._actor_pool.num_full_tasks_in_flight_workers(),
        ):
            self._start_actor()

    setattr(
        ActorPoolMapOperator,
        "_scale_up_if_needed",
        _scale_up_if_needed,
    )

    setattr(
        ActorPoolMapOperator,
        "_should_scale_up_bug_fix_old_incremental_resource_usage",
        ActorPoolMapOperator.incremental_resource_usage,
    )

    def incremental_resource_usage(self) -> ExecutionResources:
        global show_cluster_status, previous_status
        if show_cluster_status[0]:
            content = f"""`incremental_resource_usage` called.
num_total_actors: {self._actor_pool.num_total_actors()}, 
num_full_tasks_in_flight_workers: {self._actor_pool.num_full_tasks_in_flight_workers()}
_num_tasks_in_flight: {self._actor_pool._num_tasks_in_flight}
_max_tasks_in_flight: {self._actor_pool._max_tasks_in_flight}
ray_remote_args: {self._ray_remote_args}
max_workers: {self._autoscaling_policy._config.max_workers}
should_scale_up: {self._autoscaling_policy.should_scale_up( num_total_workers=self._actor_pool.num_total_actors(), num_running_workers=self._actor_pool.num_full_tasks_in_flight_workers(), )}
"""
            if content != previous_status:
                print(content)
                previous_status = content

        # We would only have nonzero incremental CPU/GPU resources if a new task would
        # require scale-up to run.
        if self._autoscaling_policy.should_scale_up(
            num_total_workers=self._actor_pool.num_total_actors(),
            #  num_running_workers=self._actor_pool.num_running_actors(),
            num_running_workers=self._actor_pool.num_full_tasks_in_flight_workers(),
        ):
            # A new task would trigger scale-up, so we include the actor resouce
            # requests in the incremental resources.
            num_cpus = self._ray_remote_args.get("num_cpus", 0)
            num_gpus = self._ray_remote_args.get("num_gpus", 0)
        else:
            # A new task wouldn't trigger scale-up, so we consider the incremental
            # compute resources to be 0.
            num_cpus = 0
            num_gpus = 0
        return ExecutionResources(cpu=num_cpus, gpu=num_gpus)

    setattr(
        ActorPoolMapOperator,
        "incremental_resource_usage",
        incremental_resource_usage,
    )
