import time
import wandb
import numpy as np
from functools import reduce
import torch
from tqdm import tqdm
from runner.shared.base_runner import Runner


def _t2n(x):
    return x.detach().cpu().numpy()


def faulty_action(action, faulty_node):
    action_fault = action.copy()
    if faulty_node >= 0:
        action_fault[:, faulty_node, :] = 0.
        # action[:, faulty_node, :] = 0.
    # return action
    return action_fault


class MujocoRunner(Runner):
    """Runner class to perform training, evaluation. and data collection for SMAC. See parent class for details."""
    def __init__(self, config):
        super(MujocoRunner, self).__init__(config)

    def run(self):
        self.warmup()

        start = time.time()
        episodes = int(self.num_env_steps) // self.episode_length // self.n_rollout_threads

        train_episode_rewards = [0 for _ in range(self.n_rollout_threads)]
        done_episodes_rewards = []

        for episode in range(episodes):
            if self.use_linear_lr_decay:
                self.trainer.policy.lr_decay(episode, episodes)

            for step in range(self.episode_length):
                # Sample actions
                values, actions, action_log_probs, rnn_states, rnn_states_critic = self.collect(step)
                # actions = faulty_action(actions, self.all_args.faulty_node)
                #
                # # Obser reward and next obs
                # obs, share_obs, rewards, dones, infos, available_actions = self.envs.step(actions)

                actions_fault = faulty_action(actions, self.all_args.faulty_node)

                # Obser reward and next obs
                obs, share_obs, rewards, dones, infos, available_actions = self.envs.step(actions_fault)

                dones_env = np.all(dones, axis=1)
                reward_env = np.mean(rewards, axis=1).flatten()
                train_episode_rewards += reward_env
                for t in range(self.n_rollout_threads):
                    if dones_env[t]:
                        done_episodes_rewards.append(train_episode_rewards[t])
                        train_episode_rewards[t] = 0

                data = obs, share_obs, rewards, dones, infos, available_actions, \
                       values, actions, action_log_probs, \
                       rnn_states, rnn_states_critic

                # insert data into buffer
                self.insert(data)

            # compute return and update network
            self.compute()
            train_infos = self.train()

            # post process
            total_num_steps = (episode + 1) * self.episode_length * self.n_rollout_threads
            # save model
            if (episode % self.save_interval == 0 or episode == episodes - 1):
                self.save(episode)

            # log information
            if episode % self.log_interval == 0:
                end = time.time()
                print("\n Scenario {} Algo {} Exp {} updates {}/{} episodes, total num timesteps {}/{}, FPS {}.\n"
                        .format(self.all_args.scenario,
                                self.algorithm_name,
                                self.experiment_name,
                                episode,
                                episodes,
                                total_num_steps,
                                self.num_env_steps,
                                int(total_num_steps / (end - start))))

                self.log_train(train_infos, total_num_steps)

                if len(done_episodes_rewards) > 0:
                    aver_episode_rewards = np.mean(done_episodes_rewards)
                    print("some episodes done, average rewards: ", aver_episode_rewards)
                    self.writter.add_scalars("train_episode_rewards", {"aver_rewards": aver_episode_rewards}, total_num_steps)
                    done_episodes_rewards = []

            # eval
            if episode % self.eval_interval == 0 and self.use_eval:
                faulty_nodes = self.all_args.eval_faulty_node
                for node in faulty_nodes:
                    self.eval(total_num_steps, node)

    ############################# my method
    ######## behaviour cloning
    def run_bc(self):
        # # load train set for path
        # with open(self.all_args.train_data_path, 'rb') as f:
        #     train_set = pickle.load(f)
        # train_data_sampler = TrainDataSampler(train_set)
        for ep_i in range(self.all_args.num_epochs):
            # start a training episode
            self.policy.train()
            train_pbar = tqdm(enumerate(range(self.all_args.num_steps_per_epochs)),
                              total=self.all_args.num_steps_per_epochs, mininterval=1 if self.all_args.quick_tqdm else 10)
            all_train_losses = []
            train_infos = {}
            for _ in train_pbar:
                # share_states, states, actions = train_data_sampler.sample_batch_data(batch_size=self.all_args.batch_size, device=self.device)
                # update network and get train info
                train_loss = self.train_offline()
                all_train_losses.append(train_loss)
                # print('train_loss', train_loss)
            print('episode', ep_i, 'mean_loss', np.mean(all_train_losses))
            train_infos['mean_loss'] = np.mean(all_train_losses)
            # eval model at each episode
            if self.use_eval:
                self.eval(ep_i)
            # log medium result to tensorboard
            self.log_train(train_infos, ep_i)
            # save model at each saving interval or at last episode
            if ep_i % self.save_interval == 0 or ep_i == self.all_args.num_epochs - 1:
                self.save(ep_i)

    def train_offline(self):
        # sample data form expert dataset
        share_obs, obs, actions = self.expert_buffer.sample_batch_data(batch_size=self.all_args.batch_size)

        return self.trainer.train_offline(share_obs, obs, actions)
    ######## behaviour cloning

    ######## gail / wail
    def run_gail(self):
        self.warmup()

        start = time.time()
        episodes = int(self.num_env_steps) // self.episode_length // self.n_rollout_threads

        train_episode_rewards = [0 for _ in range(self.n_rollout_threads)]
        done_episodes_rewards = []

        for episode in range(episodes):
            if self.use_linear_lr_decay:
                self.trainer.policy.lr_decay(episode, episodes)

            for step in range(self.episode_length):
                # Sample actions
                values, actions, action_log_probs, action_probs, rnn_states, rnn_states_critic, disc_values = self.collect(step)
                # actions = faulty_action(actions, self.all_args.faulty_node)
                #
                # # Obser reward and next obs
                # obs, share_obs, rewards, dones, infos, available_actions = self.envs.step(actions)

                actions_fault = faulty_action(actions, self.all_args.faulty_node)

                # Obser reward and next obs
                obs, share_obs, rewards, dones, infos, available_actions = self.envs.step(actions_fault)

                dones_env = np.all(dones, axis=1)
                reward_env = np.mean(rewards, axis=1).flatten()
                train_episode_rewards += reward_env
                for t in range(self.n_rollout_threads):
                    if dones_env[t]:
                        done_episodes_rewards.append(train_episode_rewards[t])
                        train_episode_rewards[t] = 0

                data = obs, share_obs, rewards, dones, infos, available_actions, \
                       values, actions, action_log_probs, action_probs, \
                       rnn_states, rnn_states_critic, disc_values

                # insert data into buffer
                self.insert(data)

            # compute return and update network
            self.compute()
            train_infos = self.train()

            # post process
            total_num_steps = (episode + 1) * self.episode_length * self.n_rollout_threads
            # save model
            if (episode % self.save_interval == 0 or episode == episodes - 1):
                self.save(episode)

            # log information
            if episode % self.log_interval == 0:
                end = time.time()
                print("\n Scenario {} Algo {} Exp {} updates {}/{} episodes, total num timesteps {}/{}, FPS {}.\n"
                      .format(self.all_args.scenario,
                              self.algorithm_name,
                              self.experiment_name,
                              episode,
                              episodes,
                              total_num_steps,
                              self.num_env_steps,
                              int(total_num_steps / (end - start))))

                self.log_train(train_infos, total_num_steps)

                if len(done_episodes_rewards) > 0:
                    aver_episode_rewards = np.mean(done_episodes_rewards)
                    print("some episodes done, average rewards: ", aver_episode_rewards)
                    self.writter.add_scalars("train_episode_rewards", {"aver_rewards": aver_episode_rewards}, total_num_steps)
                    done_episodes_rewards = []

            # eval
            if episode % self.eval_interval == 0 and self.use_eval:
                faulty_nodes = self.all_args.eval_faulty_node
                # for node in faulty_nodes:
                #     self.eval(total_num_steps, node)
                self.eval(total_num_steps)

    ######## gail / wail
    ############################# my method

    def warmup(self):
        # reset env
        obs, share_obs, _ = self.envs.reset()

        # replay buffer
        if not self.use_centralized_V:
            share_obs = obs

        self.buffer.share_obs[0] = share_obs.copy()
        self.buffer.obs[0] = obs.copy()
        if self.all_args.mat_use_history:
            self.buffer.history_obs_record[0: self.buffer.history_obs_len - 1] = self.buffer.history_obs_record[1: self.buffer.history_obs_len]
            self.buffer.history_obs_record[:, :, self.buffer.history_obs_len - 1] = _t2n(obs).copy()
            self.buffer.his_obs[0] = self.buffer.history_obs_record.copy()

    @torch.no_grad()
    def collect(self, step):
        self.trainer.prep_rollout()
        value, action, action_log_prob, action_prob, rnn_state, rnn_state_critic, disc_value \
            = self.trainer.policy.get_actions(
            np.concatenate(self.buffer.share_obs[step]),
            np.concatenate(self.buffer.obs[step]),
            self.buffer.get_history_obs_record(),
            np.concatenate(self.buffer.rnn_states[step]),
            np.concatenate(self.buffer.rnn_states_critic[step]),
            np.concatenate(self.buffer.masks[step]))
        # [self.envs, agents, dim]
        values = np.array(np.split(_t2n(value), self.n_rollout_threads))
        actions = np.array(np.split(_t2n(action), self.n_rollout_threads))
        action_log_probs = np.array(np.split(_t2n(action_log_prob), self.n_rollout_threads))
        action_probs = np.array(np.split(_t2n(action_prob), self.n_rollout_threads))
        rnn_states = np.array(np.split(_t2n(rnn_state), self.n_rollout_threads))
        rnn_states_critic = np.array(np.split(_t2n(rnn_state_critic), self.n_rollout_threads))
        disc_values = np.array(np.split(_t2n(disc_value), self.n_rollout_threads))

        return values, actions, action_log_probs, action_probs, rnn_states, rnn_states_critic, disc_values

    def insert(self, data):
        obs, share_obs, rewards, dones, infos, available_actions, \
        values, actions, action_log_probs, action_probs, rnn_states, rnn_states_critic, disc_values = data

        dones_env = np.all(dones, axis=1)

        rnn_states[dones_env == True] = np.zeros(((dones_env == True).sum(), self.num_agents, self.recurrent_N, self.hidden_size), dtype=np.float32)
        rnn_states_critic[dones_env == True] = np.zeros(((dones_env == True).sum(), self.num_agents, *self.buffer.rnn_states_critic.shape[3:]), dtype=np.float32)

        masks = np.ones((self.n_rollout_threads, self.num_agents, 1), dtype=np.float32)
        masks[dones_env == True] = np.zeros(((dones_env == True).sum(), self.num_agents, 1), dtype=np.float32)

        active_masks = np.ones((self.n_rollout_threads, self.num_agents, 1), dtype=np.float32)
        active_masks[dones == True] = np.zeros(((dones == True).sum(), 1), dtype=np.float32)
        active_masks[dones_env == True] = np.ones(((dones_env == True).sum(), self.num_agents, 1), dtype=np.float32)

        # bad_masks = np.array([[[0.0] if info[agent_id]['bad_transition'] else [1.0] for agent_id in range(self.num_agents)] for info in infos])

        if not self.use_centralized_V:
            share_obs = obs

        self.buffer.insert(share_obs, obs, rnn_states, rnn_states_critic,
                           actions, action_log_probs, action_probs, values, rewards, dones, masks, None, active_masks,
                           None, disc_values)

    def log_train(self, train_infos, total_num_steps):
        train_infos["average_step_rewards"] = np.mean(self.buffer.rewards)
        print("average_step_rewards is {}.".format(train_infos["average_step_rewards"]))
        for k, v in train_infos.items():
            if self.use_wandb:
                wandb.log({k: v}, step=total_num_steps)
            else:
                if k != 'disc_expert_score' and k != 'disc_policy_score' and \
                        k != 'all_expert_agent_mean_scores' and k != 'all_policy_agent_mean_scores':
                    self.writter.add_scalars(k, {k: v}, total_num_steps)
                else:
                    self.writter.add_scalars(k, v, total_num_steps)

    @torch.no_grad()
    def eval(self, total_num_steps, faulty_node=-1):
        eval_episode = 0
        eval_episode_rewards = []
        one_episode_rewards = [0 for _ in range(self.all_args.eval_episodes)]

        eval_obs, eval_share_obs, _ = self.eval_envs.reset()
        eval_rnn_states = np.zeros((self.all_args.eval_episodes, self.num_agents, self.recurrent_N,
                                    self.hidden_size), dtype=np.float32)
        eval_masks = np.ones((self.all_args.eval_episodes, self.num_agents, 1), dtype=np.float32)

        while True:
            self.trainer.prep_rollout()
            eval_actions, eval_rnn_states = \
                self.trainer.policy.act(
                    np.concatenate(eval_share_obs),
                    np.concatenate(eval_obs),
                    self.buffer.get_history_obs_record(),
                    np.concatenate(eval_rnn_states),
                    np.concatenate(eval_masks),
                    deterministic=True
                )
            eval_actions = np.array(np.split(_t2n(eval_actions), self.all_args.eval_episodes))
            eval_rnn_states = np.array(np.split(_t2n(eval_rnn_states), self.all_args.eval_episodes))

            # Obser reward and next obs
            eval_actions = faulty_action(eval_actions, faulty_node)
            eval_obs, eval_share_obs, eval_rewards, eval_dones, eval_infos, _ = self.eval_envs.step(eval_actions)
            eval_rewards = np.mean(eval_rewards, axis=1).flatten()
            one_episode_rewards += eval_rewards

            eval_dones_env = np.all(eval_dones, axis=1)
            eval_rnn_states[eval_dones_env == True] = np.zeros(((eval_dones_env == True).sum(), self.num_agents, self.recurrent_N, self.hidden_size), dtype=np.float32)
            eval_masks = np.ones((self.all_args.eval_episodes, self.num_agents, 1), dtype=np.float32)
            eval_masks[eval_dones_env == True] = np.zeros(((eval_dones_env == True).sum(), self.num_agents, 1), dtype=np.float32)

            for eval_i in range(self.all_args.eval_episodes):
                if eval_dones_env[eval_i]:
                    eval_episode += 1
                    eval_episode_rewards.append(one_episode_rewards[eval_i])
                    one_episode_rewards[eval_i] = 0

            if eval_episode >= self.all_args.eval_episodes:
                key_average = 'eval_average_episode_rewards'
                key_max = 'eval_max_episode_rewards'
                eval_env_infos = {key_average: eval_episode_rewards,
                                  key_max: [np.max(eval_episode_rewards)]}
                self.log_env(eval_env_infos, total_num_steps)
                # print("faulty_node {} eval_average_episode_rewards is {}."
                #       .format(faulty_node, np.mean(eval_episode_rewards)))
                print("eval_average_episode_rewards is {}.".format(np.mean(eval_episode_rewards)))
                break
