#!/bin/sh
env="StarCraft2"
map="2c_vs_64zg"
algo="mat"
exp="train_smac_2c_vs_64zg_ppo10_disc5_plr5e-4_dlr5e-6_useGail_useMultiBatch_useMatData_addActEmbd64_useCenterDisc_useDiscWarnup_useMlpDisc"
seed=1

echo "env is ${env}, map is ${map}, algo is ${algo}, exp is ${exp}, seed is ${seed}"
CUDA_VISIBLE_DEVICES=0 python train/train_smac_offline.py --env_name ${env} --algorithm_name ${algo} --experiment_name ${exp} --map_name ${map} --seed ${seed} \
--n_training_threads 16 --n_rollout_threads 32 --num_mini_batch 1 --episode_length 100 --num_env_steps 10000000 --lr 5e-4 --ppo_epoch 10 \
--clip_param 0.05 --save_interval 10 --use_value_active_masks --use_eval \
--use_gail --normalize_advantage --disc_lr 5e-6 --epoch_disc 5 --gamma 0.99 \
--disc_batch_size 128 --disc_use_act_embd --disc_act_embd_dim 64 \
--disc_warm_up --disc_warm_up_round 10 --disc_warm_up_epoch 100 \
--disc_use_mlp \
--train_data_path "/home/LAB/qiuyue/language_condition_MAT/scripts/data/smac_data/2c_vs_64zg_mat_10w/StarCraft2.pkl"

