# OPZO-SNN
This is the PyTorch implementation of the submitted paper: Online Pseudo-Zeroth-Order Training of Neuromorphic Spiking Neural Networks. Please do not distribute.

## Dependencies and Installation
- Python 3 (Recommend to use [Anaconda](https://www.anaconda.com/download/#linux))
- [PyTorch, torchvision](https://pytorch.org/)
- NVIDIA GPU + [CUDA](https://developer.nvidia.com/cuda-downloads)
- Python packages: `pip install numpy opencv-python`

## Training
Run as following examples:

	python train_mnist.py -data_dir path_to_data_dir -out_dir log_checkpoint_name -gpu-id 0
	
	python train_nmnist.py -data_dir path_to_data_dir -out_dir log_checkpoint_name -gpu-id 0
	
	python train_cifar.py -data_dir path_to_data_dir -out_dir log_checkpoint_name -gpu-id 0
	
	python train_cifar10dvs.py -data_dir path_to_data_dir -out_dir log_checkpoint_name -gpu-id 0
	
	python train_dvsgesture.py -data_dir path_to_data_dir -out_dir log_checkpoint_name -gpu-id 0

	python train_imagenet_resnet.py -data_dir path_to_data_dir -out_dir log_checkpoint_name -load_pretrain path_to_pretrained_model -p_scale 0.15 -gpu-id 0
	
	# add the argument for combination with local loss
	-local_loss
	
	# add the argument for single-point zeroth-order method
	-not_momentum_feedback
	
	# add the argument for BP instead of OPZO
	-bp
	
	# add the argument for DFA instead of OPZO
	-DFA
	
	# add the argument for DKP instead of OPZO
	-DKP
	
	# analyze gradient variance during training
	python train_cifar10dvs_analyzegrad.py -data_dir path_to_data_dir -out_dir log_checkpoint_name -gpu-id 0
	
	# intermediate global learning for deeper networks
	python train_cifar_igl.py -data_dir path_to_data_dir -dataset cifar100 -out_dir log_checkpoint_name -gpu-id 0

The default hyperparameters are the same as the paper and the default random seed is set as 2022.
