class TextualModel():
    model_registry = {}

    def __init__(self, *args, **kwargs):
        raise EnvironmentError(
            f"{self.__class__.__name__} is designed to be instantiated "
            f"using the `{self.__class__.__name__}.from_config(pretrained_model_name_or_path)`"
        )
    
    @classmethod
    def register(cls, model_cls):
        cls.model_registry[model_cls.__name__] = model_cls
        return model_cls

    @classmethod
    def from_config(cls, name, **config):

        if name not in cls.model_registry.keys():
            raise ValueError(
                "Unrecognized model class {} to build a TextualModel.\n"
                "Model type should be one of {}".format(
                    name, ", ".join(m for m in cls.model_registry.keys())
                )
            )
        
        return cls.model_registry[name](**config)