#

dataset_registry = {}

def dataset_register(cls):
    dataset_registry[cls.__name__] = cls
    return cls

def load_dataset_from_config(name, **config):

    if name not in dataset_registry.keys():
        raise ValueError(
            "Unrecognized data class {} to build a dataset.\n"
            "Data type should be one of {}".format(
                name, ", ".join(m for m in dataset_registry.keys())
            )
        )
    
    dataset = dataset_registry[name](**config)
    return dataset