# Add protenc to Python path for direct import
import os
import sys

# Add the protenc package directory to the Python path
protenc_path = os.path.join(os.path.dirname(__file__), "utils", "protenc")
if protenc_path not in sys.path:
    sys.path.append(protenc_path)

# Now we can import protenc directly
try:
    import protenc  # noqa: E402

    # Make protenc available at the haipr namespace level
    __all__ = ["protenc"]
except ImportError as e:
    import warnings

    warnings.warn(f"Could not import protenc: {e}. Some functionality may be limited.")
