from abc import ABC, abstractmethod
from typing import Callable, List, Optional

from haipr.data import HAIPRData


class BaseSequenceGenerator(ABC):
    @abstractmethod
    def setup_generator(
        self,
        data: HAIPRData,
        alphabet_per_position: Optional[List[List[str]]],
        fitness_callback: Callable,
    ):
        """Setup the generator with data and fitness function"""
        pass

    @abstractmethod
    def run(self):
        """Run the sequence generation/optimization process"""
        pass

    @abstractmethod
    def get_best_solution(self):
        """Get the best solution found"""
        pass

    @abstractmethod
    def get_all_solutions(self):
        """Get all solutions generated"""
        pass

    @abstractmethod
    def get_monitoring_statistics(self):
        """Get monitoring statistics"""
        pass

    @abstractmethod
    def reset(self):
        """Reset the generator state"""
        pass

    @abstractmethod
    def shutdown(self):
        """Shutdown the generator, handle any cleanup and final logging etc."""
        pass
