invalid_alg = """
from typing import Tuple, List
import numpy as np

def solve_B(input_B: Tuple[np.ndarray, np.ndarray, np.ndarray, int]) -> List[np.ndarray]:
    coord_matrix, cost_metric, demands, capacity = input_B
    customer_ids = np.arange(1, 51)
    unvisited = set(customer_ids)
    routes = []
    
    while unvisited:
        current_route = []
        current_capacity = 0
        starting_customer = min(unvisited, key=lambda x: np.linalg.norm(coord_matrix[x] - coord_matrix[0]))
        current_route.append(starting_customer)
        current_capacity += demands[starting_customer]
        unvisited.remove(starting_customer)

        while current_capacity < capacity and unvisited:
            next_customer = min(unvisited, key=lambda x: (np.linalg.norm(coord_matrix[starting_customer] - coord_matrix[x]), -demands[x]))
            if current_capacity + demands[next_customer] <= capacity:
                current_route.append(next_customer)
                current_capacity += demands[next_customer]
                unvisited.remove(next_customer)
                starting_customer = next_customer
            else:
                break

        routes.append(np.array(current_route))

    return routes
"""
# we see that this heuristic only applies to ID instances of size 50 (given 'customer_ids = np.arange(1, 51)')