
class GetPrompts():
    # The `heuristics` function takes as input a distance matrix (shape: n by n), Euclidean coordinates of nodes (shape: n by 2), a vector of customer demands (shape: n), and the integer capacity of vehicle capacity.
    # It returns prior indicators of how promising it is to include each edge in a solution. The return is of the same shape as the distance_matrix. The depot node is indexed by 0.
    def __init__(self):
        self.prompt_task = f"Given a set of N customers and a fleet of vehicles with limited capacity, the problem involves finding a corresponding set of optimal routes to deliver goods to all customers."
        self.reduction_template = f"""
import numpy as np
from typing import Tuple, List

def convert_input_A_to_B(coord_matrix, distance_matrix, demands, capacity):
    ''' Convert input of Problem A into input of Problem B
    Args:
    coord_matrix (np.ndarray): A (N+1)-by-2 matrix storing the Euclidean coordinates of the depot (first row) and the customers. 
    distance_matrix (np.ndarray): A (N+1)-by-(N+1) distance matrix.
    demands (np.ndarray): An array of length N+1 storing the customer demands, where the first entry is 0 (placeholder for the depot).
    capacity (int): The capacity of each vehicle for satisfying the customer demands.

    Returns:
    input_B: A tuple storing the corresponding input of Problem B.
    '''

    # Placeholder (replace with your actual implementation)
    input_B = ...

    return input_B


def convert_solution_B_to_A(solution_B):
    ''' Convert solution of Problem B into solution of Problem A
    Args:
    solution_B: The output of Problem B.

    Returns:
    routes (List[List[int]]): A list of routes; each route is represented as a list of unique customer indices (1 to N) to visit in order, subject to the capacity constraint.
    '''

    # Placeholder (replace with your actual implementation)
    routes = []
    ...

    return routes

"""
        self.heuristic_template = """
from typing import Tuple

def solve_B(<INPUT_B>):
    '''
    Args:
    <ARGS>

    Returns:
    <RETURNS>
    '''

    return <SOLUTION_B>

"""
        self.prompt_template = """
def find_route(coord_matrix: np.ndarray, distance_matrix: np.ndarray) -> np.ndarray:

    # Placeholder (replace with your actual implementation)
    problem_size = coord_matrix.shape[0]
    route = np.zeros(problem_size)
    ...

    return route

"""
        self.prompt_other_inf = "Note that 'distance_matrix' is a lookup matrix where the entry at i-th row and j-th column (or vice versa) stores the Euclidean distance between customers i and j. \
You can directly call 'route_cost(self, coord_matrix: np.ndarray, route: np.ndarray, problem_size: int) -> float' to compute the route cost without having to import or define it. "

#  A nested list where each inner list represents a route containing indices of customers to visit in order.
    def get_task(self):
        return self.prompt_task
    
    def get_func_name(self):
        return self.prompt_func_name
    
    def get_func_inputs(self):
        return self.prompt_func_inputs
    
    def get_func_outputs(self):
        return self.prompt_func_outputs
    
    def get_inout_inf(self):
        return self.prompt_inout_inf

    def get_other_inf(self):
        return self.prompt_other_inf

if __name__ == "__main__":
    getprompts = GetPrompts()
    print(getprompts.get_task())
