'''
Usage: python [FILENAME].py [problem_size(s)] [external_data?] [trial_no] [n_trial_evored]
Note: if plural, separate using '+'
Note: 1 if using external test data from MCTS-AHD, 0 if using local test data
Note: this only applies for reduc=True
Note: trial_no is the index of the completed reduc run without evo
Note: for trial_no and n_trial_evored, can use '-' to specify the range instead (e.g., 2-3 for trials #2 and #3, 2-2 for #2 only)
Example: python [FILENAME].py 50 1 9-9 1
'''
### Test Only ###
# Set system path
import sys
import os
import json
ABS_PATH = os.path.dirname(os.path.abspath(__file__))
ROOT_PATH = os.path.join(ABS_PATH, "..", "..")
sys.path.append(ROOT_PATH)  # This is for finding all the modules
sys.path.append(ABS_PATH)
print(ABS_PATH)
from eoh import eoh  # NOTE: just the caller for eoh, which calls the main eoh framework
from eoh.utils.getParas import Paras
# from evol.utils.createReport import ReportCreator

from prob import CVRP


external_data = int(sys.argv[2])
if external_data == 1:
    dirname = 'dataset_mcts'
    data_tag = '_mcts'
else:
    dirname = None  # 0 i.e., local data
    data_tag = ''
n_trial = sys.argv[3].split('-')
if len(n_trial) > 1:
    start, end = int(n_trial[0])-1, int(n_trial[1])
else:
    start, end = 0, int(n_trial[0])
n_trial_evored = sys.argv[4].split('-')
if len(n_trial_evored) > 1:
    start_evored, end_evored = int(n_trial_evored[0])-1, int(n_trial_evored[1])
else:
    start_evored, end_evored = 0, int(n_trial_evored[0])

# for problem_size in [50]:
for problem_size in sys.argv[1].split('+'):
    problem_size = int(problem_size)

    for j in range(start, end):
        exp_output_path = f"{problem_size}_{j+1}"

        for jj in range(start_evored, end_evored):
            os.makedirs(exp_output_path + f"/results/pops{data_tag}_evored_{jj+1}", exist_ok=True)
            os.makedirs(exp_output_path + f"/results/pops{data_tag}_evored_{jj+1}_best", exist_ok=True)

            # Parameter initilization #
            paras = Paras() 

            # Set your local problem
            problem_local = CVRP(problem_size=problem_size, running_time=60, dirname=dirname)

            # Set parameters #
            paras.set_paras(method = "eoh",    # ['ael','eoh']
                            problem = problem_local, # Set local problem, else use default problems
                            # llm_api_endpoint = "api.deepseek.com", # set your LLM endpoint
                            # llm_api_key = Fa"sk-da38e74580fb47f6b3b4ddfdeda357cd",   # set your key
                            # llm_model = "deepseek-chat",
                            llm_api_endpoint = "api.openai.com", # set your LLM endpoint
                            llm_api_key = "API_KEY",   # set your key
                            llm_model = "gpt-4o-mini",
                            # llm_model = "o3-mini",
                            ec_pop_size = 20, # number of samples in each population
                            ec_n_pop = 10,  # number of populations
                            ec_mobj = False,
                            ec_reduc = True,  # NOTE: this will determine whether to do reduction at initialization or not
                            ec_init_reduc_size = 10,
                            ec_reduc_size = 3,
                            ec_reduc_top_size = 3,  # NOTE: should be around pop_size/reduc_size

                            ec_reduc_evol = True,  # NOTE: this will determine whether to evolve reductions or not
                            patience = 3,
                            ec_evored_trial_id = jj+1,

                            exp_n_proc = 8,  # multi-core parallel
                            exp_debug_mode = False,
                            eva_numba_decorator = False,
                            eva_timeout = 80,
                            ec_operators = ['e2','m1'],  # operators defined in eoh_interface_EC.py and eoh_evolution.py
                            exp_output_path = exp_output_path,
                            # exp_use_continue = True,  # so we can compare with simple reduc (non-evored) experiments, as both now have the same starting population
                            # exp_continue_path = f"{exp_output_path}/results/pops{data_tag}/population_generation_0.json",
                            )

            # initilization
            evolution = eoh.EVOL(paras)

            # run 
            evolution.run()

