
class GetPrompts():
    def __init__(self, problem_size):
        self.prompt_task = f"Given a set of {problem_size} items with weights and values, the problem involves selecting a subset of items that maximizes the total value without exceeding the knapsack's weight capacity."
        self.reduction_template = f"""
import numpy as np
from typing import Tuple

def convert_input_A_to_B(weights, values, capacity):
    ''' Convert input of Problem A into input of Problem B
    Args:
    weights (np.ndarray): A 1D float array of length {problem_size} storing the item weights.
    values (np.ndarray): A 1D float array of length {problem_size} storing the associated item values.
    capacity (float): The weight capacity of the knapsack.

    Returns:
    input_B: A tuple storing the corresponding input of Problem B.
    '''

    # Placeholder (replace with your actual implementation)
    input_B = ...

    return input_B


def convert_solution_B_to_A(solution_B):
    ''' Convert solution of Problem B into solution of Problem A
    Args:
    solution_B: The output of Problem B.

    Returns:
    items: A list storing the indices of selected items subject to the capacity constraint.
    '''

    # Placeholder (replace with your actual implementation)
    items = []
    ...

    return items

"""
        self.heuristic_template = """
from typing import Tuple

def solve_B(<INPUT_B>):
    '''
    Args:
    <ARGS>

    Returns:
    <RETURNS>
    '''

    return <SOLUTION_B>

"""
        self.prompt_template = """
def pack_items(...) -> ...:

    # Placeholder (replace with your actual implementation)
    ...

    return ...

"""
        self.reduc_prompt_other_inf = "... "
        self.prompt_other_inf = "... "
#         self.prompt_template = """
# def modify_graph(G: nx.Graph, facility: int, clients: np.ndarray, num_new_edges: int) -> nx.Graph:

#     # Placeholder (replace with your actual implementation)
#     G_modified = G.copy()
#     ...

#     return G_modified

# """
#         self.prompt_task = "Given a graph comprising a set of nodes and a set of edges, where one of the nodes is a facility that provides services to a subset of the remaining nodes, \
# you need to find a set of non-edges that minimizes the sum of shortest distances between the clients to the facility subject to a given budget. \
# The task can be solved step-by-step by considering the current graph and iteratively adding a non-edge to the graph, which induces a specified cost, until the budget is depleted. \
# Help me design an efficient algorithm to select the next non-edge in each step."
#         self.prompt_template = """
# def select_non_edge(adjacency_matrix, facility_node, client_nodes, addition_cost_matrix, remaining_budget):
#     '''
#     Args:
#     adjacency_matrix (Numpy 2-D array): The adjacency matrix of a simple, weighted, and undirected graph.
#     facility_node (int): Node ID of the facility.
#     client_nodes (int): Node IDs of the clients.
#     addition_cost_matrix (Numpy 2-D array): A symmetric matrix, where the entry at i-th row and j-th column stores the cost of adding non-edge (i, j) to the graph.
#     remaining_budget (int): A nonnegative integer.

#     Returns:
#     start_node, end_node (int): Node IDs of the non-edge to be added.
#     '''

#     # Placeholder (replace with your actual implementation)
#     start_node, end_node = 

#     return start_node, end_node

# """
        # self.prompt_func_name = "select_non_edge"
        # self.prompt_func_inputs = ["adjacency_matrix","facility_node","client_nodes","addition_cost_matrix","remaining_budget"]
        # self.prompt_func_outputs = ["start_node","end_node"]
        # self.prompt_inout_inf = "'adjacency_matrix' is the weighted adjacency matrix of the current graph. 'facility_node' and 'client_nodes' are node IDs. 'addition_cost_matrix' is a symmetric matrix, where the entry at i-th row and j-th column stores the cost of adding non-edge (i, j) to the graph. 'remaining_budget' is a nonnegative integer. 'start_node' and 'end_node' are node IDs of the non-edge to be added."
        # self.prompt_other_inf = "All are Numpy arrays."

    def get_task(self):
        return self.prompt_task
    
    def get_func_name(self):
        return self.prompt_func_name
    
    def get_func_inputs(self):
        return self.prompt_func_inputs
    
    def get_func_outputs(self):
        return self.prompt_func_outputs
    
    def get_inout_inf(self):
        return self.prompt_inout_inf

    def get_other_inf(self):
        return self.prompt_other_inf

if __name__ == "__main__":
    getprompts = GetPrompts()
    print(getprompts.get_task())
