
class GetPrompts():
    def __init__(self):
        self.prompt_task = f"Given a set of N items with different sizes and some bins each with fixed capacity, the online bin packing problem involves placing each item (in the given order) one by one inside one of the bins in a way that minimizes the number of bins used without exceeding the bin capacity."
        self.reduction_template = f"""
import numpy as np
from typing import Tuple

def convert_input_A_to_B(items, bins):
    ''' Convert input of Problem A into input of Problem B
    Args:
    items (np.ndarray): Array of length N storing the item sizes to be considered in exact order.
    bins (np.ndarray): Array of capacities for each bin.

    Returns:
    input_B: A tuple storing the corresponding input of Problem B.
    '''

    # Placeholder (replace with your actual implementation)
    input_B = ...

    return input_B


def convert_solution_B_to_A(solution_B):
    ''' Convert solution of Problem B into solution of Problem A
    Args:
    solution_B: The output of Problem B.

    Returns:
    packed_bins (np.ndarray): Array of remaining capacities for each bin after packing all items.
    '''

    # Placeholder (replace with your actual implementation)
    packed_bins = ...
    ...

    return packed_bins

"""
        self.heuristic_template = """
from typing import Tuple

def solve_B(<INPUT_B>):
    '''
    Args:
    <ARGS>

    Returns:
    <RETURNS>
    '''

    return <SOLUTION_B>

"""
        self.prompt_template = """
def find_route(coord_matrix: np.ndarray, distance_matrix: np.ndarray) -> np.ndarray:

    # Placeholder (replace with your actual implementation)
    problem_size = coord_matrix.shape[0]
    route = np.zeros(problem_size)
    ...

    return route

"""
        self.prompt_other_inf = "Note that 'distance_matrix' is a lookup matrix where the entry at i-th row and j-th column (or vice versa) stores the Euclidean distance between customers i and j. \
You can directly call 'route_cost(self, coord_matrix: np.ndarray, route: np.ndarray, problem_size: int) -> float' to compute the route cost without having to import or define it. "

#  A nested list where each inner list represents a route containing indices of customers to visit in order.
    def get_task(self):
        return self.prompt_task
    
    def get_func_name(self):
        return self.prompt_func_name
    
    def get_func_inputs(self):
        return self.prompt_func_inputs
    
    def get_func_outputs(self):
        return self.prompt_func_outputs
    
    def get_inout_inf(self):
        return self.prompt_inout_inf

    def get_other_inf(self):
        return self.prompt_other_inf

if __name__ == "__main__":
    getprompts = GetPrompts()
    print(getprompts.get_task())
