import re
import time
from ...llm.interface_LLM import InterfaceLLM

class Evolution():

    def __init__(self, api_endpoint, api_key, model_LLM,llm_use_local,llm_local_url, debug_mode,prompts, **kwargs):

        # set prompt interface
        #getprompts = GetPrompts()
        self.prompt_task = prompts.prompt_task
        self.prompt_template = prompts.prompt_template
        self.reduction_template = prompts.reduction_template
        self.heuristic_template = prompts.heuristic_template
        # self.prompt_func_name    = prompts.get_func_name()
        # self.prompt_func_inputs  = prompts.get_func_inputs()
        # self.prompt_func_outputs = prompts.get_func_outputs()
        # self.prompt_inout_inf    = prompts.get_inout_inf()
        self.prompt_other_inf    = prompts.get_other_inf()
        # if len(self.prompt_func_inputs) > 1:
        #     self.joined_inputs = ", ".join("'" + s + "'" for s in self.prompt_func_inputs)
        # else:
        #     self.joined_inputs = "'" + self.prompt_func_inputs[0] + "'"

        # if len(self.prompt_func_outputs) > 1:
        #     self.joined_outputs = ", ".join("'" + s + "'" for s in self.prompt_func_outputs)
        # else:
        #     self.joined_outputs = "'" + self.prompt_func_outputs[0] + "'"

        # set LLMs
        self.api_endpoint = api_endpoint
        self.api_key = api_key
        self.model_LLM = model_LLM
        self.debug_mode = debug_mode # close prompt checking


        self.interface_llm = InterfaceLLM(self.api_endpoint, self.api_key, self.model_LLM,llm_use_local,llm_local_url, self.debug_mode)

        self.OP = {
            'e1': "Please help me create a new algorithm that has a totally different form from the given ones.",
            # 'e1': "Please help me create a new algorithm that has a totally different form from the given ones while remaining as efficient as possible. Focus on either the considered network feature(s) or the underlying network modification strategy.",
            'e2': "Please help me create a new algorithm that has a totally different form from the given ones but can be motivated from them.",
            'm1': "Please help me create a new algorithm that has a different form but can be a modified version of the provided algorithm.",
            # 'm1': "Please help me modify the provided algorithm while remaining as efficient as possible. Focus on either the considered network feature(s) or the underlying network modification strategy.",
            # 'm2': "Please identify the main algorithm parameters and help me create a new algorithm that has different parameter settings compared to the provided algorithm."
            # 'm2': "Please help me finetune the provided algorithm to improve its efficiency."
        }
        self.ROP = {  # for reduction specifically
            're1': "Please come up with a new Problem B that has a totally different form from the given ones.",
            're2': "Please come up with a new Problem B that has a totally different form but can be motivated from the given ones.",
            'rm0': "Please help me fix the following erratic code for transforming Problem A to Problem B and vice versa.",
            'rm1': "Please help me modify the following code for transforming Problem A to Problem B and vice versa while remaining as efficient as possible.",
            'rm2': "Please help me finetune the following code for transforming Problem A to Problem B and vice versa to improve its efficiency.",
        }

    def get_prompt_i1(self, seed_algorithm, reduction=None):
        if reduction is not None:
            prompt_task, prompt_template, prompt_other_inf = reduction['problem'], reduction['template'], '\n'
        else:
            prompt_task, prompt_template, prompt_other_inf = self.prompt_task, self.prompt_template, self.prompt_other_inf

        if seed_algorithm is not None:
            prompt_content = prompt_task+"\n"\
"A known algorithm for solving the problem is as follows: "+seed_algorithm+"\n"\
"Implement it in Python using the following template: \n \
"+prompt_template+f"{prompt_other_inf}Do not give additional explanations."
        else:
            prompt_content = prompt_task+"\n"\
"I need help design a novel efficient algorithm to solve the problem. First, describe your algorithm and main steps in one sentence. \
The description must be inside a brace. Next, implement it in Python using the following template: \n \
"+prompt_template+f"{prompt_other_inf}Do not give additional explanations."
        return prompt_content

        
    def get_prompt_e1(self,indivs,reduction=None):
        if reduction is not None:
            prompt_task, prompt_template, prompt_other_inf = reduction['problem'], reduction['template'], '\n'
        else:
            prompt_task, prompt_template, prompt_other_inf = self.prompt_task, self.prompt_template, self.prompt_other_inf
        prompt_indiv = ""
        for i in range(len(indivs)):
            prompt_indiv=prompt_indiv+"No."+str(i+1) +" algorithm and the corresponding code are: \n" + indivs[i]['algorithm']+"\n" +indivs[i]['code']+"\n"

        prompt_content = prompt_task+"\n"\
"I have "+str(len(indivs))+" existing algorithms with their codes as follows: \n"\
+prompt_indiv+\
f"{self.OP['e1']}\n"\
"First, describe your new algorithm and main steps in one sentence. \
The description must be inside a brace. Next, implement it in Python using the following template: \n \
"+prompt_template+f"{prompt_other_inf}Do not give additional explanations."
        return prompt_content
    
    def get_prompt_e2(self,indivs,reduction=None):
        if reduction is not None:
            prompt_task, prompt_template, prompt_other_inf = reduction['problem'], reduction['template'], '\n'
        else:
            prompt_task, prompt_template, prompt_other_inf = self.prompt_task, self.prompt_template, self.prompt_other_inf
        prompt_indiv = ""
        for i in range(len(indivs)):
            prompt_indiv=prompt_indiv+"No."+str(i+1) +" algorithm and the corresponding code are: \n" + indivs[i]['algorithm']+"\n" +indivs[i]['code']+"\n"

        prompt_content = prompt_task+"\n"\
"I have "+str(len(indivs))+" existing algorithms with their codes as follows: \n"\
+prompt_indiv+\
f"{self.OP['e2']}\n"\
"First, identify the common backbone idea in the provided algorithms. Secondly, based on the backbone idea describe your new algorithm in one sentence. \
The description must be inside a brace. Thirdly, implement it in Python using the following template: \n \
"+prompt_template+f"{prompt_other_inf}Do not give additional explanations."
        return prompt_content
    
    def get_prompt_m1(self,indiv1,reduction=None):
        if reduction is not None:
            prompt_task, prompt_template, prompt_other_inf = reduction['problem'], reduction['template'], '\n'
        else:
            prompt_task, prompt_template, prompt_other_inf = self.prompt_task, self.prompt_template, self.prompt_other_inf
        prompt_content = prompt_task+"\n"\
"I have one algorithm with its code as follows. \
Algorithm description: "+indiv1['algorithm']+"\n\
Code:\n\
"+indiv1['code']+f"\n\
{self.OP['m1']}\n"\
"First, describe your new algorithm and main steps in one sentence. \
The description must be inside a brace. Next, implement it in Python using the following template: \n \
"+prompt_template+f"{prompt_other_inf}Do not give additional explanations."
        return prompt_content
    
    def get_prompt_m2(self,indiv1,reduction=None):
        if reduction is not None:
            prompt_task, prompt_template, prompt_other_inf = reduction['problem'], reduction['template'], '\n'
        else:
            prompt_task, prompt_template, prompt_other_inf = self.prompt_task, self.prompt_template, self.prompt_other_inf
        prompt_content = prompt_task+"\n"\
"I have one algorithm with its code as follows. \
Algorithm description: "+indiv1['algorithm']+"\n\
Code:\n\
"+indiv1['code']+f"\n\
{self.OP['m2']}\n"\
"First, describe your new algorithm and main steps in one sentence. \
The description must be inside a brace. Next, implement it in Python using the following template: \n \
"+prompt_template+f"{prompt_other_inf}Do not give additional explanations."
        return prompt_content


    def get_prompt_ri0(self, problem_B):
        prompt_content = "Problem A: "+self.prompt_task+"\n"\
"Problem B: "+problem_B+"\n"\
"Implement 2 Python functions for transforming Problem A into Problem B using the following templates: \n \
"+self.reduction_template+"Only provide me the code without any further explanations."
        return prompt_content

    def get_prompt_ri1(self, problem_Bs: list):
        if problem_Bs:
            prompt_examples = "Here is an example of Problem B:\n" if len(problem_Bs) == 1 else "Here are some examples of Problem B:\n"
            for i, problem_B in enumerate(problem_Bs):
                prompt_examples = prompt_examples + f'Example no. {i+1}: {problem_B}\n'
            prompt_content = "Problem A: "+self.prompt_task+"\n"\
f"I want to transform Problem A into another problem, Problem B, that can be solved efficiently while still providing near-optimal solutions to Problem A. \
{prompt_examples}\n\
Please determine the input and output of your own Problem B. Using that information, implement 2 Python functions using the following templates: \n \
"+self.reduction_template+"First, describe the new Problem B in a sentence or two (enclosed inside a double brace), then provide me the code without any further explanations."
        else:
            prompt_content = "Problem A: "+self.prompt_task+"\n"\
"I want to transform Problem A into another problem, Problem B, that can be solved efficiently while still providing near-optimal solutions to Problem A. \
Please help me determine the input and output of Problem B. Using that information, implement 2 Python functions using the following templates: \n \
"+self.reduction_template+"First, describe Problem B in a sentence or two (enclosed inside a double brace), then provide me the code without any further explanations."
        return prompt_content

    def get_prompt_ri2(self, n):  # ask to list n potential Problem B's first (descriptions only)
        prompt_content = "Problem A: "+self.prompt_task+"\n"\
f"I want to transform Problem A into another problem, Problem B, that can be solved efficiently while still providing near-optimal solutions to Problem A. \
Please help me devise {n} different Problem B's. Describe each Problem B in a sentence or two (without mentioning Problem A) and enclose it inside a double brace as follows:\n" +\
"{{Problem B1 involves ...}}\n{{Problem B2 involves ...}}\n...\nDo not give additional explanations."
        return prompt_content

    def get_prompt_re1(self,indivs):
        prompt_indiv = ""
        for i in range(len(indivs)):
            prompt_indiv=prompt_indiv+f"Problem B no. {i+1} and the corresponding score are:\n{indivs[i]['problem']}\nScore: {indivs[i]['objective']:.5f}\n"

        prompt_content = "Problem A: "+self.prompt_task+"\n"\
f"I want to transform Problem A into another problem, Problem B, that can be solved efficiently while still providing near-optimal solutions to Problem A. \
I have already considered {len(indivs)} options for Problem B with their scores (the higher the better) as follows:\n"\
+prompt_indiv+\
f"{self.ROP['re1']}\n"\
"Determine the input and output of your own Problem B. Using that information, implement 2 Python functions using the following templates: \n \
"+self.reduction_template+"First, describe the new Problem B in a sentence or two (enclosed inside a double brace), then provide me the code without any further explanations."
        return prompt_content

    def get_prompt_re2(self,indivs):
        prompt_indiv = ""
        for i in range(len(indivs)):
            prompt_indiv=prompt_indiv+f"Problem B no. {i+1} and the corresponding score are:\n{indivs[i]['problem']}\nScore: {indivs[i]['objective']:.5f}\n"

        prompt_content = "Problem A: "+self.prompt_task+"\n"\
f"I want to transform Problem A into another problem, Problem B, that can be solved efficiently while still providing near-optimal solutions to Problem A. \
I have already considered {len(indivs)} options for Problem B with their scores (the higher the better) as follows:\n"\
+prompt_indiv+\
f"{self.ROP['re2']}\n"\
"Determine the input and output of your own Problem B. Using that information, implement 2 Python functions using the following templates: \n \
"+self.reduction_template+"First, describe the new Problem B in a sentence or two (enclosed inside a double brace), then provide me the code without any further explanations."
        return prompt_content

    def get_prompt_rm0(self,indiv1):
        prompt_content = "Problem A: "+self.prompt_task+"\n"\
"I want to transform Problem A into another problem, Problem B, that can be solved efficiently while still providing near-optimal solutions to Problem A. \
I have one option for Problem B as follows:\n \
Problem description: "+indiv1['problem']+"\n"\
+self.ROP['rm0']+"\n\
Code:\n\
"+indiv1['code']+"Do not give additional explanations."
        return prompt_content

    def get_prompt_rm1(self,indiv1):
        prompt_content = "Problem A: "+self.prompt_task+"\n"\
"I want to transform Problem A into another problem, Problem B, that can be solved efficiently while still providing near-optimal solutions to Problem A. \
I have one option for Problem B as follows:\n \
Problem description: "+indiv1['problem']+"\n"\
+self.ROP['rm1']+"\n\
Code:\n\
"+indiv1['code']+"Do not give additional explanations."
        return prompt_content

    def get_prompt_rm2(self,indiv1):
        prompt_content = "Problem A: "+self.prompt_task+"\n"\
"I want to transform Problem A into another problem, Problem B, that can be solved efficiently while still providing near-optimal solutions to Problem A. \
I have one option for Problem B as follows:\n \
Problem description: "+indiv1['problem']+"\n"\
+self.ROP['rm2']+"\n\
Code:\n\
"+indiv1['code']+"Do not give additional explanations."
        return prompt_content

    def get_template_request(self, reduc_code):
#         prompt_content = "I have the following problem description for Problem B and the corresponding code for transforming a harder Problem A into Problem B.\n\
# Problem description:\n\
# "+reduc_problem+"\n\
# Problem transformation code:\n\
# "+reduc_code+"\n\
# Using this information, fill in the blanks of the following Python function template (at <INPUT_B> and <SOLUTION_B>, with as detailed type hints as possible).\n\
# Code template:\n\
# "+self.heuristic_template+"Do not attempt to solve the problem directly and do not give additional explanations."
        prompt_content = "I have the following code for transforming a Problem A into a simplified Problem B and vice versa.\n\
Code:\n\
"+reduc_code+"\n\
Using this information, fill in the blanks of the following Python function template.\n\
Code template:\n\
"+self.heuristic_template+"First, determine <INPUT_B> from output of 'convert_input_A_to_B()'. Then, determine <SOLUTION_B> from 'solution_B' variable in 'convert_solution_B_to_A()'. \
Finally, complete the docstring at <ARGS> and <RETURNS> with as detailed type hints as possible. Do not attempt to solve the problem directly and do not give additional explanations."
        return prompt_content

    def _get_code(self, prompt_content, template=False):
        '''
        1. Get code of heuristic given problem description (when calling i1)
        2. Get modified code and template for an existing reduction (when calling rm1 & rm2; remember to set 'template = True')
        3. Get code and template for a new reduction (when calling ri0; remember to set 'template = True')
        '''

        response = self.interface_llm.get_response(prompt_content)

        # regex_patterns = [r"import.*return G_modified|import.*return modified_graph|import.*return new_graph",
        #                   r"def.*return G_modified|def.*return modified_graph|def.*return new_graph"]
        if self.model_LLM.startswith('gpt'):  # NOTE: for older LLMs (gpt-4o-mini), use "...return.*\n"; for newer LLMs (o3-mini), use "...return.*$"
            regex_patterns = [r"import .*return.*\n",
                              r"def .*return.*\n"]
        elif self.model_LLM.startswith('o'):
            regex_patterns = [r"import .*return.*$",
                              r"def .*return.*$"]
        # print(response)
        code = re.findall(regex_patterns[0], response, re.DOTALL)
        if len(code) == 0:
            code = re.findall(regex_patterns[1], response, re.DOTALL)
        # print(code)
        if self.debug_mode:
            print(f"Code: {code}")

        n_retry = 1
        while len(code) == 0:
            if self.debug_mode:
                print("Error: code not identified, wait 1 seconds and retrying ... ")

            response = self.interface_llm.get_response(prompt_content)

            code = re.findall(regex_patterns[0], response, re.DOTALL)
            if len(code) == 0:
                code = re.findall(regex_patterns[1], response, re.DOTALL)
                
            if n_retry > 3:
                break
            n_retry +=1

        code = code[0] 

        #code_all = code+" "+", ".join(s for s in self.prompt_func_outputs) 
        code_all = code

        if template:
            heuristic_template = self._get_code_template(self.get_template_request(code_all))
            return [code_all, heuristic_template]

        return code_all


    def _get_alg_and_code(self,prompt_content, for_what='heuristic', reduction=False):
        ''' If 'reduction' is True, then prompt LLM again for code template of Problem B. '''

        response = self.interface_llm.get_response(prompt_content)
        if for_what == 'reduction':
            regex_braces = r"\{\{(.*?)\}\}"
        else:
            regex_braces = r"\{(.*?)\}"
        algorithm = re.findall(regex_braces, response, re.DOTALL)
        # if len(algorithm) == 0:
        #     if 'python' in response:
        #         algorithm = re.findall(r'^.*?(?=python)', response,re.DOTALL)
        #     elif 'import' in response:
        #         algorithm = re.findall(r'^.*?(?=import)', response,re.DOTALL)
        #     else:
        #         algorithm = re.findall(r'^.*?(?=def)', response,re.DOTALL)

        # if (for_what == 'heuristic' and not reduction) or (for_what == 'reduction'):
        #     regex_patterns = [r"import .*return G_modified|import .*return modified_graph|import .*return new_graph|def .*return G_modified|def .*return modified_graph|def .*return new_graph",
        #                       r"def .*return G_modified|def .*return modified_graph|def .*return new_graph"]
        # else:  # in case (for_what == 'heuristic' and reduction) i.e., finding code of the heuristic for Problem B
        if self.model_LLM.startswith('gpt'):  # NOTE: for older LLMs (gpt-4o-mini), use "...return.*\n"; for newer LLMs (o3-mini), use "...return.*$"
            regex_patterns = [r"import .*return.*\n|^from.*import .*return.*\n|\nfrom.*import .*return.*\n|def .*return.*\n",
                              r"def .*return.*\n"]
        elif self.model_LLM.startswith('o'):
            regex_patterns = [r"import .*return.*$|^from.*import .*return.*$|\nfrom.*import .*return.*$|def .*return.*$",
                              r"def .*return.*$"]
        print(response)
        print(algorithm)
        code = re.findall(regex_patterns[0], response, re.DOTALL)
        if len(code) == 0:
            code = re.findall(regex_patterns[1], response, re.DOTALL)
        print(code)
        if self.debug_mode:
            print(f"Code: {code}")

        n_retry = 1
        while (len(algorithm) == 0 or len(code) == 0):
            if self.debug_mode:
                print("Error: algorithm or code not identified, wait 1 seconds and retrying ... ")

            response = self.interface_llm.get_response(prompt_content)
            # print(n_retry, response)

            algorithm = re.findall(regex_braces, response, re.DOTALL)
            # if len(algorithm) == 0:
            #     if 'python' in response:
            #         algorithm = re.findall(r'^.*?(?=python)', response,re.DOTALL)
            #     elif 'import' in response:
            #         algorithm = re.findall(r'^.*?(?=import)', response,re.DOTALL)
            #     else:
            #         algorithm = re.findall(r'^.*?(?=def)', response,re.DOTALL)

            code = re.findall(regex_patterns[0], response, re.DOTALL)
            if len(code) == 0:
                code = re.findall(regex_patterns[1], response, re.DOTALL)
                
            if n_retry > 3:
                break
            n_retry +=1

        algorithm = algorithm[0]
        code = code[0] 

        #code_all = code+" "+", ".join(s for s in self.prompt_func_outputs) 
        code_all = code

        if for_what == 'reduction':
            heuristic_template = self._get_code_template(self.get_template_request(code_all))
            return [code_all, algorithm, heuristic_template]

        return [code_all, algorithm]


    def _get_code_template(self, prompt_content):

        response = self.interface_llm.get_response(prompt_content)

        if self.model_LLM.startswith('gpt'):  # NOTE: for older LLMs (gpt-4o-mini), use "...return.*\n"; for newer LLMs (o3-mini), use "...return.*$"
            regex_patterns = [r"import .*return.*\n|^from.*import .*return.*\n|\nfrom.*import .*return.*\n",
                              r"def .*return.*\n"]
        elif self.model_LLM.startswith('o'):
            regex_patterns = [r"import .*return.*$|^from.*import .*return.*$|\nfrom.*import .*return.*$",
                              r"def .*return.*$"]
        # print(response)
        code = re.findall(regex_patterns[0], response, re.DOTALL)
        if len(code) == 0:
            code = re.findall(regex_patterns[1], response, re.DOTALL)
        # print(code)
        if self.debug_mode:
            print(f"Code: {code}")

        n_retry = 1
        while len(code) == 0:
            if self.debug_mode:
                print("Error: code not identified, wait 1 seconds and retrying ... ")

            response = self.interface_llm.get_response(prompt_content)

            code = re.findall(regex_patterns[0], response, re.DOTALL)
            if len(code) == 0:
                code = re.findall(regex_patterns[1], response, re.DOTALL)
                
            if n_retry > 3:
                break
            n_retry +=1

        code = code[0] 

        #code_all = code+" "+", ".join(s for s in self.prompt_func_outputs) 
        code_all = code
        return code_all


    def i1(self, algorithm=None, reduction=None):

        prompt_content = self.get_prompt_i1(algorithm, reduction)

        if self.debug_mode:
            print("\n >>> check prompt for creating algorithm using [ i1 ] : \n", prompt_content )
            print(">>> Press 'Enter' to continue")
            input()

        if algorithm is not None:
            code_all = self._get_code(prompt_content)
        else:
            [code_all, algorithm] = self._get_alg_and_code(prompt_content, reduction=reduction is not None)

        if self.debug_mode:
            print("\n >>> check designed algorithm: \n", algorithm)
            print("\n >>> check designed code: \n", code_all)
            print(">>> Press 'Enter' to continue")
            input()

        return [code_all, algorithm]
    
    def e1(self,parents,reduction):
      
        prompt_content = self.get_prompt_e1(parents, reduction)

        if self.debug_mode:
            print("\n >>> check prompt for creating algorithm using [ e1 ] : \n", prompt_content )
            print(">>> Press 'Enter' to continue")
            input()
      
        [code_all, algorithm] = self._get_alg_and_code(prompt_content, reduction=reduction is not None)

        if self.debug_mode:
            print("\n >>> check designed algorithm: \n", algorithm)
            print("\n >>> check designed code: \n", code_all)
            print(">>> Press 'Enter' to continue")
            input()

        return [code_all, algorithm]
    
    def e2(self,parents,reduction):
      
        prompt_content = self.get_prompt_e2(parents, reduction)

        if self.debug_mode:
            print("\n >>> check prompt for creating algorithm using [ e2 ] : \n", prompt_content )
            print(">>> Press 'Enter' to continue")
            input()
      
        [code_all, algorithm] = self._get_alg_and_code(prompt_content, reduction=reduction is not None)

        if self.debug_mode:
            print("\n >>> check designed algorithm: \n", algorithm)
            print("\n >>> check designed code: \n", code_all)
            print(">>> Press 'Enter' to continue")
            input()

        return [code_all, algorithm]
    
    def m1(self,parents,reduction):
      
        prompt_content = self.get_prompt_m1(parents, reduction)

        if self.debug_mode:
            print("\n >>> check prompt for creating algorithm using [ m1 ] : \n", prompt_content )
            print(">>> Press 'Enter' to continue")
            input()
      
        [code_all, algorithm] = self._get_alg_and_code(prompt_content, reduction=reduction is not None)

        if self.debug_mode:
            print("\n >>> check designed algorithm: \n", algorithm)
            print("\n >>> check designed code: \n", code_all)
            print(">>> Press 'Enter' to continue")
            input()

        return [code_all, algorithm]
    
    def m2(self,parents,reduction):
      
        prompt_content = self.get_prompt_m2(parents, reduction)

        if self.debug_mode:
            print("\n >>> check prompt for creating algorithm using [ m2 ] : \n", prompt_content )
            print(">>> Press 'Enter' to continue")
            input()
      
        [code_all, algorithm] = self._get_alg_and_code(prompt_content, reduction=reduction is not None)

        if self.debug_mode:
            print("\n >>> check designed algorithm: \n", algorithm)
            print("\n >>> check designed code: \n", code_all)
            print(">>> Press 'Enter' to continue")
            input()

        return [code_all, algorithm]


    def ri0(self, problem):
        """ Get reduction code (and Problem B's code template) given Problem B's description
        """
        prompt_content = self.get_prompt_ri0(problem)

        if self.debug_mode:
            print("\n >>> check prompt for creating reduction using [ ri0 ] : \n", prompt_content )
            print(">>> Press 'Enter' to continue")
            input()

        [code_all, code_template] = self._get_code(prompt_content, template=True)

        if self.debug_mode:
            print("\n >>> check designed reduction: \n", problem)
            print("\n >>> check designed code: \n", code_all)
            print("\n >>> check designed template: \n", code_template)
            print(">>> Press 'Enter' to continue")
            input()

        return [code_all, problem, code_template]

    def ri1(self, ref_probs=[]):
        """ It's neat that the existing regex from _get_code() and _get_alg_and_code() will just grab both forward and backward reduc functions in one go
        """
        prompt_content = self.get_prompt_ri1(ref_probs)

        if self.debug_mode:
            print("\n >>> check prompt for creating reduction using [ ri1 ] : \n", prompt_content )
            print(">>> Press 'Enter' to continue")
            input()

        # if ref_probs is not None:
        #     code_all = self._get_code(prompt_content)
        # else:
        [code_all, problem, code_template] = self._get_alg_and_code(prompt_content, for_what='reduction', reduction=True)

        if self.debug_mode:
            print("\n >>> check designed reduction: \n", problem)
            print("\n >>> check designed code: \n", code_all)
            print("\n >>> check designed template: \n", code_template)
            print(">>> Press 'Enter' to continue")
            input()

        return [code_all, problem, code_template]

    def ri2(self, n, n_min):
        """ Get a list of Problem B's descriptions
        """
        prompt_content = self.get_prompt_ri2(n)
        response = self.interface_llm.get_response(prompt_content)
        regex_braces = r"\{\{(.*?)\}\}"
        print(response)
        problems = re.findall(regex_braces, response, re.DOTALL)
        print(problems)
        n_retry = 1
        while len(problems) < n_min:
            response = self.interface_llm.get_response(prompt_content)
            problems = re.findall(regex_braces, response, re.DOTALL)

            if n_retry > 3:
                break
            n_retry +=1

        return problems

    def re1(self,parents):
      
        prompt_content = self.get_prompt_re1(parents)

        if self.debug_mode:
            print("\n >>> check prompt for creating reduction using [ re1 ] : \n", prompt_content )
            print(">>> Press 'Enter' to continue")
            input()
      
        [code_all, problem, code_template] = self._get_alg_and_code(prompt_content, for_what='reduction', reduction=True)

        if self.debug_mode:
            print("\n >>> check designed reduction: \n", problem)
            print("\n >>> check designed code: \n", code_all)
            print("\n >>> check designed template: \n", code_template)
            print(">>> Press 'Enter' to continue")
            input()

        return [code_all, problem, code_template]

    def re2(self,parents):
      
        prompt_content = self.get_prompt_re2(parents)

        if self.debug_mode:
            print("\n >>> check prompt for creating reduction using [ re2 ] : \n", prompt_content )
            print(">>> Press 'Enter' to continue")
            input()
      
        [code_all, problem, code_template] = self._get_alg_and_code(prompt_content, for_what='reduction', reduction=True)

        if self.debug_mode:
            print("\n >>> check designed reduction: \n", problem)
            print("\n >>> check designed code: \n", code_all)
            print("\n >>> check designed template: \n", code_template)
            print(">>> Press 'Enter' to continue")
            input()

        return [code_all, problem, code_template]

    def rm0(self,parent):
      
        prompt_content = self.get_prompt_rm0(parent)

        if self.debug_mode:
            print("\n >>> check prompt for creating reduction using [ rm0 ] : \n", prompt_content )
            print(">>> Press 'Enter' to continue")
            input()

        problem = parent['problem']
        [code_all, code_template] = self._get_code(prompt_content, template=True)

        if self.debug_mode:
            print("\n >>> check designed reduction: \n", problem)
            print("\n >>> check designed code: \n", code_all)
            print("\n >>> check designed template: \n", code_template)
            print(">>> Press 'Enter' to continue")
            input()

        return [code_all, problem, code_template]

    def rm1(self,parent):
      
        prompt_content = self.get_prompt_rm1(parent)

        if self.debug_mode:
            print("\n >>> check prompt for creating reduction using [ rm1 ] : \n", prompt_content )
            print(">>> Press 'Enter' to continue")
            input()

        problem = parent['problem']
        [code_all, code_template] = self._get_code(prompt_content, template=True)

        if self.debug_mode:
            print("\n >>> check designed reduction: \n", problem)
            print("\n >>> check designed code: \n", code_all)
            print("\n >>> check designed template: \n", code_template)
            print(">>> Press 'Enter' to continue")
            input()

        return [code_all, problem, code_template]

    def rm2(self,parent):
      
        prompt_content = self.get_prompt_rm2(parent)

        if self.debug_mode:
            print("\n >>> check prompt for creating reduction using [ rm2 ] : \n", prompt_content )
            print(">>> Press 'Enter' to continue")
            input()

        problem = parent['problem']
        [code_all, code_template] = self._get_code(prompt_content, template=True)

        if self.debug_mode:
            print("\n >>> check designed reduction: \n", problem)
            print("\n >>> check designed code: \n", code_all)
            print("\n >>> check designed template: \n", code_template)
            print(">>> Press 'Enter' to continue")
            input()

        return [code_all, problem, code_template]
