import numpy as np
import pickle
class GetData():
    def __init__(self) -> None:
        self.datasets = {}
        # Data from the Weibull 5k test dataset, containing 5 bin packing instances
        # each with 5,000 items.
        self.datasets['Weibull 5k'] = {'test_0': {'capacity': 100, 'num_items': 5000, 'items': [48, 66, 48, 32, 72, 37, 41, 21, 58, 35, 18, 53, 52, 42, 51, 30, 42, 44, 58, 62, 28, 20, 27, 53, 59, 56, 46, 60, 21, 49, 29, 58, 31, 47, 34, 41, 28, 49, 22, 37, 31, 27, 50, 46, 39, 52, 40, 41, 31, 57, 53, 57, 35, 39, 38, 40, 34, 22, 30, 48, 34, 34, 48, 53, 23, 57, 50, 67, 18, 40, 38, 38, 42, 53, 38, 37, 53, 62, 22, 51, 34, 51, 24, 92, 60, 29, 39, 49, 24, 33, 67, 65, 62, 57, 60, 29, 53, 29, 54, 52, 37, 59, 55, 69, 20, 41, 47, 44, 36, 48, 61, 33, 53, 36, 47, 38, 39, 35, 41, 31, 42, 41, 45, 49, 25, 20, 71, 61, 35, 33, 42, 11, 39, 68, 43, 30, 51, 31, 68, 29, 40, 45, 41, 23, 46, 65, 37, 60, 45, 38, 28, 45, 42, 30, 39, 59, 36, 60, 58, 32, 49, 19, 55, 46, 55, 53, 46, 32, 56, 29, 23, 22, 26, 19, 37, 24, 50, 44, 33, 27, 26, 34, 38, 21, 58, 48, 66, 37, 40, 10, 37, 27, 56, 30, 49, 19, 52, 17, 41, 29, 38, 53, 21, 36, 37, 23, 35, 26, 25, 33, 11, 34, 18, 69, 36, 50, 40, 19, 65, 51, 53, 35, 35, 45, 21, 27, 60, 35, 56, 14, 65, 40, 24, 39, 49, 85, 54, 32, 28, 27, 9, 28, 44, 47, 65, 59, 23, 46, 36, 46, 18, 20, 20, 36, 50, 71, 57, 63, 31, 35, 47, 35, 35, 41, 48, 19, 53, 69, 26, 43, 45, 27, 52, 19, 49, 45, 29, 32, 29, 22, 52, 15, 47, 39, 26, 41, 27, 31, 63, 50, 21, 30, 21, 42, 43, 21, 71, 21, 34, 29, 80, 41, 37, 51, 35, 33, 45, 26, 44, 30, 41, 22, 55, 26, 43, 35, 15, 31, 32, 53, 36, 33, 25, 19, 29, 64, 56, 17, 30, 13, 66, 19, 39, 51, 38, 39, 54, 37, 37, 17, 8, 45, 58, 19, 48, 51, 41, 53, 69, 33, 37, 29, 25, 41, 54, 51, 26, 29, 66, 60, 36, 33, 17, 31, 48, 73, 16, 26, 46, 25, 25, 33, 57, 49, 28, 62, 44, 22, 19, 65, 25, 60, 39, 39, 36, 45, 40, 45, 43, 28, 45, 28, 54, 44, 54, 32, 62, 67, 34, 31, 29, 47, 38, 35, 69, 57, 40, 20, 37, 27, 56, 25, 57, 54, 36, 45, 56, 49, 35, 77, 71, 53, 46, 41, 25, 50, 50, 44, 79, 52, 19, 44, 43, 36, 40, 36, 36, 35, 51, 35, 41, 67, 47, 46, 13, 53, 56, 37, 41, 46, 36, 70, 29, 18, 35, 59, 7, 51, 36, 52, 24, 40, 21, 74, 21, 23, 28, 47, 43, 40, 50, 61, 65, 17, 59, 60, 52, 53, 19, 51, 63, 59, 25, 42, 50, 50, 60, 61, 27, 37, 25, 55, 69, 45, 51, 36, 47, 20, 56, 39, 20, 43, 50, 34, 42, 37, 60, 48, 18, 41, 42, 35, 34, 46, 20, 61, 57, 25, 42, 72, 16, 39, 29, 64, 37, 44, 39, 32, 47, 61, 23, 41, 21, 38, 33, 67, 60, 54, 66, 51, 70, 39, 34, 47, 16, 38, 48, 54, 15, 34, 34, 14, 22, 25, 32, 11, 19, 44, 32, 36, 43, 20, 55, 46, 38, 62, 43, 35, 19, 47, 31, 17, 42, 31, 39, 49, 37, 53, 36, 64, 29, 19, 42, 47, 45, 9, 45, 52, 59, 35, 67, 25, 27, 55, 44, 47, 38, 17, 24, 61, 68, 35, 36, 18, 23, 50, 20, 36, 35, 48, 32, 29, 62, 23, 32, 36, 25, 15, 57, 50, 43, 43, 30, 24, 56, 52, 65, 17, 48, 29, 64, 52, 20, 45, 60, 54, 38, 57, 27, 32, 20, 44, 18, 18, 32, 38, 36, 39, 17, 41, 42, 67, 39, 21, 30, 61, 40, 43, 31, 16, 40, 41, 38, 38, 11, 43, 40, 17, 41, 65, 48, 42, 47, 24, 86, 26, 29, 48, 34, 19, 55, 65, 53, 68, 43, 41, 28, 50, 49, 15, 42, 26, 14, 45, 26, 61, 54, 25, 44, 28, 43, 43, 18, 44, 21, 52, 47, 38, 32, 55, 54, 24, 75, 38, 53, 24, 24, 39, 63, 32, 47, 32, 67, 32, 43, 25, 52, 47, 48, 50, 56, 18, 48, 64, 66, 37, 36, 42, 30, 37, 53, 32, 73, 40, 55, 30, 38, 34, 60, 39, 22, 43, 32, 13, 44, 41, 23, 48, 28, 42, 22, 34, 49, 55, 27, 34, 38, 43, 35, 71, 61, 44, 32, 22, 27, 82, 38, 50, 30, 54, 29, 48, 45, 45, 42, 64, 36, 44, 26, 52, 12, 32, 46, 50, 23, 56, 54, 23, 47, 46, 38, 60, 45, 38, 58, 48, 53, 37, 34, 45, 25, 38, 32, 11, 46, 38, 32, 42, 58, 59, 12, 50, 49, 44, 46, 37, 53, 58, 47, 34, 45, 39, 58, 31, 29, 36, 38, 36, 49, 56, 45, 34, 28, 7, 31, 42, 15, 49, 51, 47, 26, 20, 52, 26, 50, 32, 34, 33, 51, 73, 17, 45, 40, 35, 24, 30, 46, 42, 21, 11, 49, 32, 67, 50, 47, 54, 44, 57, 55, 36, 51, 37, 26, 35, 20, 42, 32, 46, 30, 33, 44, 67, 23, 47, 45, 39, 14, 37, 41, 29, 59, 53, 21, 15, 49, 37, 56, 19, 28, 48, 41, 30, 27, 32, 10, 83, 58, 22, 40, 46, 52, 34, 34, 43, 22, 17, 28, 67, 58, 35, 33, 18, 11, 44, 35, 20, 60, 50, 44, 23, 49, 29, 44, 66, 37, 44, 15, 62, 27, 41, 52, 32, 44, 28, 11, 32, 28, 72, 35, 21, 54, 42, 57, 37, 26, 37, 43, 49, 24, 57, 37, 37, 41, 19, 27, 40, 49, 50, 14, 59, 61, 34, 35, 53, 33, 36, 31, 42, 32, 60, 20, 46, 41, 31, 12, 59, 22, 60, 53, 22, 58, 19, 27, 23, 37, 32, 42, 58, 24, 38, 29, 26, 57, 17, 34, 34, 17, 35, 61, 48, 45, 31, 38, 22, 47, 38, 25, 47, 47, 43, 38, 46, 52, 45, 39, 64, 21, 35, 31, 32, 44, 46, 31, 75, 48, 23, 47, 31, 34, 22, 24, 50, 28, 32, 23, 49, 53, 51, 30, 70, 36, 28, 54, 14, 61, 61, 37, 24, 38, 34, 43, 26, 38, 44, 55, 42, 33, 35, 29, 28, 18, 19, 51, 39, 28, 54, 43, 43, 41, 27, 29, 17, 14, 44, 46, 77, 55, 34, 61, 45, 29, 24, 32, 38, 15, 72, 9, 19, 25, 59, 21, 53, 13, 42, 38, 29, 30, 39, 59, 41, 13, 38, 46, 21, 49, 41, 28, 19, 61, 24, 15, 52, 34, 23, 55, 31, 36, 54, 45, 66, 69, 37, 54, 69, 50, 62, 15, 49, 29, 56, 25, 64, 30, 34, 25, 23, 46, 52, 59, 40, 58, 59, 58, 57, 21, 25, 44, 28, 41, 44, 13, 17, 81, 29, 68, 61, 42, 38, 66, 10, 57, 49, 63, 31, 67, 63, 20, 65, 35, 14, 73, 55, 37, 69, 46, 48, 24, 39, 42, 45, 27, 48, 43, 24, 30, 41, 24, 43, 49, 45, 61, 56, 43, 39, 59, 61, 36, 22, 54, 38, 73, 44, 26, 49, 50, 44, 44, 30, 26, 16, 46, 29, 25, 54, 26, 52, 63, 61, 23, 23, 44, 31, 48, 27, 32, 28, 33, 46, 41, 35, 29, 56, 62, 81, 58, 67, 7, 46, 79, 36, 18, 37, 48, 34, 48, 56, 38, 18, 27, 33, 53, 21, 37, 43, 31, 50, 27, 39, 25, 41, 58, 24, 46, 43, 62, 28, 51, 20, 65, 57, 70, 15, 31, 73, 13, 32, 64, 32, 17, 60, 37, 35, 27, 49, 38, 42, 37, 49, 26, 51, 66, 19, 20, 63, 44, 21, 40, 44, 65, 44, 50, 51, 26, 45, 53, 46, 35, 65, 26, 62, 37, 24, 64, 13, 60, 54, 46, 37, 31, 48, 29, 18, 31, 12, 45, 31, 29, 31, 32, 35, 40, 40, 26, 41, 55, 21, 14, 47, 54, 41, 64, 13, 17, 68, 28, 11, 47, 65, 35, 25, 56, 68, 48, 25, 67, 43, 38, 10, 56, 31, 69, 42, 61, 45, 40, 54, 34, 32, 48, 65, 52, 58, 40, 28, 21, 20, 53, 41, 28, 45, 25, 69, 47, 38, 62, 30, 47, 16, 35, 61, 29, 29, 32, 76, 51, 50, 38, 58, 33, 48, 48, 48, 19, 22, 66, 42, 53, 35, 17, 30, 27, 45, 24, 52, 14, 32, 63, 44, 34, 31, 72, 28, 43, 17, 40, 58, 54, 25, 38, 41, 46, 22, 34, 26, 56, 31, 29, 19, 56, 46, 38, 57, 40, 30, 46, 36, 61, 34, 39, 52, 49, 8, 56, 49, 21, 30, 23, 34, 43, 50, 49, 70, 53, 19, 47, 48, 47, 22, 22, 49, 33, 53, 28, 39, 55, 32, 41, 31, 24, 30, 32, 42, 33, 31, 54, 38, 22, 63, 42, 29, 54, 50, 56, 39, 49, 38, 40, 33, 42, 61, 59, 22, 26, 41, 19, 71, 54, 46, 31, 47, 45, 21, 53, 40, 31, 67, 45, 66, 37, 21, 38, 45, 34, 41, 41, 45, 32, 46, 66, 60, 43, 41, 31, 56, 64, 39, 65, 19, 70, 38, 66, 28, 35, 26, 35, 20, 60, 31, 52, 30, 28, 26, 34, 50, 50, 57, 33, 48, 18, 28, 20, 68, 43, 41, 19, 36, 58, 56, 27, 48, 14, 45, 52, 31, 65, 40, 31, 19, 58, 43, 67, 16, 55, 60, 25, 43, 44, 29, 76, 50, 32, 55, 21, 37, 51, 64, 60, 41, 22, 31, 37, 30, 60, 33, 57, 40, 32, 10, 36, 33, 75, 47, 18, 64, 50, 32, 29, 41, 17, 38, 64, 58, 57, 44, 29, 50, 21, 66, 42, 40, 20, 39, 25, 44, 42, 18, 57, 46, 29, 42, 11, 17, 49, 38, 22, 3, 43, 34, 38, 21, 65, 44, 24, 28, 58, 51, 73, 34, 35, 36, 64, 59, 54, 16, 22, 39, 35, 18, 40, 50, 29, 43, 41, 11, 27, 49, 86, 49, 27, 44, 28, 19, 31, 31, 78, 23, 25, 44, 17, 34, 36, 22, 39, 6, 31, 41, 34, 37, 35, 36, 62, 65, 18, 25, 42, 39, 61, 41, 61, 55, 58, 32, 56, 44, 37, 35, 39, 41, 39, 58, 59, 45, 42, 50, 46, 76, 62, 27, 50, 50, 66, 30, 59, 34, 9, 32, 12, 30, 47, 32, 30, 48, 41, 33, 71, 39, 47, 49, 20, 28, 67, 29, 35, 28, 17, 45, 72, 48, 26, 52, 26, 71, 34, 60, 27, 64, 20, 54, 34, 57, 38, 68, 38, 45, 54, 21, 39, 41, 13, 39, 31, 22, 53, 44, 52, 18, 41, 22, 34, 30, 29, 12, 38, 62, 51, 61, 11, 35, 46, 33, 49, 9, 38, 50, 35, 38, 52, 42, 68, 48, 69, 50, 56, 40, 55, 34, 66, 25, 34, 25, 28, 53, 51, 40, 51, 77, 26, 29, 42, 36, 44, 43, 39, 62, 54, 42, 34, 7, 59, 65, 21, 39, 51, 57, 25, 28, 47, 37, 33, 66, 47, 31, 52, 46, 25, 51, 41, 41, 24, 47, 41, 47, 42, 65, 56, 40, 39, 68, 9, 50, 53, 27, 59, 49, 38, 38, 52, 29, 15, 46, 40, 47, 40, 45, 21, 36, 31, 27, 35, 48, 50, 54, 21, 32, 47, 29, 24, 35, 37, 38, 40, 51, 52, 56, 29, 17, 40, 51, 41, 28, 16, 55, 38, 25, 43, 43, 58, 55, 63, 46, 24, 26, 35, 48, 56, 20, 48, 54, 43, 24, 48, 29, 43, 24, 1, 44, 45, 27, 62, 41, 30, 32, 69, 39, 45, 45, 42, 22, 43, 25, 7, 32, 38, 49, 42, 50, 53, 61, 45, 53, 52, 50, 40, 56, 31, 47, 27, 46, 51, 18, 35, 23, 25, 35, 37, 49, 38, 44, 36, 35, 54, 28, 59, 48, 34, 42, 57, 39, 44, 49, 42, 47, 40, 37, 35, 59, 3, 55, 43, 32, 60, 17, 15, 39, 34, 28, 52, 21, 39, 32, 61, 50, 57, 46, 58, 52, 49, 43, 34, 30, 25, 69, 58, 28, 34, 40, 25, 40, 25, 42, 42, 35, 42, 30, 33, 19, 38, 49, 65, 45, 57, 6, 32, 45, 48, 73, 26, 47, 28, 66, 36, 38, 44, 53, 29, 48, 40, 59, 47, 53, 43, 39, 55, 59, 42, 33, 45, 47, 30, 30, 30, 40, 57, 63, 48, 50, 69, 56, 40, 37, 31, 55, 75, 47, 18, 34, 35, 46, 19, 20, 25, 47, 13, 32, 57, 40, 24, 38, 16, 46, 9, 24, 44, 51, 46, 25, 54, 17, 33, 41, 21, 50, 45, 48, 33, 32, 35, 33, 43, 18, 56, 61, 83, 48, 21, 36, 73, 34, 32, 38, 19, 55, 37, 62, 61, 47, 74, 47, 41, 31, 47, 52, 81, 54, 42, 47, 45, 61, 25, 36, 57, 27, 42, 61, 35, 52, 87, 61, 21, 20, 28, 50, 20, 23, 57, 67, 64, 17, 38, 42, 18, 47, 34, 64, 22, 41, 44, 38, 19, 12, 31, 36, 45, 49, 54, 40, 29, 26, 33, 39, 36, 43, 32, 34, 32, 13, 37, 45, 67, 36, 43, 53, 19, 53, 33, 29, 36, 47, 45, 47, 21, 34, 23, 43, 26, 16, 35, 48, 31, 47, 53, 34, 31, 65, 50, 47, 18, 8, 38, 48, 40, 27, 46, 55, 22, 23, 62, 29, 50, 20, 64, 51, 46, 49, 40, 27, 47, 31, 33, 28, 42, 52, 41, 33, 25, 33, 27, 23, 52, 43, 47, 7, 14, 41, 50, 33, 38, 20, 49, 39, 55, 47, 43, 22, 24, 63, 29, 65, 24, 27, 21, 57, 34, 42, 29, 28, 74, 31, 25, 45, 26, 10, 45, 5, 35, 15, 33, 18, 27, 58, 51, 48, 18, 56, 34, 44, 48, 36, 49, 87, 48, 57, 35, 23, 51, 24, 33, 34, 39, 42, 20, 37, 47, 52, 31, 27, 12, 41, 37, 80, 33, 61, 79, 71, 47, 70, 60, 60, 29, 42, 50, 27, 32, 57, 41, 27, 31, 62, 37, 30, 53, 46, 40, 33, 62, 39, 31, 74, 25, 55, 36, 71, 59, 28, 8, 28, 23, 53, 13, 31, 10, 56, 50, 43, 22, 53, 63, 33, 34, 50, 30, 34, 38, 36, 29, 31, 22, 42, 74, 37, 50, 39, 42, 29, 62, 38, 16, 58, 18, 49, 58, 50, 23, 36, 36, 53, 47, 57, 77, 45, 44, 11, 32, 22, 48, 49, 25, 61, 59, 69, 21, 44, 69, 45, 41, 22, 44, 40, 53, 43, 27, 46, 21, 47, 26, 24, 35, 38, 46, 59, 66, 48, 45, 42, 36, 47, 45, 18, 49, 5, 27, 33, 58, 78, 16, 23, 19, 34, 16, 46, 48, 36, 28, 56, 49, 53, 43, 27, 42, 41, 39, 23, 24, 20, 30, 12, 68, 30, 59, 29, 17, 29, 39, 51, 47, 59, 50, 52, 23, 18, 78, 67, 16, 50, 49, 19, 55, 31, 47, 50, 66, 45, 35, 33, 39, 42, 42, 49, 42, 62, 46, 56, 31, 43, 36, 38, 34, 61, 50, 55, 42, 34, 31, 38, 21, 52, 33, 65, 46, 26, 55, 35, 19, 60, 69, 47, 24, 22, 45, 40, 43, 66, 49, 32, 21, 15, 51, 50, 20, 69, 15, 36, 31, 49, 18, 41, 21, 48, 18, 47, 11, 46, 45, 19, 60, 53, 28, 15, 24, 47, 49, 40, 40, 65, 56, 54, 61, 61, 25, 39, 61, 30, 47, 49, 31, 27, 23, 51, 37, 47, 46, 36, 19, 45, 22, 46, 31, 48, 8, 44, 20, 15, 12, 52, 30, 24, 40, 19, 54, 70, 58, 55, 25, 48, 49, 49, 23, 60, 23, 44, 39, 28, 57, 55, 58, 44, 27, 36, 53, 32, 18, 36, 58, 41, 25, 43, 46, 18, 40, 35, 55, 46, 37, 23, 16, 56, 26, 32, 34, 61, 68, 48, 43, 35, 40, 51, 30, 22, 41, 25, 43, 63, 44, 50, 27, 38, 32, 30, 20, 46, 63, 6, 50, 32, 47, 59, 29, 48, 30, 72, 19, 41, 34, 21, 24, 29, 43, 46, 36, 68, 37, 41, 66, 52, 19, 50, 36, 26, 26, 41, 19, 48, 71, 37, 72, 22, 42, 54, 33, 20, 63, 56, 30, 44, 44, 49, 60, 45, 63, 14, 44, 40, 66, 36, 22, 46, 13, 42, 27, 9, 63, 48, 73, 38, 32, 9, 28, 60, 53, 50, 39, 36, 51, 37, 59, 49, 53, 37, 44, 48, 42, 29, 65, 37, 54, 35, 22, 10, 40, 36, 35, 25, 43, 59, 4, 33, 18, 23, 50, 33, 60, 48, 27, 18, 47, 55, 51, 63, 45, 56, 50, 57, 44, 22, 55, 34, 48, 43, 39, 27, 41, 31, 33, 21, 27, 34, 29, 37, 27, 48, 44, 55, 55, 33, 51, 52, 70, 51, 29, 71, 42, 51, 49, 27, 35, 36, 38, 43, 38, 59, 50, 52, 33, 54, 62, 28, 41, 23, 44, 25, 21, 61, 54, 35, 19, 54, 31, 38, 21, 50, 46, 26, 47, 46, 32, 48, 48, 39, 37, 24, 33, 19, 51, 34, 51, 27, 56, 35, 34, 33, 57, 33, 10, 48, 30, 49, 61, 37, 70, 40, 35, 35, 30, 27, 52, 38, 52, 57, 36, 43, 15, 27, 50, 55, 14, 37, 40, 71, 69, 26, 43, 31, 47, 43, 41, 44, 24, 17, 29, 64, 26, 27, 82, 17, 35, 53, 16, 22, 20, 34, 52, 32, 50, 51, 17, 28, 34, 42, 58, 23, 28, 30, 69, 37, 57, 52, 41, 29, 40, 58, 63, 66, 24, 39, 88, 44, 50, 31, 15, 51, 68, 24, 34, 34, 37, 51, 27, 64, 34, 50, 40, 43, 42, 47, 39, 30, 23, 23, 23, 51, 39, 27, 46, 64, 49, 50, 15, 15, 31, 29, 33, 50, 52, 24, 45, 41, 52, 61, 30, 40, 34, 51, 46, 36, 17, 50, 27, 47, 52, 54, 23, 64, 48, 40, 57, 11, 49, 29, 23, 62, 43, 66, 24, 16, 57, 10, 16, 20, 57, 23, 52, 34, 46, 29, 57, 48, 37, 45, 13, 47, 41, 42, 45, 65, 18, 50, 43, 40, 52, 49, 52, 29, 43, 37, 57, 79, 45, 51, 68, 33, 36, 30, 42, 37, 66, 40, 42, 44, 34, 59, 36, 34, 26, 44, 32, 36, 53, 44, 50, 24, 32, 13, 33, 23, 33, 35, 32, 49, 38, 54, 17, 39, 20, 45, 77, 53, 69, 22, 56, 50, 10, 44, 38, 56, 62, 35, 47, 65, 37, 58, 38, 31, 57, 22, 46, 19, 21, 55, 53, 39, 29, 45, 26, 49, 40, 41, 34, 36, 10, 51, 49, 40, 34, 16, 51, 26, 51, 24, 36, 42, 45, 56, 30, 36, 42, 22, 27, 32, 45, 50, 43, 61, 33, 56, 38, 38, 48, 37, 31, 14, 37, 17, 13, 37, 55, 13, 56, 34, 43, 33, 23, 29, 48, 51, 32, 18, 41, 32, 37, 53, 36, 49, 22, 38, 40, 28, 62, 43, 42, 40, 31, 36, 58, 29, 44, 35, 46, 37, 42, 43, 39, 53, 37, 35, 31, 42, 20, 24, 52, 37, 42, 66, 43, 12, 61, 17, 46, 34, 14, 45, 22, 22, 44, 15, 29, 51, 43, 50, 31, 30, 42, 45, 39, 55, 35, 50, 45, 66, 43, 54, 47, 45, 30, 37, 39, 24, 26, 34, 47, 42, 38, 64, 32, 28, 32, 33, 32, 36, 36, 27, 23, 62, 29, 62, 48, 39, 27, 58, 33, 35, 58, 50, 29, 24, 34, 69, 28, 19, 29, 26, 28, 28, 46, 79, 40, 61, 81, 66, 63, 68, 47, 24, 52, 17, 40, 22, 19, 20, 20, 44, 33, 66, 39, 32, 45, 17, 14, 44, 45, 34, 47, 58, 40, 64, 35, 31, 31, 39, 28, 38, 48, 43, 23, 22, 35, 45, 37, 41, 40, 20, 22, 33, 11, 45, 44, 58, 35, 48, 38, 53, 50, 27, 34, 23, 40, 39, 55, 70, 40, 17, 51, 28, 22, 34, 24, 21, 61, 50, 44, 64, 26, 58, 23, 63, 57, 40, 25, 27, 21, 37, 37, 46, 36, 41, 35, 73, 33, 26, 15, 14, 8, 43, 57, 29, 38, 49, 22, 34, 70, 41, 42, 37, 35, 28, 25, 37, 25, 29, 39, 42, 26, 47, 67, 11, 58, 50, 44, 21, 44, 31, 62, 30, 25, 35, 58, 40, 79, 19, 35, 54, 23, 55, 30, 51, 47, 33, 65, 36, 26, 33, 37, 33, 54, 31, 61, 59, 45, 49, 58, 31, 6, 24, 9, 41, 68, 35, 43, 64, 34, 76, 42, 43, 39, 60, 37, 38, 14, 40, 42, 65, 76, 56, 67, 43, 39, 45, 33, 21, 21, 41, 15, 9, 15, 49, 57, 58, 46, 58, 68, 21, 79, 51, 70, 19, 26, 37, 42, 51, 32, 16, 32, 15, 57, 36, 72, 43, 29, 28, 57, 42, 54, 19, 28, 46, 34, 47, 43, 57, 60, 54, 34, 41, 60, 30, 58, 48, 37, 48, 56, 64, 63, 57, 30, 44, 60, 48, 50, 32, 68, 52, 59, 69, 40, 34, 51, 79, 21, 47, 60, 65, 27, 50, 22, 38, 40, 41, 7, 59, 59, 24, 24, 55, 48, 43, 41, 37, 56, 55, 26, 51, 35, 33, 48, 33, 42, 40, 41, 52, 37, 14, 67, 34, 3, 14, 82, 58, 32, 46, 49, 59, 44, 18, 27, 34, 49, 63, 49, 16, 26, 61, 38, 42, 12, 13, 54, 18, 33, 38, 53, 38, 38, 34, 49, 40, 42, 26, 18, 28, 33, 30, 45, 47, 12, 60, 37, 73, 61, 31, 6, 37, 27, 21, 26, 39, 37, 30, 35, 60, 38, 49, 32, 74, 30, 43, 74, 29, 34, 51, 51, 33, 29, 41, 36, 33, 65, 49, 32, 56, 22, 41, 53, 59, 27, 27, 38, 35, 37, 42, 63, 45, 35, 61, 53, 37, 57, 44, 32, 24, 40, 40, 37, 53, 48, 18, 40, 62, 49, 65, 16, 24, 64, 55, 37, 50, 60, 49, 41, 70, 50, 41, 26, 46, 41, 30, 43, 40, 32, 41, 31, 31, 20, 41, 28, 22, 59, 36, 38, 42, 38, 16, 59, 52, 49, 26, 34, 43, 24, 20, 48, 39, 14, 25, 24, 29, 43, 37, 50, 20, 43, 71, 53, 39, 52, 29, 35, 55, 43, 30, 70, 16, 49, 59, 44, 47, 34, 56, 53, 29, 41, 46, 40, 39, 28, 23, 26, 36, 61, 41, 38, 46, 49, 34, 36, 14, 34, 48, 21, 33, 22, 35, 51, 35, 14, 54, 53, 41, 52, 48, 39, 36, 44, 36, 41, 45, 56, 32, 21, 64, 48, 24, 32, 29, 33, 34, 38, 41, 54, 33, 27, 29, 59, 43, 37, 27, 50, 25, 38, 23, 61, 47, 48, 60, 45, 30, 14, 35, 57, 39, 29, 40, 32, 40, 43, 47, 33, 47, 42, 34, 50, 23, 24, 26, 31, 28, 49, 30, 56, 9, 30, 30, 45, 17, 54, 58, 16, 17, 39, 32, 53, 38, 23, 46, 33, 12, 39, 31, 44, 46, 62, 35, 68, 45, 54, 47, 30, 50, 43, 60, 44, 12, 50, 28, 60, 66, 45, 38, 50, 31, 26, 40, 25, 25, 31, 54, 50, 53, 23, 18, 54, 53, 49, 66, 52, 12, 28, 60, 25, 54, 72, 48, 33, 46, 44, 44, 37, 54, 63, 33, 41, 32, 43, 35, 79, 52, 41, 68, 22, 53, 29, 31, 43, 43, 63, 37, 44, 43, 17, 36, 34, 58, 54, 54, 26, 27, 26, 49, 22, 51, 39, 57, 31, 32, 8, 44, 16, 23, 30, 51, 27, 54, 37, 32, 55, 41, 25, 39, 54, 15, 22, 47, 34, 61, 27, 53, 45, 44, 35, 41, 52, 42, 39, 45, 65, 61, 67, 43, 40, 38, 43, 44, 31, 35, 63, 57, 47, 28, 21, 36, 57, 54, 52, 32, 53, 23, 62, 22, 33, 32, 48, 39, 43, 20, 49, 51, 54, 46, 31, 41, 12, 49, 20, 36, 37, 62, 32, 33, 31, 34, 52, 35, 62, 24, 50, 52, 25, 8, 31, 22, 60, 52, 33, 57, 63, 59, 42, 28, 50, 25, 35, 56, 70, 65, 64, 46, 55, 16, 21, 44, 51, 39, 62, 46, 50, 53, 26, 24, 32, 26, 62, 17, 36, 55, 42, 50, 44, 43, 45, 22, 19, 62, 18, 35, 56, 27, 47, 42, 47, 7, 42, 29, 49, 50, 52, 42, 17, 53, 41, 53, 42, 45, 54, 63, 56, 23, 57, 45, 34, 29, 34, 14, 38, 42, 38, 43, 57, 32, 23, 42, 25, 16, 28, 39, 30, 54, 36, 32, 52, 83, 80, 35, 19, 23, 23, 34, 20, 46, 20, 57, 52, 34, 50, 48, 40, 51, 51, 65, 37, 8, 43, 40, 35, 38, 61, 22, 41, 56, 62, 30, 51, 29, 29, 51, 35, 39, 39, 28, 18, 53, 22, 47, 5, 30, 34, 30, 71, 57, 44, 58, 43, 56, 36, 38, 24, 33, 43, 28, 51, 36, 43, 68, 37, 49, 41, 9, 33, 42, 68, 45, 24, 50, 67, 47, 66, 50, 43, 15, 69, 42, 25, 48, 65, 37, 42, 65, 31, 45, 27, 34, 41, 68, 40, 21, 33, 19, 51, 39, 15, 19, 48, 53, 40, 83, 8, 50, 59, 47, 52, 60, 43, 57, 37, 49, 45, 52, 57, 10, 53, 25, 32, 58, 40, 33, 44, 32, 36, 44, 39, 19, 40, 54, 21, 48, 51, 37, 58, 14, 40, 55, 74, 37, 33, 30, 39, 72, 40, 34, 15, 34, 60, 55, 42, 38, 44, 51, 43, 12, 44, 43, 46, 15, 73, 37, 25, 9, 67, 30, 39, 59, 36, 19, 57, 31, 29, 36, 23, 13, 32, 50, 25, 39, 57, 48, 28, 45, 52, 31, 37, 53, 33, 47, 24, 33, 36, 62, 38, 29, 80, 27, 54, 42, 27, 61, 48, 13, 61, 53, 46, 19, 28, 42, 49, 43, 50, 34, 35, 17, 24, 44, 57, 17, 15, 21, 45, 25, 40, 38, 27, 31, 35, 46, 23, 25, 31, 61, 19, 38, 50, 29, 34, 36, 55, 34, 48, 68, 37, 37, 80, 26, 31, 23, 52, 26, 42, 20, 22, 61, 20, 42, 28, 34, 51, 38, 71, 60, 39, 39, 27, 34, 37, 14, 50, 38, 58, 55, 43, 20, 33, 44, 39, 32, 12, 35, 36, 53, 23, 23, 29, 14, 45, 53, 53, 61, 22, 78, 39, 46, 40, 60, 64, 39, 32, 32, 43, 13, 40, 15, 36, 55, 67, 39, 15, 29, 29, 56, 44, 66, 43, 50, 31, 40, 37, 54, 39, 42, 40, 25, 17, 32, 38, 59, 38, 26, 28, 7, 28, 60, 24, 36, 41, 45, 41, 22, 43, 40, 26, 24, 44, 39, 21, 38, 44, 44, 51, 25, 65, 59, 34, 27, 47, 43, 45, 14, 42, 20, 31, 16, 31, 35, 36, 45, 52, 48, 32, 40, 58, 27, 30, 23, 53, 25, 48, 35, 75, 13, 36, 38, 39, 49, 69, 20, 41, 58, 26, 45, 48, 17, 29, 49, 38, 27, 45, 17, 40, 68, 16, 17, 41, 50, 26, 20, 28, 36, 23, 27, 39, 46, 25, 24, 47, 60, 44, 47, 29, 25, 58, 36, 39, 53, 33, 35, 48, 41, 39, 34, 16, 64, 50, 45, 53, 16, 37, 59, 51, 50, 30, 59, 20, 15, 39, 65, 40, 25, 36, 53, 40, 57, 42, 48, 66, 26, 51, 25, 41, 75, 54, 34, 52, 15, 56, 41, 49, 42, 26, 26, 33, 64, 46, 45, 14, 33, 60, 26, 59, 58, 53, 27, 51, 15, 41, 10, 33, 22, 31, 48, 21, 51, 27, 18, 37, 49, 51, 37, 68, 21, 35, 69, 42, 29, 41, 34, 64, 15, 28, 35, 38, 50, 50, 34, 62, 59, 27, 53, 23, 43, 48, 33, 15, 55, 40, 54, 37, 34, 31, 26, 50, 28, 44, 22, 59, 43, 40, 47, 34, 61, 34, 44, 42, 54, 57, 50, 46, 37, 21, 26, 39, 61, 33, 37, 45, 28, 44, 20, 50, 24, 40, 36, 44, 44, 44, 22, 73, 49, 18, 16, 39, 61, 31, 48, 20, 27, 59, 31, 45, 43, 32, 46, 29, 46, 16, 28, 35, 45, 42, 32, 29, 69, 35, 43, 25, 56, 53, 31, 34, 21, 60, 30, 59, 41, 42, 59, 49, 37, 30, 28, 61, 17, 52, 23, 33, 34, 36, 19, 45, 46, 27, 25, 33, 38, 50, 24, 19, 34, 51, 35, 38, 33, 36, 34, 25, 34, 33, 39, 20, 56, 30, 26, 27, 42, 65, 42, 55, 38, 38, 43, 45, 43, 9, 51, 58, 34, 39, 64, 42, 20, 47, 26, 26, 22, 47, 46, 41, 49, 19, 46, 73, 41, 32, 19, 57, 65, 22, 17, 26, 26, 46, 66, 47, 61, 70, 38, 42, 56, 34, 36, 52, 34, 59, 66, 69, 58, 29, 48, 21, 48, 50, 28, 42, 30, 55, 42, 39, 69, 50, 76, 55, 54, 40, 58, 39, 54, 31, 39, 50, 32, 49, 45, 61, 39, 38, 45, 49, 52, 43, 27, 19, 59, 35, 23, 55, 34, 32, 61, 22, 33, 51, 23, 17, 52, 62, 59, 54, 48, 24, 27, 22, 58, 28, 29, 7, 33, 60, 50, 56, 10, 11, 42, 35, 56, 53, 18, 37, 24, 70, 28, 35, 35, 13, 23, 46, 19, 29, 52, 49, 55, 45, 28, 47, 37, 40, 42, 67, 28, 37, 16, 27, 43, 41, 40, 54, 60, 38, 45, 65, 21, 33, 55, 34, 44, 29, 45, 34, 65, 60, 10, 44, 28, 21, 53, 54, 48, 41, 34, 41, 32, 42, 18, 31, 22, 45, 54, 44, 49, 22, 37, 41, 59, 32, 35, 37, 38, 66, 49, 53, 30, 31, 18, 49, 14, 56, 40, 27, 18, 16, 16, 31, 66, 46, 41, 21, 54, 51, 51, 42, 43, 31, 36, 32, 17, 35, 30, 29, 38, 47, 32, 13, 57, 45, 35, 60, 38]}, 'test_1': {'capacity': 100, 'num_items': 5000, 'items': [42, 57, 41, 42, 43, 30, 26, 21, 42, 24, 37, 52, 50, 32, 76, 58, 69, 35, 30, 42, 40, 28, 63, 60, 42, 46, 38, 39, 45, 43, 53, 72, 26, 41, 39, 19, 63, 43, 32, 29, 48, 33, 29, 17, 44, 13, 57, 48, 12, 60, 51, 27, 55, 40, 22, 63, 37, 53, 34, 25, 41, 54, 36, 46, 43, 44, 41, 42, 20, 35, 31, 32, 72, 36, 20, 26, 26, 65, 48, 31, 71, 43, 46, 36, 33, 52, 32, 35, 56, 35, 29, 36, 61, 50, 66, 36, 29, 13, 60, 43, 40, 66, 49, 28, 48, 23, 35, 55, 84, 50, 50, 39, 33, 45, 42, 40, 27, 26, 21, 54, 30, 59, 18, 41, 52, 8, 19, 64, 41, 38, 50, 53, 65, 20, 15, 18, 36, 27, 27, 30, 43, 10, 33, 55, 26, 28, 48, 50, 36, 43, 39, 42, 48, 8, 46, 21, 15, 59, 33, 41, 40, 46, 44, 33, 42, 30, 32, 57, 30, 32, 30, 30, 41, 77, 49, 14, 54, 56, 68, 53, 24, 31, 29, 43, 22, 16, 26, 47, 18, 46, 29, 13, 47, 33, 44, 40, 60, 22, 66, 55, 37, 41, 37, 32, 37, 53, 77, 42, 28, 35, 32, 28, 27, 63, 36, 38, 61, 40, 17, 66, 53, 45, 55, 24, 3, 45, 53, 43, 59, 70, 45, 33, 68, 44, 39, 64, 56, 27, 42, 24, 54, 61, 51, 34, 58, 44, 44, 45, 56, 38, 40, 14, 57, 51, 25, 15, 35, 57, 51, 45, 16, 30, 29, 31, 45, 35, 47, 20, 20, 20, 34, 57, 61, 37, 34, 23, 31, 40, 46, 49, 59, 41, 39, 42, 23, 44, 29, 32, 31, 35, 19, 20, 54, 12, 35, 53, 40, 70, 39, 31, 43, 38, 28, 33, 38, 50, 33, 19, 30, 60, 45, 30, 43, 39, 47, 40, 33, 32, 15, 26, 53, 51, 63, 27, 55, 34, 56, 26, 56, 52, 42, 45, 39, 35, 65, 47, 33, 26, 50, 63, 24, 32, 34, 24, 47, 51, 66, 45, 42, 30, 49, 57, 40, 21, 21, 43, 31, 42, 33, 11, 75, 46, 40, 43, 34, 43, 38, 56, 42, 28, 51, 27, 44, 51, 28, 53, 41, 27, 27, 36, 50, 48, 56, 68, 28, 45, 54, 56, 33, 49, 26, 29, 33, 30, 53, 39, 26, 51, 19, 39, 27, 29, 56, 32, 40, 55, 40, 21, 32, 32, 19, 18, 54, 41, 27, 46, 43, 31, 17, 46, 31, 39, 39, 56, 34, 40, 23, 32, 28, 38, 21, 50, 51, 21, 37, 28, 35, 34, 48, 10, 45, 46, 62, 10, 24, 56, 60, 46, 54, 42, 47, 40, 20, 58, 45, 41, 16, 25, 72, 58, 42, 55, 36, 39, 31, 34, 6, 53, 52, 31, 46, 43, 24, 78, 56, 12, 43, 30, 59, 38, 48, 32, 11, 33, 36, 22, 53, 34, 70, 45, 40, 38, 30, 31, 70, 46, 20, 72, 35, 22, 32, 39, 44, 58, 34, 32, 41, 81, 52, 62, 27, 50, 29, 51, 40, 37, 48, 50, 48, 45, 9, 16, 33, 42, 50, 66, 16, 12, 77, 21, 58, 22, 38, 12, 27, 57, 19, 61, 41, 33, 25, 35, 61, 60, 66, 22, 56, 59, 34, 35, 38, 53, 53, 40, 36, 13, 27, 25, 35, 35, 66, 41, 64, 47, 62, 50, 36, 48, 33, 41, 39, 45, 49, 35, 63, 37, 16, 42, 35, 45, 24, 48, 35, 48, 21, 14, 22, 63, 26, 23, 40, 59, 48, 58, 44, 32, 69, 72, 41, 41, 51, 15, 29, 22, 42, 49, 40, 35, 48, 18, 29, 23, 25, 28, 54, 19, 13, 67, 37, 43, 31, 13, 46, 30, 29, 47, 48, 46, 49, 31, 38, 40, 54, 39, 49, 49, 50, 16, 20, 33, 46, 59, 33, 46, 49, 36, 41, 32, 44, 52, 49, 76, 32, 42, 45, 52, 47, 38, 21, 49, 22, 63, 35, 34, 51, 42, 73, 30, 62, 55, 25, 56, 51, 48, 49, 51, 52, 24, 55, 50, 25, 17, 30, 31, 33, 25, 47, 29, 38, 16, 28, 35, 51, 40, 4, 52, 15, 30, 27, 41, 43, 72, 21, 52, 47, 22, 51, 71, 29, 62, 38, 26, 64, 19, 32, 49, 39, 47, 56, 39, 51, 36, 51, 36, 57, 79, 41, 40, 47, 30, 31, 54, 45, 16, 22, 40, 46, 23, 27, 53, 53, 33, 19, 9, 11, 56, 45, 34, 37, 53, 50, 36, 48, 49, 40, 49, 32, 45, 19, 48, 33, 33, 36, 52, 32, 50, 27, 31, 19, 30, 21, 54, 68, 64, 28, 56, 8, 55, 34, 22, 54, 30, 60, 37, 29, 18, 20, 10, 17, 19, 27, 41, 35, 34, 55, 28, 51, 35, 22, 47, 41, 44, 46, 28, 20, 22, 28, 47, 50, 86, 43, 50, 20, 13, 55, 54, 45, 50, 51, 21, 53, 42, 45, 46, 39, 48, 47, 35, 14, 29, 29, 56, 57, 51, 42, 21, 40, 26, 55, 41, 32, 37, 16, 58, 52, 42, 58, 35, 61, 38, 15, 54, 8, 44, 47, 30, 69, 36, 42, 27, 28, 45, 45, 68, 18, 50, 55, 21, 32, 36, 33, 48, 29, 42, 23, 65, 37, 31, 25, 37, 52, 39, 11, 26, 51, 80, 35, 37, 40, 40, 31, 67, 35, 36, 41, 72, 34, 64, 17, 35, 44, 22, 37, 67, 49, 65, 53, 52, 40, 34, 35, 22, 43, 17, 43, 56, 46, 31, 16, 39, 39, 47, 58, 47, 43, 32, 18, 42, 48, 61, 46, 37, 46, 61, 57, 41, 29, 34, 17, 53, 18, 51, 44, 38, 55, 44, 59, 32, 64, 19, 30, 12, 34, 45, 35, 26, 20, 33, 9, 12, 52, 29, 23, 28, 28, 59, 34, 30, 51, 45, 9, 22, 34, 33, 17, 29, 45, 13, 15, 24, 51, 24, 48, 27, 33, 53, 28, 16, 34, 35, 37, 11, 57, 17, 59, 30, 36, 60, 69, 48, 33, 32, 35, 50, 29, 34, 55, 12, 28, 12, 42, 33, 50, 62, 14, 61, 50, 43, 56, 22, 45, 32, 26, 63, 19, 6, 24, 28, 25, 31, 38, 48, 73, 49, 29, 16, 37, 50, 54, 56, 19, 61, 47, 31, 28, 42, 66, 45, 75, 55, 27, 13, 16, 49, 26, 28, 66, 24, 35, 59, 38, 47, 23, 19, 34, 30, 49, 36, 48, 25, 5, 27, 46, 46, 22, 54, 9, 61, 17, 41, 43, 34, 29, 56, 44, 38, 36, 23, 31, 60, 44, 23, 38, 33, 20, 28, 28, 56, 45, 25, 40, 51, 55, 38, 36, 48, 45, 62, 66, 58, 30, 36, 40, 55, 36, 51, 57, 24, 49, 32, 29, 26, 45, 33, 39, 36, 55, 21, 17, 23, 38, 26, 72, 48, 46, 40, 58, 36, 39, 45, 31, 31, 48, 69, 22, 18, 65, 47, 56, 51, 32, 37, 29, 30, 38, 32, 30, 34, 34, 38, 46, 35, 33, 28, 54, 53, 78, 35, 60, 48, 32, 22, 35, 47, 20, 24, 20, 35, 50, 36, 58, 29, 40, 45, 22, 20, 27, 77, 24, 40, 31, 45, 50, 57, 47, 42, 34, 42, 48, 64, 43, 35, 44, 21, 26, 48, 32, 32, 22, 38, 30, 35, 40, 64, 32, 49, 28, 15, 43, 54, 22, 61, 45, 45, 39, 48, 39, 74, 52, 55, 50, 51, 42, 32, 29, 28, 13, 42, 39, 53, 48, 35, 45, 31, 38, 39, 26, 54, 23, 45, 30, 58, 31, 29, 47, 19, 74, 22, 41, 20, 70, 25, 32, 62, 16, 22, 64, 17, 50, 24, 49, 33, 20, 54, 15, 32, 67, 57, 38, 65, 35, 50, 55, 51, 23, 65, 31, 53, 36, 34, 49, 65, 32, 62, 33, 49, 52, 33, 47, 29, 36, 45, 24, 44, 30, 71, 32, 37, 36, 48, 48, 23, 36, 55, 23, 30, 37, 30, 48, 22, 39, 25, 27, 49, 34, 28, 33, 52, 55, 36, 60, 29, 44, 52, 48, 55, 16, 51, 41, 35, 30, 48, 33, 55, 24, 56, 50, 36, 49, 15, 37, 64, 56, 41, 15, 38, 21, 31, 61, 54, 32, 52, 41, 65, 41, 53, 37, 35, 23, 56, 40, 53, 11, 34, 53, 27, 48, 47, 80, 20, 57, 64, 44, 56, 26, 10, 31, 21, 32, 19, 26, 42, 27, 43, 59, 20, 70, 47, 17, 42, 13, 40, 45, 13, 47, 32, 42, 39, 63, 22, 30, 67, 63, 65, 37, 32, 53, 36, 43, 50, 12, 37, 39, 29, 35, 41, 40, 44, 50, 62, 33, 49, 43, 27, 46, 43, 13, 49, 49, 19, 42, 34, 44, 61, 59, 27, 30, 33, 45, 20, 21, 66, 47, 51, 49, 49, 32, 20, 74, 33, 66, 49, 45, 33, 29, 32, 18, 7, 37, 64, 43, 65, 25, 35, 45, 30, 31, 58, 29, 20, 9, 35, 13, 26, 41, 24, 50, 20, 64, 39, 35, 68, 40, 54, 48, 48, 67, 43, 51, 38, 35, 50, 65, 30, 46, 64, 27, 7, 46, 68, 53, 37, 66, 37, 3, 65, 50, 38, 31, 32, 29, 64, 34, 21, 32, 47, 27, 38, 31, 50, 54, 55, 34, 30, 24, 37, 42, 26, 24, 30, 46, 54, 29, 34, 39, 36, 16, 57, 50, 25, 21, 37, 43, 39, 40, 49, 44, 46, 13, 28, 41, 62, 32, 36, 30, 56, 37, 38, 72, 6, 47, 39, 37, 74, 36, 53, 31, 34, 28, 27, 47, 45, 54, 23, 50, 28, 49, 43, 45, 65, 21, 17, 35, 21, 16, 20, 47, 17, 45, 29, 24, 61, 50, 28, 26, 46, 18, 40, 27, 42, 46, 48, 24, 36, 23, 61, 55, 62, 56, 28, 36, 73, 61, 48, 41, 6, 18, 46, 48, 38, 48, 68, 26, 41, 28, 54, 36, 58, 27, 49, 40, 16, 44, 69, 36, 23, 35, 45, 55, 58, 39, 24, 43, 32, 45, 46, 50, 30, 44, 61, 57, 37, 45, 72, 33, 30, 50, 28, 23, 26, 36, 51, 36, 44, 37, 27, 38, 29, 47, 55, 27, 31, 17, 36, 53, 74, 44, 47, 36, 37, 35, 54, 26, 52, 34, 31, 49, 61, 27, 31, 29, 21, 47, 69, 49, 27, 49, 44, 41, 60, 57, 48, 48, 65, 50, 41, 53, 26, 47, 38, 22, 18, 44, 23, 52, 48, 45, 41, 18, 38, 42, 21, 45, 72, 46, 35, 49, 54, 54, 20, 43, 42, 63, 45, 38, 14, 22, 55, 51, 37, 12, 52, 38, 20, 43, 45, 78, 24, 21, 23, 20, 29, 24, 37, 46, 38, 22, 38, 33, 40, 31, 30, 25, 50, 14, 47, 29, 20, 56, 20, 42, 35, 44, 49, 68, 34, 15, 46, 40, 31, 57, 28, 35, 37, 16, 46, 12, 67, 39, 21, 23, 41, 59, 50, 13, 36, 73, 41, 29, 44, 45, 47, 59, 72, 51, 61, 23, 22, 27, 55, 37, 12, 57, 37, 67, 36, 17, 50, 29, 39, 41, 39, 32, 46, 47, 41, 42, 67, 45, 28, 37, 37, 59, 55, 51, 35, 18, 48, 46, 82, 35, 40, 62, 46, 20, 11, 50, 40, 11, 32, 35, 26, 63, 36, 35, 45, 61, 43, 50, 19, 17, 54, 55, 51, 35, 52, 38, 62, 37, 53, 40, 56, 25, 14, 36, 48, 56, 36, 19, 31, 45, 28, 52, 36, 40, 82, 33, 42, 50, 33, 19, 28, 13, 67, 63, 28, 44, 21, 85, 21, 34, 23, 60, 37, 53, 33, 49, 49, 56, 75, 37, 52, 37, 58, 42, 39, 31, 24, 54, 37, 29, 60, 58, 42, 27, 31, 53, 42, 43, 54, 47, 19, 26, 19, 45, 24, 30, 41, 26, 31, 46, 7, 48, 40, 47, 34, 30, 32, 33, 61, 48, 34, 48, 38, 51, 33, 22, 40, 49, 36, 46, 54, 64, 61, 50, 47, 44, 65, 65, 47, 31, 28, 30, 45, 43, 36, 51, 44, 66, 49, 19, 23, 45, 35, 17, 18, 37, 52, 27, 24, 52, 34, 51, 31, 63, 38, 36, 38, 30, 26, 9, 46, 54, 26, 29, 49, 23, 46, 40, 19, 23, 46, 29, 44, 46, 20, 15, 25, 30, 63, 60, 38, 30, 38, 35, 33, 35, 39, 51, 22, 34, 26, 26, 17, 34, 9, 21, 17, 23, 41, 18, 15, 44, 41, 30, 57, 43, 36, 40, 44, 32, 35, 44, 16, 41, 27, 46, 58, 47, 47, 25, 32, 42, 37, 22, 29, 21, 46, 33, 40, 77, 34, 18, 37, 33, 51, 65, 36, 38, 59, 48, 40, 22, 41, 17, 44, 39, 44, 22, 28, 41, 41, 62, 52, 41, 45, 54, 62, 39, 59, 48, 19, 54, 40, 45, 30, 33, 49, 26, 51, 42, 54, 48, 38, 33, 41, 27, 49, 51, 80, 29, 43, 56, 17, 29, 30, 32, 34, 41, 19, 38, 50, 15, 34, 54, 12, 24, 58, 31, 69, 26, 49, 52, 37, 55, 32, 46, 47, 54, 27, 33, 30, 36, 38, 28, 69, 43, 50, 45, 58, 59, 21, 41, 16, 41, 33, 16, 57, 28, 16, 13, 42, 19, 45, 52, 37, 23, 60, 27, 77, 32, 50, 49, 59, 44, 27, 46, 28, 53, 61, 15, 21, 43, 45, 42, 25, 64, 18, 64, 37, 35, 71, 51, 39, 23, 13, 3, 21, 71, 27, 37, 37, 71, 22, 58, 55, 46, 52, 69, 44, 30, 60, 14, 31, 32, 54, 48, 59, 30, 2, 21, 28, 22, 39, 7, 42, 39, 52, 57, 14, 13, 46, 37, 40, 33, 24, 60, 28, 54, 33, 49, 22, 23, 33, 23, 43, 53, 47, 40, 22, 18, 39, 41, 29, 62, 28, 49, 27, 45, 38, 30, 75, 25, 31, 45, 54, 17, 33, 18, 37, 38, 63, 46, 44, 45, 69, 42, 32, 46, 49, 36, 24, 45, 50, 18, 45, 44, 49, 23, 30, 57, 10, 87, 38, 66, 50, 44, 33, 17, 60, 58, 53, 32, 38, 48, 20, 31, 56, 43, 52, 35, 48, 37, 21, 24, 44, 42, 58, 28, 54, 56, 48, 28, 46, 73, 38, 62, 46, 44, 64, 40, 22, 54, 38, 41, 47, 47, 58, 19, 49, 28, 52, 41, 23, 31, 56, 32, 38, 53, 15, 21, 73, 58, 21, 34, 24, 22, 37, 39, 57, 16, 58, 42, 50, 71, 24, 41, 51, 33, 59, 18, 12, 24, 39, 33, 15, 73, 66, 47, 20, 27, 29, 31, 7, 44, 19, 31, 45, 34, 39, 38, 53, 67, 49, 52, 37, 40, 54, 36, 40, 31, 53, 27, 42, 40, 43, 29, 30, 22, 43, 78, 38, 30, 30, 24, 42, 63, 52, 6, 13, 12, 44, 27, 17, 50, 19, 36, 46, 45, 59, 61, 58, 59, 37, 22, 39, 44, 14, 58, 71, 74, 51, 41, 41, 49, 39, 45, 28, 33, 23, 36, 28, 43, 13, 28, 48, 44, 40, 59, 50, 29, 41, 72, 22, 16, 44, 44, 47, 39, 45, 58, 29, 68, 47, 59, 13, 51, 14, 45, 39, 49, 57, 47, 58, 70, 53, 28, 37, 52, 53, 42, 42, 45, 54, 56, 82, 38, 55, 30, 33, 53, 44, 64, 33, 38, 37, 19, 38, 37, 53, 46, 25, 46, 13, 29, 50, 61, 49, 56, 53, 61, 30, 34, 47, 54, 22, 13, 50, 42, 30, 16, 16, 38, 40, 18, 24, 16, 44, 30, 52, 44, 29, 50, 34, 64, 8, 42, 41, 55, 55, 57, 32, 23, 16, 41, 40, 37, 27, 10, 52, 69, 24, 40, 55, 35, 47, 30, 40, 46, 40, 10, 24, 30, 36, 73, 26, 28, 29, 60, 64, 54, 52, 53, 33, 33, 40, 23, 51, 66, 62, 55, 37, 30, 24, 40, 71, 17, 50, 31, 23, 38, 35, 46, 32, 50, 42, 47, 48, 36, 47, 29, 22, 41, 60, 66, 57, 18, 20, 61, 38, 17, 40, 31, 42, 47, 44, 60, 9, 33, 37, 34, 62, 49, 27, 44, 22, 25, 52, 44, 46, 18, 42, 46, 16, 31, 21, 35, 31, 67, 46, 32, 38, 40, 42, 39, 23, 20, 28, 21, 34, 22, 33, 60, 49, 52, 25, 46, 59, 48, 55, 45, 38, 40, 28, 43, 7, 39, 80, 34, 15, 32, 38, 68, 42, 52, 61, 70, 28, 54, 50, 52, 45, 35, 39, 27, 29, 65, 35, 24, 52, 8, 32, 62, 29, 51, 48, 37, 54, 29, 45, 33, 31, 69, 33, 14, 35, 39, 30, 29, 64, 64, 12, 24, 16, 40, 53, 49, 39, 52, 40, 29, 52, 60, 50, 51, 44, 18, 65, 58, 28, 51, 61, 56, 53, 21, 34, 62, 63, 59, 35, 44, 46, 56, 48, 32, 52, 25, 34, 33, 40, 16, 17, 42, 46, 51, 40, 43, 31, 68, 24, 49, 37, 31, 38, 24, 29, 65, 12, 53, 63, 32, 7, 41, 32, 26, 35, 42, 25, 29, 28, 46, 56, 34, 50, 9, 53, 29, 14, 48, 61, 33, 46, 40, 6, 65, 26, 65, 30, 43, 22, 27, 48, 60, 32, 21, 63, 30, 55, 54, 29, 65, 23, 20, 41, 52, 22, 28, 48, 33, 22, 55, 43, 64, 73, 45, 49, 53, 17, 71, 31, 56, 44, 35, 39, 32, 53, 38, 32, 40, 49, 58, 25, 46, 11, 30, 35, 43, 40, 40, 38, 27, 41, 31, 34, 58, 33, 21, 54, 66, 53, 26, 62, 27, 13, 59, 9, 48, 20, 34, 29, 27, 50, 69, 36, 28, 18, 22, 34, 51, 28, 66, 30, 55, 53, 50, 43, 60, 28, 31, 24, 34, 47, 26, 36, 16, 38, 47, 51, 65, 36, 34, 14, 40, 17, 55, 23, 33, 44, 27, 62, 59, 31, 6, 43, 19, 63, 21, 32, 61, 26, 39, 12, 35, 33, 48, 7, 41, 58, 47, 15, 45, 51, 59, 43, 56, 33, 26, 40, 50, 57, 31, 46, 27, 62, 39, 44, 45, 36, 46, 37, 44, 43, 35, 45, 53, 10, 7, 45, 33, 23, 29, 30, 35, 66, 34, 66, 37, 54, 30, 23, 48, 62, 60, 45, 68, 42, 50, 47, 51, 22, 43, 52, 40, 46, 46, 14, 7, 35, 33, 18, 52, 56, 18, 63, 43, 18, 49, 61, 58, 32, 33, 15, 12, 38, 47, 15, 39, 38, 44, 52, 47, 44, 58, 23, 23, 47, 38, 40, 66, 28, 19, 22, 25, 21, 38, 39, 57, 45, 14, 38, 23, 62, 25, 69, 30, 52, 29, 20, 51, 40, 30, 42, 36, 25, 48, 47, 54, 8, 23, 59, 32, 78, 50, 27, 42, 28, 33, 40, 29, 32, 21, 39, 59, 69, 42, 40, 16, 51, 27, 45, 38, 42, 66, 38, 26, 28, 44, 51, 54, 65, 39, 70, 29, 42, 48, 41, 51, 48, 51, 23, 58, 33, 43, 35, 50, 54, 38, 40, 43, 74, 29, 56, 55, 40, 20, 47, 43, 23, 45, 12, 50, 42, 56, 22, 32, 10, 26, 47, 54, 21, 8, 37, 34, 32, 42, 41, 15, 28, 58, 19, 35, 34, 47, 8, 30, 68, 21, 41, 25, 18, 60, 60, 48, 59, 56, 32, 32, 86, 17, 64, 51, 60, 19, 47, 41, 39, 23, 23, 62, 36, 41, 35, 49, 27, 28, 60, 11, 55, 35, 38, 14, 62, 28, 12, 55, 11, 34, 27, 46, 55, 31, 51, 24, 66, 49, 51, 39, 55, 21, 43, 40, 36, 39, 65, 38, 29, 46, 33, 27, 27, 26, 19, 25, 29, 30, 23, 50, 44, 19, 35, 34, 67, 51, 38, 53, 22, 42, 21, 61, 43, 28, 44, 12, 27, 36, 61, 40, 61, 39, 54, 30, 25, 44, 17, 54, 55, 29, 34, 31, 48, 39, 41, 61, 33, 62, 46, 36, 9, 45, 32, 54, 59, 48, 51, 37, 35, 33, 36, 53, 51, 46, 49, 18, 59, 27, 42, 50, 26, 52, 35, 26, 37, 47, 37, 41, 48, 54, 35, 40, 35, 24, 34, 33, 43, 44, 17, 45, 26, 56, 29, 43, 45, 14, 16, 42, 54, 31, 49, 59, 68, 16, 20, 63, 52, 47, 51, 64, 39, 49, 41, 65, 38, 30, 34, 9, 26, 32, 27, 20, 39, 71, 49, 16, 39, 52, 49, 64, 37, 33, 26, 46, 19, 51, 36, 51, 20, 49, 63, 67, 68, 48, 14, 51, 54, 43, 36, 41, 18, 39, 44, 61, 36, 40, 29, 35, 32, 63, 41, 21, 35, 43, 28, 53, 55, 67, 57, 35, 54, 57, 52, 33, 63, 25, 34, 57, 77, 45, 57, 30, 51, 44, 53, 42, 51, 33, 34, 63, 41, 45, 35, 40, 48, 25, 53, 48, 50, 37, 37, 55, 52, 30, 44, 35, 41, 51, 45, 42, 35, 35, 23, 34, 28, 37, 38, 63, 61, 52, 67, 52, 41, 63, 39, 33, 56, 39, 50, 63, 42, 29, 41, 38, 59, 10, 52, 56, 53, 39, 41, 43, 68, 49, 33, 43, 41, 40, 38, 20, 42, 48, 30, 65, 22, 49, 40, 34, 62, 30, 32, 28, 40, 44, 40, 2, 68, 35, 31, 48, 44, 13, 79, 27, 22, 51, 40, 28, 31, 57, 54, 47, 20, 61, 20, 26, 53, 25, 48, 27, 23, 40, 54, 24, 57, 22, 73, 25, 44, 42, 40, 52, 18, 17, 34, 40, 30, 35, 30, 46, 35, 46, 15, 18, 19, 28, 46, 81, 53, 42, 48, 36, 61, 25, 40, 25, 34, 66, 34, 29, 48, 39, 53, 40, 31, 28, 57, 45, 33, 12, 28, 21, 53, 47, 50, 38, 54, 44, 26, 27, 10, 46, 33, 46, 53, 50, 45, 31, 34, 43, 40, 43, 55, 39, 45, 33, 51, 25, 62, 31, 25, 28, 34, 52, 24, 23, 36, 87, 32, 54, 42, 26, 52, 46, 58, 39, 63, 51, 22, 31, 35, 42, 42, 49, 36, 24, 63, 69, 27, 49, 50, 39, 22, 28, 40, 31, 34, 42, 36, 43, 51, 45, 20, 28, 63, 54, 19, 54, 49, 25, 49, 21, 47, 36, 42, 38, 33, 24, 19, 31, 35, 39, 49, 9, 44, 27, 16, 47, 33, 45, 50, 51, 37, 36, 32, 64, 41, 47, 53, 59, 29, 69, 28, 65, 42, 44, 31, 47, 37, 37, 25, 62, 39, 28, 51, 55, 62, 39, 39, 38, 54, 45, 18, 54, 44, 26, 34, 52, 32, 28, 58, 29, 38, 39, 55, 46, 26, 60, 23, 50, 34, 40, 58, 31, 46, 36, 31, 54, 46, 54, 27, 77, 62, 55, 36, 20, 53, 54, 37, 50, 59, 34, 37, 44, 33, 27, 62, 29, 31, 57, 44, 43, 46, 40, 22, 45, 33, 31, 39, 51, 51, 51, 48, 61, 61, 22, 48, 47, 49, 35, 33, 15, 10, 34, 33, 52, 81, 50, 59, 57, 41, 21, 45, 64, 56, 30, 39, 37, 47, 42, 46, 23, 59, 25, 23, 48, 58, 16, 39, 20, 46, 52, 23, 55, 43, 40, 36, 28, 44, 28, 21, 60, 39, 27, 55, 39, 38, 46, 27, 40, 60, 40, 38, 22, 48, 41, 24, 20, 49, 36, 27, 17, 67, 36, 66, 42, 48, 49, 89, 31, 38, 40, 10, 24, 63, 35, 67, 43, 54, 15, 31, 41, 60, 53, 31, 34, 15, 35, 33, 19, 38, 22, 32, 32, 33, 59, 54, 18, 40, 18, 37, 41, 30, 36, 49, 56, 43, 52, 33, 62, 25, 28, 36, 16, 50, 19, 47, 69, 16, 32, 41, 45, 45, 42, 61, 61, 29, 25, 40, 39, 49, 52, 45, 37, 51, 32, 32, 55, 82, 42, 17, 30, 53, 34, 60, 38, 44, 49, 31, 48, 40, 24, 35, 14, 37, 23, 56, 41, 28, 22, 17, 47, 28, 47, 39, 32, 49, 26, 53, 31, 24, 32, 45, 65, 25, 26, 43, 34, 51, 29, 27, 53, 77, 24, 48, 38, 39, 15, 75, 18, 56, 45, 71, 32, 41, 46, 19, 51, 50, 44, 59, 46, 41, 16, 23, 75, 55, 31, 35, 75, 44, 50, 57, 40, 59, 63, 29, 52, 32, 45, 25, 33, 39, 46, 63, 23, 37, 47, 23, 40, 38, 16, 23, 38, 23, 32, 38, 56, 26, 51, 30, 26, 15, 24, 49, 49, 34, 33, 44, 32, 10, 14, 30, 37, 34, 36, 74, 38, 29, 33, 23, 45, 34, 40, 25, 39, 18, 50, 71, 40, 27, 22, 35, 11, 24, 52, 38, 24, 51, 27, 36, 52, 16, 40, 44, 55, 29, 6, 43, 41, 32, 38, 53, 43, 36, 25, 54, 34, 50, 66, 46, 67, 19, 47, 34, 27, 38, 34, 44, 28, 31, 51, 34, 46, 38, 44, 61, 35, 53, 17, 25, 35, 48, 52, 34, 26, 17, 37, 37, 22, 19, 60, 48, 68, 75, 44, 26, 37, 55, 31, 31, 54, 51, 64, 67, 20, 62, 41, 45, 25, 35, 25, 15, 47, 48, 17, 36, 40, 43, 48, 36, 40, 28, 54, 52, 19, 40, 47, 26, 42, 48, 22, 51, 22, 46, 59, 51, 24, 50, 47, 17, 52, 23, 45, 19, 63, 30, 47, 46, 46, 22, 41, 62, 26, 14, 31, 48, 50, 68, 38, 33, 42, 44, 44, 19, 19, 11, 13, 33, 48, 54, 46, 48, 24, 16, 58, 21, 18, 38, 44, 26, 57, 41, 55, 53, 37, 35, 55, 52, 32, 40, 54, 41, 60, 46, 48, 34, 17, 45, 41, 37, 39, 22, 26, 16, 44, 49, 65, 15, 42, 37, 22, 26, 47, 37, 19, 48, 69, 43, 52, 43, 20, 46, 35, 25, 54, 26, 34, 43, 41, 44, 47, 8, 77, 30, 17, 46, 9, 58, 43, 41, 65, 50, 49, 38, 61, 44, 54, 22, 33, 31, 30, 19, 49, 56, 18, 68, 27, 47, 43, 13, 53, 41, 28, 54, 52, 27, 36, 29, 34, 46, 45, 39, 84, 29, 30, 28, 43, 55, 30, 13, 24, 41, 29, 30, 21, 21, 40, 60, 40, 33, 68, 25, 25, 53, 20, 56, 51, 26, 20, 47, 34, 64, 21, 33, 25, 62, 36, 48, 46, 43, 42, 66, 77, 29, 39, 34, 35, 16, 30, 10, 33, 57, 41, 36, 23, 50, 14, 32, 17, 31, 27, 62, 28, 35, 30, 60, 45, 22, 33, 26, 70, 49, 28, 35, 32, 39, 22, 59, 44, 19, 37, 28, 45, 13, 9, 41, 38, 21, 44, 12, 64, 44, 48, 43, 58, 26, 40, 26, 54, 27, 30, 31, 41, 37, 33, 31, 47, 48, 42, 20, 46, 23, 36, 59, 33, 38, 20, 65, 51, 33, 46, 33, 32, 39, 41, 31, 63, 67, 44, 57, 17, 76, 32, 41, 42, 41, 33, 16, 71, 33, 32, 37, 29, 59, 70, 38, 39, 61, 26, 49, 70, 61, 42, 60, 46, 21, 46, 32, 47, 37, 29, 41, 43, 50, 34, 35, 23, 35, 59, 40, 38, 45, 30, 50, 37, 54, 76, 24, 40, 50, 19, 67, 35, 55, 75, 49, 28, 12, 55, 45, 78, 43, 55, 56, 35, 41, 42, 27, 58, 25, 52, 45, 32, 29, 15, 43, 25, 8, 31, 32, 16, 32, 38, 44, 23, 21, 37, 48, 37, 40, 22, 14, 29, 55, 26, 19, 46, 26, 22, 30, 56, 23, 8, 48, 33, 23, 63, 71, 53, 52, 24, 56, 49, 20, 40, 53, 36, 61, 56, 15, 31, 44, 35, 60, 46, 50, 54, 36, 55, 22, 25, 40, 40, 49, 46, 53, 19, 51, 51, 27, 51, 53, 22, 25, 21, 25, 18, 42, 55, 43, 39, 27, 42, 6, 38, 42, 62, 10, 39, 15, 32, 25, 48, 24, 41, 39, 75, 41, 22, 52, 11, 29, 54, 42, 30, 16, 21, 22, 42, 21, 64, 16, 18, 57, 47, 42, 3, 36, 13, 29, 52, 34, 28, 39, 74, 43, 50, 43, 42, 68, 22, 49, 35, 51, 47, 29, 36, 35, 27, 53, 13, 84, 29, 18, 33, 54, 54, 67, 45, 53, 41, 54, 18, 49, 39, 36, 46, 17, 31, 23, 33, 50, 39, 33, 43, 19, 35, 29, 41, 72, 52, 53, 45, 64, 26, 26, 45, 38, 31, 21, 31, 16, 15, 38, 32, 55, 26, 20, 37, 50, 20, 23, 50, 58, 82, 38, 54, 14, 47, 13, 21, 61, 38, 38, 14, 42, 55, 42, 45, 51, 58, 33, 37, 44, 44, 37, 10, 49, 63, 60, 35, 27, 47, 71, 60, 25, 46, 51, 29, 49, 51, 36, 17, 32, 32, 49, 24, 22, 35, 28, 87, 29, 34, 30, 23, 38, 31, 28, 33, 30, 40, 11, 59, 37, 69, 37, 53, 29, 55, 43, 46, 40, 21, 69, 44, 19, 41, 48, 33, 30, 24, 51, 37, 22, 22, 32, 54, 35, 47, 39, 9, 61, 53, 26, 60, 34, 48, 55, 32, 21, 27, 36, 35, 33, 34, 15, 38, 38, 41, 54, 50, 45, 26, 26, 38, 36, 29, 43, 43, 65, 46, 18, 53, 32, 14, 46, 31, 43, 13, 34, 33, 43, 68, 55, 18, 30, 52, 14, 31, 24, 9, 56, 24, 64, 65, 61, 38, 46, 58, 50, 49, 40, 56, 62, 47, 58, 50, 21, 17, 52, 22, 46, 51, 32, 55, 54, 50, 43, 36, 66, 63, 17, 61, 43, 40, 19, 45, 44, 42, 11, 46, 35, 23, 30, 29, 54, 26, 44, 16, 43, 26, 60, 32, 21, 11, 28, 37, 41, 46, 29, 60, 36, 46, 38, 59, 49, 31, 13, 28, 44, 50, 36, 34, 46, 38, 45, 54, 54, 37, 38, 30, 26, 47, 56, 52, 35, 40, 32, 34, 37, 44, 58, 43, 46, 83, 44, 32, 24, 39, 47, 16, 49, 11, 37, 52, 20, 43, 25, 46, 14, 44, 21, 45, 62, 15, 36, 26, 29, 47, 58, 42, 38, 40, 39, 26, 25, 21, 44, 28, 55, 57, 43, 34, 49, 19, 50, 34, 21, 31, 50, 35, 34, 51, 41, 69, 66, 21, 44, 26, 22, 47, 66, 43, 43, 65, 28, 30, 30, 25, 12, 31, 55, 28, 39, 33, 41, 33, 46, 9, 40, 65, 41, 27, 47, 50, 12, 19, 50, 52, 33, 49, 38, 39, 42, 67, 55, 36, 47, 23, 54, 34, 32]}, 'test_2': {'capacity': 100, 'num_items': 5000, 'items': [20, 47, 39, 29, 7, 45, 45, 18, 39, 48, 15, 25, 33, 40, 52, 32, 33, 30, 11, 57, 15, 44, 22, 23, 83, 19, 34, 17, 14, 34, 50, 36, 52, 62, 48, 68, 40, 33, 27, 18, 25, 37, 39, 46, 35, 50, 60, 66, 52, 32, 31, 25, 62, 38, 54, 31, 58, 34, 20, 42, 57, 19, 21, 30, 21, 29, 20, 47, 43, 31, 34, 70, 19, 27, 17, 61, 53, 20, 69, 37, 32, 40, 49, 47, 26, 55, 52, 62, 41, 53, 17, 16, 42, 43, 49, 41, 41, 38, 25, 41, 42, 28, 14, 40, 50, 47, 16, 26, 38, 46, 35, 39, 77, 14, 55, 51, 43, 41, 23, 27, 60, 60, 38, 14, 31, 54, 23, 44, 44, 32, 32, 27, 24, 40, 51, 8, 46, 29, 10, 48, 65, 31, 55, 13, 23, 50, 28, 13, 38, 60, 27, 32, 22, 25, 45, 54, 38, 35, 23, 60, 77, 77, 24, 27, 28, 45, 17, 54, 45, 55, 42, 32, 42, 67, 55, 33, 57, 41, 35, 16, 35, 36, 45, 23, 24, 34, 35, 37, 48, 57, 57, 46, 47, 51, 59, 60, 42, 31, 63, 40, 31, 37, 11, 20, 49, 51, 33, 49, 53, 31, 51, 44, 39, 30, 41, 17, 43, 51, 33, 17, 39, 42, 38, 52, 55, 46, 55, 45, 58, 43, 59, 40, 42, 5, 45, 31, 28, 36, 52, 53, 48, 47, 9, 38, 45, 27, 34, 38, 47, 51, 34, 44, 40, 14, 67, 56, 30, 25, 42, 37, 21, 31, 69, 51, 46, 45, 55, 26, 58, 45, 50, 58, 44, 66, 27, 23, 28, 50, 39, 74, 30, 12, 24, 18, 27, 40, 55, 59, 58, 37, 29, 17, 17, 37, 21, 16, 41, 17, 39, 33, 42, 30, 60, 31, 32, 23, 32, 28, 17, 60, 24, 36, 29, 25, 81, 43, 44, 51, 51, 46, 28, 32, 36, 57, 39, 32, 31, 46, 35, 25, 70, 46, 50, 53, 50, 35, 49, 30, 33, 64, 41, 25, 29, 47, 26, 61, 54, 64, 29, 35, 35, 58, 47, 26, 58, 8, 66, 41, 64, 52, 22, 34, 38, 17, 14, 44, 33, 24, 36, 56, 49, 29, 35, 23, 15, 49, 79, 42, 36, 18, 50, 32, 27, 44, 36, 50, 51, 24, 83, 48, 35, 33, 37, 14, 32, 33, 34, 38, 40, 63, 31, 41, 51, 34, 71, 56, 37, 46, 52, 62, 36, 35, 57, 43, 26, 36, 43, 53, 17, 66, 39, 23, 42, 39, 17, 53, 57, 32, 44, 32, 44, 30, 53, 32, 41, 22, 38, 39, 15, 22, 45, 46, 59, 35, 31, 14, 37, 38, 24, 33, 53, 29, 39, 37, 61, 36, 47, 37, 29, 25, 47, 42, 31, 41, 59, 55, 28, 44, 49, 50, 33, 41, 51, 43, 32, 58, 55, 38, 49, 38, 36, 40, 54, 72, 53, 51, 42, 47, 49, 48, 57, 52, 33, 27, 33, 28, 41, 22, 48, 25, 50, 23, 41, 36, 54, 55, 25, 53, 26, 8, 47, 44, 48, 26, 8, 50, 39, 44, 68, 44, 70, 50, 44, 52, 39, 64, 41, 64, 52, 38, 16, 20, 11, 41, 25, 29, 35, 37, 17, 21, 46, 40, 32, 25, 14, 57, 29, 31, 20, 32, 48, 70, 48, 20, 61, 57, 25, 59, 35, 80, 27, 26, 54, 45, 54, 50, 46, 23, 48, 31, 40, 27, 43, 24, 48, 61, 36, 41, 41, 31, 42, 55, 49, 48, 37, 20, 35, 45, 37, 11, 32, 54, 50, 4, 24, 61, 48, 63, 38, 43, 38, 27, 20, 52, 22, 11, 38, 53, 27, 43, 26, 40, 47, 38, 42, 56, 52, 72, 53, 40, 25, 50, 43, 49, 32, 55, 25, 51, 37, 41, 56, 47, 37, 57, 29, 27, 60, 34, 42, 61, 46, 31, 38, 54, 48, 34, 55, 59, 38, 43, 22, 27, 28, 29, 30, 53, 60, 16, 55, 13, 39, 29, 28, 44, 42, 53, 60, 33, 48, 48, 44, 40, 57, 50, 59, 28, 31, 65, 23, 27, 44, 46, 57, 36, 60, 23, 23, 58, 51, 47, 15, 57, 50, 33, 14, 42, 44, 19, 24, 42, 40, 51, 37, 33, 50, 39, 38, 28, 31, 49, 55, 68, 42, 81, 21, 38, 55, 49, 39, 31, 36, 59, 62, 62, 79, 36, 55, 57, 23, 24, 32, 18, 53, 34, 70, 32, 38, 40, 43, 41, 35, 30, 53, 24, 47, 38, 36, 30, 52, 28, 67, 58, 23, 29, 33, 21, 54, 42, 44, 41, 33, 52, 35, 42, 39, 44, 50, 34, 53, 29, 50, 26, 8, 41, 39, 25, 48, 34, 45, 30, 35, 38, 57, 65, 34, 33, 47, 28, 42, 62, 42, 12, 31, 51, 13, 51, 47, 28, 76, 54, 34, 66, 18, 51, 32, 27, 48, 46, 15, 36, 43, 58, 35, 32, 41, 43, 16, 52, 22, 70, 19, 34, 25, 45, 27, 41, 33, 43, 47, 43, 62, 29, 62, 56, 33, 23, 72, 66, 44, 28, 29, 16, 20, 55, 53, 48, 59, 44, 44, 39, 14, 42, 40, 47, 67, 28, 51, 19, 44, 42, 41, 50, 12, 47, 37, 38, 11, 31, 51, 25, 29, 5, 22, 32, 51, 44, 56, 61, 43, 16, 50, 38, 20, 62, 70, 31, 37, 30, 69, 46, 13, 19, 45, 20, 10, 42, 34, 64, 56, 10, 35, 41, 32, 34, 48, 61, 55, 37, 49, 40, 26, 42, 35, 44, 41, 62, 29, 34, 34, 41, 54, 55, 35, 34, 37, 30, 29, 36, 62, 35, 38, 45, 31, 35, 37, 43, 38, 48, 45, 43, 28, 50, 49, 42, 64, 29, 75, 47, 60, 30, 55, 56, 62, 48, 35, 36, 22, 43, 56, 30, 37, 41, 21, 31, 60, 56, 15, 38, 32, 53, 25, 26, 36, 65, 40, 30, 42, 54, 47, 10, 11, 36, 61, 31, 53, 33, 21, 58, 42, 39, 43, 83, 44, 26, 25, 52, 10, 30, 29, 45, 30, 56, 39, 12, 38, 56, 33, 29, 31, 42, 36, 25, 24, 44, 54, 43, 48, 29, 38, 57, 50, 21, 67, 42, 28, 38, 22, 68, 11, 38, 15, 28, 58, 47, 24, 43, 50, 27, 17, 38, 20, 39, 53, 34, 61, 37, 57, 30, 20, 33, 65, 43, 44, 65, 38, 38, 15, 69, 49, 40, 30, 41, 14, 45, 43, 27, 56, 30, 45, 53, 39, 72, 32, 35, 15, 48, 18, 66, 54, 58, 44, 40, 40, 48, 25, 33, 62, 38, 43, 38, 20, 21, 29, 45, 35, 41, 61, 48, 25, 42, 36, 25, 34, 51, 39, 46, 53, 68, 21, 26, 18, 49, 49, 12, 29, 29, 46, 63, 38, 32, 49, 67, 28, 39, 19, 42, 55, 44, 44, 29, 26, 29, 33, 24, 22, 22, 57, 55, 29, 19, 34, 59, 43, 45, 37, 58, 80, 28, 76, 39, 51, 20, 32, 55, 34, 43, 65, 14, 60, 41, 33, 30, 35, 38, 51, 37, 49, 33, 43, 34, 21, 91, 9, 67, 41, 52, 24, 45, 35, 38, 35, 33, 37, 52, 42, 37, 45, 24, 44, 38, 32, 47, 38, 47, 65, 73, 31, 47, 46, 29, 70, 35, 36, 19, 34, 59, 46, 23, 31, 31, 21, 33, 32, 32, 43, 43, 23, 66, 52, 20, 35, 51, 47, 23, 58, 40, 44, 43, 12, 75, 41, 31, 35, 30, 48, 34, 28, 47, 43, 53, 37, 57, 36, 37, 45, 41, 60, 34, 33, 41, 17, 26, 67, 63, 46, 69, 29, 46, 27, 51, 38, 39, 47, 33, 31, 58, 38, 32, 53, 39, 41, 44, 20, 15, 23, 52, 44, 46, 49, 40, 13, 46, 25, 52, 48, 44, 29, 70, 42, 41, 19, 36, 54, 28, 48, 42, 34, 64, 13, 22, 46, 60, 58, 65, 52, 46, 38, 56, 36, 52, 18, 41, 64, 59, 41, 47, 20, 64, 15, 33, 72, 45, 36, 51, 47, 39, 38, 30, 58, 78, 56, 47, 38, 53, 36, 21, 62, 57, 37, 46, 54, 14, 36, 58, 67, 42, 41, 37, 31, 30, 55, 59, 46, 42, 31, 42, 22, 24, 62, 36, 52, 44, 54, 30, 24, 61, 19, 49, 63, 52, 57, 42, 9, 66, 17, 54, 23, 40, 27, 59, 53, 45, 48, 42, 22, 22, 42, 51, 47, 30, 40, 26, 34, 50, 47, 33, 37, 27, 31, 45, 61, 34, 40, 36, 29, 59, 34, 56, 38, 24, 32, 51, 47, 26, 22, 69, 25, 58, 25, 57, 11, 45, 15, 54, 34, 52, 16, 47, 29, 54, 18, 29, 32, 66, 43, 51, 37, 59, 46, 35, 19, 44, 43, 35, 18, 36, 59, 36, 33, 42, 42, 48, 35, 36, 5, 19, 35, 39, 63, 25, 44, 42, 41, 61, 52, 37, 42, 37, 48, 51, 65, 41, 30, 29, 25, 44, 48, 74, 19, 22, 40, 28, 45, 35, 44, 35, 46, 27, 41, 75, 42, 19, 27, 39, 50, 19, 49, 32, 38, 71, 50, 24, 45, 31, 33, 23, 45, 32, 30, 60, 33, 25, 25, 34, 14, 46, 37, 38, 30, 34, 31, 49, 62, 42, 33, 39, 49, 23, 65, 27, 29, 81, 59, 54, 43, 31, 56, 23, 59, 65, 44, 50, 59, 45, 32, 41, 29, 11, 14, 25, 37, 22, 37, 44, 62, 44, 28, 53, 9, 49, 44, 34, 49, 67, 51, 37, 26, 45, 28, 24, 57, 31, 54, 16, 36, 32, 22, 28, 19, 24, 39, 69, 46, 22, 39, 58, 45, 41, 23, 26, 60, 35, 50, 43, 35, 57, 32, 19, 45, 10, 42, 36, 15, 78, 40, 57, 21, 33, 56, 51, 15, 67, 26, 25, 64, 38, 36, 39, 43, 30, 35, 34, 44, 29, 29, 18, 32, 40, 68, 46, 24, 40, 48, 31, 40, 19, 36, 45, 57, 17, 18, 31, 31, 31, 25, 53, 42, 34, 21, 48, 30, 7, 56, 48, 25, 32, 52, 44, 32, 55, 57, 59, 63, 48, 33, 9, 12, 44, 42, 50, 44, 37, 56, 57, 26, 42, 27, 49, 31, 24, 14, 31, 51, 26, 15, 27, 37, 37, 57, 30, 53, 41, 12, 57, 42, 27, 31, 40, 18, 56, 22, 37, 48, 30, 35, 36, 37, 32, 35, 49, 35, 34, 38, 26, 57, 60, 46, 32, 50, 37, 41, 36, 45, 47, 40, 45, 29, 18, 40, 53, 52, 42, 33, 26, 44, 32, 39, 60, 43, 60, 24, 44, 75, 55, 27, 32, 19, 20, 42, 21, 41, 41, 47, 34, 46, 55, 38, 35, 49, 36, 45, 34, 22, 41, 68, 31, 12, 36, 27, 52, 46, 26, 15, 37, 59, 26, 52, 38, 35, 54, 13, 48, 46, 55, 57, 39, 52, 35, 44, 52, 24, 51, 41, 59, 53, 36, 38, 62, 44, 58, 18, 41, 44, 44, 26, 38, 35, 42, 49, 52, 37, 33, 46, 56, 42, 44, 47, 63, 24, 47, 69, 31, 32, 11, 23, 46, 43, 53, 65, 56, 17, 54, 29, 36, 38, 54, 33, 37, 53, 46, 30, 46, 28, 30, 41, 31, 23, 49, 35, 33, 62, 43, 44, 30, 18, 52, 57, 38, 42, 30, 42, 44, 44, 39, 46, 50, 44, 27, 61, 29, 31, 33, 41, 68, 49, 36, 13, 32, 62, 41, 59, 39, 24, 12, 57, 53, 31, 66, 19, 47, 47, 51, 60, 21, 41, 50, 49, 31, 26, 64, 26, 48, 29, 4, 35, 48, 51, 52, 33, 23, 26, 60, 44, 55, 23, 44, 41, 47, 52, 26, 13, 75, 12, 53, 43, 54, 40, 57, 36, 17, 33, 49, 25, 54, 10, 34, 43, 28, 37, 48, 31, 25, 54, 22, 70, 55, 39, 57, 39, 14, 39, 20, 57, 39, 35, 42, 40, 35, 30, 70, 24, 43, 42, 28, 43, 13, 32, 19, 42, 53, 63, 31, 44, 19, 41, 29, 51, 30, 61, 45, 43, 47, 65, 56, 53, 23, 27, 54, 39, 56, 47, 50, 54, 49, 51, 15, 35, 32, 68, 41, 76, 16, 43, 36, 23, 40, 43, 12, 30, 56, 57, 47, 18, 31, 53, 22, 47, 21, 39, 47, 43, 29, 51, 29, 39, 36, 54, 24, 30, 62, 36, 70, 16, 46, 24, 15, 26, 20, 42, 55, 29, 57, 59, 30, 47, 60, 37, 43, 43, 27, 42, 55, 26, 12, 16, 45, 42, 57, 39, 22, 37, 38, 41, 38, 46, 22, 10, 51, 32, 38, 41, 17, 17, 28, 35, 43, 25, 51, 35, 45, 67, 42, 18, 41, 35, 77, 30, 20, 46, 46, 43, 44, 41, 50, 29, 45, 26, 31, 41, 32, 44, 31, 58, 26, 30, 66, 14, 55, 30, 19, 48, 55, 53, 15, 64, 32, 43, 21, 40, 78, 37, 29, 46, 29, 25, 40, 67, 32, 53, 29, 48, 28, 48, 26, 70, 53, 52, 47, 19, 22, 44, 49, 48, 29, 55, 44, 30, 55, 32, 50, 51, 45, 63, 71, 28, 13, 26, 48, 34, 43, 49, 39, 38, 69, 14, 32, 38, 50, 48, 37, 50, 33, 52, 28, 39, 46, 37, 30, 28, 28, 32, 35, 24, 38, 33, 36, 52, 37, 27, 32, 15, 41, 36, 53, 23, 33, 11, 43, 48, 32, 50, 35, 69, 31, 39, 10, 22, 18, 40, 21, 8, 39, 39, 32, 28, 35, 61, 47, 28, 41, 61, 71, 39, 37, 42, 55, 46, 23, 42, 64, 28, 33, 22, 65, 26, 35, 26, 23, 22, 53, 51, 50, 22, 50, 49, 28, 15, 48, 58, 53, 51, 44, 25, 26, 59, 47, 51, 25, 21, 40, 32, 26, 35, 68, 34, 17, 59, 63, 29, 22, 27, 8, 21, 49, 43, 46, 28, 53, 43, 16, 58, 56, 56, 38, 41, 53, 51, 58, 50, 52, 31, 44, 26, 36, 52, 38, 14, 31, 40, 24, 52, 58, 37, 56, 43, 62, 58, 25, 55, 30, 40, 60, 26, 23, 26, 61, 18, 43, 43, 47, 21, 38, 51, 33, 60, 39, 40, 40, 58, 38, 43, 31, 49, 28, 20, 48, 36, 42, 28, 36, 22, 62, 19, 52, 28, 47, 51, 58, 56, 32, 29, 75, 55, 32, 40, 34, 47, 57, 49, 32, 41, 20, 25, 38, 42, 30, 53, 24, 25, 53, 42, 17, 29, 21, 44, 46, 33, 32, 54, 35, 48, 30, 66, 43, 44, 71, 66, 46, 57, 64, 9, 41, 22, 39, 45, 43, 33, 26, 46, 41, 34, 32, 66, 18, 40, 22, 52, 29, 73, 31, 36, 36, 50, 26, 56, 62, 19, 76, 43, 39, 55, 39, 44, 58, 15, 27, 16, 47, 35, 50, 23, 58, 57, 44, 53, 48, 24, 63, 20, 39, 40, 39, 30, 38, 32, 44, 29, 43, 30, 49, 45, 45, 42, 69, 16, 26, 57, 36, 37, 56, 47, 15, 57, 64, 36, 50, 42, 39, 9, 45, 14, 36, 33, 34, 47, 32, 52, 26, 41, 33, 19, 43, 15, 25, 55, 59, 33, 33, 32, 44, 56, 67, 84, 33, 42, 44, 61, 47, 24, 71, 29, 22, 36, 33, 41, 19, 36, 24, 51, 36, 29, 26, 26, 35, 28, 38, 49, 58, 35, 47, 31, 43, 30, 23, 19, 29, 33, 50, 44, 71, 13, 20, 22, 31, 44, 62, 23, 25, 31, 24, 48, 25, 58, 32, 31, 37, 34, 63, 56, 16, 59, 51, 25, 30, 69, 32, 39, 50, 55, 28, 37, 87, 35, 70, 52, 33, 41, 47, 9, 52, 55, 32, 59, 47, 79, 35, 55, 12, 25, 24, 36, 18, 52, 34, 28, 56, 20, 35, 24, 40, 61, 42, 61, 29, 29, 30, 64, 45, 22, 45, 28, 45, 30, 46, 47, 33, 25, 34, 43, 53, 41, 20, 43, 60, 49, 46, 55, 50, 32, 45, 33, 62, 14, 57, 54, 35, 26, 58, 36, 52, 68, 29, 56, 30, 13, 38, 22, 30, 33, 52, 35, 63, 42, 50, 44, 23, 52, 37, 17, 56, 49, 44, 50, 50, 48, 37, 52, 35, 43, 46, 12, 52, 45, 34, 36, 22, 46, 51, 50, 33, 34, 35, 25, 28, 71, 33, 34, 10, 19, 20, 42, 39, 73, 37, 39, 30, 43, 40, 15, 55, 35, 32, 49, 51, 41, 55, 42, 44, 46, 20, 44, 61, 46, 55, 34, 27, 32, 33, 41, 56, 33, 63, 7, 34, 7, 36, 36, 50, 15, 30, 45, 29, 39, 62, 30, 66, 37, 40, 61, 35, 25, 64, 20, 38, 29, 17, 23, 41, 42, 50, 49, 45, 27, 28, 46, 69, 24, 57, 34, 43, 22, 34, 19, 30, 21, 11, 62, 47, 44, 50, 37, 39, 32, 33, 10, 56, 39, 17, 35, 57, 42, 55, 41, 30, 38, 27, 44, 28, 31, 36, 52, 17, 12, 37, 47, 48, 20, 55, 47, 38, 62, 48, 41, 48, 46, 22, 59, 37, 39, 30, 39, 32, 19, 51, 33, 61, 52, 46, 47, 34, 32, 44, 41, 42, 64, 23, 31, 48, 62, 19, 50, 34, 40, 21, 43, 19, 31, 57, 37, 52, 69, 49, 45, 28, 35, 23, 21, 35, 27, 41, 58, 8, 20, 41, 37, 46, 26, 45, 21, 39, 54, 21, 41, 41, 26, 58, 16, 69, 49, 26, 30, 32, 63, 51, 30, 74, 42, 36, 46, 31, 54, 24, 27, 21, 62, 30, 41, 34, 62, 59, 21, 40, 22, 29, 69, 31, 17, 36, 44, 36, 65, 49, 52, 52, 22, 51, 35, 55, 28, 43, 28, 45, 28, 48, 49, 47, 41, 34, 60, 28, 45, 32, 77, 44, 36, 25, 58, 17, 50, 51, 39, 40, 9, 52, 21, 15, 41, 34, 49, 57, 28, 21, 47, 26, 68, 47, 13, 54, 49, 26, 63, 34, 52, 35, 28, 7, 46, 63, 17, 20, 32, 27, 42, 17, 55, 50, 14, 33, 45, 36, 15, 10, 46, 25, 41, 49, 67, 20, 27, 49, 28, 36, 68, 37, 34, 59, 44, 55, 34, 69, 51, 56, 36, 30, 63, 60, 84, 48, 44, 44, 47, 34, 58, 45, 39, 23, 33, 39, 85, 64, 56, 42, 46, 43, 35, 32, 55, 28, 46, 23, 58, 28, 31, 54, 52, 31, 48, 35, 50, 24, 35, 54, 13, 10, 23, 51, 38, 24, 53, 3, 18, 34, 55, 54, 23, 42, 54, 12, 36, 50, 39, 43, 29, 38, 36, 41, 40, 36, 32, 29, 46, 37, 69, 36, 36, 50, 40, 28, 21, 45, 42, 16, 49, 50, 36, 37, 24, 30, 32, 29, 36, 20, 57, 16, 25, 53, 49, 23, 51, 40, 22, 59, 32, 45, 40, 31, 44, 39, 26, 29, 38, 60, 41, 71, 39, 37, 20, 26, 39, 32, 40, 45, 43, 67, 32, 45, 53, 29, 54, 36, 41, 33, 24, 57, 51, 55, 40, 64, 25, 27, 20, 18, 31, 43, 18, 24, 30, 25, 48, 53, 18, 39, 37, 54, 25, 35, 31, 35, 34, 30, 44, 12, 45, 31, 44, 38, 17, 50, 31, 31, 37, 42, 43, 33, 35, 22, 26, 48, 47, 33, 58, 29, 53, 31, 27, 66, 6, 60, 46, 36, 27, 66, 54, 57, 71, 5, 12, 42, 42, 15, 28, 43, 71, 21, 53, 48, 33, 27, 55, 14, 51, 34, 17, 53, 30, 32, 37, 59, 39, 29, 64, 50, 48, 51, 32, 28, 29, 32, 49, 18, 58, 49, 46, 35, 50, 40, 48, 33, 27, 35, 51, 38, 51, 57, 14, 78, 34, 18, 33, 33, 35, 45, 34, 40, 12, 25, 53, 56, 27, 31, 40, 27, 48, 68, 48, 29, 42, 19, 38, 53, 33, 19, 54, 17, 27, 42, 69, 60, 37, 65, 57, 55, 65, 48, 42, 76, 23, 26, 64, 52, 55, 6, 27, 26, 29, 30, 26, 64, 50, 59, 54, 58, 34, 47, 42, 50, 55, 53, 24, 28, 21, 51, 39, 56, 37, 49, 37, 56, 37, 58, 49, 39, 61, 40, 41, 19, 50, 65, 50, 53, 45, 54, 20, 30, 29, 27, 53, 37, 56, 24, 37, 54, 46, 18, 11, 43, 19, 34, 22, 27, 29, 35, 48, 56, 48, 53, 27, 38, 39, 26, 33, 15, 62, 28, 56, 43, 31, 15, 45, 50, 23, 49, 27, 57, 25, 36, 32, 54, 60, 38, 33, 28, 32, 49, 34, 14, 27, 58, 20, 21, 23, 43, 38, 29, 52, 78, 41, 63, 50, 38, 36, 39, 65, 36, 38, 61, 59, 47, 45, 17, 57, 24, 69, 74, 23, 50, 32, 35, 55, 42, 54, 47, 29, 52, 42, 27, 12, 60, 11, 33, 28, 48, 38, 25, 45, 59, 28, 61, 42, 33, 29, 27, 64, 20, 27, 15, 56, 15, 64, 34, 41, 27, 77, 52, 51, 36, 40, 43, 59, 23, 19, 49, 44, 47, 45, 37, 38, 39, 31, 35, 41, 18, 55, 38, 60, 38, 20, 52, 21, 26, 49, 73, 35, 29, 32, 29, 17, 47, 31, 38, 36, 31, 33, 22, 14, 17, 44, 72, 54, 58, 32, 49, 29, 28, 50, 62, 42, 35, 30, 22, 35, 29, 40, 43, 42, 50, 33, 42, 61, 42, 40, 34, 44, 30, 15, 64, 48, 35, 25, 44, 41, 53, 26, 46, 61, 38, 20, 39, 63, 24, 34, 52, 17, 30, 41, 45, 40, 55, 56, 27, 44, 31, 23, 24, 52, 39, 24, 51, 46, 60, 27, 52, 34, 62, 22, 48, 58, 38, 39, 60, 72, 24, 51, 51, 12, 48, 7, 20, 19, 46, 27, 45, 21, 31, 34, 35, 50, 6, 40, 45, 47, 42, 37, 24, 66, 43, 39, 40, 64, 30, 48, 9, 47, 47, 59, 40, 34, 46, 33, 45, 44, 49, 34, 56, 48, 31, 39, 58, 62, 30, 24, 42, 28, 59, 57, 61, 38, 60, 35, 23, 46, 46, 40, 44, 43, 38, 34, 51, 49, 49, 39, 37, 21, 74, 48, 80, 39, 30, 23, 53, 48, 42, 20, 44, 35, 53, 34, 52, 14, 32, 73, 36, 24, 41, 42, 46, 39, 35, 40, 18, 14, 34, 27, 38, 54, 28, 29, 41, 71, 18, 48, 41, 32, 34, 13, 37, 24, 23, 38, 47, 42, 47, 53, 38, 31, 9, 37, 59, 33, 29, 67, 9, 27, 44, 53, 13, 29, 38, 52, 32, 31, 22, 54, 43, 42, 20, 32, 43, 17, 60, 17, 38, 40, 25, 67, 50, 40, 16, 72, 41, 43, 12, 47, 10, 34, 31, 28, 43, 63, 55, 42, 17, 31, 62, 53, 19, 22, 28, 46, 42, 29, 76, 17, 21, 41, 31, 32, 42, 43, 43, 24, 36, 59, 5, 60, 37, 18, 46, 9, 48, 53, 51, 60, 40, 21, 9, 19, 38, 44, 32, 41, 30, 43, 52, 26, 20, 46, 37, 40, 54, 40, 36, 10, 29, 54, 56, 19, 35, 59, 33, 42, 39, 32, 50, 31, 33, 57, 15, 32, 34, 41, 55, 43, 55, 59, 41, 69, 32, 34, 21, 34, 32, 43, 55, 27, 28, 49, 22, 34, 37, 36, 39, 58, 42, 45, 50, 14, 39, 56, 46, 73, 21, 29, 37, 34, 56, 55, 37, 44, 49, 40, 51, 64, 64, 62, 60, 10, 43, 34, 43, 20, 31, 44, 41, 40, 29, 57, 68, 47, 44, 28, 27, 34, 53, 49, 48, 38, 51, 25, 15, 31, 28, 42, 50, 37, 33, 38, 24, 36, 29, 38, 65, 48, 60, 40, 40, 42, 10, 36, 36, 46, 64, 45, 38, 51, 20, 45, 39, 38, 44, 12, 61, 27, 44, 62, 50, 69, 57, 58, 53, 31, 56, 29, 39, 21, 35, 40, 29, 36, 28, 56, 15, 55, 59, 50, 46, 8, 38, 54, 15, 46, 29, 59, 56, 52, 33, 34, 74, 34, 38, 43, 25, 37, 42, 40, 64, 58, 31, 28, 47, 21, 60, 54, 62, 70, 27, 44, 17, 25, 35, 7, 58, 6, 68, 39, 37, 4, 44, 30, 41, 12, 42, 24, 31, 24, 58, 48, 37, 38, 44, 43, 45, 42, 31, 17, 41, 52, 55, 45, 24, 5, 56, 73, 25, 30, 36, 59, 24, 46, 18, 57, 30, 31, 34, 40, 61, 46, 49, 40, 44, 45, 20, 43, 33, 42, 38, 54, 10, 39, 42, 40, 12, 48, 36, 32, 33, 43, 38, 28, 28, 18, 61, 27, 23, 37, 51, 31, 30, 46, 22, 32, 27, 36, 44, 79, 45, 50, 44, 6, 33, 28, 31, 15, 36, 54, 43, 51, 51, 21, 57, 21, 24, 17, 53, 38, 41, 37, 18, 21, 27, 43, 42, 20, 18, 55, 21, 36, 43, 26, 38, 46, 44, 50, 27, 19, 45, 45, 39, 25, 56, 27, 45, 55, 36, 37, 30, 30, 27, 38, 44, 52, 30, 48, 42, 29, 27, 24, 14, 38, 18, 38, 52, 36, 17, 37, 53, 59, 61, 12, 27, 36, 24, 16, 22, 31, 55, 45, 54, 45, 51, 29, 32, 33, 46, 30, 49, 51, 47, 71, 52, 33, 12, 36, 39, 33, 53, 43, 32, 76, 39, 25, 31, 28, 14, 40, 70, 35, 30, 51, 44, 47, 39, 48, 43, 33, 37, 12, 34, 62, 46, 36, 44, 25, 69, 36, 24, 13, 34, 45, 28, 47, 27, 58, 14, 36, 45, 36, 35, 20, 55, 14, 29, 50, 50, 33, 28, 24, 38, 26, 68, 55, 20, 33, 47, 56, 67, 48, 39, 37, 50, 51, 29, 20, 34, 33, 53, 45, 28, 51, 50, 39, 53, 50, 58, 46, 43, 16, 31, 50, 71, 40, 41, 66, 40, 33, 38, 48, 52, 11, 28, 29, 49, 56, 23, 46, 51, 58, 49, 33, 47, 28, 41, 51, 25, 45, 41, 28, 39, 54, 41, 28, 26, 35, 33, 56, 45, 39, 27, 40, 48, 25, 40, 51, 51, 33, 32, 41, 10, 41, 55, 43, 26, 28, 50, 46, 29, 35, 19, 27, 28, 55, 36, 57, 64, 44, 34, 34, 32, 26, 30, 36, 20, 40, 6, 37, 33, 49, 68, 45, 34, 54, 52, 48, 65, 37, 35, 32, 48, 41, 48, 32, 43, 26, 41, 35, 41, 62, 35, 26, 45, 31, 30, 37, 23, 68, 40, 16, 28, 28, 24, 39, 46, 12, 40, 45, 44, 35, 53, 38, 42, 27, 32, 39, 53, 18, 30, 45, 58, 42, 36, 67, 24, 36, 38, 9, 56, 61, 47, 60, 58, 66, 14, 35, 32, 32, 58, 38, 40, 37, 38, 44, 57, 34, 75, 44, 33, 29, 53, 44, 32, 40, 35, 55, 13, 35, 52, 31, 47, 16, 35, 56, 39, 33, 46, 47, 24, 46, 21, 35, 35, 17, 31, 39, 39, 36, 17, 29, 42, 33, 29, 54, 56, 24, 28, 48, 15, 44, 35, 35, 39, 60, 42, 48, 43, 58, 36, 46, 30, 45, 40, 63, 42, 15, 54, 34, 30, 54, 34, 21, 19, 25, 21, 19, 47, 28, 58, 28, 11, 29, 36, 30, 56, 31, 38, 29, 48, 36, 34, 45, 35, 39, 55, 10, 31, 72, 44, 31, 44, 34, 15, 39, 5, 35, 35, 50, 66, 45, 50, 47, 40, 20, 22, 50, 34, 46, 55, 44, 55, 62, 38, 46, 45, 52, 27, 51, 33, 29, 16, 40, 37, 62, 37, 46, 26, 37, 47, 26, 39, 36, 35, 31, 48, 19, 41, 56, 44, 54, 67, 36, 27, 39, 31, 46, 19, 50, 29, 48, 28, 52, 49, 30, 39, 53, 54, 20, 29, 48, 40, 44, 49, 53, 19, 23, 33, 32, 47, 36, 42, 38, 24, 13, 52, 45, 52, 46, 59, 18, 31, 37, 35, 22, 26, 9, 12, 20, 36, 10, 41, 31, 48, 42, 44, 29, 38, 53, 27, 50, 46, 64, 22, 30, 37, 24, 50, 52, 32, 43, 51, 78, 70, 62, 34, 58, 27, 61, 27, 54, 59, 48, 42, 58, 67, 50, 24, 42, 30, 29, 36, 52, 53, 27, 20, 38, 9, 29, 17, 34, 26, 8, 32, 52, 27, 31, 35, 31, 23, 50, 24, 41, 67, 44, 69, 21, 30, 58, 33, 32, 44, 53, 41, 41, 40, 15, 48, 56, 39, 37, 59, 20, 61, 38, 44, 23, 28, 32, 54, 29, 33, 46, 42, 63, 58, 47, 37, 32, 12, 39, 46, 13, 56, 68, 49, 59, 35, 23, 13, 47, 27, 69, 4, 49, 35, 60, 41, 5, 28, 67, 51, 42, 45, 28, 36, 42, 52, 50, 46, 36, 35, 17, 33, 20, 23, 53, 38, 39, 43, 29, 37, 55, 44, 32, 35, 20, 63, 51, 39, 50, 30, 27, 80, 18, 53, 54, 51, 53, 39, 32, 63, 10, 31, 32, 39, 38, 44, 30, 37, 40, 44, 43, 30, 20, 44, 58, 70, 65, 54, 47, 40, 54, 36, 46, 48, 54, 31, 29, 47, 48, 27, 46, 24, 40, 50, 28, 50, 31, 19, 50, 61, 37, 36, 47, 25, 67, 31, 38, 19, 39, 25, 14, 76, 34, 52, 22, 55, 47, 20, 39, 34, 54, 40, 44, 59, 48, 41, 50, 29, 25, 42, 64, 38, 23, 55, 27, 40, 47, 24, 34, 66, 31, 56, 10, 46, 43, 45, 30, 48, 15, 28, 43, 50, 16, 35, 28, 45, 40, 38, 48, 16, 26, 30, 26, 30, 68, 67, 53, 44, 45, 51, 47, 45, 29, 45, 46, 46, 75, 21, 28, 30, 35, 44, 45, 42, 48, 33, 52, 49, 53, 39, 36, 25, 49, 45, 17, 20, 61, 18, 29, 68, 50, 47, 28, 41, 26, 36, 40, 16, 46, 26, 38, 37, 59, 56, 18, 57, 33, 65, 44, 42, 37, 55, 38, 46, 8, 16, 51, 27, 51, 54, 27, 12, 10, 48, 70, 19, 39, 39, 28, 36, 23, 33, 32, 31, 24, 7, 37, 21, 31, 36, 46, 21, 51, 61, 54, 24, 36, 74, 40, 49, 25, 40, 46, 19, 28, 44, 58, 10, 34, 43, 45, 30, 36, 48, 33, 50, 43, 50, 35, 16, 40, 36, 38, 35, 54, 37, 40, 42, 14, 35, 41, 47, 51, 50, 61, 36, 58, 30, 46, 44, 38, 20, 11, 34, 42, 59, 38, 71, 40, 25, 35, 52, 26, 66, 49, 36, 31, 24, 52, 58, 60, 7, 31, 49, 35, 61, 56, 46, 32, 19, 78, 35]}, 'test_3': {'capacity': 100, 'num_items': 5000, 'items': [55, 51, 16, 43, 30, 49, 52, 44, 48, 29, 52, 34, 37, 25, 53, 48, 33, 34, 37, 72, 42, 46, 13, 64, 42, 66, 60, 37, 27, 48, 32, 46, 41, 36, 52, 22, 17, 30, 32, 37, 39, 35, 43, 55, 49, 23, 43, 66, 36, 42, 30, 37, 29, 44, 29, 48, 51, 47, 60, 51, 40, 36, 55, 60, 42, 60, 54, 20, 28, 43, 46, 41, 39, 36, 22, 23, 22, 44, 44, 41, 35, 50, 17, 30, 24, 46, 32, 66, 39, 54, 34, 24, 41, 49, 37, 41, 5, 34, 49, 44, 24, 44, 20, 31, 46, 32, 86, 31, 48, 38, 49, 16, 46, 58, 18, 41, 26, 61, 48, 51, 16, 48, 30, 48, 21, 34, 13, 37, 59, 30, 34, 68, 59, 36, 28, 19, 61, 50, 14, 44, 43, 18, 48, 69, 55, 63, 69, 69, 25, 55, 44, 55, 29, 63, 50, 47, 37, 40, 35, 25, 25, 34, 49, 30, 40, 34, 47, 43, 65, 69, 47, 67, 36, 56, 18, 16, 34, 48, 31, 13, 61, 42, 24, 52, 42, 35, 37, 33, 17, 21, 49, 57, 47, 27, 25, 52, 20, 20, 36, 40, 46, 44, 59, 46, 47, 54, 38, 65, 68, 54, 47, 36, 61, 25, 53, 34, 21, 54, 61, 27, 31, 50, 42, 43, 25, 29, 32, 26, 26, 37, 33, 29, 30, 64, 37, 52, 43, 43, 47, 59, 37, 38, 33, 66, 34, 32, 53, 14, 67, 10, 35, 58, 50, 23, 36, 46, 52, 34, 48, 24, 28, 47, 49, 19, 60, 20, 23, 18, 34, 32, 62, 31, 50, 53, 26, 53, 27, 39, 40, 61, 48, 41, 40, 32, 33, 42, 30, 31, 50, 19, 36, 64, 46, 36, 29, 55, 49, 43, 42, 62, 47, 36, 49, 47, 27, 59, 24, 46, 40, 48, 35, 39, 62, 31, 67, 37, 15, 10, 17, 66, 48, 35, 24, 36, 41, 17, 34, 43, 70, 44, 55, 50, 35, 42, 14, 33, 63, 12, 62, 56, 60, 17, 26, 45, 62, 68, 24, 66, 24, 52, 27, 12, 68, 43, 41, 38, 75, 65, 51, 63, 20, 24, 32, 46, 41, 32, 51, 64, 60, 11, 59, 54, 47, 60, 26, 38, 76, 15, 46, 7, 25, 57, 23, 32, 34, 26, 25, 38, 59, 45, 38, 33, 31, 37, 37, 44, 46, 21, 22, 52, 29, 19, 39, 41, 39, 31, 51, 32, 23, 21, 30, 49, 64, 28, 49, 19, 48, 19, 49, 16, 34, 46, 61, 13, 45, 39, 36, 36, 32, 40, 29, 54, 34, 37, 38, 65, 27, 28, 38, 46, 34, 38, 50, 54, 34, 39, 39, 21, 38, 44, 21, 52, 59, 33, 69, 38, 54, 13, 44, 52, 32, 28, 44, 43, 58, 21, 52, 35, 42, 34, 49, 39, 26, 69, 25, 37, 49, 54, 56, 65, 43, 32, 36, 27, 40, 23, 48, 24, 13, 25, 38, 29, 40, 26, 36, 50, 47, 25, 59, 24, 45, 28, 41, 23, 55, 44, 49, 64, 14, 49, 13, 12, 14, 61, 37, 63, 45, 17, 33, 27, 32, 15, 48, 54, 28, 36, 24, 45, 43, 26, 55, 29, 60, 53, 30, 87, 48, 51, 47, 54, 38, 53, 51, 25, 48, 12, 30, 36, 80, 63, 30, 33, 38, 33, 32, 24, 12, 29, 41, 26, 64, 37, 24, 83, 27, 62, 52, 45, 23, 39, 37, 51, 52, 48, 23, 34, 51, 27, 41, 50, 52, 73, 23, 38, 38, 25, 36, 52, 79, 21, 42, 60, 68, 48, 23, 15, 33, 39, 50, 23, 39, 64, 51, 16, 27, 41, 70, 50, 34, 29, 44, 18, 63, 47, 14, 36, 45, 69, 71, 42, 11, 49, 10, 43, 31, 48, 54, 31, 40, 35, 40, 38, 33, 46, 43, 34, 26, 49, 8, 46, 11, 27, 27, 11, 64, 47, 37, 41, 68, 28, 31, 69, 36, 40, 45, 49, 55, 35, 46, 44, 66, 50, 53, 37, 30, 66, 14, 63, 39, 45, 42, 37, 48, 55, 54, 32, 18, 64, 39, 49, 68, 35, 40, 16, 51, 51, 41, 54, 41, 27, 17, 40, 36, 54, 58, 36, 46, 29, 34, 35, 18, 41, 59, 49, 44, 36, 50, 29, 36, 15, 58, 30, 15, 46, 26, 30, 62, 50, 35, 19, 35, 20, 32, 19, 69, 19, 40, 51, 51, 53, 17, 38, 40, 10, 43, 22, 72, 33, 70, 14, 48, 38, 50, 42, 21, 28, 36, 44, 67, 34, 22, 17, 18, 28, 49, 66, 26, 53, 41, 21, 8, 26, 39, 54, 45, 42, 28, 49, 62, 66, 41, 36, 41, 32, 31, 20, 42, 26, 39, 37, 29, 29, 21, 41, 26, 36, 57, 44, 45, 26, 42, 44, 45, 47, 61, 51, 27, 22, 44, 44, 25, 7, 36, 21, 53, 26, 38, 26, 28, 60, 57, 28, 65, 64, 33, 34, 29, 26, 48, 42, 46, 21, 31, 62, 58, 47, 56, 42, 50, 52, 41, 23, 28, 64, 11, 46, 36, 56, 44, 58, 58, 29, 13, 68, 46, 45, 15, 29, 53, 51, 58, 27, 35, 47, 39, 48, 34, 26, 36, 54, 60, 56, 67, 40, 39, 63, 47, 44, 24, 58, 48, 48, 49, 46, 41, 68, 42, 50, 73, 23, 23, 36, 41, 43, 20, 63, 36, 20, 39, 49, 25, 32, 53, 21, 31, 54, 30, 22, 28, 37, 57, 37, 41, 42, 21, 14, 48, 22, 49, 39, 21, 36, 19, 31, 64, 50, 12, 32, 58, 45, 35, 21, 49, 58, 69, 48, 37, 27, 44, 32, 20, 24, 35, 49, 54, 19, 53, 40, 49, 67, 26, 49, 70, 43, 30, 38, 27, 35, 57, 39, 45, 38, 41, 15, 21, 54, 26, 34, 46, 64, 36, 28, 45, 63, 57, 67, 22, 26, 8, 42, 47, 36, 66, 23, 42, 24, 16, 37, 39, 57, 54, 26, 33, 17, 21, 66, 26, 32, 35, 54, 40, 19, 59, 41, 45, 34, 45, 31, 32, 20, 35, 50, 24, 41, 93, 47, 30, 45, 32, 45, 37, 40, 67, 32, 14, 28, 41, 62, 34, 28, 33, 28, 41, 61, 37, 46, 23, 32, 33, 39, 37, 49, 36, 32, 61, 27, 68, 62, 52, 40, 39, 46, 23, 49, 17, 38, 31, 23, 17, 25, 70, 47, 46, 50, 15, 34, 56, 51, 48, 74, 27, 64, 11, 51, 46, 37, 35, 51, 23, 35, 36, 31, 55, 32, 33, 49, 12, 39, 48, 20, 35, 58, 70, 36, 52, 21, 46, 32, 41, 42, 42, 13, 14, 44, 31, 51, 47, 21, 45, 43, 38, 44, 44, 32, 54, 30, 51, 36, 8, 44, 14, 28, 35, 34, 40, 28, 16, 49, 21, 33, 39, 48, 65, 38, 58, 38, 35, 41, 36, 77, 33, 38, 29, 23, 20, 59, 38, 30, 32, 25, 27, 28, 45, 43, 42, 23, 20, 37, 29, 49, 51, 10, 73, 12, 33, 30, 21, 48, 38, 48, 46, 31, 37, 35, 26, 67, 21, 66, 55, 43, 26, 49, 52, 39, 33, 59, 33, 25, 54, 55, 16, 19, 34, 49, 42, 44, 26, 32, 40, 25, 53, 33, 36, 61, 66, 55, 78, 54, 31, 44, 40, 25, 31, 65, 57, 50, 25, 17, 52, 23, 50, 24, 54, 28, 56, 26, 41, 46, 43, 43, 46, 39, 26, 26, 40, 59, 31, 24, 30, 14, 53, 34, 54, 34, 46, 66, 51, 52, 56, 30, 45, 38, 22, 49, 55, 40, 24, 54, 41, 44, 38, 39, 40, 15, 7, 76, 42, 53, 44, 39, 39, 41, 38, 53, 23, 52, 44, 28, 62, 41, 69, 43, 60, 37, 33, 37, 69, 38, 49, 35, 37, 29, 22, 37, 52, 40, 40, 20, 18, 30, 39, 49, 10, 9, 62, 47, 46, 27, 79, 43, 37, 34, 57, 56, 45, 42, 44, 47, 21, 27, 59, 36, 17, 39, 45, 69, 28, 28, 48, 20, 47, 48, 60, 31, 56, 43, 54, 19, 19, 59, 67, 23, 48, 52, 26, 50, 18, 70, 22, 15, 42, 39, 29, 64, 23, 57, 24, 31, 12, 25, 20, 54, 49, 65, 60, 41, 32, 45, 41, 57, 54, 35, 16, 27, 54, 55, 71, 33, 21, 51, 39, 45, 29, 36, 28, 7, 8, 34, 38, 26, 33, 81, 62, 15, 31, 19, 42, 25, 47, 53, 45, 49, 52, 33, 42, 34, 59, 54, 45, 54, 31, 47, 52, 42, 26, 46, 36, 41, 54, 31, 52, 60, 42, 41, 47, 43, 19, 54, 17, 31, 34, 77, 49, 12, 27, 36, 61, 31, 47, 45, 53, 48, 44, 18, 45, 51, 21, 32, 20, 38, 32, 15, 35, 45, 34, 38, 35, 48, 60, 61, 37, 54, 26, 74, 56, 22, 38, 20, 24, 42, 26, 48, 58, 61, 45, 40, 48, 50, 25, 36, 67, 44, 52, 30, 69, 35, 39, 46, 65, 76, 41, 45, 28, 34, 41, 27, 61, 51, 18, 34, 45, 20, 29, 54, 27, 32, 65, 16, 27, 47, 25, 17, 38, 38, 35, 34, 22, 34, 36, 15, 49, 47, 78, 20, 28, 26, 42, 34, 32, 38, 42, 50, 32, 47, 37, 32, 52, 39, 30, 29, 58, 27, 25, 38, 50, 49, 39, 50, 43, 27, 55, 49, 49, 58, 31, 18, 41, 49, 49, 31, 12, 41, 68, 51, 83, 22, 38, 39, 65, 35, 17, 49, 28, 21, 19, 53, 40, 44, 67, 49, 17, 25, 31, 24, 29, 41, 26, 35, 38, 36, 61, 38, 37, 13, 49, 58, 37, 32, 57, 46, 39, 38, 25, 47, 17, 50, 33, 51, 44, 47, 47, 35, 42, 47, 50, 31, 46, 11, 28, 52, 22, 31, 50, 54, 22, 39, 36, 29, 34, 34, 60, 47, 29, 40, 49, 26, 51, 26, 52, 39, 49, 14, 52, 19, 34, 48, 39, 14, 57, 40, 49, 16, 68, 45, 30, 29, 55, 40, 42, 43, 33, 61, 38, 40, 23, 9, 47, 59, 38, 38, 39, 30, 59, 45, 81, 48, 62, 22, 40, 20, 46, 19, 62, 56, 40, 34, 35, 34, 26, 40, 34, 26, 48, 37, 22, 45, 26, 38, 13, 21, 37, 37, 31, 56, 47, 17, 42, 12, 35, 58, 29, 40, 39, 34, 25, 50, 49, 10, 58, 62, 28, 84, 47, 41, 48, 62, 54, 49, 53, 58, 33, 52, 43, 27, 29, 53, 81, 52, 31, 23, 37, 50, 68, 28, 30, 14, 39, 55, 44, 40, 37, 28, 31, 42, 40, 51, 45, 58, 67, 36, 39, 34, 26, 61, 49, 57, 51, 42, 26, 63, 46, 41, 58, 13, 49, 39, 43, 49, 23, 43, 51, 51, 20, 47, 15, 55, 72, 18, 21, 25, 37, 49, 39, 45, 52, 39, 73, 31, 38, 36, 36, 29, 33, 33, 21, 22, 36, 41, 65, 69, 28, 28, 26, 59, 26, 41, 35, 14, 22, 44, 43, 40, 34, 54, 29, 36, 50, 37, 44, 48, 26, 44, 64, 32, 48, 46, 50, 37, 45, 40, 11, 31, 14, 32, 42, 40, 36, 34, 36, 48, 29, 16, 48, 55, 54, 58, 32, 35, 55, 28, 43, 24, 38, 52, 34, 34, 20, 63, 31, 57, 38, 31, 27, 51, 34, 18, 60, 47, 55, 39, 41, 39, 27, 39, 67, 57, 41, 21, 13, 39, 42, 28, 33, 32, 31, 57, 18, 50, 32, 16, 42, 44, 15, 31, 51, 48, 15, 22, 40, 29, 26, 14, 51, 38, 39, 40, 21, 52, 59, 23, 38, 26, 45, 32, 61, 40, 51, 35, 44, 53, 38, 49, 29, 26, 21, 37, 20, 54, 29, 56, 28, 75, 29, 47, 59, 36, 24, 31, 32, 51, 43, 45, 72, 44, 30, 62, 39, 30, 36, 37, 33, 31, 32, 39, 30, 64, 46, 25, 22, 70, 45, 30, 62, 67, 61, 40, 9, 41, 5, 30, 52, 32, 38, 8, 13, 67, 27, 40, 36, 36, 38, 31, 27, 39, 33, 72, 56, 41, 64, 51, 62, 21, 36, 51, 30, 36, 29, 33, 17, 43, 18, 38, 24, 59, 30, 36, 15, 27, 45, 14, 47, 29, 36, 51, 58, 45, 49, 61, 37, 45, 38, 58, 30, 58, 52, 29, 65, 38, 43, 18, 30, 28, 41, 42, 11, 51, 22, 57, 38, 54, 36, 55, 38, 29, 46, 35, 27, 26, 56, 47, 27, 29, 22, 38, 13, 24, 32, 42, 32, 50, 46, 35, 24, 41, 54, 43, 47, 36, 37, 30, 48, 34, 55, 38, 35, 75, 28, 12, 57, 39, 21, 18, 33, 17, 26, 48, 68, 55, 50, 50, 30, 45, 26, 37, 52, 53, 22, 73, 54, 39, 24, 26, 27, 23, 38, 41, 48, 47, 30, 36, 22, 38, 27, 26, 33, 58, 70, 68, 8, 29, 9, 19, 17, 32, 42, 50, 60, 43, 51, 25, 30, 56, 22, 70, 52, 26, 22, 53, 47, 23, 19, 61, 46, 39, 47, 11, 39, 29, 37, 70, 52, 41, 37, 36, 51, 33, 29, 41, 46, 44, 24, 24, 58, 11, 53, 34, 44, 53, 39, 52, 74, 16, 53, 46, 38, 71, 57, 26, 38, 54, 54, 40, 47, 81, 31, 52, 29, 29, 52, 64, 30, 63, 40, 26, 42, 56, 55, 36, 37, 19, 40, 51, 29, 51, 57, 45, 31, 57, 32, 27, 39, 42, 31, 23, 42, 27, 48, 31, 35, 25, 52, 58, 62, 6, 80, 29, 72, 54, 43, 48, 29, 50, 49, 19, 53, 48, 36, 35, 35, 9, 55, 37, 20, 56, 46, 50, 13, 48, 13, 18, 41, 52, 35, 33, 43, 39, 25, 31, 41, 32, 55, 28, 41, 43, 15, 66, 16, 47, 18, 40, 25, 27, 45, 39, 30, 43, 52, 44, 24, 74, 45, 36, 28, 46, 43, 7, 27, 48, 44, 80, 39, 46, 39, 31, 34, 29, 19, 8, 36, 37, 12, 43, 54, 20, 22, 31, 28, 45, 19, 40, 47, 44, 54, 32, 20, 39, 51, 61, 42, 33, 72, 38, 30, 48, 28, 36, 32, 31, 59, 38, 37, 67, 68, 14, 20, 33, 59, 44, 35, 18, 49, 53, 63, 27, 45, 41, 38, 35, 42, 13, 34, 23, 26, 64, 21, 24, 55, 42, 52, 35, 26, 24, 33, 29, 51, 50, 21, 42, 58, 48, 25, 34, 46, 21, 44, 29, 42, 43, 55, 48, 38, 54, 27, 38, 29, 29, 40, 51, 20, 66, 29, 39, 41, 23, 54, 27, 37, 44, 29, 40, 52, 18, 35, 25, 31, 41, 22, 28, 22, 55, 55, 27, 17, 69, 75, 33, 32, 65, 34, 60, 40, 39, 36, 21, 36, 59, 10, 44, 16, 41, 25, 11, 30, 33, 40, 63, 27, 38, 56, 49, 49, 33, 30, 26, 61, 28, 26, 48, 37, 42, 46, 25, 50, 21, 33, 78, 26, 19, 36, 34, 40, 33, 42, 50, 35, 33, 52, 46, 46, 28, 23, 55, 26, 30, 31, 42, 40, 63, 63, 43, 32, 42, 32, 13, 37, 53, 42, 22, 51, 61, 18, 25, 20, 36, 20, 36, 19, 41, 30, 64, 57, 38, 35, 31, 40, 46, 45, 31, 42, 24, 37, 33, 28, 53, 9, 35, 20, 30, 9, 49, 30, 52, 51, 61, 41, 11, 29, 37, 50, 49, 32, 50, 72, 49, 58, 32, 45, 30, 19, 30, 52, 16, 41, 38, 41, 41, 33, 22, 31, 44, 57, 24, 67, 52, 29, 29, 10, 56, 60, 76, 33, 69, 26, 32, 62, 18, 20, 38, 16, 50, 30, 31, 36, 40, 46, 26, 75, 34, 46, 34, 61, 28, 65, 37, 30, 62, 65, 35, 50, 27, 51, 43, 34, 32, 22, 41, 30, 35, 30, 60, 44, 50, 46, 26, 27, 39, 62, 23, 25, 36, 41, 50, 35, 36, 21, 28, 18, 58, 22, 11, 27, 26, 41, 36, 30, 60, 37, 64, 29, 56, 21, 44, 33, 49, 49, 53, 38, 41, 24, 60, 38, 26, 60, 9, 54, 42, 23, 46, 77, 23, 42, 37, 30, 23, 15, 26, 35, 21, 25, 39, 45, 28, 58, 52, 26, 34, 55, 59, 11, 21, 7, 57, 17, 28, 41, 54, 29, 38, 39, 29, 19, 39, 45, 52, 54, 40, 38, 22, 42, 46, 35, 29, 20, 35, 21, 42, 40, 32, 50, 27, 48, 68, 25, 44, 42, 64, 35, 77, 15, 32, 32, 31, 45, 52, 14, 63, 48, 17, 45, 37, 16, 21, 13, 39, 26, 29, 49, 24, 41, 39, 43, 41, 35, 34, 21, 39, 37, 23, 28, 51, 51, 27, 33, 36, 40, 49, 39, 40, 50, 41, 62, 49, 59, 39, 48, 49, 16, 39, 51, 47, 32, 51, 27, 36, 39, 28, 50, 27, 28, 18, 36, 37, 28, 23, 27, 15, 60, 49, 29, 13, 24, 32, 36, 51, 23, 27, 70, 13, 28, 57, 19, 61, 27, 60, 23, 46, 39, 43, 22, 69, 42, 30, 39, 9, 17, 53, 27, 45, 52, 29, 7, 13, 45, 45, 47, 36, 65, 49, 59, 41, 33, 26, 65, 21, 23, 19, 48, 27, 56, 38, 57, 47, 42, 63, 45, 33, 15, 22, 14, 15, 30, 51, 38, 39, 41, 48, 31, 39, 61, 29, 75, 47, 35, 58, 50, 26, 40, 53, 65, 53, 43, 44, 56, 45, 60, 40, 22, 33, 59, 53, 47, 56, 67, 47, 46, 45, 34, 75, 48, 29, 62, 24, 34, 36, 55, 31, 67, 17, 36, 29, 51, 41, 33, 25, 48, 38, 16, 63, 46, 43, 46, 45, 35, 45, 77, 35, 28, 66, 51, 20, 41, 36, 23, 65, 40, 37, 30, 51, 23, 38, 15, 63, 47, 37, 24, 18, 28, 42, 27, 44, 36, 46, 43, 41, 46, 57, 49, 43, 40, 44, 53, 23, 33, 63, 30, 32, 36, 47, 43, 35, 7, 67, 48, 33, 54, 12, 64, 57, 12, 52, 8, 58, 45, 42, 43, 54, 54, 59, 32, 35, 36, 20, 43, 40, 37, 45, 38, 41, 50, 29, 15, 34, 73, 30, 37, 55, 47, 21, 33, 37, 39, 60, 14, 52, 67, 48, 12, 37, 40, 57, 59, 64, 47, 13, 31, 57, 59, 30, 30, 22, 39, 38, 13, 32, 46, 24, 47, 16, 44, 32, 49, 28, 61, 65, 24, 24, 19, 22, 42, 20, 51, 43, 25, 27, 54, 28, 55, 36, 27, 32, 27, 55, 51, 41, 46, 37, 53, 19, 68, 44, 65, 29, 22, 55, 14, 59, 76, 50, 37, 46, 49, 38, 20, 34, 58, 52, 62, 30, 48, 45, 37, 17, 51, 33, 41, 18, 34, 17, 22, 51, 48, 14, 69, 26, 47, 54, 31, 19, 49, 49, 53, 51, 50, 69, 53, 27, 24, 33, 48, 50, 37, 42, 48, 37, 49, 68, 34, 49, 22, 44, 26, 39, 32, 43, 32, 55, 46, 73, 42, 18, 57, 53, 27, 3, 46, 51, 49, 59, 57, 26, 34, 32, 22, 47, 60, 35, 42, 28, 71, 30, 35, 52, 54, 54, 35, 35, 34, 37, 42, 70, 42, 33, 35, 56, 24, 34, 52, 54, 53, 41, 45, 24, 16, 35, 65, 38, 35, 45, 18, 46, 16, 19, 25, 34, 30, 49, 54, 28, 32, 46, 42, 30, 32, 31, 38, 28, 43, 34, 51, 52, 58, 45, 31, 59, 24, 31, 52, 33, 53, 26, 48, 45, 61, 38, 57, 36, 28, 37, 41, 40, 47, 25, 54, 17, 50, 30, 56, 26, 42, 34, 23, 19, 70, 45, 47, 68, 39, 24, 35, 56, 39, 26, 25, 22, 49, 40, 38, 32, 31, 32, 56, 48, 45, 43, 40, 58, 44, 37, 54, 40, 19, 27, 12, 41, 34, 29, 17, 86, 50, 49, 38, 22, 72, 33, 19, 47, 47, 59, 64, 62, 65, 62, 29, 49, 43, 46, 30, 70, 59, 40, 34, 52, 47, 29, 42, 31, 28, 68, 52, 24, 32, 40, 18, 35, 28, 41, 31, 58, 29, 58, 36, 31, 32, 34, 48, 66, 32, 34, 48, 35, 31, 22, 38, 23, 21, 42, 41, 34, 24, 65, 55, 29, 47, 43, 56, 38, 18, 31, 32, 54, 18, 22, 43, 67, 55, 24, 39, 49, 35, 46, 28, 28, 49, 18, 52, 28, 74, 62, 60, 59, 23, 36, 28, 61, 58, 68, 16, 25, 41, 38, 21, 51, 28, 56, 43, 38, 24, 29, 65, 37, 44, 25, 41, 40, 36, 36, 38, 57, 63, 29, 41, 51, 16, 71, 59, 14, 19, 36, 20, 31, 59, 75, 24, 36, 52, 53, 29, 50, 51, 68, 24, 49, 49, 18, 63, 57, 46, 46, 34, 63, 38, 40, 39, 46, 45, 49, 3, 73, 23, 30, 43, 63, 45, 46, 33, 20, 65, 35, 65, 65, 44, 19, 38, 14, 41, 53, 54, 61, 55, 40, 28, 53, 38, 38, 49, 65, 61, 50, 31, 42, 48, 13, 26, 64, 71, 46, 29, 25, 28, 60, 62, 48, 37, 73, 43, 21, 32, 57, 48, 20, 43, 52, 45, 47, 67, 21, 29, 32, 16, 56, 32, 71, 35, 29, 38, 52, 37, 57, 52, 19, 39, 65, 26, 33, 36, 25, 47, 40, 44, 36, 55, 28, 25, 25, 27, 44, 42, 36, 64, 24, 30, 41, 24, 30, 54, 38, 35, 43, 27, 57, 51, 34, 20, 15, 45, 34, 34, 49, 14, 28, 61, 50, 53, 69, 33, 9, 29, 55, 54, 45, 27, 51, 29, 68, 52, 52, 59, 18, 28, 21, 35, 52, 13, 19, 34, 40, 41, 33, 43, 38, 54, 66, 77, 11, 31, 51, 59, 34, 25, 66, 44, 25, 41, 21, 52, 36, 40, 26, 32, 31, 42, 52, 41, 27, 41, 25, 27, 45, 38, 48, 45, 27, 44, 31, 19, 38, 21, 57, 38, 65, 36, 57, 37, 38, 73, 48, 51, 52, 54, 37, 55, 52, 20, 37, 38, 48, 16, 45, 20, 36, 43, 51, 12, 27, 60, 46, 63, 48, 67, 31, 42, 37, 64, 21, 30, 49, 47, 41, 29, 45, 52, 35, 32, 61, 13, 36, 44, 35, 34, 40, 26, 38, 46, 48, 60, 52, 19, 29, 35, 37, 22, 61, 23, 43, 28, 27, 63, 30, 34, 52, 35, 56, 50, 37, 31, 16, 51, 39, 53, 52, 16, 24, 57, 23, 29, 26, 39, 40, 51, 53, 38, 54, 47, 35, 44, 44, 51, 29, 43, 55, 61, 39, 33, 43, 42, 51, 11, 47, 29, 67, 25, 47, 10, 66, 61, 29, 61, 20, 18, 51, 50, 36, 22, 42, 44, 43, 55, 21, 23, 28, 68, 24, 31, 70, 73, 70, 43, 16, 49, 32, 19, 56, 73, 28, 32, 39, 15, 46, 18, 42, 20, 43, 15, 65, 66, 21, 59, 27, 44, 31, 31, 38, 72, 44, 32, 46, 41, 40, 58, 33, 53, 63, 22, 16, 38, 40, 24, 61, 19, 29, 11, 18, 23, 49, 22, 20, 60, 35, 53, 28, 59, 49, 56, 27, 35, 61, 47, 61, 50, 44, 40, 22, 29, 59, 61, 59, 21, 52, 32, 44, 36, 23, 55, 42, 12, 55, 33, 46, 49, 10, 56, 25, 29, 42, 53, 55, 50, 27, 18, 22, 50, 47, 41, 54, 20, 56, 62, 18, 40, 26, 6, 62, 41, 51, 33, 36, 53, 52, 60, 17, 48, 36, 30, 27, 41, 27, 57, 14, 41, 53, 36, 44, 52, 27, 20, 44, 71, 38, 18, 35, 39, 34, 42, 17, 58, 47, 22, 28, 48, 19, 37, 38, 39, 12, 29, 61, 19, 30, 18, 31, 41, 53, 35, 32, 52, 20, 55, 35, 41, 45, 45, 35, 35, 50, 37, 29, 28, 53, 26, 55, 51, 31, 44, 25, 29, 21, 45, 42, 35, 17, 51, 34, 47, 70, 51, 48, 11, 44, 15, 64, 40, 51, 25, 47, 48, 53, 49, 47, 47, 42, 52, 50, 42, 52, 39, 48, 35, 51, 53, 34, 49, 59, 47, 45, 58, 27, 26, 22, 37, 42, 66, 46, 29, 52, 54, 34, 52, 39, 33, 52, 43, 41, 35, 46, 37, 47, 28, 40, 11, 37, 51, 55, 28, 71, 54, 48, 18, 45, 52, 41, 25, 19, 24, 54, 45, 36, 31, 31, 10, 45, 36, 41, 44, 41, 30, 65, 57, 65, 68, 24, 34, 50, 40, 56, 36, 26, 33, 71, 45, 5, 21, 50, 52, 31, 22, 30, 35, 56, 18, 28, 15, 37, 28, 37, 60, 36, 25, 26, 55, 54, 44, 55, 49, 49, 16, 42, 19, 39, 42, 46, 46, 41, 30, 28, 42, 69, 52, 32, 61, 45, 38, 9, 24, 28, 13, 26, 54, 49, 37, 47, 38, 49, 22, 55, 53, 48, 19, 46, 33, 27, 61, 31, 47, 46, 25, 25, 54, 18, 52, 38, 36, 27, 11, 42, 44, 48, 71, 42, 22, 53, 67, 26, 32, 49, 40, 32, 16, 36, 52, 27, 39, 44, 62, 85, 51, 41, 55, 64, 50, 39, 27, 38, 40, 35, 61, 24, 14, 55, 48, 49, 50, 44, 14, 17, 42, 59, 30, 38, 23, 55, 29, 34, 34, 44, 55, 28, 9, 27, 49, 49, 12, 51, 38, 44, 46, 55, 26, 42, 38, 18, 53, 70, 28, 70, 58, 41, 42, 44, 31, 46, 43, 22, 59, 22, 17, 18, 24, 32, 31, 51, 26, 14, 65, 47, 47, 55, 55, 29, 27, 55, 36, 38, 52, 36, 31, 44, 29, 29, 36, 39, 34, 22, 32, 44, 45, 22, 37, 16, 65, 46, 41, 18, 52, 48, 36, 36, 8, 60, 64, 29, 61, 35, 41, 46, 29, 34, 71, 26, 49, 42, 46, 60, 56, 35, 11, 58, 27, 42, 55, 47, 39, 28, 36, 34, 59, 38, 50, 58, 34, 59, 31, 41, 39, 14, 42, 27, 33, 34, 45, 56, 63, 46, 40, 21, 45, 34, 33, 44, 49, 35, 25, 35, 19, 62, 42, 34, 49, 63, 43, 48, 59, 55, 37, 26, 16, 82, 61, 41, 19, 11, 32, 50, 47, 55, 27, 26, 21, 28, 40, 69, 42, 45, 74, 40, 19, 38, 21, 62, 39, 31, 59, 29, 59, 27, 27, 56, 37, 35, 28, 26, 59, 39, 74, 59, 31, 56, 67, 48, 31, 28, 72, 27, 29, 36, 26, 44, 32, 39, 39, 74, 61, 34, 47, 47, 55, 21, 32, 18, 55, 24, 33, 46, 37, 56, 29, 39, 55, 41, 34, 36, 31, 48, 31, 49, 31, 63, 10, 87, 42, 38, 28, 32, 46, 29, 34, 52, 59, 21, 17, 31, 30, 57, 37, 37, 26, 46, 29, 58, 63, 18, 66, 37, 55, 53, 43, 53, 21, 47, 31, 41, 38, 26, 49, 36, 53, 37, 45, 63, 48, 13, 48, 39, 26, 35, 45, 43, 27, 49, 39, 29, 16, 49, 26, 26, 44, 45, 21, 39, 41, 52, 15, 25, 53, 36, 58, 45, 50, 32, 47, 40, 47, 38, 54, 55, 58, 48, 43, 50, 60, 43, 48, 20, 13, 32, 44, 57, 39, 12, 44, 59, 58, 33, 43, 59, 65, 58, 41, 25, 51, 33, 54, 32, 32, 34, 41, 65, 41, 48, 34, 38, 14, 54, 40, 46, 73, 18, 33, 37, 30, 42, 39, 29, 71, 29, 21, 38, 17, 45, 49, 25, 52, 35, 34, 42, 14, 40, 19, 40, 35, 45, 28, 36, 32, 64, 43, 50, 33, 27, 60, 42, 36, 36, 49, 69, 61, 41, 60, 27, 55, 25, 42, 43, 22, 39, 57, 48, 35, 53, 52, 47, 41, 27, 58, 43, 59, 27, 48, 20, 31, 52, 26, 50, 23, 75, 49, 37, 45, 57, 56, 44, 39, 34, 45, 30, 18, 35, 30, 76, 28, 51, 40, 55, 61, 67, 53, 24, 42, 42, 36, 51, 53, 71, 39, 31, 30, 42, 35, 24, 41, 65, 51, 16, 43, 47, 41, 50, 41, 24, 60, 24, 32, 48, 24, 64, 31, 60, 43, 18, 44, 41, 17, 38, 12, 34, 42, 38, 48, 7, 13, 62, 63, 13, 41, 51, 31, 34, 29, 35, 48, 38, 15, 53, 32, 70, 40, 8, 31, 22, 27, 26, 54, 16, 43, 15, 22, 42, 48, 53, 64, 63, 20, 37, 40, 36, 4, 42, 42, 43, 32, 54, 66, 72, 30, 38, 30, 35, 41, 47, 21, 18, 63, 33, 31, 39, 59, 42, 20, 47, 27, 47, 59, 22, 34, 45, 14, 63, 40, 54, 25, 19, 44, 46, 60, 55, 47, 48, 16, 34, 37, 49, 22, 34, 17, 17, 59, 25, 44, 39, 47, 31, 40, 38, 50, 50, 50, 46, 45, 38, 39, 23, 12, 21, 47, 15, 37, 38, 20, 27, 58, 37, 70, 28, 18, 41, 12, 29, 30, 47, 27, 50, 29, 39, 17, 31, 17, 41, 29, 50, 42, 65, 32, 13, 17, 34, 54, 32, 48, 39, 67, 56, 15, 41, 36, 39, 28, 30, 45, 45, 34, 46, 30, 40, 56, 48, 26, 43, 22, 61, 31, 28, 29, 50, 16, 65, 54, 44, 52, 28, 32, 19, 42, 42, 39, 39, 59, 28, 60, 66, 23, 31, 24, 28, 13, 60, 38, 27, 35, 48, 59, 40, 62, 46, 70, 25, 54, 50, 32, 46, 57, 40, 38, 11, 45, 53, 21, 50, 30, 40, 43, 16, 32, 51, 42, 49, 60, 60, 37, 44, 73, 45, 55, 33, 42, 31, 49, 44, 21, 62, 50, 58, 26, 17, 71, 17, 27, 39, 50, 40, 43, 44, 31, 21, 44, 43, 22, 60, 29, 57, 20, 39, 44, 33, 34, 34, 41, 16, 25, 51, 23, 48, 17, 34, 24, 40, 27, 39, 28, 24, 26, 36, 37, 23, 57, 29, 56, 23, 41, 67, 35, 23, 10, 69, 56, 53, 50, 45, 32, 52, 39, 42, 30, 36, 47, 47, 36, 21, 21, 51, 24, 72, 10, 17, 52, 39, 39, 19, 20, 36, 54, 36, 34, 49, 63, 37, 24, 21, 43, 28, 65, 32, 29, 38, 23, 31, 9, 44, 51, 26, 52, 54, 28, 52, 46, 32, 50, 43, 46, 40, 24, 42, 38, 24, 46, 44, 40, 29, 35, 27, 55, 32, 28, 23, 13, 33, 31, 37, 18, 19, 37, 42, 18, 24, 36, 25, 54, 65, 6, 43, 27, 37, 68, 42, 33, 41, 48, 45, 66, 15, 27, 34]}, 'test_4': {'capacity': 100, 'num_items': 5000, 'items': [38, 34, 46, 40, 59, 55, 27, 37, 11, 63, 9, 31, 18, 52, 43, 50, 47, 34, 44, 47, 50, 41, 17, 40, 52, 55, 27, 29, 28, 54, 13, 57, 40, 15, 35, 27, 13, 28, 20, 8, 24, 47, 38, 48, 26, 34, 36, 47, 39, 10, 19, 57, 39, 44, 43, 56, 31, 48, 50, 26, 52, 52, 56, 41, 49, 37, 46, 37, 29, 47, 43, 30, 32, 24, 47, 37, 55, 47, 43, 10, 50, 27, 50, 27, 33, 51, 15, 43, 45, 48, 44, 59, 32, 44, 40, 46, 66, 39, 51, 30, 38, 25, 38, 28, 48, 50, 14, 41, 39, 31, 33, 38, 17, 24, 32, 23, 18, 55, 41, 40, 66, 35, 51, 63, 50, 88, 31, 63, 34, 51, 58, 32, 43, 59, 65, 43, 40, 31, 47, 66, 47, 45, 61, 24, 43, 53, 37, 36, 57, 19, 51, 6, 29, 41, 30, 11, 25, 50, 53, 53, 52, 42, 22, 29, 39, 25, 25, 34, 52, 50, 42, 59, 42, 50, 52, 49, 22, 60, 37, 50, 45, 24, 30, 40, 64, 33, 64, 47, 26, 55, 29, 39, 60, 27, 34, 41, 43, 35, 49, 40, 39, 51, 33, 45, 48, 64, 19, 47, 23, 41, 53, 35, 43, 33, 39, 34, 63, 27, 42, 34, 54, 52, 74, 27, 59, 71, 56, 33, 41, 16, 74, 34, 38, 41, 29, 30, 28, 28, 51, 29, 53, 27, 6, 15, 35, 63, 16, 52, 43, 21, 41, 21, 36, 32, 52, 39, 32, 25, 37, 52, 58, 21, 32, 35, 61, 52, 23, 58, 36, 19, 51, 61, 42, 40, 30, 34, 25, 28, 28, 19, 20, 30, 34, 63, 30, 53, 49, 24, 20, 54, 45, 18, 52, 49, 43, 37, 33, 44, 42, 43, 50, 33, 25, 29, 64, 43, 63, 45, 58, 59, 50, 73, 48, 34, 8, 26, 50, 21, 80, 24, 36, 26, 37, 65, 53, 50, 50, 60, 33, 81, 43, 57, 25, 67, 35, 35, 47, 52, 14, 60, 36, 27, 52, 24, 37, 44, 57, 42, 33, 37, 39, 43, 58, 44, 35, 46, 50, 47, 74, 25, 46, 27, 53, 54, 37, 46, 39, 27, 32, 49, 77, 37, 68, 34, 63, 56, 44, 45, 26, 74, 47, 52, 37, 37, 67, 26, 28, 39, 49, 25, 34, 40, 30, 56, 47, 50, 56, 32, 26, 50, 51, 40, 27, 61, 54, 42, 25, 43, 17, 41, 49, 26, 51, 22, 15, 52, 50, 31, 28, 31, 55, 32, 20, 33, 54, 49, 32, 42, 68, 47, 64, 6, 37, 38, 44, 37, 25, 9, 60, 44, 38, 40, 62, 48, 49, 55, 40, 55, 41, 40, 42, 51, 46, 61, 54, 45, 34, 48, 80, 63, 28, 31, 41, 49, 30, 41, 13, 48, 65, 59, 33, 42, 24, 48, 48, 30, 75, 43, 62, 60, 65, 15, 19, 33, 47, 36, 21, 31, 41, 23, 38, 51, 42, 58, 14, 42, 12, 20, 37, 35, 42, 43, 15, 43, 28, 42, 34, 55, 35, 43, 49, 28, 16, 40, 26, 27, 41, 35, 27, 46, 38, 31, 36, 21, 35, 64, 35, 33, 42, 13, 49, 51, 59, 53, 18, 27, 67, 20, 38, 26, 37, 33, 44, 31, 21, 23, 46, 38, 36, 65, 39, 52, 35, 42, 30, 38, 33, 45, 72, 21, 35, 54, 29, 57, 52, 33, 20, 30, 45, 33, 53, 73, 48, 49, 32, 36, 62, 66, 30, 56, 53, 29, 42, 24, 46, 39, 20, 43, 38, 52, 25, 58, 22, 38, 44, 48, 34, 40, 32, 8, 35, 45, 25, 68, 30, 45, 67, 56, 40, 22, 30, 74, 27, 48, 33, 67, 39, 11, 37, 53, 45, 57, 42, 45, 50, 47, 40, 40, 61, 64, 51, 28, 18, 12, 49, 43, 47, 44, 55, 31, 53, 37, 31, 47, 48, 31, 39, 42, 50, 14, 33, 42, 39, 50, 37, 55, 47, 50, 78, 37, 38, 30, 61, 39, 48, 30, 26, 48, 62, 46, 27, 54, 38, 36, 46, 34, 35, 64, 24, 39, 75, 29, 70, 38, 28, 39, 10, 24, 49, 47, 33, 47, 58, 30, 10, 26, 28, 43, 33, 29, 46, 36, 35, 19, 36, 10, 37, 31, 7, 42, 46, 63, 82, 49, 42, 42, 22, 54, 42, 50, 30, 51, 61, 48, 43, 29, 13, 33, 36, 58, 38, 47, 59, 57, 19, 33, 56, 7, 49, 41, 49, 11, 40, 68, 28, 11, 36, 39, 26, 26, 64, 25, 36, 18, 53, 33, 39, 45, 62, 30, 23, 38, 31, 26, 35, 26, 4, 44, 39, 34, 29, 23, 36, 62, 39, 41, 38, 14, 55, 19, 46, 57, 51, 37, 19, 27, 33, 36, 34, 38, 43, 27, 66, 30, 27, 46, 48, 48, 59, 81, 58, 40, 50, 35, 45, 51, 53, 53, 46, 52, 39, 17, 49, 35, 32, 41, 54, 46, 33, 42, 44, 24, 43, 45, 28, 29, 44, 44, 34, 46, 44, 17, 54, 27, 39, 42, 41, 26, 39, 57, 38, 17, 21, 52, 47, 24, 32, 37, 45, 13, 62, 48, 31, 42, 19, 23, 30, 50, 15, 31, 28, 42, 51, 45, 47, 23, 40, 52, 85, 54, 36, 20, 38, 34, 18, 25, 14, 34, 43, 21, 35, 39, 45, 33, 52, 24, 40, 51, 29, 26, 51, 41, 64, 57, 29, 45, 48, 35, 37, 38, 42, 46, 36, 43, 26, 41, 62, 62, 63, 6, 21, 30, 30, 21, 36, 33, 58, 41, 53, 29, 42, 9, 57, 27, 37, 48, 25, 23, 31, 33, 32, 42, 35, 15, 13, 61, 30, 16, 47, 25, 31, 62, 5, 50, 19, 38, 61, 27, 26, 35, 40, 24, 31, 30, 18, 18, 41, 36, 61, 11, 46, 7, 8, 42, 39, 28, 28, 33, 37, 37, 44, 6, 53, 35, 29, 35, 67, 29, 31, 49, 34, 46, 21, 23, 35, 48, 28, 38, 67, 45, 59, 44, 50, 61, 24, 49, 58, 9, 16, 40, 14, 18, 34, 47, 37, 56, 22, 41, 39, 35, 59, 57, 34, 24, 16, 48, 36, 38, 44, 23, 79, 24, 10, 36, 51, 32, 39, 43, 55, 28, 27, 25, 42, 45, 63, 24, 41, 47, 19, 32, 26, 57, 30, 24, 32, 62, 73, 35, 65, 30, 67, 38, 41, 30, 37, 48, 22, 58, 50, 8, 42, 44, 72, 42, 67, 24, 64, 55, 54, 42, 13, 13, 27, 27, 19, 53, 28, 33, 23, 36, 70, 54, 55, 37, 56, 35, 35, 53, 3, 43, 26, 43, 29, 69, 45, 61, 45, 46, 19, 40, 25, 43, 38, 62, 45, 58, 71, 45, 28, 42, 42, 11, 56, 58, 39, 35, 66, 23, 30, 42, 35, 50, 24, 44, 61, 56, 42, 41, 56, 48, 54, 21, 35, 51, 21, 29, 16, 44, 40, 50, 34, 38, 63, 58, 20, 51, 30, 39, 33, 29, 7, 39, 36, 59, 16, 45, 54, 49, 73, 30, 55, 32, 53, 83, 28, 44, 38, 54, 32, 23, 30, 50, 12, 52, 52, 46, 28, 47, 32, 26, 8, 60, 9, 36, 27, 27, 69, 49, 45, 31, 16, 48, 14, 31, 36, 44, 35, 48, 47, 51, 55, 40, 43, 42, 21, 51, 70, 53, 18, 37, 37, 53, 26, 28, 53, 65, 33, 27, 17, 42, 32, 19, 65, 31, 13, 32, 42, 24, 45, 54, 51, 48, 45, 54, 60, 31, 62, 43, 43, 43, 58, 33, 9, 46, 43, 16, 77, 52, 55, 46, 70, 78, 35, 42, 27, 24, 62, 40, 41, 43, 60, 43, 46, 27, 54, 47, 49, 51, 35, 42, 46, 21, 37, 47, 13, 39, 42, 21, 24, 45, 11, 50, 29, 36, 43, 49, 46, 28, 36, 47, 49, 42, 35, 57, 44, 41, 51, 59, 68, 37, 40, 32, 67, 21, 35, 28, 36, 35, 60, 39, 35, 39, 13, 51, 24, 8, 21, 59, 34, 42, 33, 41, 44, 22, 35, 33, 45, 80, 36, 42, 26, 25, 45, 46, 23, 30, 27, 53, 58, 50, 71, 39, 35, 49, 18, 56, 43, 16, 51, 24, 60, 53, 57, 51, 27, 34, 49, 47, 55, 37, 13, 11, 34, 53, 21, 24, 29, 61, 56, 45, 15, 33, 40, 31, 18, 36, 44, 9, 20, 41, 48, 34, 38, 35, 65, 48, 18, 11, 37, 28, 39, 51, 59, 42, 54, 44, 41, 10, 30, 54, 44, 38, 22, 44, 11, 54, 30, 40, 50, 49, 34, 26, 33, 39, 31, 44, 51, 47, 40, 41, 9, 42, 28, 45, 28, 36, 47, 50, 7, 47, 64, 43, 44, 46, 46, 11, 45, 26, 29, 31, 61, 44, 53, 71, 31, 69, 6, 42, 38, 51, 34, 51, 38, 45, 27, 29, 32, 25, 32, 25, 36, 43, 56, 49, 36, 36, 60, 46, 24, 36, 45, 57, 56, 41, 43, 35, 18, 52, 33, 41, 66, 71, 25, 28, 17, 11, 40, 34, 34, 12, 38, 31, 24, 52, 39, 19, 66, 55, 24, 43, 24, 33, 39, 66, 30, 24, 8, 62, 55, 64, 40, 59, 53, 42, 52, 29, 26, 24, 40, 32, 43, 30, 38, 55, 39, 16, 27, 33, 58, 31, 66, 35, 30, 26, 18, 34, 50, 35, 23, 30, 36, 36, 21, 33, 46, 52, 48, 31, 30, 29, 9, 27, 26, 40, 39, 45, 38, 60, 40, 34, 49, 45, 78, 34, 29, 56, 38, 20, 83, 19, 34, 37, 33, 54, 69, 47, 32, 49, 45, 48, 42, 19, 44, 30, 21, 39, 30, 29, 67, 37, 29, 33, 74, 38, 36, 10, 26, 27, 26, 49, 57, 56, 26, 34, 33, 9, 20, 22, 36, 53, 16, 69, 28, 35, 58, 53, 9, 50, 43, 30, 58, 49, 39, 40, 27, 42, 40, 42, 19, 39, 46, 58, 62, 30, 48, 30, 39, 36, 17, 37, 51, 18, 56, 48, 18, 24, 39, 21, 48, 8, 45, 36, 42, 44, 38, 50, 40, 51, 27, 23, 47, 16, 62, 49, 37, 44, 50, 17, 45, 45, 68, 12, 22, 59, 54, 38, 11, 43, 51, 21, 34, 29, 49, 41, 17, 33, 78, 18, 30, 47, 71, 33, 56, 44, 55, 46, 48, 50, 45, 31, 45, 27, 50, 46, 36, 43, 40, 59, 52, 53, 44, 29, 33, 59, 29, 55, 48, 38, 38, 21, 52, 22, 35, 38, 19, 31, 51, 47, 52, 41, 29, 26, 28, 60, 27, 40, 61, 44, 39, 36, 34, 37, 37, 39, 48, 73, 26, 24, 34, 29, 32, 59, 40, 41, 31, 14, 63, 19, 38, 45, 40, 58, 27, 55, 66, 45, 31, 28, 51, 22, 31, 15, 16, 31, 29, 34, 55, 52, 33, 46, 43, 70, 44, 40, 33, 31, 28, 52, 22, 37, 61, 17, 15, 21, 42, 54, 35, 25, 63, 15, 38, 52, 49, 58, 39, 65, 32, 31, 52, 43, 46, 44, 51, 34, 43, 56, 60, 80, 10, 46, 18, 17, 25, 37, 33, 34, 61, 31, 44, 64, 22, 30, 22, 35, 57, 38, 37, 42, 56, 39, 54, 25, 57, 52, 58, 36, 27, 36, 43, 24, 50, 60, 36, 16, 26, 18, 62, 50, 19, 39, 15, 34, 27, 49, 33, 22, 49, 45, 33, 43, 39, 65, 20, 44, 58, 42, 24, 38, 36, 23, 37, 41, 35, 33, 10, 31, 58, 59, 24, 36, 39, 61, 27, 43, 34, 37, 37, 31, 55, 44, 28, 11, 48, 34, 56, 41, 67, 51, 35, 26, 40, 22, 31, 46, 36, 21, 29, 22, 37, 31, 30, 68, 37, 47, 37, 33, 31, 72, 48, 33, 40, 44, 47, 52, 20, 25, 61, 27, 33, 57, 61, 46, 17, 29, 15, 68, 31, 35, 24, 54, 42, 24, 9, 12, 48, 52, 43, 43, 42, 23, 57, 53, 75, 36, 59, 46, 40, 38, 37, 51, 52, 30, 62, 41, 41, 71, 57, 20, 40, 51, 26, 60, 46, 57, 12, 9, 47, 26, 30, 30, 51, 27, 20, 47, 64, 36, 32, 34, 68, 31, 34, 18, 42, 24, 25, 17, 20, 78, 61, 47, 61, 19, 42, 27, 28, 52, 35, 14, 37, 51, 44, 44, 57, 48, 49, 46, 23, 41, 39, 37, 45, 70, 38, 30, 16, 36, 45, 26, 53, 29, 39, 29, 59, 28, 42, 31, 60, 52, 18, 34, 38, 52, 32, 40, 60, 81, 58, 55, 19, 28, 62, 54, 52, 35, 13, 9, 26, 26, 70, 49, 25, 30, 33, 12, 54, 29, 32, 51, 30, 64, 54, 28, 39, 23, 31, 22, 38, 40, 54, 42, 75, 34, 15, 33, 63, 37, 32, 21, 34, 47, 47, 39, 39, 49, 33, 31, 49, 43, 45, 55, 62, 39, 17, 53, 47, 39, 42, 22, 47, 64, 29, 17, 34, 24, 34, 47, 4, 32, 54, 63, 52, 32, 31, 43, 38, 36, 34, 21, 46, 60, 35, 25, 40, 18, 36, 50, 34, 27, 73, 48, 31, 48, 37, 19, 24, 61, 20, 36, 60, 32, 25, 39, 40, 38, 52, 21, 7, 52, 79, 60, 58, 57, 50, 50, 27, 40, 45, 21, 36, 28, 23, 38, 41, 35, 42, 6, 26, 23, 36, 19, 59, 41, 28, 45, 45, 57, 33, 55, 63, 42, 19, 35, 47, 17, 44, 31, 11, 7, 15, 36, 66, 42, 19, 41, 40, 30, 49, 49, 55, 51, 48, 21, 51, 39, 32, 42, 38, 61, 44, 26, 12, 25, 28, 52, 14, 56, 23, 47, 36, 51, 25, 31, 43, 34, 58, 25, 30, 34, 24, 90, 49, 36, 20, 55, 49, 43, 22, 64, 76, 33, 57, 50, 28, 42, 40, 23, 56, 39, 27, 23, 40, 47, 38, 49, 52, 39, 39, 43, 17, 44, 28, 43, 49, 53, 70, 31, 48, 63, 29, 25, 31, 45, 29, 40, 43, 46, 17, 27, 60, 56, 53, 54, 66, 30, 44, 29, 46, 32, 22, 40, 28, 34, 37, 19, 51, 42, 26, 19, 28, 66, 36, 33, 62, 23, 70, 62, 54, 49, 44, 39, 59, 58, 60, 39, 75, 41, 59, 33, 63, 51, 53, 38, 28, 52, 80, 39, 50, 29, 63, 48, 54, 32, 19, 11, 55, 27, 39, 36, 33, 18, 39, 15, 38, 23, 35, 46, 34, 31, 25, 26, 55, 30, 32, 22, 56, 45, 39, 31, 21, 28, 68, 36, 35, 45, 17, 36, 47, 23, 37, 17, 42, 53, 37, 42, 53, 45, 23, 34, 30, 26, 42, 39, 31, 43, 62, 55, 40, 75, 37, 41, 40, 26, 35, 26, 65, 18, 41, 37, 31, 43, 60, 62, 44, 42, 74, 41, 51, 30, 40, 49, 52, 55, 36, 22, 41, 50, 19, 53, 11, 32, 24, 18, 34, 62, 47, 39, 35, 34, 32, 35, 23, 36, 28, 37, 48, 65, 46, 57, 7, 26, 69, 38, 58, 50, 47, 38, 21, 50, 35, 45, 40, 46, 36, 48, 58, 36, 30, 54, 38, 56, 24, 44, 35, 30, 33, 27, 81, 44, 80, 45, 49, 38, 19, 23, 30, 27, 40, 71, 35, 67, 18, 33, 73, 46, 33, 44, 51, 31, 52, 44, 57, 51, 26, 27, 67, 23, 14, 36, 34, 41, 40, 55, 23, 37, 18, 21, 26, 43, 33, 42, 53, 21, 35, 52, 51, 30, 48, 30, 37, 50, 46, 8, 43, 30, 54, 53, 35, 58, 38, 47, 35, 8, 52, 38, 37, 81, 29, 43, 55, 37, 25, 49, 41, 39, 32, 38, 46, 59, 18, 46, 46, 44, 14, 35, 50, 49, 16, 33, 44, 36, 42, 77, 33, 36, 51, 39, 18, 58, 10, 43, 58, 60, 55, 41, 25, 63, 20, 39, 69, 29, 30, 65, 59, 23, 50, 25, 33, 36, 31, 44, 23, 54, 8, 49, 14, 31, 39, 61, 58, 32, 59, 37, 32, 57, 26, 38, 64, 61, 45, 37, 39, 45, 36, 28, 41, 38, 28, 20, 37, 57, 30, 36, 53, 42, 58, 26, 45, 18, 74, 53, 48, 52, 23, 49, 20, 35, 8, 27, 38, 65, 28, 7, 48, 29, 48, 50, 37, 41, 56, 36, 43, 44, 30, 32, 21, 48, 40, 29, 52, 56, 37, 57, 34, 16, 54, 20, 56, 33, 16, 38, 25, 74, 20, 52, 25, 60, 50, 29, 44, 60, 35, 32, 41, 42, 26, 43, 25, 30, 36, 31, 23, 48, 14, 29, 32, 59, 41, 32, 27, 23, 34, 41, 30, 46, 66, 52, 66, 31, 39, 25, 78, 24, 47, 33, 54, 7, 34, 56, 28, 33, 31, 40, 31, 15, 62, 42, 47, 44, 43, 25, 35, 32, 45, 6, 45, 20, 65, 13, 29, 47, 49, 43, 37, 51, 38, 50, 52, 48, 40, 55, 49, 23, 42, 38, 18, 21, 45, 56, 37, 33, 28, 50, 46, 43, 34, 67, 27, 22, 33, 44, 37, 27, 50, 46, 37, 14, 49, 24, 53, 34, 26, 54, 27, 35, 46, 45, 78, 18, 41, 25, 29, 30, 17, 17, 7, 50, 21, 69, 49, 61, 15, 35, 33, 7, 27, 20, 32, 45, 40, 54, 18, 15, 54, 42, 50, 41, 69, 45, 48, 49, 59, 27, 26, 63, 66, 35, 32, 50, 18, 31, 51, 62, 57, 59, 19, 47, 51, 32, 44, 65, 26, 43, 60, 65, 33, 50, 22, 32, 34, 45, 59, 90, 68, 52, 38, 37, 25, 46, 49, 29, 15, 46, 26, 36, 37, 50, 35, 29, 23, 31, 19, 68, 37, 34, 33, 49, 65, 43, 41, 52, 35, 37, 30, 30, 37, 30, 41, 58, 22, 36, 66, 43, 50, 49, 29, 39, 42, 70, 20, 30, 62, 41, 29, 29, 45, 38, 59, 46, 5, 31, 52, 44, 51, 60, 45, 33, 50, 40, 39, 46, 45, 63, 32, 53, 53, 43, 31, 34, 69, 36, 61, 18, 28, 26, 38, 31, 19, 55, 42, 53, 39, 62, 29, 55, 59, 22, 53, 29, 46, 39, 26, 26, 61, 38, 26, 50, 59, 53, 52, 42, 24, 25, 54, 15, 48, 43, 37, 31, 51, 26, 59, 37, 66, 68, 39, 39, 47, 28, 45, 42, 57, 41, 66, 21, 25, 58, 29, 40, 28, 27, 78, 39, 44, 27, 67, 63, 35, 63, 22, 49, 26, 44, 36, 34, 34, 38, 42, 44, 43, 41, 52, 7, 20, 51, 38, 50, 58, 35, 36, 27, 35, 48, 34, 67, 20, 48, 31, 40, 14, 65, 45, 75, 35, 32, 24, 46, 44, 30, 20, 50, 17, 38, 58, 60, 24, 53, 51, 56, 44, 65, 18, 52, 32, 35, 56, 37, 42, 48, 54, 48, 18, 22, 42, 32, 40, 39, 40, 41, 57, 53, 36, 26, 34, 26, 61, 42, 54, 50, 46, 56, 34, 43, 33, 41, 35, 20, 16, 32, 54, 50, 54, 60, 70, 24, 35, 47, 30, 13, 31, 46, 41, 36, 44, 48, 32, 33, 33, 56, 51, 39, 30, 46, 41, 54, 39, 48, 46, 43, 26, 34, 27, 43, 25, 57, 61, 62, 19, 47, 23, 27, 36, 48, 47, 58, 60, 23, 36, 31, 32, 10, 44, 46, 33, 49, 31, 67, 24, 40, 52, 15, 40, 44, 28, 48, 37, 40, 39, 45, 34, 50, 47, 29, 44, 20, 54, 35, 30, 51, 35, 44, 34, 54, 48, 35, 51, 28, 52, 36, 18, 40, 55, 19, 62, 58, 31, 22, 19, 32, 59, 42, 30, 32, 51, 67, 20, 38, 33, 94, 37, 59, 69, 61, 33, 35, 40, 43, 33, 28, 38, 48, 52, 43, 21, 55, 64, 38, 57, 47, 34, 39, 35, 40, 67, 34, 35, 64, 25, 21, 31, 41, 44, 24, 49, 54, 32, 23, 64, 64, 32, 37, 55, 45, 38, 45, 34, 35, 36, 35, 41, 29, 34, 55, 34, 45, 18, 48, 38, 24, 35, 45, 49, 34, 57, 34, 51, 57, 21, 47, 53, 64, 40, 54, 58, 14, 51, 63, 29, 56, 41, 64, 25, 21, 40, 75, 13, 50, 34, 45, 50, 65, 32, 42, 19, 41, 33, 18, 26, 35, 50, 40, 22, 34, 44, 55, 56, 10, 31, 13, 39, 20, 47, 12, 44, 52, 41, 43, 52, 31, 49, 35, 37, 58, 20, 17, 14, 38, 59, 27, 56, 21, 36, 54, 35, 26, 17, 26, 50, 32, 58, 37, 60, 57, 52, 42, 15, 54, 21, 18, 40, 48, 29, 38, 42, 48, 21, 46, 41, 48, 19, 20, 36, 21, 36, 49, 53, 16, 53, 22, 25, 62, 45, 23, 28, 30, 63, 44, 23, 37, 28, 22, 65, 43, 60, 21, 8, 25, 28, 52, 58, 46, 59, 4, 47, 64, 23, 35, 31, 33, 50, 45, 45, 24, 46, 51, 52, 68, 47, 19, 48, 63, 30, 38, 25, 41, 40, 59, 40, 23, 41, 27, 71, 30, 31, 73, 72, 52, 49, 30, 58, 53, 32, 72, 44, 45, 52, 43, 66, 43, 48, 17, 41, 27, 72, 24, 20, 63, 42, 36, 13, 41, 67, 40, 41, 34, 30, 39, 23, 38, 26, 46, 19, 26, 65, 46, 20, 31, 32, 49, 60, 58, 41, 9, 18, 29, 54, 34, 47, 51, 28, 44, 52, 44, 22, 56, 30, 52, 14, 41, 71, 50, 27, 15, 44, 25, 43, 39, 38, 58, 39, 51, 49, 27, 50, 52, 31, 17, 44, 45, 15, 42, 34, 51, 53, 55, 18, 66, 61, 22, 22, 36, 27, 64, 13, 76, 65, 36, 22, 30, 42, 57, 34, 52, 17, 58, 71, 39, 75, 24, 44, 18, 37, 64, 45, 23, 16, 22, 49, 46, 33, 46, 39, 41, 35, 30, 37, 25, 24, 47, 65, 20, 43, 55, 71, 27, 21, 55, 55, 48, 46, 8, 46, 46, 34, 19, 54, 58, 52, 42, 28, 13, 66, 33, 43, 21, 51, 55, 41, 43, 44, 48, 17, 22, 41, 39, 44, 53, 20, 32, 39, 64, 27, 50, 44, 43, 51, 34, 24, 26, 61, 42, 17, 45, 37, 60, 30, 22, 23, 44, 43, 33, 55, 29, 32, 31, 31, 51, 65, 80, 43, 57, 44, 29, 24, 12, 64, 42, 52, 24, 51, 22, 39, 42, 55, 33, 48, 47, 62, 31, 46, 14, 25, 55, 34, 21, 29, 47, 44, 21, 44, 58, 59, 24, 29, 38, 51, 39, 25, 44, 37, 62, 13, 48, 48, 39, 43, 12, 6, 52, 27, 47, 44, 34, 54, 42, 49, 38, 34, 35, 62, 35, 36, 49, 32, 19, 48, 61, 32, 57, 58, 27, 52, 44, 39, 26, 23, 42, 45, 56, 55, 52, 35, 38, 31, 31, 28, 20, 40, 48, 44, 40, 71, 63, 48, 44, 52, 47, 35, 63, 62, 25, 37, 35, 35, 39, 32, 43, 45, 58, 68, 25, 37, 50, 48, 30, 51, 31, 28, 52, 63, 50, 81, 36, 59, 48, 44, 27, 18, 19, 26, 54, 54, 39, 43, 24, 40, 13, 39, 22, 23, 29, 53, 34, 23, 61, 56, 43, 49, 48, 49, 42, 9, 27, 33, 39, 29, 26, 53, 46, 46, 43, 41, 28, 34, 29, 33, 43, 44, 15, 41, 30, 32, 55, 75, 50, 26, 55, 68, 15, 17, 22, 55, 33, 52, 23, 39, 39, 39, 74, 18, 21, 37, 36, 23, 64, 51, 20, 65, 38, 25, 68, 58, 33, 53, 27, 25, 59, 35, 49, 51, 28, 38, 40, 36, 27, 46, 24, 17, 47, 38, 64, 52, 18, 32, 20, 27, 48, 37, 46, 77, 10, 39, 33, 48, 29, 38, 37, 41, 81, 39, 19, 54, 46, 33, 60, 29, 52, 40, 14, 54, 38, 27, 34, 41, 37, 34, 57, 18, 23, 36, 31, 73, 39, 40, 33, 31, 22, 35, 36, 50, 28, 41, 31, 18, 38, 53, 27, 43, 33, 29, 34, 36, 48, 18, 39, 38, 27, 47, 51, 68, 44, 39, 16, 29, 54, 16, 42, 38, 43, 33, 25, 27, 56, 57, 57, 50, 59, 42, 46, 58, 48, 52, 37, 10, 25, 63, 18, 49, 26, 32, 23, 31, 47, 28, 11, 32, 54, 17, 66, 27, 31, 30, 50, 49, 36, 20, 32, 72, 30, 27, 14, 58, 40, 41, 51, 39, 48, 19, 49, 58, 58, 50, 54, 40, 29, 30, 33, 33, 44, 39, 39, 32, 37, 45, 38, 48, 28, 41, 40, 53, 52, 29, 38, 44, 57, 22, 39, 24, 45, 20, 38, 53, 43, 38, 54, 40, 35, 17, 53, 18, 34, 44, 18, 38, 55, 48, 46, 35, 26, 21, 34, 62, 53, 46, 30, 6, 18, 63, 56, 15, 58, 68, 47, 49, 47, 43, 26, 42, 31, 28, 42, 18, 35, 66, 45, 53, 67, 41, 31, 34, 48, 42, 57, 40, 47, 16, 67, 45, 61, 8, 12, 44, 74, 35, 41, 40, 37, 38, 46, 37, 56, 32, 57, 25, 51, 48, 47, 31, 60, 15, 64, 39, 46, 37, 38, 10, 48, 31, 62, 13, 26, 34, 33, 53, 61, 28, 67, 8, 33, 24, 32, 26, 66, 35, 52, 32, 43, 43, 27, 45, 34, 33, 35, 51, 33, 48, 39, 33, 40, 20, 30, 32, 34, 71, 62, 29, 54, 31, 24, 47, 11, 22, 18, 34, 41, 36, 65, 41, 35, 63, 27, 29, 44, 38, 13, 36, 23, 25, 40, 55, 47, 49, 46, 36, 53, 38, 16, 13, 28, 63, 28, 49, 15, 46, 12, 24, 50, 24, 49, 61, 79, 37, 21, 45, 33, 38, 38, 30, 49, 48, 52, 49, 45, 48, 9, 47, 49, 44, 49, 28, 28, 43, 10, 46, 52, 15, 51, 45, 54, 30, 10, 50, 25, 44, 25, 53, 50, 13, 65, 20, 66, 25, 39, 10, 40, 10, 38, 50, 36, 30, 51, 46, 53, 31, 41, 42, 35, 62, 51, 14, 33, 37, 57, 43, 56, 21, 22, 50, 41, 50, 27, 32, 11, 49, 56, 23, 54, 32, 46, 44, 29, 31, 25, 19, 50, 37, 46, 47, 48, 51, 20, 43, 57, 33, 44, 46, 70, 34, 45, 13, 36, 53, 28, 50, 10, 48, 27, 19, 52, 22, 51, 49, 65, 21, 40, 40, 18, 53, 27, 38, 37, 32, 74, 52, 23, 40, 54, 55, 51, 61, 34, 37, 43, 33, 33, 73, 48, 46, 48, 54, 49, 20, 33, 37, 43, 15, 36, 42, 40, 29, 43, 18, 31, 56, 36, 24, 57, 48, 67, 20, 16, 15, 62, 35, 53, 36, 43, 35, 35, 51, 62, 53, 66, 44, 34, 50, 34, 40, 58, 44, 52, 25, 30, 23, 52, 32, 50, 27, 28, 48, 30, 53, 50, 50, 35, 15, 22, 19, 45, 51, 22, 39, 36, 49, 61, 57, 58, 40, 43, 81, 79, 54, 41, 20, 22, 37, 12, 34, 61, 23, 37, 57, 36, 38, 43, 30, 60, 20, 45, 35, 32, 23, 27, 33, 30, 22, 24, 51, 23, 26, 35, 10, 70, 48, 38, 11, 24, 67, 32, 24, 62, 49, 24, 30, 49, 51, 31, 32, 14, 59, 50, 51, 30, 68, 38, 19, 37, 34, 46, 37, 63, 32, 21, 41, 43, 24, 41, 67, 26, 36, 46, 54, 61, 49, 35, 16, 16, 16, 56, 41, 41, 17, 40, 12, 46, 48, 19, 73, 31, 11, 52, 50, 26, 41, 55, 35, 23, 56, 22, 33, 60, 44, 23, 40, 23, 31, 43, 46, 26, 40, 40, 56, 29, 33, 24, 20, 53, 62, 22, 51, 68, 62, 56, 30, 56, 49, 64, 35, 39, 29, 36, 47, 24, 74, 36, 39, 54, 18, 21, 55, 34, 70, 24, 37, 31, 39, 63, 11, 42, 61, 31, 62, 46, 25, 38, 19, 53, 33, 26, 23, 52, 52, 36, 30, 10, 48, 58, 26, 29, 16, 23, 34, 22, 15, 26, 42, 15, 18, 46, 59, 58, 30, 42, 49, 16, 14, 50, 29, 27, 41, 48, 59, 42, 32, 33, 43, 43, 53, 52, 43, 63, 44, 19, 46, 43, 34, 50, 50, 23, 37, 36, 76, 50, 49, 54, 40, 35, 52, 42, 15, 32, 27, 22, 36, 26, 62, 31, 37, 50, 59, 35, 28, 18, 33, 39, 56, 44, 53, 39, 13, 12, 42, 44, 56, 58, 45, 31, 44, 74, 28, 46, 44, 31, 36, 40, 35, 41, 23, 34, 27, 27, 64, 39, 31, 51, 15, 38, 58, 41, 30, 31, 56, 44, 43, 41, 31, 10, 56, 66, 19, 54, 43, 35, 50, 40, 43, 50, 39, 19, 29, 17, 16, 46, 33, 11, 38, 47, 47, 33, 21, 45, 35, 37, 78, 69, 42, 59, 50, 30, 43, 50, 49, 29, 61, 46, 62, 25, 39, 67, 32, 43, 21, 26, 16, 26, 18, 55, 37, 33, 23, 33, 45, 47, 32, 51, 45, 23, 56, 49, 75, 28, 21, 34, 28, 40, 47, 34, 37, 43, 25, 31, 56, 65, 38, 14, 25, 33, 20, 7, 40, 39, 25, 56, 28, 51, 24, 52, 35, 46, 57, 52, 38, 56, 31, 18, 14, 20, 45, 36, 28, 24, 30, 50, 39, 43, 64, 31, 22, 48, 42, 42, 68, 51, 16, 37, 22, 43, 55, 22, 26, 41, 40, 29, 27, 35, 29, 59, 42, 50, 59, 31, 29, 52, 55, 30, 26, 30, 30, 39, 32, 40, 19, 45, 30, 32, 12, 52, 37, 26, 45, 36, 60, 58, 15, 9, 38, 38, 36, 44, 47, 27, 38, 46, 36, 44, 26, 28, 24, 32, 44, 14, 31, 62, 60, 61, 12, 45, 38, 55, 27, 30, 30, 70, 48, 38, 49, 33, 46, 47, 39, 43, 22, 29, 31, 37, 69, 14, 45, 81, 38, 45, 32, 13, 41, 7, 38, 44, 54, 45, 35, 13, 35, 53, 55, 25, 9, 15, 36, 40, 26, 35, 25, 45, 15, 55, 47, 22, 50, 29, 41, 35, 46, 25, 33, 23, 20, 35, 34, 31, 32, 29, 42, 46, 19, 60, 57, 31, 29, 31, 36, 50, 59, 51, 33, 31, 61, 64, 28, 58, 48, 43, 24, 33, 40, 43, 21, 48, 37, 44, 14, 31, 28, 41, 33, 50, 52, 59, 54, 50, 23, 47, 27, 28, 54, 44, 34, 28, 60, 46, 37, 29, 28, 54, 14, 26, 19, 41, 46, 31, 20, 74, 27, 31, 38, 48, 24, 48, 57, 72, 11, 43]}}

        def read_dataset_from_file(filename):
            with open(filename, 'rb') as file:
                dataset = pickle.load(file)

            transformed_dataset = {}

            for num_items, instances in dataset.items():
                transformed_dataset[f"Weibull {int(num_items/1000)}k"] = {}
                for instance_num, items in enumerate(instances, 1):
                    instance_name = f"test_{instance_num-1}"
                    instance_data = {
                        "capacity": 100,
                        "num_items": num_items,
                        "items": items
                    }
                    transformed_dataset[f"Weibull {int(num_items/1000)}k"][instance_name] = instance_data

            return transformed_dataset
        
        # self.datasets = read_dataset_from_file('../weibull_instances/test_dataset_100k.pkl')
        # for test_num in range(5):
        #     test_key = f'test_{test_num}'
        #     data = np.array(self.datasets['Weibull 5k'][test_key]['items'])
        #     print(data)
        #     print(self.datasets['Weibull 5k'][test_key]['capacity'])
        #     data = data / self.datasets['Weibull 5k'][test_key]['capacity']
        #     self.datasets['Weibull 5k'][test_key]['capacity'] = 1.0
        #     top_500_items = data[:1000]
        #     self.datasets['Weibull 5k'][test_key]['items'] = top_500_items
        #     self.datasets['Weibull 5k'][test_key]['num_items'] = 1000



    def l1_bound(self,items: tuple, capacity: int) -> float:
        """Computes L1 lower bound on OPT for bin packing.

        Args:
        items: Tuple of items to pack into bins.
        capacity: Capacity of bins.

        Returns:
        Lower bound on number of bins required to pack items.
        """
        return np.ceil(np.sum(items) / capacity)


    def l1_bound_dataset(self,instances: dict) -> float:
        """Computes the mean L1 lower bound across a dataset of bin packing instances.

        Args:
        instances: Dictionary containing a set of bin packing instances.

        Returns:
        Average L1 lower bound on number of bins required to pack items.
        """
        l1_bounds = []
        for name in instances:
            instance = instances[name]
            l1_bounds.append(self.l1_bound(instance['items'], instance['capacity']))
        return np.mean(l1_bounds)

    def get_instances(self):
        opt_num_bins = {}
        for name, dataset in self.datasets.items():
            opt_num_bins[name] = self.l1_bound_dataset(dataset)
        print(opt_num_bins)
        return self.datasets, opt_num_bins


