#!/bin/bash
output_dir="../outputs/cath_42_test"
if [ ! -d $output_dir ]
then
    mkdir -p $output_dir
fi
path_for_parsed_chains=$output_dir"/parsed_pdbs.jsonl"
num_seq_per_target=1
#python ../helper_scripts/parse_multiple_chains.py --input_path=$folder_with_pdbs --output_path=$path_for_parsed_chains

python ../protein_mpnn_run.py \
        --jsonl_path $path_for_parsed_chains \
        --out_folder $output_dir \
        --num_seq_per_target $num_seq_per_target \
        --sampling_temp "0.0000001" \
        --seed 123 \
        --batch_size 1 \
        --path_to_model_weights "../model_weights" \
        --model_name "model" \
           --use_attentionEncoder \
           --use_node_features \
           --use_physicsAttention \
           --use_physics_node \
           --use_physics_edge \
           --use_globalforce \
           --use_physical_constraint \
           --physical_constraint_ratio 0.2 \
           --num_encoder_layers 2 \
           --num_decoder_layers 2 \
           --use_se3