# AION @ ICML
Repo for scripts and plots for ICML submission


## Setting up environment 

Installing python environment
```bash
module load modules/2.3-20240529
module load gcc python/3.10.13
python -m venv --system-site-packages ~/venvs/aion_eval
source ~/venvs/aion_eval/bin/activate
pip install --upgrade eventlet
pip3 install torch==2.4.0 torchvision==0.19.0 torchaudio==2.4.0 --index-url https://download.pytorch.org/whl/cu124
pip install AION
pip install -e .
```

Adding link to shared data folder
```bash
ln -s data/AION_Eval data
```

## Preparing data 

Please refer to the data preparation section in the README.md file in the `scripts` folder.

## Running experiments

For instance to run the experiments for provabgs
```bash
for config in configs/benchmarks/provabgs/*.yaml; do
    sbatch submit_config.slurm "$config"
done
```
This will submit a job for each configuration file in the `configs/benchmarks/provabgs` folder, experiments can then be tracked on wandb.