SELECT
        object_id,
        ra,
        dec,
        f.g_cmodel_mag,
        f.g_cmodel_magerr,
        f.r_cmodel_mag,
        f.r_cmodel_magerr,
        f.i_cmodel_mag,
        f.i_cmodel_magerr,
        f.z_cmodel_mag,
        f.z_cmodel_magerr,
        f.y_cmodel_mag,
        f.y_cmodel_magerr,
		f.a_g, f.a_r, f.a_i, f.a_z, f.a_y,
		pz.photoz_median,
		pz.stellar_mass,
		pz.sfr
    FROM
        pdr3_wide.forced AS f
        JOIN pdr3_wide.forced2 AS f2 USING (object_id)
        JOIN pdr3_wide.photoz_mizuki AS pz USING (object_id)
    WHERE
        -- (i)(a): Is primary object
        f.isprimary = TRUE
        -- (i)(b, c, d): Pixel flags
        AND NOT (f.g_pixelflags_edge OR f.r_pixelflags_edge OR f.i_pixelflags_edge OR f.z_pixelflags_edge OR f.y_pixelflags_edge)
        AND NOT (f.g_pixelflags_interpolatedcenter OR f.r_pixelflags_interpolatedcenter OR f.i_pixelflags_interpolatedcenter OR f.z_pixelflags_interpolatedcenter OR f.y_pixelflags_interpolatedcenter)
        AND NOT (f.g_pixelflags_crcenter OR f.r_pixelflags_crcenter OR f.i_pixelflags_crcenter OR f.z_pixelflags_crcenter OR f.y_pixelflags_crcenter)
        -- (i)(e): CModel flag
        AND NOT (f.g_cmodel_flag OR f.r_cmodel_flag OR f.i_cmodel_flag OR f.z_cmodel_flag OR f.y_cmodel_flag)
        -- (i)(f): Extendedness
        AND f.i_extendedness_value > 0.9
        -- (i)(g): r/i CModel mag constraints
        AND (f.r_cmodel_mag - f.a_r) < 28.0
        AND (f.i_cmodel_mag - f.a_i) < 28.0
        -- (i)(h): z CModel mag constraint
        AND (f.z_cmodel_mag - f.a_z) < 21.0
        -- (ii)(i): SDSS centroid flag
        AND NOT (f2.g_sdsscentroid_flag OR f2.r_sdsscentroid_flag OR f2.i_sdsscentroid_flag OR f2.z_sdsscentroid_flag OR f2.y_sdsscentroid_flag)
        -- (iv)(k): Mask for bright object center
        AND NOT f.g_pixelflags_bright_objectcenter
        AND NOT f.r_pixelflags_bright_objectcenter
        AND NOT f.z_pixelflags_bright_objectcenter
        AND NOT f.y_pixelflags_bright_objectcenter
        -- (v)(l): Photo-z median constraint
        -- AND pz.photoz_median BETWEEN 0.2 AND 1.2
        -- (v)(m): Stellar mass
        -- AND pz.stellar_mass > 5.0e10
        -- (v)(n): SFR/stellar mass
        -- AND (pz.sfr / pz.stellar_mass) < 1.0e-10
		;