import os
from collections.abc import Mapping, Sequence

import numpy as np
import torch
import yaml
from aion.tokenizers import load_tokenizer


def get_tokenizers(survey, device="cuda"):
    """Loads all the tokenizers for the given survey"""
    # Loads the tokenizers configuration from the yaml file
    script_dir = os.path.dirname(__file__)
    file_path = os.path.join(script_dir, "tokenizers.yaml")
    print(file_path)
    with open(file_path, "r") as file:
        tokenizers = yaml.safe_load(file)
    outputs = {}
    for key, value in tokenizers[survey].items():
        outputs[key] = load_tokenizer(value, device)
    return outputs
