# AION: AstronomIcal Omnimodal Network - NeurIPS Supplementary Material

This archive contains the supplementary material for the NeurIPS submission of AION, a family of foundation models specifically designed for astronomical observations.

## 📁 Archive Structure

```
NeurIPS/
├── appendix.pdf          # Extended technical appendix with additional experiments and details
├── AION/                 # Main AION model implementation
│   ├── aion/            # Core model code and architecture
│   ├── README.md        # Detailed AION documentation
│   ├── LICENSE          # License information
│   └── pyproject.toml   # Python package configuration
└── AION_Eval/           # Evaluation framework and benchmarks
    ├── aion_eval/       # Evaluation code modules
    ├── configs/         # Configuration files for experiments
    ├── scripts/         # Data preparation and evaluation scripts
    ├── README.md        # Evaluation setup instructions
    └── submit_config.slurm  # SLURM job submission template
```

## 🚀 Quick Overview

**AION** is a multimodal foundation model for astronomy that:
- Processes 39 different astronomical modalities from major surveys (DES, HSC, DESI, Gaia, SDSS)
- Enables any-to-any multimodal predictions
- Supports cross-survey translation and cross-modal prediction
- Provides zero/few-shot learning capabilities
- Trained on 100TB+ of astronomical data 

## 📋 Contents Description

### 1. **appendix.pdf**
Extended technical appendix containing:
- Additional experimental results
- Detailed ablation studies
- Extended methodology descriptions
- Supplementary figures and tables
- Technical implementation details

### 2. **AION/** - Core Model Implementation
The main AION model package including:
- **Model Architecture**: Transformer-based encoder-decoder with cross-attention
- **Installation**: Simple pip-installable package

Key capabilities:
- Cross-survey translation (e.g., DES → HSC)
- Cross-modal prediction (e.g., images → spectra)
- Physical parameter estimation (e.g., redshift prediction)
- Spectrum super-resolution

Note however that we have not yet made the model weights available.

### 3. **AION_Eval/** - Evaluation Framework
Comprehensive evaluation suite containing:
- **Benchmark Tasks**: Multiple downstream astronomy tasks
- **Data Preparation Scripts**: Tools for processing various astronomical datasets
- **Evaluation Scripts**: Automated evaluation pipelines
- **Configuration System**: YAML-based experiment configuration
- **SLURM Integration**: HPC job submission support

Supported benchmarks:
- Galaxy property prediction (ProvaBGS)
- Spectroscopic parameter estimation (DESI-DDPayne)
- Galaxy morphology classification (GZ-DECALS, GZ10)
- Strong gravitational lens detection