"""
AION-1 (AstronomIcal Omnimodal Network) - Foundation models for astronomical data.

AION is a family of multimodal foundation models specifically designed for astronomical 
observations. Built on the Multimodal Universe (MMU) dataset, AION can process and 
generate predictions across 39 different astronomical modalities from major surveys.

Key Features:
    - Any-to-any multimodal prediction capabilities
    - Pre-trained on data from DES, HSC, DESI, Gaia, SDSS, and more
    - Cross-survey translation and cross-modal understanding
    - Efficient adaptation for downstream tasks via embeddings
    
Available Models:
    - AION-1 Base (300M parameters)
    - AION-1 Large (800M parameters)
    - AION-1 XLarge (3B parameters)

Example:
    >>> from aion import AION
    >>> model = AION.from_pretrained('aion-1-base')
    >>> 
    >>> # Cross-survey translation: DES to HSC
    >>> hsc_pred = model.forward(
    ...     input_dict={'des': des_images},
    ...     target_mask={'hsc': hsc_mask}
    ... )
    >>> 
    >>> # Predict spectra from images
    >>> spectra = model.forward(
    ...     input_dict={'hsc': hsc_images},
    ...     target_mask={'desi': spectrum_mask}
    ... )
    
References:
    - Lanusse et al. "One Network to Rule Them All" (2025)
    - Multimodal Universe Dataset (NeurIPS 2024)
    - https://github.com/MultimodalUniverse
"""

from .model import AION
