## Experiment Results for GZ10 Galaxy Classification

### Overview:
GZ10 galaxy classification experiments with from AION representations.

- **Data**: We use the GZ10 dataset for this experiment, with 7914 total LegacySurvey images. We perform a 90-10 train-validation split.
- **Model**: We use the Oct 24 AION-B, AION-L, and AION-XL models for this experiment. We use mean-pooled encoder outputs for classification, by freezing the encoder and only training the classification head.

### Results:

#### GZ10 Galaxy Classification
We evaluate sample efficiency by training on a equally spaced subset of 10%, 20%, ..., 90% of the entire data. We evaluate the performance of the model on the validation set at each step. The results can also be found in `gz10_oct24.csv`.

| Data Percentage (Samples) | AION-B (%) | AION-L (%) | AION-XL (%) |
|----------------------------|-------------------|--------------------|----------------------|
| 10% (791)                 | 76.57            | 81.01             | 80.52               |
| 20% (1582)                | 79.71            | 83.20             | 82.65               |
| 30% (2374)                | 81.18            | 84.19             | 83.83               |
| 40% (3165)                | 82.07            | 83.95             | 84.41               |
| 50% (3957)                | 82.27            | 84.29             | 84.59               |
| 60% (4748)                | 82.51            | 85.69             | 86.18               |
| 70% (5539)                | 82.92            | 85.48             | 86.15               |
| 80% (6331)                | 83.30            | 85.69             | 86.99               |
| 90% (7122)                | 83.95            | 87.16             | 86.52               |

#### Transfer Experiments
Next, we evaluate the transferability of the GZ10 classification head to other sources of input galaxy images. In particular, after a classification head is trained on the 90% of GZ10 dataset with 7122 samples, we evaluate its performance on HSC images, which features a standalone set of embeddings from the LegacySurvey images. This experiment is designed to evaluate the transferability of AION representations across modalities.

|  | AION-B (%) | AION-L (%) | AION-XL (%) |
|-------------|-------------|-------------|-------------|
| HSC (618)   | 84.15      | 85.66      | 86.15      |
