from datasetting.dataloader import get_digits_dataloader
from solver.solver_digits_test import SolverDigitsTest


def main():
    da_method = 'Multi-PL'
    target = 'USPS'
    batch_size = 128
    target_data_num = 9000
    data_dir = './../data/digits'

    # get target dataloader
    _, _, target_test_dataloader, _ = \
        get_digits_dataloader(name=target, target=True, batch_size=batch_size, data_num=target_data_num, data_dir=data_dir)
    solver = SolverDigitsTest(da_method, target, target_test_dataloader)

    acc, loss = solver.test()
    print('{} with target {} --- Accuracy: {:08f}, Loss: {:06f}'.format(da_method, target, acc, loss))


if __name__ == '__main__':
    main()
