set -x
# export VLLM_ATTENTION_BACKEND=XFORMERS

# countdown3_train_path=$HOME/data/countdown/train.parquet
# countdown3_test_path=$HOME/data/countdown/test.parquet
# countdown4_test_path=$HOME/data/countdown4/test.parquet

# train_files="['$countdown3_train_path']"
# test_files="['$countdown3_test_path', '$countdown4_test_path']"
# test_files="['$countdown3_test_path']"

python3 -m verl.trainer.main_ppo \
    algorithm.adv_estimator=grpo \
    +algorithm.use_grpo_simplified=$USE_GRPO_SIMPLIFIED \
    +algorithm.alpha=$GRPO_SIMPLIFIED_ALPHA \
    data.train_files=/root/data/countdown/train.parquet \
    data.val_files=/root/data/countdown/test.parquet \
    +data.shuffle=True \
    +data.seed=$SEED \
    data.train_batch_size=256 \
    data.val_batch_size=1024 \
    data.max_prompt_length=256 \
    data.max_response_length=1024 \
    actor_rollout_ref.model.path=$BASE_MODEL \
    actor_rollout_ref.actor.optim.lr=1e-6 \
    actor_rollout_ref.model.use_remove_padding=True \
    actor_rollout_ref.actor.ppo_mini_batch_size=64 \
    actor_rollout_ref.actor.ppo_micro_batch_size=8 \
    actor_rollout_ref.actor.use_dynamic_bsz=True \
    actor_rollout_ref.actor.use_kl_loss=$USE_KL_LOSS \
    actor_rollout_ref.actor.kl_loss_coef=$KL_LOSS_COEFFICIENT \
    actor_rollout_ref.actor.entropy_coeff=$ENTROPY_LOSS_COEFFICIENT \
    actor_rollout_ref.actor.kl_loss_type=low_var_kl \
    actor_rollout_ref.model.enable_gradient_checkpointing=True \
    actor_rollout_ref.actor.fsdp_config.param_offload=False \
    actor_rollout_ref.actor.fsdp_config.grad_offload=False \
    actor_rollout_ref.actor.fsdp_config.optimizer_offload=False \
    actor_rollout_ref.rollout.log_prob_micro_batch_size=8 \
    actor_rollout_ref.rollout.tensor_model_parallel_size=$ROLLOUT_TP_SIZE \
    actor_rollout_ref.rollout.name=vllm \
    actor_rollout_ref.rollout.gpu_memory_utilization=0.4 \
    actor_rollout_ref.rollout.n=5 \
    actor_rollout_ref.ref.log_prob_micro_batch_size=4 \
    actor_rollout_ref.ref.fsdp_config.param_offload=True \
    algorithm.kl_ctrl.kl_coef=$KL_CTRL_COEFFICIENT \
    trainer.critic_warmup=0 \
    trainer.logger=['console','wandb'] \
    trainer.project_name=$PROJECT_NAME \
    trainer.experiment_name=$EXPERIMENT_NAME \
    trainer.default_hdfs_dir=null \
    +trainer.val_before_train=True \
    +trainer.val_only=True \
    +trainer.resume_mode='auto' \
    +trainer.remove_previous_ckpt_in_save=False \
    +trainer.del_local_ckpt_after_load=False \
    trainer.n_gpus_per_node=$N_GPUS \
    trainer.nnodes=1 \
    trainer.save_freq=10 \
    trainer.test_freq=10 \
    trainer.default_hdfs_dir=null \
    trainer.default_local_dir=/verl_repo/grpo_simplified/checkpoints/$PROJECT_NAME/$EXPERIMENT_NAME/ \
    trainer.total_epochs=50 $@