# Learning to solve Class-Constrained Bin Packing Problems via Encoder-Decoder Model


## Dependencies
* Python>=3.8
* NumPy
* sklearn
* scikit-opt
* ortools
* [PyTorch>=1.2](http://pytorch.org/)
* tqdm
* Matplotlib (optional, only for plotting)
* tensorboardX

The synthetic datasets will be generated during the training and test process if not exist.

## Training

```bash
python train_bpp.py  --train_size 6400  --val_size 320 --nof_epoch 20 --C 5 --Q 10 --M 1
```

M = 1 for single-class constrained BPP, M > 1 for multi-class constrained BPP
## Cluster Decode with Active Search

```bash
python run_eas_bpp.py  --test_size 200 --max-iter 30 -C 5 --Q 10 --M 1
```

## Baselines

### Random or FFD
```bash
python test_bpp.py  --test_size 200 --batch_size 50  -C 5 --Q 10 --M 1 --search_type random/decreasing
```

### GA or ACO
```bash
python baseline/test_ga_aco.py --C 5 --Q 10  --data_dir 
```

```bash
python baseline/test_mccbpp_ga_aco.py --C 5 --Q 10 --M 2 --data_dir 
```

### PointNet
```bash
cd baseline
python train_rl.py --C 5 --Q 10 --M 1 
python evaluate_rl.py  --C 5 --Q 10 --M 1
```

