def get_xff_score(priority):
    n = len(weights)
    #priority = np.argsort(-weights)
    used_capacity = []
    used_classes = []
    queue_list = []
    result = 0

    for p in priority:
        flag = False
        for j in range(result):
            if weights[p] + used_capacity[j] <= capacity and len(set([classes[p]] + used_classes[j])) <= params.C:
                used_capacity[j] += weights[p]
                if classes[p] not in used_classes[j]:
                    used_classes[j].append(classes[p] )
                queue_list[j].append(p)
                flag = True
                break
        if not flag:
            used_capacity.append(weights[p])
            used_classes.append([classes[p]])
            queue_list.append([p])
            result += 1
    return result

def get_ff_score(priority):
    n = len(weights)
    #priority = np.argsort(-weights)
    used_capacity = []
    used_classes = []
    queue_list = []
    result = 0
    for p in priority:
        flag = False
        for j in range(result):
            new_class_set = set(used_classes[j])|set(list(classes[p]))
            if weights[p] + used_capacity[j] <= capacity and len(new_class_set) <= params.C:
                used_capacity[j] += weights[p]
                used_classes[j] = list(new_class_set)
                queue_list[j].append(p)
                flag = True
                break
        if not flag:
            used_capacity.append(weights[p])
            used_classes.append(list(classes[p]))
            queue_list.append([p])
            result += 1
    return result

def get_nf_score(priority):
    used_capacity = 0
    used_classes = []
    result = 1

    for p in priority:
        if weights[p] + used_capacity <= capacity and len(set([classes[p]] + used_classes)) <= params.C:
            used_capacity += weights[p]
            if classes[p] not in used_classes:
                used_classes.append(classes[p])
        else:
            used_capacity = weights[p]
            used_classes = [classes[p]]
            result += 1
    return result


from sko.GA import GA_TSP
from sko.ACA import ACA_TSP
from sko.SA import SA_TSP
import time
import argparse
import numpy as np
import os
from sko.tools import set_run_mode
from sklearn.metrics.pairwise import cosine_similarity


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Pytorch implementation of GA and ACO")

    # Data
    parser.add_argument('--N', type=int, default=200, help='Number of items in CCBPP')
    parser.add_argument('--B', type=int, default=100, help='capacity of item in CCBPP')
    parser.add_argument('--C', type=int, default=5, help='compartments limit of item in CCBPP')
    parser.add_argument('--Q', type=int, default=11, help='Number of classes of item in CCBPP')
    parser.add_argument('--M', type=int, default=2, help='Number of classes of item in CCBPP')

    parser.add_argument('--data_dir', type=str, default="../ccbpp_data", help='Number of classes of item in CCBPP')

    params = parser.parse_args()

    ga_time = []
    ga_result = []

    aca_time = []
    aca_result = []

    data_path = os.path.join(params.data_dir,"testB100_C%d_N200_Q%d_M%d"%(params.C, params.Q, params.M))

    weights_list = np.load(os.path.join(data_path, 'weights_0.npy'))[:200].transpose(0,2,1)
    capacity = params.B

    for i in range(len(weights_list)):
        weights = weights_list[i,0]
        classes = weights_list[i,1:].transpose(1,0)
        onehot_classes = []
        for j in range(params.M):
	        onehot_classes.append(np.eye(params.Q)[classes[:,j].astype(int)])

        sim_feats = cosine_similarity(np.array(onehot_classes).sum(axis=0), np.array(onehot_classes).sum(axis=0))
     
        print("%d th test..." %(i))
        t1 = time.time()

        set_run_mode(get_ff_score, 'cached')

        ga_tsp = GA_TSP(func=get_ff_score, n_dim=len(weights), size_pop=50, max_iter=300, prob_mut=1)
        _, best_distance = ga_tsp.run()

        print("%d instance, ga time %d" % (i, time.time() - t1))
        print("%d instance,ga result %d" % (i, best_distance[0]) )
        ga_time.append(time.time() - t1)
        ga_result.append(best_distance[0])


        t2 =  time.time()
        aca_tsp = ACA_TSP(func=get_ff_score, n_dim=len(weights), size_pop=50, max_iter=100, distance_matrix=1.001-sim_feats)
        _, best_distance = aca_tsp.run()

        print("%d instance,aca time %d"% (i, time.time() - t2))
        print("%d instance,aca result %d"% (i, best_distance))
        
        aca_time.append(time.time() - t2)
        aca_result.append(best_distance)
        

    print("Total result:")
    print("GA: average bins %.4f, average time %.4f" %(np.mean(ga_result), np.mean(ga_time)))
    print("ACA: average bins %.4f, average time %.4f" %(np.mean(aca_result), np.mean(aca_time)))
