import matplotlib
matplotlib.use('TkAgg')
import matplotlib.pyplot as plt
import numpy as np
import cv2

# Load the image
image = cv2.imread('E:/Kodak/kodim01.png')
image_rgb = cv2.cvtColor(image, cv2.COLOR_BGR2RGB)

# Set window size
window_size = 32  # 8x8 pixel windows

# Get image dimensions
height, width, _ = image.shape

# Plot image
fig, ax = plt.subplots()
ax.imshow(image_rgb)

# Draw grid lines for window partitioning
for i in range(0, width, window_size):
    ax.axvline(i, color='red', linestyle='--', linewidth=0.6)
for j in range(0, height, window_size):
    ax.axhline(j, color='red', linestyle='--', linewidth=0.6)

# Display the image with grid overlay
ax.axis('off')
#plt.title('Window Partitioning (8x8)')

plt.savefig('D:\ResearchingRoad\ICLR2025\Attention\Figures\partition1.png', bbox_inches='tight', pad_inches=0,dpi=300)

plt.show()