# Time : 2023/11/14 16:23
# Author : 小霸奔
# FileName: plot_.p
import numpy as np

from utils.util import old_task_acc_mf1_plot, old_task_aaa_fr_plot, new_task_plot, old_task_rand_aaa_plot, \
    compare_different_method, old_task_lr_aaa_plot, compute_aaf1
import matplotlib.pyplot as plt
import seaborn as sns
import pandas as pd

def stability_plot():

    isruc_stability = [
                    [ISRUC_Stability_1_AAA, ISRUC_Stability_1_AAF1],
                 [ISRUC_Stability_2_AAA, ISRUC_Stability_2_AAF1],
                 [ISRUC_Stability_3_AAA, ISRUC_Stability_3_AAF1],
                 [ISRUC_Stability_4_AAA, ISRUC_Stability_4_AAF1],
                 [ISRUC_Stability_5_AAA, ISRUC_Stability_5_AAF1],
                 [ISRUC_Stability_6_AAA, ISRUC_Stability_6_AAF1],
                 [ISRUC_Stability_7_AAA, ISRUC_Stability_7_AAF1],
                 [ISRUC_Stability_8_AAA, ISRUC_Stability_8_AAF1],
                 [ISRUC_Stability_9_AAA, ISRUC_Stability_9_AAF1],
                 [ISRUC_Stability_10_AAA, ISRUC_Stability_10_AAF1],
                ]
    isruc_data_list = []
    metric = ["AAA", "AAF1"]
    for stability_idx in isruc_stability:
        for i, seq in enumerate(stability_idx):
            for j in range(len(ISRUC_Stability_1_AAA)):
                isruc_data_list.append({
                                'feature': seq[j],
                                'individual_idx': j,
                                'Metric': metric[i]
                            })
    isruc_df = pd.DataFrame(isruc_data_list)

    face_stability = [[FACE_Stability_1_AAA, FACE_Stability_1_AAF1],
                       [FACE_Stability_2_AAA, FACE_Stability_2_AAF1],
                       [FACE_Stability_3_AAA, FACE_Stability_3_AAF1],
                       [FACE_Stability_4_AAA, FACE_Stability_4_AAF1],
                       [FACE_Stability_5_AAA, FACE_Stability_5_AAF1],
                       [FACE_Stability_6_AAA, FACE_Stability_6_AAF1],
                       [FACE_Stability_7_AAA, FACE_Stability_7_AAF1],
                       [FACE_Stability_8_AAA, FACE_Stability_8_AAF1],
                       [FACE_Stability_9_AAA, FACE_Stability_9_AAF1],
                       [FACE_Stability_10_AAA, FACE_Stability_10_AAF1],
                      ]
    face_data_list = []
    for stability_idx in face_stability:
        for i, seq in enumerate(stability_idx):
            for j in range(len(FACE_Stability_1_AAA)):
                face_data_list.append({
                    'feature': seq[j],
                    'individual_idx': j,
                    'Metric': metric[i]
                })
    face_df = pd.DataFrame(face_data_list)

    physionet_stability = [
                           [BCI2000_Stability_1_AAA, BCI2000_Stability_1_AAF1],
                           [BCI2000_Stability_2_AAA, BCI2000_Stability_2_AAF1],
                           # [BCI2000_Stability_3_AAA, BCI2000_Stability_3_AAF1],
                           [BCI2000_Stability_4_AAA, BCI2000_Stability_4_AAF1],
                           [BCI2000_Stability_5_AAA, BCI2000_Stability_5_AAF1],
                           [BCI2000_Stability_6_AAA, BCI2000_Stability_6_AAF1],
                           # [BCI2000_Stability_7_AAA, BCI2000_Stability_7_AAF1],
                           [BCI2000_Stability_8_AAA, BCI2000_Stability_8_AAF1],
                           # [BCI2000_Stability_9_AAA, BCI2000_Stability_9_AAF1],
                           # [BCI2000_Stability_10_AAA, BCI2000_Stability_10_AAF1],
                           [BCI2000_Stability_11_AAA, BCI2000_Stability_11_AAF1],
                           [BCI2000_Stability_12_AAA, BCI2000_Stability_12_AAF1],
                           # [BCI2000_Stability_13_AAA, BCI2000_Stability_13_AAF1],
                           [BCI2000_Stability_14_AAA, BCI2000_Stability_14_AAF1],
                           # [BCI2000_Stability_15_AAA, BCI2000_Stability_15_AAF1],
                           # [BCI2000_Stability_16_AAA, BCI2000_Stability_16_AAF1],
                           # [BCI2000_Stability_17_AAA, BCI2000_Stability_17_AAF1],
                           [BCI2000_Stability_18_AAA, BCI2000_Stability_18_AAF1],
                           # [BCI2000_Stability_19_AAA, BCI2000_Stability_19_AAF1],
                            ]
    bci2000_data_list = []
    for stability_idx in physionet_stability:
        for i, seq in enumerate(stability_idx):
            for j in range(len(BCI2000_Stability_1_AAA)):
                bci2000_data_list.append({
                    'feature': seq[j],
                    'individual_idx': j,
                    'Metric': metric[i]
                })
    bci2000_df = pd.DataFrame(bci2000_data_list)


    rc = {'font.sans-serif': ['Times New Roman']}
    sns.set(font_scale=2.8, style=None, rc=rc)
    plt.figure(figsize=(40, 7))
    plt.subplot(1, 3, 1)
    sns.lineplot(data=isruc_df, x='individual_idx', y='feature',  style='Metric', hue='Metric', markers=True, markersize=7)
    plt.ylabel("")
    plt.title("ISRUC")
    plt.xlabel("")
    plt.xticks([])
    plt.legend(loc="lower right", prop={"size": 30}, markerscale=2.5)
    plt.grid(alpha=0.4)

    plt.subplot(1, 3, 2)
    sns.lineplot(data=face_df, x='individual_idx', y='feature', style='Metric', hue='Metric', markers=True, markersize=7)
    plt.xlabel("")
    plt.xticks([])
    plt.ylabel("")
    plt.legend(loc="lower right", prop={"size": 30}, markerscale=2.5)
    plt.title("FACED")
    plt.grid(alpha=0.4)

    plt.subplot(1, 3, 3)
    sns.lineplot(data=bci2000_df, x='individual_idx', y='feature', style='Metric', hue='Metric', markers=True, markersize=7)
    plt.xlabel("")
    plt.xticks([])
    plt.ylabel("")
    plt.legend(loc="lower right", prop={"size": 30}, markerscale=2.5)
    plt.title("Physionet")
    plt.grid(alpha=0.4)

    plt.subplots_adjust(wspace=0.13)
    plt.savefig("stability_photo.pdf")
    # plt.show()

def ablation_plot():
    """消融实验数据仓库"""
    #######ISRUC########
    ISRUC_AAA_Curve = [0.7204918032786886, 0.7176814988290399, 0.7225409836065575, 0.7264344262295083, 0.7291334894613584, 0.7294398907103826, 0.7303278688524591, 0.7313744145199064, 0.7311410356492325, 0.7323946135831383, 0.7330689802001278, 0.732294106167057, 0.7299000180147721, 0.7296211107393777, 0.7269164715066355, 0.7274882903981263, 0.7269699683151948, 0.7183938329430132, 0.7176999876741031, 0.7191071428571427, 0.7200512992082078, 0.7209202682563337, 0.7212376540067202, 0.7209040788446526, 0.721519906323185, 0.7218744370383715, 0.7224607511492758, 0.7229382736701239, 0.7236392635064202, 0.7242818110850898, 0.7248035808717989, 0.7242297277517564, 0.7240898445816478, 0.7245849979335997, 0.7247490799598527, 0.723801392141556, 0.7251202607759983, 0.7256933316898803, 0.7260913949438538, 0.7264373536299766, 0.7265608042497287, 0.7277643024422884, 0.7272847339469527, 0.7280032467532466, 0.7283086130627113, 0.7284085123714488, 0.7286436793063928, 0.7285092213114753, 0.7286156382927879, 0.7286065573770492]
    ISRUC_AAF1_Curve = [0.6986579952263389, 0.6960104446743687, 0.7004114701394125, 0.7050024503137776, 0.7088216378573342, 0.709403372959495, 0.7108192694573345, 0.7123756570997637, 0.7120429185921979, 0.7128786560443817, 0.7133688200193681, 0.7126355173139469, 0.7102462139748794, 0.7101483403829556, 0.7080282839349666, 0.708712813033565, 0.7084917552986987, 0.6996278311693371, 0.698487450972864, 0.699916963396508, 0.7010095182319797, 0.7020113654002098, 0.7024048265968913, 0.702137793807235, 0.7027774736795394, 0.7029532721336835, 0.7035246566867029, 0.7040007630499584, 0.7048740293990686, 0.7055413904229133, 0.7061434345394739, 0.7055261769334812, 0.7054025594607235, 0.7058348880243175, 0.7059654222464364, 0.7050124111067072, 0.7063157082309807, 0.7068626457829696, 0.70728915250643, 0.7076573900627812, 0.7075949550178812, 0.7088550776420866, 0.7083109627106822, 0.709127236370446, 0.7093156351077871, 0.7094705347030775, 0.7095624506514671, 0.7093856594561693, 0.7094583609152997, 0.7094628711399191]

    ISRUC_CEA_AAA_Curve = [0.7204918032786886, 0.7291569086651054, 0.7315768930523029, 0.7321282201405153, 0.7329859484777518, 0.7336846213895395, 0.7335898293743728, 0.73254537470726, 0.7330210772833724, 0.734344262295082, 0.7343570364062167, 0.7343481654957066, 0.7352684201044858, 0.7354215456674474, 0.7345160031225606, 0.73501267892421, 0.7358387002341921, 0.7357693897231024, 0.7359744990892533, 0.7369037347467029, 0.7367886416861827, 0.7373313259730122, 0.7365525867575048, 0.7367528764891559, 0.7369145199063233, 0.735440281030445, 0.7365564763105746, 0.7365209471766848, 0.7367012378721981, 0.7368993781797626, 0.7369340359094457, 0.7372894160308227, 0.7373024004683841, 0.7346320346320346, 0.7342919134867062, 0.7349280695884911, 0.7347693858964351, 0.7345765554781949, 0.7347312954517442, 0.7351077883864771, 0.7349795081967213, 0.7356743017078882, 0.7361046057767369, 0.736155438156963, 0.7362598467106664, 0.7343052302888367, 0.7340940331941757, 0.7342418655638048, 0.7342371682279468, 0.7343270563494717]
    ISRUC_CEA_AAF1_Curve = [0.6986579952263389, 0.7076425042382122, 0.7121712707131819, 0.7128706957529585, 0.7134126541797636, 0.7144346602006899, 0.7142622096988689, 0.7129708694735919, 0.7132953213806421, 0.7144849792564377, 0.7139554186633404, 0.714119698906953, 0.7151673470002489, 0.7151918502943525, 0.7141494617677916, 0.71502649752313, 0.7157473162625883, 0.7157354363671216, 0.7159625923794478, 0.7168794094270324, 0.7166401483146314, 0.7169966114633862, 0.7159094795895777, 0.7162722655856761, 0.7164480334368593, 0.7149855656507421, 0.7162378353155197, 0.7162014843282727, 0.7164722136200219, 0.7167015118251175, 0.7166470611779696, 0.7170276244092894, 0.7170172660831801, 0.714214441589305, 0.7138793922897747, 0.7145367201416545, 0.7144758643180346, 0.7142771891336744, 0.7144993079218966, 0.7149908846804605, 0.7149298582121781, 0.7155588191475235, 0.7159274887268803, 0.7159786702748301, 0.7160999206184606, 0.7140377824782588, 0.7138883508649524, 0.7140684151236861, 0.7140641562498908, 0.7141779162427113]

    ISRUC_DCB_AAA_Curve = [0.7204918032786886, 0.7176814988290399, 0.7220921155347385, 0.7246926229508197, 0.7258782201405152, 0.7274004683840749, 0.7295416527266644, 0.7301961358313818, 0.7301912568306012, 0.7314285714285715, 0.7303172237598468, 0.7304352068696333, 0.730769230769231, 0.7312604550016729, 0.7318071818891493, 0.7319672131147541, 0.7333172613307619, 0.7269548529794432, 0.7253173918402565, 0.7260304449648712, 0.7265166722426676, 0.7268921652118374, 0.7270797271153652, 0.7275297619047619, 0.7278126463700234, 0.7284948657899477, 0.7288359788359787, 0.7291945466711275, 0.7297968989744004, 0.7286904761904761, 0.7288188411271436, 0.7291477605386417, 0.7294336810730253, 0.7296700647472103, 0.7305051856808297, 0.7305929612282072, 0.7311538704981327, 0.7313647849131024, 0.7318891491022639, 0.7325263466042153, 0.7328868452618952, 0.7339299654287944, 0.7330047383040139, 0.7336371620183096, 0.7337887067395263, 0.7337338356582832, 0.7338245552842693, 0.7337992779078845, 0.7339184151412321, 0.7338548009367681]
    ISRUC_DCB_AAF1_Curve = [0.6986579952263389, 0.6960104446743687, 0.7005349970906601, 0.7043264863366494, 0.7057866713707497, 0.7074316786771383, 0.7095545631351242, 0.7105851778898324, 0.7104337974758128, 0.7113184976008555, 0.710524664538758, 0.7107666069090345, 0.7112013798908011, 0.7117109264928247, 0.7123118786407442, 0.7124882722266552, 0.7137212578900991, 0.7069056501301383, 0.7047393153439012, 0.7055522957693863, 0.7062534429576405, 0.7067413613975688, 0.7067456999189653, 0.7071738170029129, 0.7072507936512396, 0.7079751483559693, 0.7083290005586916, 0.7087250668469762, 0.70949948479805, 0.7084888945886393, 0.7086836791438677, 0.708937576368464, 0.7092874551859633, 0.7095325123893943, 0.7104629535018466, 0.7106124101751097, 0.7111505357614655, 0.7113211214313443, 0.7118394755398646, 0.7124046904225498, 0.7127638211188658, 0.7138787417765922, 0.7129141718713847, 0.7136271721910742, 0.713729517714564, 0.71373740131384, 0.713599368435412, 0.7135505554778705, 0.7136656977472908, 0.7136473836496093]

    ISRUC_OUR_AAA = [0.7204918032786886, 0.7234192037470726, 0.7269906323185013, 0.7293764637002342, 0.7288173302107729, 0.7286690085870414, 0.7307544329207093, 0.7318793911007027, 0.7318696330991413, 0.7323126463700235, 0.7328826910794124, 0.7336699843871974, 0.7346829400108088, 0.7354884576781532, 0.735854800936768, 0.7359, 0.7360948477751756, 0.7355834136933462, 0.7344294821753838, 0.7348853691606064, 0.7349414519906323, 0.7351065016170402, 0.735307110921865, 0.7354520924549435, 0.7346531030444966, 0.7350983606557377, 0.7355701675373807, 0.7360026888715415, 0.7361638507862163, 0.7363522571267062, 0.7366022638563624, 0.7369740122384228, 0.7369639197892273, 0.7371868568589881, 0.7380286540845846, 0.73796587487454, 0.7388693728857664, 0.738860054433825, 0.7390391963515345, 0.7397841229808443, 0.7398814402810304, 0.7402981664477066, 0.7403632764581242, 0.7407221828876422, 0.7407068341494571, 0.740736403851158, 0.7409454230730069, 0.7408577906223529, 0.7408665105386416, 0.740845003106629]
    ISRUC_OUR_AAF1 = [0.6986579952263389, 0.7027865691185531, 0.7063565800852505, 0.7096234788834697, 0.7092269771857842, 0.7091250262100938, 0.7112474464643608, 0.7124957077942677, 0.7121762611900138, 0.7124070812264967, 0.7132436515863995, 0.7138817855422888, 0.7152918152451732, 0.7160522839218013, 0.7164666960100128, 0.7165, 0.7166351534922907, 0.7158665288975652, 0.7144079414072273, 0.7149188625547215, 0.715031297165804, 0.7152071646075564, 0.7154627567981859, 0.7156496686751039, 0.7148556253318002, 0.715335692937582, 0.715890355147583, 0.7163428691629771, 0.7164404909853889, 0.7165472615534314, 0.7168515873245521, 0.7171871193984783, 0.7172242322523714, 0.7173835511186332, 0.7182311820130084, 0.7182384597208549, 0.7190140823584787, 0.7190081449650397, 0.7191761360414657, 0.7199225040002115, 0.7200213289383959, 0.7205428627528858, 0.720673736440565, 0.7209978398745073, 0.720918627612564, 0.7210090510277196, 0.7211672052406644, 0.7210436010200755, 0.7210209328857685, 0.7209871453260605]

    ######FACED#########
    FACED_AAA_Curve = [0.23958333333333334, 0.24627976190476192, 0.2584325396825397, 0.2723214285714286, 0.28065476190476196, 0.2899305555555556, 0.2835884353741497, 0.2877604166666667, 0.28058862433862436, 0.28645833333333337, 0.29856601731601734, 0.29377480158730157, 0.2899496336996337, 0.2929421768707483, 0.2908730158730159, 0.29389880952380953, 0.2925420168067227, 0.2931547619047619, 0.29581766917293234, 0.2944196428571429, 0.29365079365079366, 0.2930871212121212, 0.2935429606625259, 0.29693700396825395, 0.29720238095238094, 0.29658882783882784, 0.296902557319224, 0.29862882653061223, 0.3023399014778325, 0.30610119047619044, 0.30217933947772657, 0.3001302083333333, 0.301046176046176, 0.30348389355742295, 0.30161564625850334, 0.30121527777777773, 0.3029279279279279, 0.30321898496240596, 0.30227411477411475, 0.3023065476190476, 0.3012122531939605, 0.3009495464852608, 0.3027754706533777, 0.305566829004329, 0.303505291005291, 0.3025685817805383, 0.3007535460992908, 0.2999131944444445, 0.3007774538386783, 0.30270833333333336, 0.30266690009337066, 0.3033997252747253, 0.304526055705301, 0.30712632275132273, 0.30933441558441555, 0.3116762329931972, 0.3138053467000835, 0.3154505336617405, 0.3174435028248587, 0.31917162698412693, 0.3198916861826697, 0.32111655145929335]
    FACED_AAF1_Curve = [0.1874819175619343, 0.1931073649605185, 0.20512246531734854, 0.22362476955917776, 0.23609496172554398, 0.24666168511003006, 0.23759721502199385, 0.24301501416987586, 0.23464799559635383, 0.24297843032275682, 0.2584682594472838, 0.2516676202090637, 0.246892259642538, 0.25087326853884323, 0.2480938886127386, 0.2523770713405563, 0.2511921868505855, 0.2521510940495619, 0.255405146020286, 0.2535083963341611, 0.2524357707891137, 0.2511981959849956, 0.2518866868906535, 0.2565397220678116, 0.25646872418201594, 0.25556746075978215, 0.2560816544865356, 0.2584907775647607, 0.26333290769493295, 0.26812708179037076, 0.26341176989740606, 0.2607598490510117, 0.2620623744388535, 0.26522522088015626, 0.2626140599667453, 0.2621254405560867, 0.26419034032503874, 0.2647664284311551, 0.263498876281782, 0.26357687792317036, 0.26207694497918543, 0.261868443814831, 0.26433445669545513, 0.26781747478953544, 0.2651635082622005, 0.2641305540620157, 0.26169159335636366, 0.2605497483276957, 0.2618210681470028, 0.2643714104912855, 0.2644295364677786, 0.2654895320599272, 0.2670176633122632, 0.27030110483097514, 0.2732165485188535, 0.2761136142366933, 0.27875724045763045, 0.28084758597348436, 0.28333564220861573, 0.28555850742221467, 0.2865491430518792, 0.2882080444353729]

    FACED_CEA_AAA_Curve = [0.23958333333333334, 0.2760416666666667, 0.2698412698412698, 0.2779017857142857, 0.29107142857142854, 0.2951388888888889, 0.2848639455782313, 0.28943452380952384, 0.28654100529100535, 0.29836309523809523, 0.31087662337662336, 0.30419146825396826, 0.30196886446886445, 0.29878826530612246, 0.298015873015873, 0.3041294642857143, 0.30182072829131656, 0.2995205026455027, 0.3017700501253133, 0.2991815476190477, 0.2988236961451248, 0.29707792207792216, 0.297942546583851, 0.3023313492063492, 0.30160714285714285, 0.29979395604395603, 0.3004298941798942, 0.3044749149659864, 0.30834359605911327, 0.3114583333333333, 0.3073156682027649, 0.30594308035714285, 0.30884740259740256, 0.31219362745098034, 0.30943877551020404, 0.30952380952380953, 0.3108912483912484, 0.3114426691729323, 0.31021062271062266, 0.31060267857142854, 0.3087616144018583, 0.3087797619047619, 0.31097729789590256, 0.3138528138528139, 0.3115740740740741, 0.31162655279503104, 0.3097771023302938, 0.30952380952380953, 0.31116375121477163, 0.3130952380952381, 0.3131127450980392, 0.3142456501831502, 0.3159535040431267, 0.318479938271605, 0.3203733766233766, 0.32257121598639454, 0.3244569757727653, 0.32589285714285715, 0.32778450363196127, 0.329389880952381, 0.32984484777517564, 0.33098118279569894]
    FACED_CEA_AAF1_Curve = [0.1874819175619343, 0.23403964879419675, 0.2214120505552587, 0.23046650784496664, 0.24970646027554305, 0.2531045047157032, 0.23866255544778867, 0.24481197267615262, 0.2425816977678459, 0.258064244223634, 0.273884099051158, 0.2646016693581626, 0.26218644314988093, 0.257968106477875, 0.2569239733607563, 0.2650490859388397, 0.2629289791240929, 0.26048385373413013, 0.26277921584757297, 0.2594646751004831, 0.2584358643157366, 0.2555988590607851, 0.2569947462963035, 0.2629056579220021, 0.26153475418167693, 0.2588726799426147, 0.25985495842451106, 0.26502845307356654, 0.27004711123008607, 0.2741574467281822, 0.26911436580360076, 0.26726005158937816, 0.27120395549136855, 0.27548702224930965, 0.2718346529896243, 0.27210262175113925, 0.27368683688648654, 0.2745571353596569, 0.2726668052648414, 0.27334816237768644, 0.2709138040781276, 0.2711398569607879, 0.274062471139502, 0.27764303890543496, 0.2746554976162208, 0.2748102492905134, 0.2722634024737382, 0.2719800067847858, 0.27424047704789645, 0.27675478310168317, 0.27682408527763275, 0.27841377283342245, 0.2806178114184204, 0.2837831058727745, 0.28633531198955703, 0.2890303727098738, 0.2913839531267229, 0.29320600645861367, 0.29556422397738014, 0.2976079640412242, 0.2982735802477515, 0.2998248051603214]

    FACED_DCB_AAA_Curve = [0.23958333333333334, 0.24627976190476192, 0.2410714285714286, 0.2566964285714286, 0.2550595238095238, 0.26785714285714285, 0.27232142857142855, 0.2684151785714286, 0.2733134920634921, 0.2703869047619048, 0.2704274891774892, 0.27529761904761907, 0.27850274725274726, 0.28773384353741494, 0.29057539682539685, 0.2902715773809524, 0.2929796918767507, 0.2953042328042328, 0.30270989974937346, 0.30558035714285714, 0.31030328798185947, 0.3159496753246753, 0.3196816770186336, 0.3240327380952381, 0.3282142857142857, 0.3307005494505494, 0.3330577601410934, 0.32993197278911557, 0.3299466338259441, 0.32971230158730147, 0.3307411674347157, 0.32863653273809523, 0.3272005772005772, 0.32755602240896353, 0.3249149659863945, 0.32407407407407407, 0.32456563706563707, 0.3226033834586466, 0.32047466422466425, 0.3209821428571429, 0.3229529616724739, 0.3253259637188209, 0.3275539867109635, 0.3295116341991342, 0.3314484126984127, 0.3330745341614907, 0.3327001013171226, 0.33271329365079366, 0.33224003887269193, 0.3316964285714286, 0.3325163398692811, 0.3339629120879121, 0.33588836477987427, 0.33735670194003536, 0.33560606060606063, 0.33317389455782315, 0.331296992481203, 0.33189655172413784, 0.33310633575464077, 0.3344246031746031, 0.33594359875097574, 0.3373655913978494]
    FACED_DCB_AAF1_Curve = [0.1874819175619343, 0.1931073649605185, 0.18588816145786882, 0.2024757237900759, 0.1999122719028602, 0.21632547139220426, 0.22290221327584142, 0.2180181173833019, 0.22496986741154462, 0.2209461152107573, 0.22055492017027153, 0.22717954256685455, 0.23116940303139025, 0.2428292421022471, 0.24685113565546618, 0.24607938594904355, 0.24936587681006206, 0.25276941218899845, 0.26193301147773973, 0.26605321710017193, 0.2722401342004309, 0.2794498621403525, 0.28440419156638125, 0.2899670582928195, 0.2953298633836313, 0.29875066581863063, 0.302206111819234, 0.2979074758546326, 0.297804995951895, 0.2976535908316078, 0.29908408401912484, 0.29609729190674583, 0.29428508196340697, 0.2948746210860994, 0.2911444101439081, 0.2900611057451059, 0.290953118378669, 0.2882968293525846, 0.28572245881544367, 0.28659639271473825, 0.28927148077140613, 0.2922976576902185, 0.2951406918623381, 0.2976463839595466, 0.30019854071430646, 0.3022357411719675, 0.30150619399188355, 0.30149549336507125, 0.3009376594402129, 0.3001926296520463, 0.3013590021440678, 0.30336004105551956, 0.30573109006570953, 0.3076568846609111, 0.30525415615278223, 0.30216608687857516, 0.29987477237688215, 0.30073163415567644, 0.3023429501217687, 0.30406508248372993, 0.30593443342920573, 0.3077619305448721]

    FACED_OUR_AAA = [0.23958333333333334, 0.3191964285714286, 0.31597222222222227, 0.31808035714285715, 0.33571428571428574, 0.3384384920634921, 0.3373316326530613, 0.34128273809523814, 0.34292328042328046, 0.3438988095238096, 0.3434794372294373, 0.3495783730158731, 0.3408882783882785, 0.33258928571428586, 0.33452380952380967, 0.3390066964285714, 0.3447128851540616, 0.3482969576719577, 0.3514254385964912, 0.34672619047619047, 0.34552154195011336, 0.3482819264069264, 0.3490553830227743, 0.3505084325396825, 0.35238095238095235, 0.35113324175824173, 0.3517416225749559, 0.35390093537414963, 0.35570607553366174, 0.35362103174603177, 0.35450268817204306, 0.3562593005952381, 0.358270202020202, 0.3600752801120448, 0.36007653061224487, 0.3594576719576719, 0.3616473616473616, 0.36207706766917286, 0.36141636141636135, 0.3625372023809524, 0.36160714285714285, 0.3617842970521542, 0.3627145625692137, 0.363873106060606, 0.3653769841269841, 0.36675077639751547, 0.3682560790273556, 0.36941964285714285, 0.36850097181729835, 0.36636904761904765, 0.36683006535947715, 0.36541323260073266, 0.36506064690026957, 0.3657407407407408, 0.3663419913419914, 0.3658854166666667, 0.3653926482873852, 0.366276683087028, 0.3658192090395481, 0.3666418650793652, 0.36411982825917266, 0.3645833333333335]
    FACED_OUR_AAF1 = [0.1874819175619343, 0.28531108232926056, 0.2828955992361311, 0.28769918716076626, 0.3106068617935397, 0.3147308256587364, 0.3139739358106908, 0.3167100929808845, 0.3173909905453524, 0.31788810266316625, 0.3170402722859291, 0.32466830846072164, 0.31358109939880924, 0.303431677828971, 0.3056774274959849, 0.311487515547386, 0.3184033943776558, 0.3229476445026288, 0.3269418558619077, 0.32123040314518614, 0.3197918049340479, 0.3234131674566716, 0.32455969840060184, 0.32630895689242273, 0.3285843638798256, 0.3271345556401375, 0.32803335942684675, 0.3308210350094654, 0.33301850912402214, 0.33041677342965226, 0.3316116191118639, 0.333889242091256, 0.33631398272080526, 0.33834576477575795, 0.3384291789149139, 0.3376681826597131, 0.3402075993731552, 0.3408669075020277, 0.33991262880276507, 0.3412909712398332, 0.3402095321633512, 0.3405695829580337, 0.34186423708025376, 0.3433773734329679, 0.34531763701226614, 0.3471542019852102, 0.3490191045163817, 0.35051306761294104, 0.349341209369595, 0.34687606622786105, 0.34742009234708776, 0.34572542251545124, 0.34541192565327566, 0.34634600722912395, 0.347021356476045, 0.34639618054465604, 0.34581340277250366, 0.34694417919017956, 0.3462908958564574, 0.3472586066127812, 0.34441644771150076, 0.34499441655679647]

    ########BCI2000#####
    Physionet_AAA_Curve = [0.4696969696969697, 0.4716610549943884, 0.4745604190048635, 0.4751683501683502, 0.4765432098765432, 0.4767115600448934, 0.4764309764309765, 0.4775533108866442, 0.4779897742860706, 0.4780583613916948, 0.47796143250688705, 0.4765245043022821, 0.4756108089441423, 0.47514830848164186, 0.4753834642723532, 0.4752034231200898, 0.4755397108338285, 0.47552687367502183, 0.4756925984996161, 0.47603815937149274, 0.4757629202073647, 0.47474747474747475, 0.47469867759722834, 0.4742564534231201, 0.47427609427609424, 0.47472589139255805, 0.47468512283327097, 0.47474747474747475, 0.4744765664305894, 0.4736812570145903, 0.4736251402918069, 0.4724501964085297, 0.4720946842158963, 0.47205717303756517, 0.47198973865640526, 0.4718013468013468, 0.4718203051536385, 0.47188256837379644, 0.47156752712308264, 0.47129629629629627, 0.47136678437491447, 0.47107316551760997, 0.4704016913319239, 0.47029639832670134, 0.46992143658810326, 0.4697335675596545, 0.46955369295794824, 0.46963851477740365, 0.46943356467165986, 0.4694388327721661, 0.4694108844435641, 0.469362427695761]
    Physionet_AAF1_Curve = [0.46335815763159616, 0.4676734179861308, 0.4708717071381965, 0.4711643723876623, 0.4731469919379857, 0.47333239435609836, 0.47269408988707606, 0.4741577834416408, 0.4745908495779787, 0.47452509304092116, 0.4743971691329355, 0.4725726508073777, 0.4713457437780073, 0.4709724875805631, 0.47108850308398603, 0.4709636126270187, 0.471455682559294, 0.47149949681398684, 0.47168047100403937, 0.4721445035765706, 0.4719464423927446, 0.4707134451047638, 0.4706250204112567, 0.47014058205148973, 0.4701090318755914, 0.4706666854165374, 0.4706713148076303, 0.4708734383508676, 0.47059486251489846, 0.4697543364479494, 0.46971244249697025, 0.468413121973313, 0.4679399250441636, 0.4679398512653834, 0.46793982803354217, 0.46775913453688694, 0.46779941005222847, 0.4678622179916103, 0.46749109603981115, 0.46722007687052686, 0.467356330594735, 0.4670399542686048, 0.4662415503957734, 0.46618390806505317, 0.4657923215741546, 0.46566844740904556, 0.4654958953327401, 0.46564680093154404, 0.46543948763262155, 0.4655132073087114, 0.46550059892615314, 0.4655069303572355]

    Physionet_CEA_AAA_Curve = [0.4696969696969697, 0.4725028058361392, 0.47156752712308264, 0.4722222222222222, 0.4732884399551066, 0.4738121960344183, 0.47450697450697454, 0.4752384960718294, 0.47387454794862205, 0.47356902356902364, 0.47388021630445876, 0.47409277964833524, 0.475006475006475, 0.4749478916145583, 0.4747100635989525, 0.47502805836139167, 0.47474747474747475, 0.4748410026187804, 0.47459979916120265, 0.4748316498316498, 0.475041419485864, 0.47497704315886136, 0.4755282291514176, 0.476010101010101, 0.47604938271604935, 0.47563239229905896, 0.4756619694891299, 0.4756293089626422, 0.4757924068268895, 0.4756827534605312, 0.47576119619130364, 0.4758171997755331, 0.4762949358908955, 0.47639796659404504, 0.47665544332210996, 0.4769609677017084, 0.4770679770679771, 0.4771398192450824, 0.4772079772079772, 0.4773428731762065, 0.477594371903315, 0.4775800331355888, 0.47716179886722526, 0.4772217120701969, 0.47726649208130695, 0.47722393012248093, 0.47745779306063, 0.4776117658062103, 0.4777021919879063, 0.4774747474747475, 0.4776303338394841, 0.4776828110161443]
    Physionet_CEA_AAF1_Curve = [0.46335815763159616, 0.4678356267696542, 0.4658988312794954, 0.4668445688628195, 0.4687759977853583, 0.46914789396599504, 0.4701770923377211, 0.47095464662094333, 0.46920774925736314, 0.4689584216598056, 0.4694669646977781, 0.469544853390981, 0.47060173552526674, 0.4704651452428631, 0.470155248739074, 0.4704851064886718, 0.47010455342815666, 0.470210588461627, 0.4699826038325527, 0.4702787357146064, 0.47042447047779296, 0.470379587165886, 0.47101236933925805, 0.4715411011689478, 0.47155531362555214, 0.4710777393718484, 0.4710878074788338, 0.4710366408035225, 0.47126058843145746, 0.4711169063827248, 0.4712111611105409, 0.4712439674369505, 0.47180925380495914, 0.4719921506790784, 0.47231373837149654, 0.47268415626741184, 0.4727426666467513, 0.47277288958049535, 0.4728015473083688, 0.47292068051284525, 0.47320651119714485, 0.47319172700929035, 0.47276362314101666, 0.4728495632469315, 0.4729224709854728, 0.47288002342026325, 0.4730926665410535, 0.47326660654510705, 0.473333995599316, 0.4730215949344063, 0.4731896468512883, 0.47320016081686134]

    Physionet_DCB_AAA_Curve = [0.4696969696969697, 0.4744668911335578, 0.4713804713804714, 0.4739057239057239, 0.4745230078563412, 0.47418630751964086, 0.4738656405323072, 0.4743265993265993, 0.472003990522509, 0.47210998877665544, 0.4721456994184267, 0.47226898615787505, 0.4726323059656393, 0.47258297258297255, 0.4725402169846614, 0.4727132435465769, 0.4723047468145507, 0.47262750966454664, 0.4722665248981038, 0.47250280583613913, 0.47244936133825016, 0.47268135904499536, 0.4727955887376177, 0.47341470258136925, 0.47384960718294056, 0.4730208063541397, 0.47352122043480066, 0.4736251402918069, 0.4738960486086922, 0.4739057239057239, 0.47396908149596323, 0.4740635521885522, 0.47449239873482296, 0.47464844523668054, 0.47487574154240825, 0.4751839381469012, 0.47546030879364215, 0.475544922913344, 0.4754669199113644, 0.4755892255892256, 0.47560975609756095, 0.47557586446475336, 0.4747996763500639, 0.4748622589531681, 0.47488464895872307, 0.47451568828380425, 0.4744251020846766, 0.47470071081182197, 0.47475892713987955, 0.47451178451178455, 0.4743623599832751, 0.4744884744884746]
    Physionet_DCB_AAF1_Curve = [0.46335815763159616, 0.4698061602292432, 0.4648848436403939, 0.4680212415882292, 0.4696049927061921, 0.4693652071273475, 0.4692416724221283, 0.4695657914742499, 0.46656965126728456, 0.46671254966068565, 0.4668668745725153, 0.46708287483581046, 0.46753659338727854, 0.4673638780871649, 0.46746244632157924, 0.46764724682520364, 0.4670813809332569, 0.46753721394209763, 0.467278365156822, 0.46764705585586075, 0.46741760778837244, 0.46773985940915214, 0.46779980235200663, 0.4686185309049038, 0.46912703028801045, 0.46803316504793124, 0.4686353109031676, 0.4686572758244713, 0.46900333849343917, 0.46895203616618325, 0.46899410907931083, 0.469075010015639, 0.46961365908730607, 0.46989651396432663, 0.47020543233091505, 0.4706011778775103, 0.470837568684199, 0.47086260924099116, 0.47067216126981476, 0.4707639246369849, 0.4707561888309517, 0.47069187855416045, 0.46986122441966677, 0.46995423747962606, 0.4699660191640349, 0.4695491795342198, 0.46938743721738846, 0.4697440447658665, 0.4697572531741369, 0.4694350371492486, 0.4691869299805144, 0.4692890220085417]

    Physionet_CEA_DCB_AAA_Curve = [0.4696969696969697, 0.4761503928170595, 0.4818555929667041, 0.4782547699214366, 0.4801346801346802, 0.4804526748971194, 0.481561648228315, 0.4812710437710438, 0.48166853722409286, 0.481986531986532, 0.4823997551270278, 0.4819491208380097, 0.4822153155486489, 0.48216289882956553, 0.4823419378974935, 0.4828843995510662, 0.482504786426355, 0.4826038159371493, 0.4830173075787111, 0.4828563411896745, 0.48236331569664903, 0.48278236914600553, 0.4831893817401064, 0.4833520389075945, 0.48350168350168354, 0.4838772338772339, 0.4842665336492497, 0.48454785954785956, 0.48510004257130696, 0.4855218855218855, 0.4858260019550342, 0.48593574635241304, 0.48610685984423363, 0.48621839308113823, 0.48624338624338626, 0.48654757451053743, 0.4867746534413201, 0.4866648945596314, 0.4869924314368759, 0.4870510662177329, 0.48705209274314964, 0.4871198760087649, 0.48744551457729757, 0.4874119987756352, 0.4874298540965208, 0.48759332454984633, 0.48779759772667575, 0.4878881406659185, 0.48787191644334504, 0.488013468013468, 0.4880394357518541, 0.4881507381507382]
    Physionet_CEA_DCB_AAF1_Curve = [0.46335815763159616, 0.47169634081442846, 0.4781164154886219, 0.4739871924085747, 0.47610954526258265, 0.4761664236031913, 0.4775141583056465, 0.47714671675553877, 0.4776026208811967, 0.4782042117742978, 0.47865040700370404, 0.47839919997162217, 0.47867869511101013, 0.47853192987515875, 0.47866437949299523, 0.47913468118373004, 0.4788521620482854, 0.4790276489368478, 0.47956763299595834, 0.47926847323014493, 0.4786019446520741, 0.479117709414319, 0.47961300888623265, 0.4796996174937345, 0.47969799730572577, 0.48012625768859635, 0.48051695724336213, 0.480911166998691, 0.48147328024752584, 0.4818877517949476, 0.482197338198368, 0.48242812147515063, 0.48255489400896173, 0.4826655358321447, 0.4827121270090902, 0.48305010562340833, 0.48333735288674906, 0.48332717955824583, 0.48361921124216967, 0.48368871895144805, 0.48359321314069315, 0.48358011687773034, 0.483952272013067, 0.4838704555127189, 0.4838890617560506, 0.4840807723248819, 0.48429452690253827, 0.484306049475653, 0.484340394856216, 0.4844684945075952, 0.4845422170761814, 0.4846757124231196]

    ISRUC_AAA = [ISRUC_AAA_Curve, ISRUC_CEA_AAA_Curve, ISRUC_DCB_AAA_Curve, ISRUC_OUR_AAA][::-1]
    Methods = ['Base', 'Base+CEA', 'Base+DCB', 'BrainUICL'][::-1]
    ISRUC_LIST = []
    for i, data in enumerate(ISRUC_AAA):
        for j in range(len(data)):
            ISRUC_LIST.append({
                'y': data[j],
                'x': j,
                'method': Methods[i]
            })
    ISRUC_DF = pd.DataFrame(ISRUC_LIST)

    ISRUC_AAF1 = [ISRUC_AAF1_Curve, ISRUC_CEA_AAF1_Curve, ISRUC_DCB_AAF1_Curve, ISRUC_OUR_AAF1][::-1]
    ISRUC_LIST_F1 = []
    for i, data in enumerate(ISRUC_AAF1):
        for j in range(len(data)):
            ISRUC_LIST_F1.append({
                'y': data[j],
                'x': j,
                'method': Methods[i]
            })
    ISRUC_DF_F1 = pd.DataFrame(ISRUC_LIST_F1)

    FACED_AAA = [FACED_AAA_Curve, FACED_CEA_AAA_Curve, FACED_DCB_AAA_Curve, FACED_OUR_AAA][::-1]
    FACED_LIST = []
    for i, data in enumerate(FACED_AAA):
        for j in range(len(data)):
            FACED_LIST.append({
                'y': data[j],
                'x': j,
                'method': Methods[i]
            })
    FACED_DF = pd.DataFrame(FACED_LIST)

    FACED_AAF1 = [FACED_AAF1_Curve, FACED_CEA_AAF1_Curve, FACED_DCB_AAF1_Curve, FACED_OUR_AAF1][::-1]
    FACED_LIST_F1 = []
    for i, data in enumerate(FACED_AAF1):
        for j in range(len(data)):
            FACED_LIST_F1.append({
                'y': data[j],
                'x': j,
                'method': Methods[i]
            })
    FACED_DF_F1 = pd.DataFrame(FACED_LIST_F1)

    BCI_AAA = [Physionet_AAA_Curve, Physionet_CEA_AAA_Curve, Physionet_DCB_AAA_Curve, Physionet_CEA_DCB_AAA_Curve][::-1]
    BCI_LIST = []
    for i, data in enumerate(BCI_AAA):
        for j in range(len(data)):
            BCI_LIST.append({
                'y': data[j],
                'x': j,
                'method': Methods[i]
            })
    BCI_DF = pd.DataFrame(BCI_LIST)

    BCI_AAF1 = [Physionet_AAF1_Curve, Physionet_CEA_AAF1_Curve, Physionet_DCB_AAF1_Curve, Physionet_CEA_DCB_AAF1_Curve][::-1]
    BCI_LIST_F1 = []
    for i, data in enumerate(BCI_AAF1):
        for j in range(len(data)):
            BCI_LIST_F1.append({
                'y': data[j],
                'x': j,
                'method': Methods[i]
            })
    BCI_DF_F1 = pd.DataFrame(BCI_LIST_F1)

    rc = {'font.sans-serif': ['Times New Roman']}
    sns.set(font_scale=2.8, style=None, rc=rc)
    plt.figure(figsize=(40, 12))
    ax1 = plt.subplot(2, 3, 1)
    sns.lineplot(data=ISRUC_DF, x='x', y='y', style='method', hue='method', markers=True, legend=False, linewidth=5,
                 markersize=8)
    ax1.set_ylabel("AAA")
    ax1.set_xlabel("")
    ax1.set_title("ISRUC", fontsize=30)
    # ax1.set_yticks([0.715, 0.72, 0.73, 0.74, 0.745])
    # ax1.set_ylim(0.717, 0.743)
    ax1.set_xticks([], [])
    ax1.legend(loc='center', prop={"size": 14})
    ax1.grid(alpha=0.4)

    ax2 = plt.subplot(2, 3, 4)
    sns.lineplot(data=ISRUC_DF_F1, x='x', y='y', style='method', hue='method', markers=True, legend=False,
                 linewidth=5, markersize=8)
    ax2.set_xlabel("")
    ax2.set_ylabel("AAF1")
    # ax2.set_yticks([0.694, 0.70, 0.71, 0.72, 0.725])
    # ax2.set_ylim(0.696, 0.724)
    ax2.legend(loc="lower right", prop={"size": 14})
    ax2.set_xticks([], [])
    ax2.grid(alpha=0.4)
    #
    ax3 = plt.subplot(2, 3, 2)
    sns.lineplot(data=FACED_DF, x='x', y='y', style='method', hue='method', markers=True, legend=False, linewidth=5,
                 markersize=8)
    ax3.set_title("FACED", fontsize=30)
    ax3.set_xlabel("")
    ax3.set_ylabel("")
    # ax3.set_yticks([0.20, 0.25, 0.30, 0.35, 0.39])
    # ax3.set_ylim(0.21, 0.38)
    ax3.grid(alpha=0.4)
    ax3.set_xticks([], [])

    ax4 = plt.subplot(2, 3, 5)
    sns.lineplot(data=FACED_DF_F1, x='x', y='y', style='method', hue='method', markers=True, legend=False,
                 linewidth=5, markersize=8)
    ax4.set_xlabel("")
    ax4.set_xticks([], [])
    ax4.legend(loc="lower right", prop={"size": 14})
    ax4.set_ylabel("")
    # ax4.set_yticks([0.14, 0.20, 0.25, 0.30, 0.35, 0.37])
    # ax4.set_ylim(0.15, 0.36)
    ax4.grid(alpha=0.4)
    #
    ax5 = plt.subplot(2, 3, 3)
    sns.lineplot(data=BCI_DF, x='x', y='y', style='method', hue='method', markers=True, legend=False, linewidth=5,
                 markersize=8)
    ax5.set_title("Physionet", fontsize=30)
    ax5.grid(alpha=0.4)
    ax5.set_ylabel("")
    # ax5.set_yticks([0.46, 0.47, 0.48, 0.49])
    # ax5.set_ylim(0.468, 0.49)
    ax5.set_xlabel("")
    ax5.set_xticks([], [])

    ax6 = plt.subplot(2, 3, 6)
    sns.lineplot(data=BCI_DF_F1, x='x', y='y', style='method', hue='method', markers=True, legend=True, linewidth=5,
                 markersize=8)

    ax6.set_xlabel("")
    ax6.set_ylabel("")
    # ax6.set_yticks([0.46, 0.47, 0.48, 0.49])
    # ax6.set_ylim(0.46, 0.487)
    ax6.legend(loc="lower right", prop={"size": 30}, bbox_to_anchor=(0.1, -0.25), ncol=4, frameon=False,
               markerscale=2.8)
    ax6.grid(alpha=0.4)
    ax6.set_xticks([], [])

    plt.subplots_adjust(wspace=0.12, hspace=0.1)
    plt.savefig("ablation_photo.pdf")
    # plt.show()


def plot_alpha1():
    x = np.arange(1, 10, 0.01)
    x1 = np.arange(0, 1, 0.01)
    y1 = np.repeat(0.01, 100)
    y = np.power(0.1, np.log10(x)+2)
    x_point1 = np.repeat(1, 200)
    y_point1 = np.arange(-0.01, 0.01, 0.0001)

    x_point2 = np.repeat(10, 200)
    y_point2 = np.arange(-0.001, 0.001, 0.00001)

    y_point3 = np.repeat(0.001, 1000)
    x_point3 = np.arange(0, 10, 0.01)

    rc = {'font.sans-serif': ['Times New Roman']}
    plt.figure(figsize=(16, 8))
    sns.set(font_scale=3, style=None, rc=rc)
    plt.plot(x, y, c='m', linewidth=2)
    plt.plot(x1, y1, c='m', linewidth=2, label='α')
    plt.plot(x_point1, y_point1, c='black', linestyle='--')
    plt.plot(x_point2, y_point2, c='black', linestyle='--')
    plt.plot(x_point3, y_point3, c='black', linestyle='--')
    plt.yticks([0.001, 0.01])
    plt.xticks([1, 10])
    plt.xlim(0, 10.5)
    plt.ylim(0, 0.011)
    plt.legend()
    plt.savefig("alpha_photo.pdf")
    # plt.show()


def plot_alpha2():
    x = np.arange(1, 10, 0.01)
    x1 = np.arange(0, 1, 0.01)
    y1 = 0.1*np.power(0.1, x1)
    y = np.power(0.1, np.log10(x)+2)
    x_point1 = np.repeat(1, 200)
    y_point1 = np.arange(-0.01, 0.01, 0.0001)

    x_point2 = np.repeat(10, 200)
    y_point2 = np.arange(-0.001, 0.001, 0.00001)

    y_point3 = np.repeat(0.01, 1000)
    x_point3 = np.arange(0, 1, 0.001)

    rc = {'font.sans-serif': ['Times New Roman']}
    sns.set(font_scale=1, style=None, rc=rc)
    plt.plot(x, y, c='m')
    plt.plot(x1, y1, c='m')
    plt.plot(x_point1, y_point1, c='black', linestyle='--')
    # plt.plot(x_point2, y_point2, c='black', linestyle='--')
    plt.plot(x_point3, y_point3, c='black', linestyle='--')
    plt.yticks([0.01, 0.1])
    plt.xticks([0, 1, 10])
    plt.xlim(0, 10.5)
    plt.ylim(0, 0.11)
    plt.show()

def plot_alpha3():
    x = np.arange(1, 10, 0.01)
    y = np.power(0.1, np.log2(x)+2)
    x1 = np.arange(0, 1, 0.01)
    y1 = 0.1*np.power(0.1, x1)

    x_point1 = np.repeat(1, 200)
    y_point1 = np.arange(-0.01, 0.01, 0.0001)

    x_point2 = np.repeat(10, 200)
    y_point2 = np.arange(-0.001, 0.001, 0.00001)

    y_point3 = np.repeat(0.01, 1000)
    x_point3 = np.arange(0, 1, 0.001)

    rc = {'font.sans-serif': ['Times New Roman']}
    sns.set(font_scale=1, style=None, rc=rc)

    plt.plot(x, y, c='m', linewidth=3)
    plt.plot(x1, y1, c='m')
    plt.plot(x_point1, y_point1, c='black', linestyle='--')
    plt.plot(x_point2, y_point2, c='black', linestyle='--')
    plt.plot(x_point3, y_point3, c='black', linestyle='--')
    plt.yticks([0.01, 0.1])
    plt.xticks([0, 1, 10])
    plt.xlim(0, 10.5)
    plt.ylim(0, 0.11)
    plt.show()


def compared_plot():
    ISRUC_MMD_AAA = [0.7204918032786886, 0.7197306791569087, 0.7153590944574552, 0.7130122950819673, 0.716768149882904, 0.7111729117876658, 0.7070257611241217, 0.7078966627634661, 0.7073900598490763, 0.7078337236533958, 0.705849478390462, 0.7052644418423107, 0.7061610520626915, 0.6984233857477419, 0.6994886807181889, 0.7003988583138174, 0.701195068191211, 0.6951600312256051, 0.6873258967089856, 0.6863290398126465, 0.6874121779859486, 0.6882132212050246, 0.6892398941044702, 0.6902322404371585, 0.6898594847775175, 0.6852999459556836, 0.6779772746985862, 0.673502843760455, 0.6695449406444318, 0.6695081967213115, 0.670956410062703, 0.6723195989461359, 0.6736338797814209, 0.6747055379528861, 0.6763215122114421, 0.678218514181629, 0.6784780682321667, 0.6793649081720696, 0.6805215276526754, 0.6806498829039812, 0.681467413034786, 0.6801996208319393, 0.6797260497794237, 0.6804223440493932, 0.6813505074160812, 0.6820244883413094, 0.6825240420549105, 0.6828710480093676, 0.6825538880657648, 0.6825117096018734]
    ISRUC_MMD_AAF1 = [0.6986579952263389, 0.6967680779956782, 0.6921093847429219, 0.6913780210687474, 0.696299488949234, 0.6899628477791401, 0.6856315243699351, 0.6867441406602202, 0.6866833118357935, 0.687127953221965, 0.6855340961646608, 0.6843653151550978, 0.6854315051548722, 0.6773196923421916, 0.6786846526431187, 0.6802929135603075, 0.6814885565553485, 0.6749288869828546, 0.6656415237035596, 0.6645178341258369, 0.6656660040756731, 0.6669704175177489, 0.66808844065075, 0.6691723729507585, 0.6688856649499607, 0.6590162274370746, 0.6479282716962838, 0.6432475659063293, 0.6391477116555323, 0.6391656949598424, 0.6407914228617777, 0.6423981692121843, 0.644092080927138, 0.6455141276944103, 0.6472274343946308, 0.6494076229257797, 0.6498990810689147, 0.6507865218463816, 0.6520578855993263, 0.6522774175242473, 0.65329645432184, 0.6519246349910904, 0.6519863377638956, 0.6531443245874953, 0.6542335056501041, 0.6550647812159173, 0.6556465021629095, 0.6560084093998131, 0.6558685160128903, 0.656142896137164]

    ISRUC_TSTCC_AAA = [0.7204918032786886, 0.6752049180327869, 0.6857533177205308, 0.640998243559719, 0.6435714285714286, 0.6425936768149884, 0.6268400802944128, 0.6363583138173302, 0.6381928181108508, 0.6465163934426229, 0.6077496274217585, 0.6148809523809523, 0.613024680237795, 0.6192372030779525, 0.6248985167837626, 0.6292813231850117, 0.6307652569224411, 0.6152485037730939, 0.6150684087267347, 0.6207874707259953, 0.6242137838742053, 0.627126357249308, 0.6301725893493534, 0.6330235167837627, 0.6208384074941451, 0.6133444424428031, 0.6100268887154132, 0.613422131147541, 0.6120629088266171, 0.6152829820452771, 0.6167466193246203, 0.6199868266978923, 0.6225959832517209, 0.6256974101115855, 0.6275092004014721, 0.6286690085870413, 0.6314117982150769, 0.6333430913348946, 0.6268029784423228, 0.6275936768149883, 0.6297152567544411, 0.6288167726106837, 0.6296443548826317, 0.6314256440281031, 0.633400988810825, 0.6338865695957642, 0.6357529024864219, 0.6365437158469945, 0.6379020694929025, 0.6390327868852459]
    ISRUC_TSTCC_AAF1 = [0.6986579952263389, 0.65021950371452, 0.6662514942043377, 0.5835252966661368, 0.5924492497246469, 0.5964410643876823, 0.5656645521627476, 0.5806601318136297, 0.5855737218263573, 0.5975506698651966, 0.5520871492369213, 0.5609527058854493, 0.5512971322656386, 0.560828363499631, 0.5693507194647265, 0.5761675339626092, 0.5795805340532179, 0.5654538483739153, 0.5654229263546992, 0.5719903312247292, 0.5771493039174433, 0.581694551231339, 0.5855473743742196, 0.5896161583796209, 0.5745077662825864, 0.5634853581696262, 0.556864941037693, 0.5613536478024301, 0.5562641539705813, 0.5604260889572538, 0.5632225728818135, 0.5674823834378734, 0.5712690259075637, 0.5752558776892917, 0.5779882847584723, 0.5801464926217431, 0.5835617417856626, 0.5860850212562811, 0.5778918211826953, 0.5788931465038354, 0.5816859182466758, 0.5774610103820758, 0.579088091135709, 0.5814639905956019, 0.5838643158356528, 0.5850848874167777, 0.5870486863414786, 0.5885154791744618, 0.5906191931629641, 0.5923710190451016]

    ISRUC_EWC_AAA = [0.7204918032786886, 0.6879976580796253, 0.6941061670569867, 0.6901346604215457, 0.6958313817330211, 0.6961553473848556, 0.6813733690197391, 0.6866217798594848, 0.6869502992453813, 0.6891276346604216, 0.6906057057696402, 0.6933645589383294, 0.6950999819852279, 0.6964871194379391, 0.6980679156908666, 0.6993742681498829, 0.6999655599944896, 0.6904859484777517, 0.6873074078639221, 0.6889754098360655, 0.6900552024088323, 0.6911885245901639, 0.692439670094695, 0.6922911787665885, 0.6829461358313815, 0.6800644028103042, 0.6764181628935725, 0.678435513549682, 0.6758640878623917, 0.6770804059328647, 0.6783089068520055, 0.6794185450819673, 0.6802604499325812, 0.6816434770629565, 0.683298762127802, 0.6841627634660422, 0.6854025571238687, 0.6864754098360656, 0.6848315618807422, 0.6858416276346604, 0.6868638258982122, 0.6848109735697557, 0.6847298622079407, 0.6854920694060038, 0.686392141556076, 0.6868979737297627, 0.6875853306093976, 0.6876890612802499, 0.6879546432156001, 0.6880995316159251]
    ISRUC_EWC_AAF1 = [0.6986579952263389, 0.6668215867584513, 0.6756346741539482, 0.6706646641476489, 0.6769755716653778, 0.6773415144229724, 0.651992457008946, 0.6592410470612758, 0.6604052845417541, 0.663866706743051, 0.6664532695255537, 0.6699173614364459, 0.6715063445800401, 0.6733992498406539, 0.6758039917251485, 0.677656707600649, 0.67881646236592, 0.6689718602117616, 0.6652260688870439, 0.6666616069889898, 0.6679824365836086, 0.6696223193193751, 0.6708851259221604, 0.6708210976463014, 0.6590482679431715, 0.6562687992927582, 0.6520077481416803, 0.6540224727303381, 0.651303276370774, 0.6527278957824606, 0.6541705177335281, 0.6553806115762014, 0.6563617832883093, 0.6578398391169652, 0.6595001201405198, 0.660546092364328, 0.6616168190212467, 0.6628141190555619, 0.6609143503180576, 0.6619400537631412, 0.6630071751193674, 0.6604006339757723, 0.6606668448519123, 0.6617136647328176, 0.6626170860627086, 0.663270573929791, 0.6637990727433927, 0.6640722405691113, 0.6646052268496466, 0.6649657795757135]

    ISRUC_LWF_AAA = [0.7204918032786886, 0.6954625292740046, 0.6964285714285715, 0.6984192037470727, 0.6994613583138174, 0.6768930523028884, 0.6830796252927401, 0.6856191451990632, 0.672664584959667, 0.6735304449648712, 0.6727113050883543, 0.6773370413739266, 0.6773959646910466, 0.67918200066912, 0.6803825136612022, 0.682721018735363, 0.6856212976994076, 0.687291829300026, 0.6893042031307777, 0.6897628805620608, 0.6912038585926173, 0.6796545667447306, 0.6815090113023113, 0.671875, 0.673871194379391, 0.6756665465681859, 0.6762793824269235, 0.6773732853797257, 0.6730154243721232, 0.67358118657299, 0.6739820200951879, 0.6750512295081967, 0.6749095167127954, 0.6699803691968591, 0.6678738708598193, 0.6682539682539682, 0.6586334578137857, 0.6607142857142857, 0.654415120398727, 0.6550834309133489, 0.6521048723367795, 0.6528855804616929, 0.6540330047383041, 0.6546213008303172, 0.6546226906062972, 0.6512065981060992, 0.6486471672729085, 0.6470640612802497, 0.6483761888830474, 0.6493536299765807]
    ISRUC_LWF_AAF1 = [0.6986579952263389, 0.6718072144929039, 0.6761418441716464, 0.6799520703953653, 0.6823377008076233, 0.6394346998635693, 0.6485732230625575, 0.6531789952563212, 0.6257614526010328, 0.6282572725481091, 0.6303289662061605, 0.6356691011975594, 0.6378786947726518, 0.6414093389112627, 0.6431362682517159, 0.6466264350210226, 0.6495033767542777, 0.6522826968213646, 0.6550228754581686, 0.6560548373186548, 0.6581839864188979, 0.6470458192473835, 0.6492403548384104, 0.6334958558499907, 0.6360302462610617, 0.6383436845800581, 0.6387225218000848, 0.6408072472598475, 0.6320770754727442, 0.6336387733456823, 0.6344374651504157, 0.63639832353361, 0.6370450897222428, 0.6282786812995774, 0.6264907581626967, 0.627265756861291, 0.6150527923446241, 0.6169252513330303, 0.607274190867303, 0.6088051762984346, 0.601919162676239, 0.6035565019668103, 0.6052201917916676, 0.60600752865188, 0.6066497286820882, 0.5998093343905857, 0.5951208280134609, 0.5935332788489042, 0.5955500348755073, 0.5972878276777289]

    ISRUC_UCLGV_AAA = [0.7204918032786886, 0.7239168618266979, 0.6912177985948477, 0.6948185011709601, 0.7008899297423887, 0.703620218579235, 0.7076363332218133, 0.7087895199063232, 0.7105581576893053, 0.7101170960187354, 0.7114115392803918, 0.7132952771272444, 0.7146009727976941, 0.7148084643693543, 0.7172443403590945, 0.7176009953161593, 0.7168824907011986, 0.7154729378090035, 0.7162424503882658, 0.7163670960187354, 0.7168004906880786, 0.7171119863742815, 0.7163399857448326, 0.7165568891491022, 0.7128126463700234, 0.7133714646009728, 0.7127135918119524, 0.7130854800936767, 0.7141443915044818, 0.7138563622170178, 0.7142951575130315, 0.714633343091335, 0.7125168547299696, 0.711459911833586, 0.7097775175644029, 0.7097059588862868, 0.709831318437876, 0.7099238875878221, 0.7080706179066836, 0.7080605971896955, 0.7089292854286856, 0.7066786550685848, 0.7056355862970427, 0.7057683095592933, 0.7057663283892792, 0.705940077385195, 0.7058298868902289, 0.7043276736924278, 0.7044795201452947, 0.7050409836065574]
    ISRUC_UCLGV_AAF1 = [0.6986579952263389, 0.702867013990669, 0.6679366440083866, 0.6717953713300968, 0.6783206360296334, 0.6817534834694099, 0.6858106342129574, 0.6876963283751347, 0.6899636990892096, 0.6897049687643206, 0.6911460891919406, 0.6934290816170359, 0.6947388526357514, 0.6948164685322143, 0.6966400634179682, 0.6973608105172664, 0.6964347541359135, 0.6949942423444847, 0.6957825492951133, 0.6961111289283353, 0.6965676530616696, 0.6968084026741106, 0.6960842008788114, 0.6963784098671338, 0.6925831323331135, 0.6927705594930287, 0.6921312975571894, 0.692513424954022, 0.6935159306683601, 0.6932288526775644, 0.6936379572227268, 0.6940345861238489, 0.6916072034423154, 0.6904519774486753, 0.6887476546017732, 0.688760867993068, 0.6888516027645859, 0.6890155578245574, 0.6872918903533594, 0.6873536291981589, 0.6882753894413096, 0.6855618575696313, 0.6845807700035126, 0.6847766626361627, 0.6847108765577621, 0.6849021895779898, 0.6848160659278435, 0.6831175694518459, 0.6833552763418537, 0.683819498518161]

    ISRUC_CONDA_AAA = [0.7204918032786886, 0.7396370023419203, 0.740671350507416, 0.7392564402810304, 0.7198594847775175, 0.7242681498829039, 0.7287387085981933, 0.7304156908665105, 0.731167056986729, 0.7284601873536298, 0.7279699808388332, 0.7255366900858703, 0.7253152585119798, 0.7255394780863165, 0.7272014051522249, 0.7273931498829039, 0.7266668962667033, 0.7258619568045797, 0.7257056575865893, 0.7255386416861825, 0.7271300323408051, 0.726535554609325, 0.7267208023622848, 0.7268710967993756, 0.7269086651053864, 0.7269163213835346, 0.7267390927226993, 0.727019906323185, 0.7263284341435841, 0.7256186572989852, 0.7252662990103498, 0.7252213846604216, 0.7249680647221632, 0.7251170960187355, 0.7230796252927402, 0.7225312256049963, 0.7221817836571937, 0.7223453099963024, 0.7227121239416323, 0.7216583723653396, 0.7206103272976524, 0.7202464592394335, 0.7197048091062579, 0.7200766446668087, 0.7195459276606818, 0.7193348437022706, 0.717854651452489, 0.7177058938329429, 0.717691057687712, 0.7164894613583138]
    ISRUC_CONDA_AAF1 = [0.6986579952263389, 0.719477862977848, 0.7190984832669708, 0.7187965203175111, 0.6995048276209637, 0.7044173813986664, 0.708543709222248, 0.7105990215596512, 0.7119946640530013, 0.7094990634526491, 0.7091240023760862, 0.7064112068198972, 0.7061504871459133, 0.7061169311520665, 0.7078859101113805, 0.708247738841067, 0.7076622380687921, 0.7069164539130467, 0.7068510679167187, 0.7066551825534942, 0.7083532995820095, 0.7078437786604508, 0.7080733647776214, 0.7081857825268161, 0.7082221916966428, 0.7080242742163214, 0.7077835125898453, 0.7080654207128502, 0.7074338992465786, 0.7067606695058166, 0.7063793830497244, 0.7060223150424837, 0.7057410429578768, 0.7058185947725581, 0.7035779487987329, 0.7030700328632217, 0.7027965959087585, 0.7028583264144531, 0.7031967836623431, 0.7021432725872112, 0.70118570568819, 0.7007405751068655, 0.7002203185812781, 0.7004883321542184, 0.6999581882942236, 0.699526081244547, 0.6980272616206252, 0.6976631557331446, 0.6974689393663126, 0.6962626700622441]

    ISRUC_COTTA_AAA = [0.7204918032786886, 0.7233021077283373, 0.7248438719750195, 0.730342505854801, 0.730456674473068, 0.7292642466822795, 0.7299263967882235, 0.7300278103044496, 0.7319476971116315, 0.7333138173302107, 0.7319459229295294, 0.7295179547228727, 0.7289812646370023, 0.7292280026764804, 0.729207650273224, 0.7302473653395785, 0.7309753409560545, 0.7310499609679938, 0.7311968445704425, 0.7306879391100704, 0.7310025649604105, 0.7252341920374707, 0.7244119743406985, 0.7233313817330211, 0.7242388758782202, 0.7246374527112233, 0.7257372712290746, 0.7253199230511879, 0.7245255592344344, 0.7236885245901641, 0.7235230792475638, 0.72317037470726, 0.7218082463984103, 0.7205004132800662, 0.7176898628303781, 0.7178360005204268, 0.7166292170390531, 0.7172485517071368, 0.7156773554314538, 0.7149355971896956, 0.7143242702918833, 0.7113834058213451, 0.7116578617722348, 0.7095473174366618, 0.7082292479833464, 0.7072586803787803, 0.7048383078379592, 0.7039629683840749, 0.7037016680208382, 0.701947306791569]
    ISRUC_COTTA_AAF1 = [0.6986579952263389, 0.7009936205972216, 0.7031862729742665, 0.7097230659933551, 0.7102724875257045, 0.7089846145312246, 0.7095685226526646, 0.7098988557794386, 0.7120552146582451, 0.7127499162512662, 0.7116324308616571, 0.708988508416057, 0.7086690257146523, 0.7088242800712685, 0.7088188802364702, 0.7099630894936915, 0.7103529522107307, 0.7107404902731093, 0.710882615639789, 0.7104476960322772, 0.7106068229027264, 0.7048647278352406, 0.7040395325508102, 0.7029625632893012, 0.7038373097515204, 0.7043058969579049, 0.7054577282650598, 0.705120142204405, 0.7044418098872814, 0.7036967134187168, 0.7034470750877377, 0.7032436279067468, 0.7019877378104958, 0.7005827937396549, 0.6975131204512306, 0.6975001918914309, 0.6962957984776228, 0.6965969402285193, 0.6950680759937709, 0.6944683433350558, 0.6937493351666805, 0.6906795959794698, 0.6909421528736995, 0.6884776362979429, 0.6871067275726696, 0.6862770792556245, 0.6836204058683337, 0.682809200802565, 0.6825739706119321, 0.6804847490705315]

    ISRUC_OUR_AAA = [0.7204918032786886, 0.7234192037470726, 0.7269906323185013, 0.7293764637002342, 0.7288173302107729, 0.7286690085870414, 0.7307544329207093, 0.7318793911007027, 0.7318696330991413, 0.7323126463700235, 0.7328826910794124, 0.7336699843871974, 0.7346829400108088, 0.7354884576781532, 0.735854800936768, 0.7359, 0.7360948477751756, 0.7355834136933462, 0.7344294821753838, 0.7348853691606064, 0.7349414519906323, 0.7351065016170402, 0.735307110921865, 0.7354520924549435, 0.7346531030444966, 0.7350983606557377, 0.7355701675373807, 0.7360026888715415, 0.7361638507862163, 0.7363522571267062, 0.7366022638563624, 0.7369740122384228, 0.7369639197892273, 0.7371868568589881, 0.7380286540845846, 0.73796587487454, 0.7388693728857664, 0.738860054433825, 0.7390391963515345, 0.7397841229808443, 0.7398814402810304, 0.7402981664477066, 0.7403632764581242, 0.7407221828876422, 0.7407068341494571, 0.740736403851158, 0.7409454230730069, 0.7408577906223529, 0.7408665105386416, 0.740845003106629]
    ISRUC_OUR_AAF1 = [0.6986579952263389, 0.7027865691185531, 0.7063565800852505, 0.7096234788834697, 0.7092269771857842, 0.7091250262100938, 0.7112474464643608, 0.7124957077942677, 0.7121762611900138, 0.7124070812264967, 0.7132436515863995, 0.7138817855422888, 0.7152918152451732, 0.7160522839218013, 0.7164666960100128, 0.7165, 0.7166351534922907, 0.7158665288975652, 0.7144079414072273, 0.7149188625547215, 0.715031297165804, 0.7152071646075564, 0.7154627567981859, 0.7156496686751039, 0.7148556253318002, 0.715335692937582, 0.715890355147583, 0.7163428691629771, 0.7164404909853889, 0.7165472615534314, 0.7168515873245521, 0.7171871193984783, 0.7172242322523714, 0.7173835511186332, 0.7182311820130084, 0.7182384597208549, 0.7190140823584787, 0.7190081449650397, 0.7191761360414657, 0.7199225040002115, 0.7200213289383959, 0.7205428627528858, 0.720673736440565, 0.7209978398745073, 0.720918627612564, 0.7210090510277196, 0.7211672052406644, 0.7210436010200755, 0.7210209328857685, 0.7209871453260605]

    FACED_MMD_AAA = [0.23958333333333334, 0.26860119047619047, 0.30009920634920634, 0.28273809523809523, 0.3074404761904762, 0.294890873015873, 0.29549319727891155, 0.30245535714285715, 0.3014219576719577, 0.29583333333333334, 0.29193722943722944, 0.28273809523809523, 0.2847985347985348, 0.28135629251700683, 0.28611111111111115, 0.28859747023809523, 0.2915791316526611, 0.2900132275132275, 0.29174498746867167, 0.2904017857142857, 0.2957766439909297, 0.29335768398268397, 0.2974896480331263, 0.3011532738095238, 0.30494047619047615, 0.3043727106227106, 0.30489417989417983, 0.30256164965986393, 0.30151888341543515, 0.30218253968253966, 0.30035522273425497, 0.30115327380952384, 0.30118145743145747, 0.29862570028011204, 0.2971513605442177, 0.2983217592592593, 0.2986245173745174, 0.2958176691729324, 0.29532967032967034, 0.2953497023809524, 0.295695412311266, 0.29570578231292516, 0.2981035437430786, 0.3008996212121212, 0.30205026455026457, 0.3023097826086957, 0.30246327254305977, 0.3038194444444445, 0.3034803206997085, 0.3020535714285715, 0.30281279178338005, 0.3048305860805861, 0.305256064690027, 0.30530753968253976, 0.30716991341991345, 0.30901892006802717, 0.3112207602339181, 0.31137110016420355, 0.3118694511702986, 0.31180555555555556, 0.31191451990632313, 0.3123319892473118]
    FACED_MMD_AAF1 = [0.1874819175619343, 0.21749404592649546, 0.2609559693911364, 0.23824014544334546, 0.27068953193199496, 0.25382832285723383, 0.25336699773817, 0.26382639706893546, 0.2616172356669652, 0.25562467704935615, 0.24943277314753923, 0.2384874454025905, 0.2409941461638996, 0.2366812243385918, 0.24272485149456724, 0.24612866357083088, 0.24985796784198147, 0.24683289976945375, 0.24919581903359378, 0.24672450364444343, 0.2538142416530452, 0.24992791739399509, 0.25530487141245695, 0.26002457709478016, 0.26527292696861626, 0.26449719074712175, 0.2653236429858618, 0.26236200231923484, 0.2613785110384354, 0.2625967987494304, 0.2601040798994716, 0.2613366493124327, 0.26158453198549064, 0.25838436546997356, 0.2567329682211965, 0.2582168164595926, 0.25863781362980043, 0.2552799561324556, 0.25440502466018294, 0.25424636022666813, 0.25471539070702814, 0.2549606224090616, 0.2581794921607095, 0.26173548222818543, 0.26316655041968806, 0.26365326194686906, 0.2639680770104793, 0.2658906036699382, 0.26540740339918184, 0.2636746903341962, 0.2647265676751649, 0.2673857814274044, 0.26780503209377, 0.2677858143580777, 0.27022836341407197, 0.27273357253373726, 0.27554156500471205, 0.2757811906232733, 0.27654753204383076, 0.2765103493523216, 0.27673679329626233, 0.2772666553924112]

    FACED_TSTCC_AAA = [0.23958333333333334, 0.24479166666666669, 0.27480158730158727, 0.29873511904761907, 0.32083333333333336, 0.32415674603174605, 0.33333333333333337, 0.3208705357142857, 0.31415343915343913, 0.31339285714285714, 0.30073051948051943, 0.3013392857142857, 0.3067765567765568, 0.3122874149659864, 0.31369047619047613, 0.31184895833333337, 0.311186974789916, 0.31283068783068785, 0.31524122807017546, 0.3140625, 0.3182397959183674, 0.32264610389610393, 0.32336956521739135, 0.32446676587301587, 0.3281547619047619, 0.3286973443223443, 0.33134920634920634, 0.3315263605442177, 0.3287151067323481, 0.3294642857142857, 0.32925307219662053, 0.33165922619047616, 0.33400974025974023, 0.33390231092436967, 0.33069727891156453, 0.33089451058201047, 0.33128217503217494, 0.3329808897243107, 0.3348595848595848, 0.3365699404761905, 0.3383783391405343, 0.3398880385487528, 0.34056616832779624, 0.3423971861471861, 0.34427910052910055, 0.3421001552795031, 0.3421669199594731, 0.34350198412698413, 0.3425959669582118, 0.3437797619047619, 0.3418534080298786, 0.3414033882783883, 0.3421776729559748, 0.3431712962962962, 0.3447240259740259, 0.34404230442176875, 0.3437238930659984, 0.3423901888341544, 0.3398153753026635, 0.33980654761904766, 0.3386758391881343, 0.3383016513056836]
    FACED_TSTCC_AAF1 = [0.1874819175619343, 0.18876983436658915, 0.2277947689849519, 0.2592832615097541, 0.2883482198788414, 0.2927231623150081, 0.30394806550583653, 0.28782289616860857, 0.28049349483763747, 0.27930038618513064, 0.26355511845903296, 0.26384594267694733, 0.2713994331332803, 0.2788775272157052, 0.2804880120197247, 0.27791710573150136, 0.2769749899893599, 0.27934328799730773, 0.2823090683505047, 0.28090249633481434, 0.28613578807468787, 0.2913738995394503, 0.29244028667139643, 0.2941341823914137, 0.2987489206437582, 0.2995752333781537, 0.3030520709214251, 0.30288699826362614, 0.29912689135251164, 0.2998665284394712, 0.2995102453305767, 0.3026382779077196, 0.3056286899807938, 0.3054145040129304, 0.30120507934064816, 0.3014300120817325, 0.30218525199376095, 0.30438320786734824, 0.30678533260619967, 0.30895345688957426, 0.3112312867195317, 0.31317236612947247, 0.3139148953393589, 0.31613949301179717, 0.3183567231066731, 0.31556639971696465, 0.3155519230531722, 0.31710945340335317, 0.3158613131937675, 0.31726237060908535, 0.31475770440755363, 0.3142892494921123, 0.31535023686009755, 0.31668516435490407, 0.3185860149217953, 0.3177502078780696, 0.31747164239970127, 0.315892110254997, 0.31264489670344686, 0.3126007666005545, 0.31115354004610224, 0.3107426387687494]

    FACED_EWC_AAA = [0.23958333333333334, 0.22470238095238096, 0.2604166666666667, 0.29910714285714285, 0.28928571428571426, 0.30927579365079366, 0.3244047619047619, 0.3175223214285714, 0.31911375661375657, 0.32291666666666663, 0.31804653679653677, 0.3189484126984127, 0.3249771062271062, 0.3272746598639455, 0.3187499999999999, 0.3151041666666667, 0.3185399159663866, 0.3185350529100529, 0.32401315789473684, 0.32514880952380953, 0.32142857142857145, 0.3188582251082251, 0.3198110766045549, 0.3233506944444444, 0.32654761904761903, 0.33007097069597074, 0.33349867724867727, 0.3329081632653062, 0.3340004105090313, 0.3310019841269842, 0.3334293394777266, 0.32807849702380953, 0.331213924963925, 0.33442752100840334, 0.33613945578231286, 0.33531746031746024, 0.33671171171171166, 0.3346647869674185, 0.3324175824175824, 0.33366815476190476, 0.32974012775842043, 0.3318452380952381, 0.33264119601328906, 0.33350243506493504, 0.3325396825396825, 0.333106884057971, 0.3325734549138804, 0.33407738095238093, 0.3358539844509232, 0.3338988095238095, 0.33274976657329597, 0.33236034798534797, 0.3331367924528302, 0.33443562610229277, 0.33612012987012985, 0.3346885629251701, 0.33380325814536344, 0.33533456486042695, 0.3345944309927361, 0.3349702380952381, 0.33657786885245905, 0.3350134408602151]
    FACED_EWC_AAF1 = [0.1874819175619343, 0.16644100700598696, 0.21110618194719358, 0.2587390454991052, 0.24762200154257394, 0.27238678386405174, 0.29062114810007084, 0.28312779021945245, 0.2857281005116866, 0.2902397367158168, 0.2840699375556874, 0.28552951233492824, 0.2927527480651872, 0.29592411916863964, 0.2850668816595645, 0.2809299483576291, 0.28558448009207893, 0.28564527846636006, 0.29245206181717986, 0.2936083147965519, 0.28905451717874975, 0.2860173321088514, 0.28721516161020894, 0.2920756796034158, 0.29591408077678777, 0.3002079620888907, 0.3042339093417454, 0.303303419808465, 0.30469547739441905, 0.30063506142249025, 0.30357888263654614, 0.29714840851364177, 0.3010318722591914, 0.3048038829105232, 0.30690031710546234, 0.30600943580857554, 0.3077411876014735, 0.30538468382285017, 0.3026246822215981, 0.3041576140233626, 0.29887852488788513, 0.30145700055540375, 0.3024114797305167, 0.3035606935952294, 0.30256433762337004, 0.3034512596248671, 0.30269397384046554, 0.30448290400393563, 0.30667387077464164, 0.30410584628143966, 0.30248893036368857, 0.30205800678322814, 0.30319457040511927, 0.30497848310271547, 0.3071226760162955, 0.30510193603910846, 0.3040939192970688, 0.305874924817409, 0.30501280084912014, 0.3055139052538934, 0.3075501974766441, 0.3055519986796789]

    FACED_LWF_AAA = [0.23958333333333334, 0.2767857142857143, 0.2976190476190476, 0.29389880952380953, 0.2982142857142857, 0.29216269841269843, 0.29825680272108845, 0.31045386904761907, 0.3123346560846561, 0.31250000000000006, 0.3099296536796537, 0.302703373015873, 0.30952380952380953, 0.3087797619047619, 0.31587301587301586, 0.3195684523809524, 0.3245798319327731, 0.3229166666666667, 0.3254229323308271, 0.3248511904761905, 0.3213577097505669, 0.31784361471861466, 0.3211697722567287, 0.3234747023809524, 0.3268452380952381, 0.32944139194139194, 0.33272707231040566, 0.3360437925170068, 0.3350266830870279, 0.33358134920634913, 0.3324692780337941, 0.33482142857142855, 0.33491161616161613, 0.3321516106442577, 0.33142006802721086, 0.33283730158730157, 0.3326093951093951, 0.3299263784461153, 0.3298611111111111, 0.3300967261904762, 0.3305749128919861, 0.3307823129251701, 0.33264119601328906, 0.3347199675324675, 0.33607804232804234, 0.3364065734989648, 0.33605623100303955, 0.33745659722222215, 0.3373420796890184, 0.3357738095238095, 0.33703898225957046, 0.33868475274725274, 0.3389487870619946, 0.33914792768959434, 0.34112554112554117, 0.3428199404761904, 0.34432435254803667, 0.34495587027914604, 0.3454398708635996, 0.3454365079365079, 0.34545765027322395, 0.3458621351766512]
    FACED_LWF_AAF1 = [0.1874819175619343, 0.23180887787758114, 0.26176899893265854, 0.2546275813722124, 0.26048432442027397, 0.2517582149788458, 0.25950012871039124, 0.2753221516203529, 0.27720617717362317, 0.2776220151887965, 0.27328293364918044, 0.2643080841562663, 0.27282866311207005, 0.27195463707714035, 0.280653851775729, 0.28575558057984435, 0.2919762737016223, 0.289542925439972, 0.29299549169991423, 0.2919016899587476, 0.28812712120148687, 0.283223790168564, 0.28776910980616466, 0.2909706401824757, 0.29546956737188035, 0.29891685318802835, 0.302957089227809, 0.30716982211083377, 0.3060649553390392, 0.30445728759508445, 0.30277556120100974, 0.3056664761706266, 0.30593208899999846, 0.30252348093590303, 0.3018262190522804, 0.3035199658569631, 0.30330741294014585, 0.3000390092226969, 0.2997962563496475, 0.29991761263348016, 0.30042058003941097, 0.3007891407069697, 0.3032503930289012, 0.30580390016280307, 0.307411542673797, 0.30795966266593783, 0.30766383525695834, 0.3095375831163674, 0.3093705444126725, 0.30757092997681534, 0.3092757086595406, 0.31135006444325597, 0.3116849846975474, 0.31196720965103, 0.31439888114984793, 0.3165671548468295, 0.31841985188557637, 0.31916076469124416, 0.31988006139679104, 0.3199589027577849, 0.3200423217427323, 0.3205609286886656]

    FACED_UCLGV_AAA = [0.23958333333333334, 0.2886904761904762, 0.3060515873015873, 0.32961309523809523, 0.32916666666666666, 0.30704365079365076, 0.3125, 0.31045386904761907, 0.3197751322751323, 0.3190476190476191, 0.31872294372294374, 0.3251488095238096, 0.33276098901098905, 0.32546768707483, 0.32638888888888895, 0.3312872023809524, 0.33114495798319327, 0.33622685185185186, 0.3346647869674186, 0.32924107142857145, 0.33255385487528344, 0.3354301948051948, 0.33799171842650105, 0.3407118055555555, 0.3385714285714285, 0.33619505494505486, 0.3350418871252204, 0.3301977040816326, 0.32789408866995073, 0.3303075396825397, 0.33299731182795694, 0.3356584821428571, 0.33829365079365076, 0.33849789915966383, 0.33979591836734685, 0.34160052910052907, 0.3440315315315315, 0.34292763157894735, 0.34123168498168494, 0.34285714285714286, 0.3418989547038328, 0.34052579365079366, 0.3390088593576966, 0.33786525974025977, 0.3369708994708995, 0.3363095238095238, 0.33602456940222897, 0.3342013888888889, 0.3327259475218659, 0.3309226190476191, 0.3325163398692811, 0.3337339743589744, 0.3337825696316263, 0.3336640211640212, 0.335146103896104, 0.3366549744897959, 0.3379542606516291, 0.3379772167487685, 0.3378228410008071, 0.33844246031746034, 0.3381879391100703, 0.3391897081413211]
    FACED_UCLGV_AAF1 = [0.1874819175619343, 0.2475592859609545, 0.27099690094437534, 0.3009863769410303, 0.2998067358516475, 0.2735566731367762, 0.2788739098802658, 0.27466605599269756, 0.2878819356644312, 0.28575631289906317, 0.285814065826193, 0.2942682561439785, 0.30365578154057393, 0.29444524925226234, 0.29576343931792415, 0.30191178740780783, 0.3023238003748914, 0.3087199425701734, 0.3066148585995629, 0.2999832318408314, 0.30446944291226796, 0.3082372444268875, 0.3115336849989187, 0.31496384255700544, 0.3119041690425856, 0.3087082334766113, 0.30721257898512633, 0.3010439081381035, 0.29814468315200804, 0.3014059215929889, 0.30481466174879385, 0.3080850517447682, 0.3113026928512065, 0.31148092111134273, 0.31328615985908537, 0.31569602238512506, 0.3189475509166468, 0.3175830728891965, 0.31518984731456157, 0.3171351978291267, 0.31590410254760387, 0.31381549398086633, 0.3118432357563385, 0.31052548897865867, 0.30920255259580504, 0.30820095581317264, 0.30787145018207374, 0.3056518167248344, 0.30338286428874256, 0.3010331801829038, 0.30299825971240457, 0.3045549971435589, 0.30458896310965133, 0.3044319859511658, 0.3063089691446117, 0.30823692813867165, 0.30990738867445133, 0.30987914415124956, 0.3096575273183858, 0.3103674153510888, 0.31008892078209604, 0.311455156344188]

    FACED_CONDA_AAA = [0.23958333333333334, 0.3117559523809524, 0.29365079365079366, 0.2961309523809524, 0.30446428571428574, 0.31795634920634924, 0.3210034013605442, 0.32570684523809523, 0.3263888888888889, 0.32514880952380953, 0.32954545454545453, 0.3343253968253968, 0.3257783882783883, 0.3246173469387755, 0.3250992063492063, 0.32719494047619047, 0.3286064425770308, 0.32531415343915343, 0.3226817042606516, 0.3223214285714286, 0.32142857142857145, 0.321090367965368, 0.3215579710144928, 0.318328373015873, 0.31952380952380954, 0.3187957875457875, 0.3185626102292769, 0.321109693877551, 0.32466133004926107, 0.32594246031746027, 0.3289170506912442, 0.33017113095238093, 0.3287337662337662, 0.3297443977591036, 0.3297619047619047, 0.3269675925925925, 0.326295045045045, 0.32695018796992475, 0.32768620268620263, 0.3293526785714286, 0.33097415795586527, 0.333156179138322, 0.3339908637873754, 0.3344155844155844, 0.33624338624338623, 0.3355978260869565, 0.33703774062816616, 0.33795262896825395, 0.3382227891156462, 0.3395535714285714, 0.34016106442577027, 0.3391712454212454, 0.3393699460916441, 0.3375496031746031, 0.33574134199134187, 0.3357514880952381, 0.33581349206349204, 0.3357194170771757, 0.334115213882163, 0.3328621031746032, 0.3326258782201405, 0.33177323348694315]
    FACED_CONDA_AAF1 = [0.1874819175619343, 0.2779458541542663, 0.2545460542714045, 0.257764819826412, 0.2692487206860973, 0.28701182309695644, 0.2907037049970542, 0.29729449030634975, 0.2986757708467843, 0.2963110798561442, 0.30168564594755454, 0.30762671888492993, 0.2968837815014945, 0.29557674191500566, 0.296506625894973, 0.2989037831653433, 0.30054483643544566, 0.2966407756406925, 0.29358763061951715, 0.29314296921096494, 0.29182640554524175, 0.2913773057179156, 0.2915394047460815, 0.2871126524934413, 0.28864289646141117, 0.28759891494788037, 0.2873988800167429, 0.2907342643210393, 0.2952632369120969, 0.29706586241195077, 0.3008110718899231, 0.3024203455925655, 0.3008111208833682, 0.3021286502381392, 0.3021966489148389, 0.29876733329104393, 0.2978320271972494, 0.2986781211291573, 0.2996444877684718, 0.3017940765895166, 0.3039494297824962, 0.3065800211562235, 0.30762894047642375, 0.3081362667027958, 0.310263002199004, 0.30924853394757973, 0.31092474744874465, 0.3121036560117378, 0.3124769083119232, 0.3139940057076519, 0.31475878615286085, 0.31334071561315135, 0.3132985087646729, 0.3109138864362417, 0.30867900456477154, 0.308604046422121, 0.3086040404837358, 0.30846095016687053, 0.30643225409335906, 0.3048246323652251, 0.30432284342485544, 0.3029829938801072]

    FACED_COTTA_AAA = [0.23958333333333334, 0.26711309523809523, 0.30456349206349204, 0.33407738095238093, 0.3261904761904762, 0.31820436507936506, 0.3322704081632653, 0.32254464285714285, 0.3176256613756614, 0.32514880952380953, 0.3334686147186147, 0.3410218253968254, 0.3438644688644689, 0.3499149659863946, 0.3554563492063493, 0.35202752976190477, 0.3496148459383754, 0.3468915343915344, 0.34570802005012535, 0.3485119047619048, 0.3521825396825397, 0.3536931818181819, 0.3531314699792961, 0.35546875, 0.35410714285714284, 0.3503891941391941, 0.34882054673721336, 0.3482674319727891, 0.34672619047619047, 0.3491071428571429, 0.34922235023041476, 0.35109747023809523, 0.3509199134199134, 0.3493960084033613, 0.3477891156462585, 0.34933035714285715, 0.350265444015444, 0.346687030075188, 0.3443223443223443, 0.3416666666666667, 0.34117305458768876, 0.34272250566893425, 0.34260797342192695, 0.34290449134199136, 0.34163359788359793, 0.3410326086956522, 0.34067882472137795, 0.34040178571428575, 0.34168488824101073, 0.34327380952380954, 0.34500466853408035, 0.3439503205128206, 0.34318845462713393, 0.3444113756613757, 0.34499458874458877, 0.34510522959183676, 0.34466374269005845, 0.34572557471264365, 0.34718018563357544, 0.34600694444444446, 0.34540886026541767, 0.3462461597542243]
    FACED_COTTA_AAF1 = [0.1874819175619343, 0.22321391760752007, 0.2705987859956381, 0.3065854987230438, 0.29589042151896777, 0.2868582733305829, 0.3046640705753157, 0.29454712542266037, 0.2868899900493867, 0.296851448124739, 0.30738277281642196, 0.3166235153853764, 0.32050403136547334, 0.3278256833290083, 0.3344017819719557, 0.3298671300881306, 0.3269735173925535, 0.3228683705495993, 0.32138011967471863, 0.32516603931912963, 0.32960063629130537, 0.33139126428565596, 0.33071737273377405, 0.3337325458200466, 0.3315619874141836, 0.32696458736400985, 0.32509726982420833, 0.32442939782873675, 0.322490575319688, 0.325483215657325, 0.3256638787582597, 0.32808415373279115, 0.32790161098069714, 0.32617932079896345, 0.3241935964853044, 0.3259346371919794, 0.3271473742752602, 0.3223608049201785, 0.3192847886018996, 0.3158197940395936, 0.3150575788852619, 0.31682489428451105, 0.31673064332199213, 0.3172419046179216, 0.3155036605550031, 0.3147979936563927, 0.3142900312163096, 0.3140966193904207, 0.31577542347155996, 0.31773853548753656, 0.31996793848601485, 0.3183293796487996, 0.3173645142033283, 0.3189725863227553, 0.31971655180546593, 0.31992808684163065, 0.3194570563386019, 0.32083241372518034, 0.32264259739278034, 0.3209457021774217, 0.3201844356465056, 0.32128342786177233]

    FACED_OUR_AAA = [0.23958333333333334, 0.3191964285714286, 0.31597222222222227, 0.31808035714285715, 0.33571428571428574, 0.3384384920634921, 0.3373316326530613, 0.34128273809523814, 0.34292328042328046, 0.3438988095238096, 0.3434794372294373, 0.3495783730158731, 0.3408882783882785, 0.33258928571428586, 0.33452380952380967, 0.3390066964285714, 0.3447128851540616, 0.3482969576719577, 0.3514254385964912, 0.34672619047619047, 0.34552154195011336, 0.3482819264069264, 0.3490553830227743, 0.3505084325396825, 0.35238095238095235, 0.35113324175824173, 0.3517416225749559, 0.35390093537414963, 0.35570607553366174, 0.35362103174603177, 0.35450268817204306, 0.3562593005952381, 0.358270202020202, 0.3600752801120448, 0.36007653061224487, 0.3594576719576719, 0.3616473616473616, 0.36207706766917286, 0.36141636141636135, 0.3625372023809524, 0.36160714285714285, 0.3617842970521542, 0.3627145625692137, 0.363873106060606, 0.3653769841269841, 0.36675077639751547, 0.3682560790273556, 0.36941964285714285, 0.36850097181729835, 0.36636904761904765, 0.36683006535947715, 0.36541323260073266, 0.36506064690026957, 0.3657407407407408, 0.3663419913419914, 0.3658854166666667, 0.3653926482873852, 0.366276683087028, 0.3658192090395481, 0.3666418650793652, 0.36411982825917266, 0.3645833333333335]
    FACED_OUR_AAF1 = [0.1874819175619343, 0.28531108232926056, 0.2828955992361311, 0.28769918716076626, 0.3106068617935397, 0.3147308256587364, 0.3139739358106908, 0.3167100929808845, 0.3173909905453524, 0.31788810266316625, 0.3170402722859291, 0.32466830846072164, 0.31358109939880924, 0.303431677828971, 0.3056774274959849, 0.311487515547386, 0.3184033943776558, 0.3229476445026288, 0.3269418558619077, 0.32123040314518614, 0.3197918049340479, 0.3234131674566716, 0.32455969840060184, 0.32630895689242273, 0.3285843638798256, 0.3271345556401375, 0.32803335942684675, 0.3308210350094654, 0.33301850912402214, 0.33041677342965226, 0.3316116191118639, 0.333889242091256, 0.33631398272080526, 0.33834576477575795, 0.3384291789149139, 0.3376681826597131, 0.3402075993731552, 0.3408669075020277, 0.33991262880276507, 0.3412909712398332, 0.3402095321633512, 0.3405695829580337, 0.34186423708025376, 0.3433773734329679, 0.34531763701226614, 0.3471542019852102, 0.3490191045163817, 0.35051306761294104, 0.349341209369595, 0.34687606622786105, 0.34742009234708776, 0.34572542251545124, 0.34541192565327566, 0.34634600722912395, 0.347021356476045, 0.34639618054465604, 0.34581340277250366, 0.34694417919017956, 0.3462908958564574, 0.3472586066127812, 0.34441644771150076, 0.34499441655679647]

    BCI_MMD_AAA = [0.4696969696969697, 0.4719416386083053, 0.471754582865694, 0.46885521885521886, 0.4695847362514029, 0.4725963337074448, 0.4733044733044733, 0.4727833894500561, 0.4710687118094526, 0.4695847362514029, 0.4696969696969697, 0.47035166479610924, 0.4692653025986359, 0.4693362193362193, 0.4693228582117471, 0.46878507295173966, 0.46798045817653666, 0.46723406908592097, 0.46665485261976497, 0.4666947250280584, 0.4667575223130779, 0.46666156514641366, 0.46618357487922707, 0.4653011597456042, 0.464287317620651, 0.4636320469653803, 0.4632747225339818, 0.46320346320346323, 0.462634002863888, 0.46202768424990653, 0.46151478947177876, 0.4610690235690236, 0.46076930925415777, 0.4607182940516274, 0.4605739939073273, 0.4604844743733633, 0.4602936269602937, 0.4586951385197, 0.45713545713545717, 0.4565937149270483, 0.45625633024007006, 0.4558014002458447, 0.45522407537911413, 0.45477502295684114, 0.45455792492829533, 0.45433806665690724, 0.4539842873176206, 0.45310746352413017, 0.4522091664948808, 0.4515263748597082, 0.4503091921392575, 0.4496136579469913]
    BCI_MMD_AAF1 = [0.46335815763159616, 0.46613794766821603, 0.46669090251608353, 0.46347537352908674, 0.4627123910136004, 0.4666524267799139, 0.46809549715761845, 0.4675128703540994, 0.46468598782447035, 0.4627579601199062, 0.46291136553397333, 0.46355454572902904, 0.46204600997953926, 0.46224530577602735, 0.4623186580839305, 0.4617438841104205, 0.4609289036783426, 0.4603048302846622, 0.45979386152869345, 0.4598641768666841, 0.46012978983934827, 0.4599185142391819, 0.45958301406040614, 0.4588664797296991, 0.45755806885801986, 0.4569217592988809, 0.4568217917198688, 0.45691655268323444, 0.45629469652409993, 0.45550693661199365, 0.45477859169750157, 0.45447201008372845, 0.4543413189675197, 0.45437156648038646, 0.4543274899754097, 0.4542875341543561, 0.45415569695836366, 0.45219892943862006, 0.45038536712013677, 0.44999226137261183, 0.4498319634627596, 0.4495382618435785, 0.4490623121648843, 0.4487611844321041, 0.4485751957619471, 0.4484837180317242, 0.44835796338719425, 0.4476332468427855, 0.44668638002009836, 0.4460646940463363, 0.444861219554316, 0.4440909877711092]

    BCI_TSTCC_AAA = [0.4696969696969697, 0.4691358024691358, 0.4678264122708567, 0.46352413019079686, 0.46296296296296297, 0.4632435465768799, 0.46336379669713007, 0.4631734006734007, 0.46252649956353664, 0.4625140291806959, 0.461228446076931, 0.46165357276468394, 0.4614089614089615, 0.46107904441237785, 0.4603067714178826, 0.46026234567901236, 0.4608173235624216, 0.46034418256640486, 0.4609250398724083, 0.45996071829405166, 0.4603709048153493, 0.46071829405162745, 0.4607914897769971, 0.4605546202768425, 0.4604040404040404, 0.46028662695329364, 0.4604481024234111, 0.45959595959595967, 0.4596540113781494, 0.4594276094276095, 0.45975887911371793, 0.4594205948372615, 0.45935788865081795, 0.4595464448405625, 0.4594195927529261, 0.4593309639605936, 0.45895895895895894, 0.45888711678185357, 0.4588909033353477, 0.459104938271605, 0.45866524321808877, 0.45816631927743046, 0.45752094589303893, 0.4573002754820937, 0.45690235690235687, 0.4566193334309276, 0.4562647754137116, 0.4560419004863449, 0.45583957488719384, 0.4557239057239057, 0.4554367201426024, 0.4551929551929551]
    BCI_TSTCC_AAF1 = [0.46335815763159616, 0.4551262869548029, 0.45298558875261924, 0.44751500915262854, 0.44573655932447026, 0.44751271140910237, 0.4484504449762879, 0.44923403663505906, 0.4487480527913218, 0.44931798449823557, 0.4479683451844462, 0.4482224949939684, 0.44783868457814513, 0.447440280823398, 0.44617022078413526, 0.4456762902477702, 0.44628125427500975, 0.44627444277184025, 0.4472156912363072, 0.4467744404824831, 0.447563933550007, 0.4476038521519529, 0.4472219505343797, 0.4469579403114756, 0.44718060210352367, 0.4471624301370044, 0.44733872575787637, 0.44573055312324256, 0.44608885461822845, 0.4462173924510958, 0.4467474405206974, 0.4465943641430651, 0.446305880804125, 0.44676760360802864, 0.4466792341233753, 0.44677151275628213, 0.44630618022300134, 0.4461353077936943, 0.4462693133055842, 0.44640133743032406, 0.4461049846589769, 0.4457490887381164, 0.4454946753344705, 0.4453951944256666, 0.4446385614986085, 0.4443481780343216, 0.4439979853466939, 0.4439153786391623, 0.44404076607055004, 0.44377982640471886, 0.4433537382361665, 0.4431932115671121]

    BCI_EWC_AAA = [0.4696969696969697, 0.4767115600448934, 0.47886270108492335, 0.47811447811447816, 0.4780022446689114, 0.4766180321735878, 0.47635080968414306, 0.4761503928170595, 0.4757451053747351, 0.4748597081930416, 0.47382920110192844, 0.4741863075196409, 0.4733229733229734, 0.472943722943723, 0.47242798353909465, 0.46997755331088664, 0.4693998811645871, 0.469354034168849, 0.4689881268828638, 0.46865881032547707, 0.4683875794986907, 0.46824303642485465, 0.46762309081149667, 0.4672886270108492, 0.4668686868686869, 0.46661054994388323, 0.4664962381011763, 0.4667508417508417, 0.46621386276558685, 0.46659184436962214, 0.46652909018500416, 0.4662948933782267, 0.46571778389960206, 0.4657027794282696, 0.46632996632996626, 0.46608055867315124, 0.4661176327842994, 0.46618229074369427, 0.46615729949063284, 0.4658810325476992, 0.46572773808546164, 0.46572871572871566, 0.4660167567144311, 0.4648760330578512, 0.46457164234942006, 0.4641218952813155, 0.46402559877737176, 0.4638280957725402, 0.46382189239332094, 0.46404040404040403, 0.46387623511806514, 0.4637939221272554]
    BCI_EWC_AAF1 = [0.46335815763159616, 0.4723498503322844, 0.47523915265459893, 0.47407469671802427, 0.4739449015229775, 0.4724867639063624, 0.47169097033054125, 0.47133049766180024, 0.4703561070320328, 0.4692469228237181, 0.46782324317970353, 0.4678308132543467, 0.4669781364499543, 0.4664428969742992, 0.4661287672937785, 0.4631141866413733, 0.4624202326445735, 0.4623219099498343, 0.4617721490505855, 0.46122492847151797, 0.4608874609861943, 0.4605772416110662, 0.45988597879175297, 0.4596037674697863, 0.4591872042598807, 0.4588362255758061, 0.45856119280567864, 0.458770033038056, 0.4578659838682199, 0.4583981776324146, 0.458262447181348, 0.4580279027421794, 0.4571331281989007, 0.457137364936276, 0.45797861842593873, 0.45761787035751134, 0.45759581114799247, 0.457865233652689, 0.4578633223290078, 0.4573687064759072, 0.4570910793619344, 0.4569945808071077, 0.4573380143135843, 0.45584453529209645, 0.4553948090960543, 0.45455634722057797, 0.4544563718442996, 0.4541444352175967, 0.45416777985921464, 0.45445298602529904, 0.45432337054426625, 0.4543297582998266]

    BCI_LWF_AAA = [0.4696969696969697, 0.4710998877665544, 0.4711934156378601, 0.4670314253647587, 0.4695847362514029, 0.4719416386083053, 0.47178130511463845, 0.47208193041526375, 0.4696346177827659, 0.4696408529741863, 0.4693908784817875, 0.4693696221473999, 0.4676681343348009, 0.46661054994388323, 0.46621773288439955, 0.46643518518518523, 0.4667590942100746, 0.46673525377229086, 0.4668615984405459, 0.46719977553310893, 0.46763935652824545, 0.4676308539944904, 0.46811106231396094, 0.4668677515899738, 0.46572390572390576, 0.46557454890788225, 0.4657895830735337, 0.4654481321147988, 0.4648593211811603, 0.4635802469135803, 0.462962962962963, 0.46275252525252525, 0.4624358058701493, 0.46248432032745757, 0.4617925284591951, 0.4615444569148272, 0.46090029423362755, 0.4589757221336168, 0.45855995855995846, 0.4580246913580247, 0.458076701979141, 0.4573780129335685, 0.45711638347297257, 0.4566625854504642, 0.4563037785260007, 0.4561069633533401, 0.456181197315949, 0.4559834455667789, 0.4554158363682173, 0.45574635241301914, 0.45586584802271085, 0.45455624622291296]
    BCI_LWF_AAF1 = [0.46335815763159616, 0.46386099119755275, 0.4649298846825977, 0.4581238548417915, 0.46051093329888326, 0.46420950276775236, 0.46447377818661845, 0.4646445176720627, 0.46076207279450315, 0.4609048539112002, 0.4607470346199208, 0.46062521812801477, 0.4568041505221628, 0.45596046478023033, 0.45498808658056106, 0.45541656423247856, 0.45592530733522824, 0.4565153351342721, 0.45655999442029815, 0.45720263235139286, 0.4574804095429655, 0.4571956982142744, 0.4578644964438764, 0.4552537259635119, 0.4537374520120509, 0.45359125053151234, 0.45377653128877854, 0.45305249103256034, 0.45188444305394865, 0.4498140498112265, 0.44851988663972775, 0.44824932951310936, 0.44762326870912467, 0.4474365328285219, 0.44639650894138816, 0.44564052439299584, 0.44472982420099083, 0.44196210856544166, 0.441482967725629, 0.44028245934376803, 0.4403114620413714, 0.4392843421349718, 0.43893607289912595, 0.4379977971234993, 0.4372724460485905, 0.43702327985382, 0.4370931047530351, 0.43683095111316633, 0.4357731862429574, 0.43624362852558674, 0.4364111275417006, 0.43448480780730553]

    BCI_UCLGV_AAA = [0.4696969696969697, 0.4710998877665544, 0.47250280583613913, 0.4718013468013468, 0.47059483726150386, 0.4709128320239431, 0.4712201378868045, 0.47152076318742986, 0.46932285821174713, 0.4684062850729518, 0.46816651362105915, 0.4684343434343435, 0.46654579987913325, 0.4667308000641334, 0.4665918443696222, 0.46643518518518523, 0.46603287779758373, 0.46502057613168724, 0.46461692952921024, 0.46377665544332214, 0.46344396344396344, 0.4628609325579022, 0.4619138242326648, 0.4603675645342313, 0.45939393939393947, 0.4585383752050419, 0.4580995136550693, 0.45745149911816585, 0.457099732961802, 0.4563411896745231, 0.4561022410484777, 0.4549487934904602, 0.45435839880284323, 0.4536376840298409, 0.4528459195125862, 0.4521449058486096, 0.45131495131495136, 0.44943587926044076, 0.44807044807044816, 0.44681537598204263, 0.4455257178834414, 0.443963443963444, 0.4425260355492914, 0.4414600550964188, 0.4403541588726775, 0.43916215293026895, 0.43763879934092703, 0.4355359147025813, 0.43390824343205286, 0.4320987654320987, 0.4298210866838317, 0.42787921954588615]
    BCI_UCLGV_AAF1 = [0.46335815763159616, 0.4651915965547525, 0.4682688761243908, 0.4658232831118506, 0.46454793895523994, 0.4655949962788133, 0.46616164876185573, 0.4662955244040726, 0.4636369510056645, 0.46265337191445954, 0.4624186554761803, 0.46251992124216895, 0.4598570380619035, 0.4605208427190234, 0.4602700939434783, 0.4604061694532476, 0.46017797427474605, 0.4592305358900101, 0.4588092356398836, 0.45823124883093086, 0.45816167146033027, 0.4576923440209539, 0.45695875193755614, 0.4549482559501062, 0.4541351296275025, 0.4535859060878382, 0.45342190624901624, 0.453085430610503, 0.4528993155003215, 0.45222256915473197, 0.45217149873014373, 0.4512137781204815, 0.4508972356621949, 0.450424817331936, 0.4498786358583584, 0.449414469899374, 0.4487793853316496, 0.4466473577372744, 0.44536764244036536, 0.44411179941091294, 0.4429979225748198, 0.4415008256038969, 0.4402162054588186, 0.4392319737452727, 0.43826505960150414, 0.43724707314699585, 0.4357441500348895, 0.43348128898305066, 0.43180209559915683, 0.4298778205207882, 0.4271829186759945, 0.4249247495678059]

    BCI_CONDA_AAA = [0.4696969696969697, 0.4722222222222222, 0.47755331088664416, 0.4785353535353535, 0.47968574635241296, 0.4780209502431724, 0.478675645342312, 0.47874579124579125, 0.4781144781144781, 0.4771604938271604, 0.4745434139373533, 0.47413954358398797, 0.4738409738409738, 0.4735850569183902, 0.4734006734006734, 0.4714506172839506, 0.4712814418696772, 0.4707881281955356, 0.4709079095044007, 0.4702020202020202, 0.47007108118219226, 0.469594939291909, 0.46930659249499834, 0.4690422745978302, 0.46835016835016835, 0.46831563498230167, 0.46759778858544293, 0.4675124258457592, 0.466465420488409, 0.4657687991021324, 0.4654067557293364, 0.4648393658810326, 0.4635581403258171, 0.4630454875552915, 0.46281866281866285, 0.46216797605686494, 0.46170412837079505, 0.4605853860239826, 0.45982618204840436, 0.45899270482603816, 0.458446251129178, 0.45775212441879115, 0.45715553467491454, 0.45564228139985724, 0.4552188552188553, 0.45417947591860647, 0.4535544571005565, 0.45303731762065097, 0.45208319017842824, 0.4517171717171717, 0.45067230034550293, 0.450045325045325]
    BCI_CONDA_AAF1 = [0.46335815763159616, 0.4669087435978887, 0.4734259163040533, 0.4736625173228709, 0.4752800739172828, 0.4732214432865689, 0.47351071892263014, 0.4735491308842257, 0.4727041996521997, 0.47176783665508787, 0.4685027165873294, 0.46773646469225655, 0.4674390843764748, 0.4669992520252131, 0.4670399242548811, 0.4650138476921405, 0.4648141920827176, 0.46438816030332813, 0.4644272272793839, 0.4637846339051467, 0.46369376348001257, 0.4631447760774527, 0.4629018550725858, 0.4627965851036493, 0.46203890756305915, 0.4619851474457593, 0.4610070407195395, 0.46102714946595624, 0.459559521618973, 0.4587962039996041, 0.45837588126825957, 0.4577260542460839, 0.4562211452783596, 0.45562555329894067, 0.4554501663451885, 0.45458497925686703, 0.45401327770601135, 0.4525777246086323, 0.4516687891542435, 0.4504635456977624, 0.44981676166148327, 0.44896081347105415, 0.4483592280626207, 0.4464004562822044, 0.44576742611297815, 0.44414098335947666, 0.443171477654512, 0.4423353606214129, 0.44093469718366474, 0.4402736332970476, 0.43868533058874076, 0.4377111267633777]

    BCI_COTTA_AAA = [0.4696969696969697, 0.43490460157126826, 0.4481855592966704, 0.43925364758698093, 0.44848484848484854, 0.45145903479236815, 0.455988455988456, 0.45791245791245794, 0.459221848110737, 0.45993265993265997, 0.4616875828997041, 0.4633838383838384, 0.4642579642579643, 0.46556838223504887, 0.4662551440329218, 0.46692620650953987, 0.46629695649303493, 0.46608055867315124, 0.4656801937503691, 0.46557239057239047, 0.4660092993426326, 0.4652841546780939, 0.4644024788952324, 0.4635007482229705, 0.4625589225589226, 0.46311404644737986, 0.4620069002785053, 0.46218133718133725, 0.4624791981113821, 0.4626823793490461, 0.4620397523623331, 0.4614548260381594, 0.4617385981022345, 0.46160955964877537, 0.46190476190476193, 0.46123269734380856, 0.4611581278247946, 0.46101364522417165, 0.4609053497942388, 0.46091470258136924, 0.46101940817387976, 0.4609454331676554, 0.4607182940516274, 0.4601061116212631, 0.4598578376356154, 0.4594251695700971, 0.4593213458461685, 0.4592569210624767, 0.45933255457064986, 0.459270482603816, 0.4592438546686913, 0.45909954243287576]
    BCI_COTTA_AAF1 = [0.46335815763159616, 0.41939405750744824, 0.43688516100107083, 0.4235690280586688, 0.4356824555645349, 0.43881541788139167, 0.44450553696059636, 0.44727593151599054, 0.4484584479243223, 0.44981054424202005, 0.45194443306967763, 0.4539823760397506, 0.45546995606386914, 0.45747978059909855, 0.45813254972417705, 0.45857384095823417, 0.45712723156839774, 0.4567417022618231, 0.4560195865325465, 0.4559572329077362, 0.4565700934931312, 0.4553687505621608, 0.45432719858770354, 0.4527656318514391, 0.4506300052584152, 0.4513751373766584, 0.449670197866984, 0.44968605967974346, 0.4499473807331549, 0.4500697717434304, 0.4487597735837738, 0.4481626791165973, 0.4485838350167789, 0.4485105734852845, 0.44873891301004054, 0.4472524429178738, 0.44720118116532814, 0.44675051954278533, 0.44659478202066066, 0.4466766928060208, 0.44682253196394617, 0.44661779937130464, 0.44629361561940384, 0.4455175794481186, 0.444940690997259, 0.44413636378317667, 0.44398524768007097, 0.44404078017069654, 0.44411153034118606, 0.4438042495812634, 0.4438482646856688, 0.44345272107804595]

    BCI_OUR_AAA = [0.4696969696969697, 0.4761503928170595, 0.4818555929667041, 0.4782547699214366, 0.4801346801346802, 0.4804526748971194, 0.481561648228315, 0.4812710437710438, 0.48166853722409286, 0.481986531986532, 0.4823997551270278, 0.4819491208380097, 0.4822153155486489, 0.48216289882956553, 0.4823419378974935, 0.4828843995510662, 0.482504786426355, 0.4826038159371493, 0.4830173075787111, 0.4828563411896745, 0.48236331569664903, 0.48278236914600553, 0.4831893817401064, 0.4833520389075945, 0.48350168350168354, 0.4838772338772339, 0.4842665336492497, 0.48454785954785956, 0.48510004257130696, 0.4855218855218855, 0.4858260019550342, 0.48593574635241304, 0.48610685984423363, 0.48621839308113823, 0.48624338624338626, 0.48654757451053743, 0.4867746534413201, 0.4866648945596314, 0.4869924314368759, 0.4870510662177329, 0.48705209274314964, 0.4871198760087649, 0.48744551457729757, 0.4874119987756352, 0.4874298540965208, 0.48759332454984633, 0.48779759772667575, 0.4878881406659185, 0.48787191644334504, 0.488013468013468, 0.4880394357518541, 0.4881507381507382]
    BCI_OUR_AAF1 = [0.46335815763159616, 0.47169634081442846, 0.4781164154886219, 0.4739871924085747, 0.47610954526258265, 0.4761664236031913, 0.4775141583056465, 0.47714671675553877, 0.4776026208811967, 0.4782042117742978, 0.47865040700370404, 0.47839919997162217, 0.47867869511101013, 0.47853192987515875, 0.47866437949299523, 0.47913468118373004, 0.4788521620482854, 0.4790276489368478, 0.47956763299595834, 0.47926847323014493, 0.4786019446520741, 0.479117709414319, 0.47961300888623265, 0.4796996174937345, 0.47969799730572577, 0.48012625768859635, 0.48051695724336213, 0.480911166998691, 0.48147328024752584, 0.4818877517949476, 0.482197338198368, 0.48242812147515063, 0.48255489400896173, 0.4826655358321447, 0.4827121270090902, 0.48305010562340833, 0.48333735288674906, 0.48332717955824583, 0.48361921124216967, 0.48368871895144805, 0.48359321314069315, 0.48358011687773034, 0.483952272013067, 0.4838704555127189, 0.4838890617560506, 0.4840807723248819, 0.48429452690253827, 0.484306049475653, 0.484340394856216, 0.4844684945075952, 0.4845422170761814, 0.4846757124231196]


    ISRUC_AAA = [ISRUC_MMD_AAA, ISRUC_TSTCC_AAA, ISRUC_EWC_AAA, ISRUC_LWF_AAA,
             ISRUC_UCLGV_AAA, ISRUC_CONDA_AAA, ISRUC_COTTA_AAA, ISRUC_OUR_AAA][::-1]
    Methods = ['MMD', 'TSTCC', 'EWC', 'LwF', 'UCL-GV', 'ConDA', 'CoTTA', 'BrainUICL'][::-1]
    ISRUC_LIST = []
    for i, data in enumerate(ISRUC_AAA):
        for j in range(len(data)):
            ISRUC_LIST.append({
                'y': data[j],
                'x': j,
                'method': Methods[i]
            })
    ISRUC_DF = pd.DataFrame(ISRUC_LIST)

    ISRUC_AAF1 = [ISRUC_MMD_AAF1, ISRUC_TSTCC_AAF1, ISRUC_EWC_AAF1, ISRUC_LWF_AAF1,
                 ISRUC_UCLGV_AAF1, ISRUC_CONDA_AAF1, ISRUC_COTTA_AAF1, ISRUC_OUR_AAF1][::-1]
    Methods = ['MMD', 'TSTCC', 'EWC', 'LwF', 'UCL-GV', 'ConDA', 'CoTTA', 'BrainUICL'][::-1]
    ISRUC_LIST_F1 = []
    for i, data in enumerate(ISRUC_AAF1):
        for j in range(len(data)):
            ISRUC_LIST_F1.append({
                'y': data[j],
                'x': j,
                'method': Methods[i]
            })
    ISRUC_DF_F1 = pd.DataFrame(ISRUC_LIST_F1)

    FACED_AAA = [FACED_MMD_AAA, FACED_TSTCC_AAA, FACED_EWC_AAA, FACED_LWF_AAA,
                 FACED_UCLGV_AAA, FACED_CONDA_AAA, FACED_COTTA_AAA, FACED_OUR_AAA][::-1]
    Methods = ['MMD', 'TSTCC', 'EWC', 'LwF', 'UCL-GV', 'ConDA', 'CoTTA', 'BrainUICL'][::-1]
    FACED_LIST = []
    for i, data in enumerate(FACED_AAA):
        for j in range(len(data)):
            FACED_LIST.append({
                'y': data[j],
                'x': j,
                'method': Methods[i]
            })
    FACED_DF = pd.DataFrame(FACED_LIST)

    FACED_AAF1 = [FACED_MMD_AAF1, FACED_TSTCC_AAF1, FACED_EWC_AAF1, FACED_LWF_AAF1,
                  FACED_UCLGV_AAF1, FACED_CONDA_AAF1, FACED_COTTA_AAF1, FACED_OUR_AAF1][::-1]
    Methods = ['MMD', 'TSTCC', 'EWC', 'LwF', 'UCL-GV', 'ConDA', 'CoTTA', 'BrainUICL'][::-1]
    FACED_LIST_F1 = []
    for i, data in enumerate(FACED_AAF1):
        for j in range(len(data)):
            FACED_LIST_F1.append({
                'y': data[j],
                'x': j,
                'method': Methods[i]
            })
    FACED_DF_F1 = pd.DataFrame(FACED_LIST_F1)

    BCI_AAA = [BCI_MMD_AAA, BCI_TSTCC_AAA, BCI_EWC_AAA, BCI_LWF_AAA,
                 BCI_UCLGV_AAA, BCI_CONDA_AAA, BCI_COTTA_AAA, BCI_OUR_AAA][::-1]
    Methods = ['MMD', 'TSTCC', 'EWC', 'LwF', 'UCL-GV', 'ConDA', 'CoTTA', 'BrainUICL'][::-1]
    BCI_LIST = []
    for i, data in enumerate(BCI_AAA):
        for j in range(len(data)):
            BCI_LIST.append({
                'y': data[j],
                'x': j,
                'method': Methods[i]
            })
    BCI_DF = pd.DataFrame(BCI_LIST)

    BCI_AAF1 = [BCI_MMD_AAF1, BCI_TSTCC_AAF1, BCI_EWC_AAF1, BCI_LWF_AAF1,
                  BCI_UCLGV_AAF1, BCI_CONDA_AAF1, BCI_COTTA_AAF1, BCI_OUR_AAF1][::-1]
    Methods = ['MMD', 'TSTCC', 'EWC', 'LwF', 'UCL-GV', 'ConDA', 'CoTTA', 'BrainUICL'][::-1]
    BCI_LIST_F1 = []
    for i, data in enumerate(BCI_AAF1):
        for j in range(len(data)):
            BCI_LIST_F1.append({
                'y': data[j],
                'x': j,
                'method': Methods[i]
            })
    BCI_DF_F1 = pd.DataFrame(BCI_LIST_F1)


    rc = {'font.sans-serif': ['Times New Roman']}
    sns.set(font_scale=2.8, style=None, rc=rc)
    plt.figure(figsize=(40, 12))
    ax1 = plt.subplot(2, 3, 1)
    sns.lineplot(data=ISRUC_DF, x='x', y='y', style='method', hue='method', markers=True, legend=False, linewidth=3.5, markersize=6.5)
    ax1.set_ylabel("AAA")
    ax1.set_xlabel("")
    ax1.set_title("ISRUC", fontsize=30)
    ax1.set_yticks([0.57, 0.60, 0.65, 0.70, 0.75, 0.77])
    ax1.set_ylim(0.58, 0.76)
    ax1.set_xticks([], [])
    ax1.legend(loc='center', prop={"size": 14})
    ax1.grid(alpha=0.4)

    ax2 = plt.subplot(2, 3, 4)
    sns.lineplot(data=ISRUC_DF_F1, x='x', y='y', style='method', hue='method', markers=True, legend=False, linewidth=3.5, markersize=6.5)
    ax2.set_xlabel("")
    ax2.set_ylabel("AAF1")
    ax2.set_yticks([0.52, 0.55, 0.60, 0.65, 0.70, 0.74])
    ax2.set_ylim(0.53, 0.73)
    ax2.legend(loc="lower right", prop={"size": 14})
    ax2.set_xticks([], [])
    ax2.grid(alpha=0.4)
    #
    ax3 = plt.subplot(2, 3, 2)
    sns.lineplot(data=FACED_DF, x='x', y='y', style='method', hue='method', markers=True, legend=False, linewidth=3.5, markersize=6.5)
    ax3.set_title("FACED", fontsize=30)
    ax3.set_xlabel("")
    ax3.set_ylabel("")
    ax3.set_yticks([0.20, 0.25, 0.30, 0.35, 0.39])
    ax3.set_ylim(0.21, 0.38)
    ax3.grid(alpha=0.4)
    ax3.set_xticks([], [])

    ax4 = plt.subplot(2, 3, 5)
    sns.lineplot(data=FACED_DF_F1, x='x', y='y', style='method', hue='method', markers=True, legend=False, linewidth=3.5, markersize=6.5)
    ax4.set_xlabel("")
    ax4.set_xticks([], [])
    ax4.legend(loc="lower right", prop={"size": 14})
    ax4.set_ylabel("")
    ax4.set_yticks([0.14, 0.20, 0.25, 0.30, 0.35, 0.37])
    ax4.set_ylim(0.15, 0.36)
    ax4.grid(alpha=0.4)
    #
    ax5 = plt.subplot(2, 3, 3)
    sns.lineplot(data=BCI_DF, x='x', y='y', style='method', hue='method', markers=True, legend=False, linewidth=3.5, markersize=6.5)
    ax5.set_title("Physionet", fontsize=30)
    ax5.grid(alpha=0.4)
    ax5.set_ylabel("")
    ax5.set_yticks([0.42, 0.43, 0.45, 0.47, 0.49, 0.50])
    ax5.set_ylim(0.425, 0.492)
    ax5.set_xlabel("")
    ax5.set_xticks([], [])

    ax6 = plt.subplot(2, 3, 6)
    sns.lineplot(data=BCI_DF_F1, x='x', y='y', style='method', hue='method', markers=True, legend=True, linewidth=3.5, markersize=6.5)

    ax6.set_xlabel("")
    ax6.set_ylabel("")
    ax6.legend(loc="lower right", prop={"size": 30}, bbox_to_anchor=(0.65, -0.25), ncol=8, frameon=False, markerscale=2.8)
    ax6.grid(alpha=0.4)
    ax6.set_xticks([], [])

    plt.subplots_adjust(wspace=0.12, hspace=0.1)
    plt.savefig("compared_photo2.pdf")
    # plt.show()


if __name__ == '__main__':
    compared_plot()

    """Stability 稳定性实验 数据仓库"""
    #######ISRUC########
    ISRUC_Stability_1_AAA = [0.7204918032786886, 0.7291569086651054, 0.7304839968774396, 0.7326258782201406, 0.7328922716627635, 0.7354898516783762, 0.730361324857812, 0.7300424473067916, 0.7303734061930783, 0.7317564402810305, 0.7326325314030232, 0.7316891100702576, 0.7317780580075662, 0.732138675142188, 0.7329156908665105, 0.734375, 0.7349566055930569, 0.735236143637783, 0.7347251325033897, 0.734885831381733, 0.7350814096130256, 0.7343863104109005, 0.7349047958456368, 0.735106850117096, 0.7352740046838407, 0.7365947577013151, 0.7366770752016654, 0.7373870859819337, 0.7378603730921424, 0.7380230288836845, 0.7381355291984588, 0.7381733021077284, 0.7384163650557093, 0.7382060201129631, 0.7384476413516226, 0.7388205828779598, 0.7387809355022469, 0.738845063478368, 0.7388128265177445, 0.7389168618266979, 0.7397084023533443, 0.7396467603434816, 0.7396587876477316, 0.7388266446668085, 0.7389110070257611, 0.7390362488544954, 0.7391848123972294, 0.739177156518345, 0.7393717440137648]
    ISRUC_Stability_1_AAF1 = [0.6986579952263389, 0.7076425042382122, 0.7103420281149102, 0.7132045797461857, 0.7131166325961222, 0.7159768016950893, 0.7096201848794333, 0.7092783927343123, 0.7098303723583297, 0.711158642095811, 0.7117808243416276, 0.7114301711538314, 0.7116347760729541, 0.7119639840797418, 0.7126381955992348, 0.7142573146579946, 0.7149541735707454, 0.715071649730537, 0.7145720079556289, 0.7147786811293837, 0.7149135876155969, 0.7140396419890972, 0.7148325682391348, 0.7150191802825517, 0.7152882560706463, 0.7165441896357545, 0.7165901976944047, 0.7173858083755444, 0.7179388316263297, 0.7180693932854212, 0.7181274086645154, 0.71811993211231, 0.7183165319565591, 0.7180260690164489, 0.7181695520951644, 0.7186319101533996, 0.7186166538478912, 0.7186816430137707, 0.7187324717180957, 0.7188911168853, 0.719609744286434, 0.7195780943809971, 0.7196393950814826, 0.718860837608926, 0.7189791406330696, 0.7190918871644744, 0.7192406504793255, 0.7192731438182772, 0.7195329348722085]

    ISRUC_Stability_2_AAA = [0.7204918032786886, 0.7287470725995316, 0.7273419203747072, 0.7316744730679157, 0.7322131147540983, 0.7349141295862607, 0.7399046503847441, 0.7388612412177986, 0.7376854020296643, 0.7391276346604215, 0.7384553970619545, 0.7388905152224825, 0.7396234912628356, 0.7392313482770158, 0.7388641686182671, 0.7393259660421545, 0.7388173302107728, 0.7384627894873796, 0.7381116726241834, 0.738269906323185, 0.7381008140961302, 0.7392511177347242, 0.7402912127074635, 0.737682962529274, 0.7350655737704918, 0.7350747613042695, 0.7352437331945528, 0.7354278186684509, 0.7357001534361625, 0.7362919594067134, 0.7365943945002643, 0.7366528834894613, 0.736732666240863, 0.7368731918997107, 0.7370859819337571, 0.7375374056726516, 0.7374058484714222, 0.7374291260939233, 0.7376478712544287, 0.7377093091334894, 0.7377534700405552, 0.7377467380394781, 0.7377294265018245, 0.7379590696189056, 0.7381355711683579, 0.7382267589858466, 0.7382405700333847, 0.7382440476190476, 0.7381912249677388]
    ISRUC_Stability_2_AAF1 = [0.6986579952263389, 0.7095851191148504, 0.7064194791304611, 0.7111801705252458, 0.7115821471598596, 0.7146290032373749, 0.7192775083219299, 0.7183769750736111, 0.7170518639624857, 0.7187564900476963, 0.7177731362534493, 0.7183426808436434, 0.7191469052563959, 0.7188684706214177, 0.7185135375997057, 0.7191553318562273, 0.7186383507513322, 0.7182591991337435, 0.7179539193545633, 0.7181970816630149, 0.7179953767004259, 0.7192829318053728, 0.7204357138011409, 0.7177756343470022, 0.7153619850646045, 0.7153151315706571, 0.7153323444033489, 0.7156147560105462, 0.7158986984446878, 0.7165720029071192, 0.7169859821302155, 0.7171025046112438, 0.7171789203080088, 0.7172292073575715, 0.7174186229601244, 0.7180157473927238, 0.7178560266306377, 0.7178543653150676, 0.7180698361801674, 0.7181359500976732, 0.7182159643348491, 0.7181286539968128, 0.7180667642782421, 0.7183174956059072, 0.7185287678109133, 0.7185652595641171, 0.7185533710731551, 0.718515018895533, 0.7184930687778788]

    ISRUC_Stability_3_AAA = [0.7204918032786886, 0.7238875878220141, 0.7183645589383295, 0.7239314988290398, 0.7255386416861827, 0.7296448087431694, 0.7291736366677819, 0.7314841920374708, 0.7299570647931305, 0.7308665105386418, 0.7319672131147542, 0.7319525761124123, 0.7340614303729059, 0.7339913014386085, 0.733466042154567, 0.7339212529274004, 0.7334343573494971, 0.7335577673692426, 0.7319394798471588, 0.73211943793911, 0.7319895171183227, 0.732137534596551, 0.7323312289990835, 0.7318208430913349, 0.7317423887587822, 0.7317848135471087, 0.7322707953855496, 0.7326467882234863, 0.7328757167083907, 0.7322970335675254, 0.7322146256704692, 0.7328783665105386, 0.7330015612802497, 0.7330916792946687, 0.733559718969555, 0.733826112412178, 0.7340512057725173, 0.733979415752496, 0.7341935387017354, 0.7344159836065574, 0.7345304735248757, 0.7344192595070814, 0.7347026305756766, 0.735408239301682, 0.7358743169398908, 0.7358275633845841, 0.736368279435946, 0.73639368657299, 0.7363666778186685]
    ISRUC_Stability_3_AAF1 = [0.6986579952263389, 0.7021434877226724, 0.6952104392486875, 0.7015466082124845, 0.703691702263517, 0.7081270289028595, 0.7077725997797238, 0.7102451662452993, 0.7085190339519358, 0.7096066344677296, 0.7107937349682785, 0.7105311057819842, 0.7129859967185165, 0.7128131106498975, 0.7123952028439106, 0.713088780013999, 0.7126305856584333, 0.712637514900186, 0.7111729068712895, 0.7113034352730643, 0.7110780252374406, 0.7113613833494988, 0.7116394119430597, 0.7111950521610729, 0.7111680140289923, 0.7111623766785586, 0.7117207540101146, 0.7122553014993501, 0.7125941858531358, 0.7119447172651295, 0.7118644834062706, 0.7125653563713343, 0.7128040100067464, 0.7129299261695463, 0.7133709436647134, 0.7136796393580671, 0.7138654510323134, 0.713847754954062, 0.7139895836470002, 0.7142396135428932, 0.714360531539264, 0.7142602605166962, 0.7145730067591193, 0.7152882429948698, 0.7158275684611118, 0.7156705221669359, 0.7162900657317639, 0.7162507287045381, 0.7162769230233792]

    ISRUC_Stability_4_AAA = [0.7204918032786886, 0.7310304449648712, 0.7325722092115535, 0.7221165105386417, 0.7238407494145199, 0.7208430913348947, 0.7245734359317498, 0.7260245901639344, 0.7277127244340359, 0.7286943793911007, 0.7300404513519267, 0.7300400078064012, 0.7295667447306792, 0.7301187688190031, 0.7319320843091336, 0.7325929449648713, 0.7330451852872297, 0.7332585219880303, 0.7330857882410946, 0.7332406323185012, 0.7345293855247018, 0.7350995316159252, 0.7360732104673661, 0.7359411592505856, 0.7360374707259955, 0.7368920014411819, 0.7370695637089081, 0.737144529943125, 0.7376302188484215, 0.7379527712724436, 0.7377294704238123, 0.7378128659250586, 0.737955077709176, 0.7378581760573081, 0.7380545332887253, 0.7384286364819151, 0.7384359769605671, 0.7381810057931715, 0.738179307031766, 0.7381850117096018, 0.738193294110927, 0.7382848221255716, 0.7382155111377375, 0.7387641047477114, 0.7386065573770493, 0.7385334996436209, 0.7384486023219894, 0.7378073770491804, 0.7379152129235771]
    ISRUC_Stability_4_AAF1 = [0.6986579952263389, 0.7110834060206805, 0.7139920960414893, 0.7029316384816826, 0.7034415089291391, 0.6989603653725589, 0.7036727280886703, 0.705222116151262, 0.7072710207119863, 0.7085432507004336, 0.7098422762872635, 0.7097743826553667, 0.7092949871745134, 0.7098094154652587, 0.7116556644655343, 0.712339805311234, 0.7125531373953745, 0.7129540667722087, 0.7127311717618671, 0.7130215678376356, 0.7143753298851121, 0.7149864574804673, 0.716134103688266, 0.7161057567613085, 0.7162561418535016, 0.717235230288911, 0.7173448955341255, 0.7174813455063871, 0.7179108437796218, 0.7182910636889949, 0.7180373925238677, 0.7181785538161826, 0.7183774111947115, 0.7180420829147393, 0.718211431599889, 0.7184769690356763, 0.7183964347244144, 0.718146000779868, 0.7181897418240286, 0.7181693950672712, 0.7181350358457588, 0.7181724483610191, 0.7181194357668479, 0.7188019810955844, 0.7186580582186209, 0.7185064433119912, 0.7183362566892771, 0.717793744899001, 0.7179031372032396]

    ISRUC_Stability_5_AAA = [0.7204918032786886, 0.7353922716627634, 0.7355386416861828, 0.7368559718969556, 0.7357377049180329, 0.7361631537861046, 0.7360070257611241, 0.7362558548009368, 0.7315638823835546, 0.7319086651053864, 0.7329625292740047, 0.7342213114754098, 0.7345117996757341, 0.7358230177316828, 0.7360850897736143, 0.7360253220140516, 0.736416861826698, 0.7368462138953942, 0.7370947861456921, 0.7380532786885247, 0.7373396899743504, 0.7379444326165637, 0.7378474697077692, 0.7379927790788446, 0.7377822014051522, 0.7378557917492343, 0.7375639691213463, 0.7379077450652393, 0.7377452959702818, 0.7378005464480875, 0.7375103875500492, 0.7378037177985949, 0.7385015257966078, 0.7391341782614685, 0.7393710270993643, 0.7392727036169658, 0.7397050446230774, 0.7396354616048317, 0.7394598570828078, 0.7397701990632319, 0.7397555263608843, 0.7394543883127023, 0.7394436577528458, 0.7397474451777731, 0.7400871714806142, 0.7401919356481012, 0.7402548706960985, 0.7404127634660421, 0.740387372747694]
    ISRUC_Stability_5_AAF1 = [0.6986579952263389, 0.7171803688435034, 0.7164169441590674, 0.717231146465163, 0.7164380618214599, 0.7169355280577406, 0.7169134466188171, 0.7174032671019517, 0.7130088549272355, 0.7135710972809762, 0.714586766410807, 0.7152699209037273, 0.7155254393595742, 0.717227880683448, 0.717475052370016, 0.717561868678064, 0.7176902798739448, 0.7179590302122459, 0.7181468787240871, 0.7191755541499452, 0.7181929998470179, 0.7189077817456545, 0.7185828154256807, 0.7187209977753132, 0.7186480856927421, 0.7186350954059567, 0.7183138242765397, 0.7186284315083461, 0.7184259243124351, 0.7185159684602712, 0.7181730342611704, 0.7184900975377372, 0.7191292800516755, 0.7198551830404375, 0.7200682428162961, 0.7199499773394118, 0.7202614804279733, 0.720064922734815, 0.719834874361924, 0.720138956745302, 0.7200395770790534, 0.7197003417279758, 0.7196037562782289, 0.719941330169032, 0.7202946382953235, 0.7203893487379606, 0.7203988207378089, 0.7205422191329752, 0.7205036662910435]

    ISRUC_Stability_6_AAA = [0.7204918032786886, 0.7234192037470726, 0.7269906323185013, 0.7293764637002342, 0.7288173302107729, 0.7286690085870414, 0.7307544329207093, 0.7318793911007027, 0.7318696330991413, 0.7323126463700235, 0.7328826910794124, 0.7336699843871974, 0.7346829400108088, 0.7354884576781532, 0.735854800936768, 0.7360948477751756, 0.7355834136933462, 0.7344294821753838, 0.7348853691606064, 0.7349414519906323, 0.7351065016170402, 0.735307110921865, 0.7354520924549435, 0.7346531030444966, 0.7350983606557377, 0.7355701675373807, 0.7360026888715415, 0.7361638507862163, 0.7363522571267062, 0.7366022638563624, 0.7369740122384228, 0.7369639197892273, 0.7371868568589881, 0.7380286540845846, 0.73796587487454, 0.7388693728857664, 0.738860054433825, 0.7390391963515345, 0.7397841229808443, 0.7398814402810304, 0.7402981664477066, 0.7403632764581242, 0.7407221828876422, 0.7407068341494571, 0.740736403851158, 0.7409454230730069, 0.7408577906223529, 0.7408665105386416, 0.740845003106629]
    ISRUC_Stability_6_AAF1 = [0.6986579952263389, 0.7027865691185531, 0.7063565800852505, 0.7096234788834697, 0.7092269771857842, 0.7091250262100938, 0.7112474464643608, 0.7124957077942677, 0.7121762611900138, 0.7124070812264967, 0.7132436515863995, 0.7138817855422888, 0.7152918152451732, 0.7160522839218013, 0.7164666960100128, 0.7166351534922907, 0.7158665288975652, 0.7144079414072273, 0.7149188625547215, 0.715031297165804, 0.7152071646075564, 0.7154627567981859, 0.7156496686751039, 0.7148556253318002, 0.715335692937582, 0.715890355147583, 0.7163428691629771, 0.7164404909853889, 0.7165472615534314, 0.7168515873245521, 0.7171871193984783, 0.7172242322523714, 0.7173835511186332, 0.7182311820130084, 0.7182384597208549, 0.7190140823584787, 0.7190081449650397, 0.7191761360414657, 0.7199225040002115, 0.7200213289383959, 0.7205428627528858, 0.720673736440565, 0.7209978398745073, 0.720918627612564, 0.7210090510277196, 0.7211672052406644, 0.7210436010200755, 0.7210209328857685, 0.7209871453260605]

    ISRUC_Stability_7_AAA = [0.7204918032786886, 0.719115925058548, 0.7289032006245121, 0.7334601873536299, 0.7345784543325526, 0.7360753317720531, 0.7375041820006691, 0.7375073185011709, 0.736911267239136, 0.7378688524590162, 0.7373908878007238, 0.7384514051522247, 0.7387182489641505, 0.7385245901639343, 0.7394457455113191, 0.7390954332552693, 0.7396576663452266, 0.7395068956544366, 0.7381024282016516, 0.7382757611241217, 0.7384437381509981, 0.7386869278262721, 0.7390438855513695, 0.7392174082747852, 0.739967213114754, 0.7397788686723111, 0.7401335761991499, 0.7398732853797256, 0.7398388920293952, 0.7396272443403592, 0.7395897862053336, 0.7396443208430914, 0.7394897452274503, 0.7396232263397162, 0.739158581465373, 0.7389962269060629, 0.7389549971517184, 0.7393380993467273, 0.7391115714886206, 0.739025175644028, 0.7397398183583709, 0.7392564402810303, 0.7392094657153748, 0.7393296252927399, 0.7394678636481915, 0.7394562671825679, 0.7393268224625043, 0.7392893735362999, 0.7395294651818574]
    ISRUC_Stability_7_AAF1 = [0.6986579952263389, 0.6976277605993189, 0.70917434076705, 0.7138776032635901, 0.7153903256946781, 0.7172126739173684, 0.7187454524119005, 0.7191751945414486, 0.7186375333506851, 0.7198284071222314, 0.7193935762325977, 0.7205038767878138, 0.7206851407218203, 0.7206017632983505, 0.7216875050312932, 0.7213286865700869, 0.7219791714336269, 0.7217965026801316, 0.7202251608850251, 0.7203186069266819, 0.7204629267309575, 0.7205900548103552, 0.7208428887163932, 0.7210750667310007, 0.7218418134572877, 0.7215400840278234, 0.72192258978803, 0.7215689790342593, 0.7214685503690401, 0.7211370762817749, 0.7211029551088178, 0.7211231663611963, 0.72084310333075, 0.7209424235003103, 0.7204683756083243, 0.7202627944282791, 0.72014295355464, 0.72044032198274, 0.7201951678897272, 0.7200814185232232, 0.7208673739508742, 0.7202153511143161, 0.7200610013180188, 0.7201365766509361, 0.7201394192921365, 0.7200881207691066, 0.7199334294133378, 0.719870912442547, 0.7200740296170818]

    ISRUC_Stability_8_AAA = [0.7204918032786886, 0.7084894613583138, 0.7233216237314598, 0.7276200234192038, 0.727857142857143, 0.7333723653395786, 0.7375292740046839, 0.7362558548009368, 0.7364754098360655, 0.7369496487119438, 0.7374494358100915, 0.7380074160811865, 0.737358133669609, 0.7383196721311475, 0.7382630757220919, 0.7394833138173302, 0.7387346741975479, 0.7379195940671351, 0.7386139529150747, 0.7387500000000001, 0.7380115980818558, 0.737944432616564, 0.7386773241014154, 0.7396052888368462, 0.7394543325526932, 0.7393802918393082, 0.7395958018908838, 0.7397896453663433, 0.739711701526286, 0.7396057767369243, 0.7398126463700234, 0.7398437499999999, 0.7398924845646155, 0.7399194103871055, 0.7401840080294412, 0.7400175644028102, 0.7398901829229697, 0.7400221866140761, 0.739624992493845, 0.7396692037470725, 0.7397141143542583, 0.7400677484108397, 0.7400645389684657, 0.739989621034703, 0.7398269581056466, 0.7398711943793911, 0.7397678010862524, 0.7398565573770494, 0.7398508818047126]
    ISRUC_Stability_8_AAF1 = [0.6986579952263389, 0.6883443232646581, 0.7033800742255053, 0.7086040246767612, 0.7094490846906101, 0.7151498330389305, 0.7189175191454898, 0.7177611840718355, 0.7179895309423127, 0.7186829430047028, 0.7189784600506836, 0.7194690990376157, 0.7186496561093658, 0.7197384744558334, 0.7196620600645812, 0.7206926988814982, 0.719807414897226, 0.7189846026342925, 0.719777526312776, 0.7198799499067934, 0.7187642081318474, 0.7184834217091972, 0.719107007412253, 0.7200077301518609, 0.7200183536466558, 0.7197049538651737, 0.7198654538820265, 0.7201588089261763, 0.7200165943391672, 0.7199288986281009, 0.7201462503833251, 0.720218140496247, 0.7202311710150884, 0.7203404113864913, 0.7205567731790377, 0.7204295118278251, 0.7203338094723469, 0.7204501161509635, 0.7199951696785434, 0.720020056809712, 0.7200265866332657, 0.7205078458845939, 0.7204835413948967, 0.720423393470774, 0.7201538859604397, 0.7201789105096728, 0.7199322929515526, 0.7200221350747004, 0.7199859287750068]

    ISRUC_Stability_9_AAA = [0.7204918032786886, 0.7388173302107728, 0.748048399687744, 0.7438817330210772, 0.7449063231850117, 0.7369047619047618, 0.7367597858815657, 0.7356337822014051, 0.735135310954983, 0.7369613583138173, 0.7384234617841176, 0.7392027712724434, 0.7388623671410557, 0.7388424222147876, 0.7382279469164714, 0.7380525468384075, 0.7371435459429674, 0.7375097580015613, 0.737569333168988, 0.7376697892271662, 0.7380366900858704, 0.7380349159037682, 0.737862743101517, 0.7378342115534738, 0.737992974238876, 0.7380584579355072, 0.738242692341053, 0.738227668116427, 0.7384115319389486, 0.7380913348946136, 0.7380580947344565, 0.7353117681498829, 0.7353026754666099, 0.735738393718143, 0.736758113081298, 0.7369568045797554, 0.7369422115323754, 0.7372596450141747, 0.7372680598090434, 0.7370008782201405, 0.7372608099617295, 0.7374163599866175, 0.7373073362017318, 0.7376916116670214, 0.7378532396565182, 0.737870379798391, 0.7385482585081466, 0.7385245901639345, 0.7386022558906467]
    ISRUC_Stability_9_AAF1 = [0.6986579952263389, 0.7192297335436962, 0.7298757280792181, 0.7252186991261576, 0.7262627333589423, 0.7179096948813327, 0.7180501610474206, 0.7162891959189854, 0.7153604332567913, 0.7175095215550092, 0.7191254186330996, 0.719797125894865, 0.7192332774666936, 0.7193141200046178, 0.7187734914128681, 0.7184308305262446, 0.7174936525765611, 0.7178152941898388, 0.7180300109554942, 0.7180205239309634, 0.7185012527398552, 0.7185274624747555, 0.7183793672554953, 0.7182758132334998, 0.7183025499887076, 0.7184765432756106, 0.7186710054718057, 0.7185928812087251, 0.7186765546176686, 0.7182306390977444, 0.7181898574518152, 0.7153831789241714, 0.7153483254720797, 0.7157848441133635, 0.7169467937476051, 0.7170066835765956, 0.7170231108885444, 0.7173476126611887, 0.7172978960309631, 0.7169495389310901, 0.7171386301192565, 0.7173190381411257, 0.7172280784446051, 0.7176444406991427, 0.7178185101771941, 0.7178204338967068, 0.7184549784988343, 0.7184416352875944, 0.7184975008418502]

    ISRUC_Stability_10_AAA = [0.7204918032786886, 0.7381733021077284, 0.7400468384074941, 0.7233899297423887, 0.7255620608899297, 0.7255464480874316, 0.726012044161927, 0.7271004098360656, 0.7263010668748374, 0.7265690866510539, 0.7278049819033426, 0.7308304059328651, 0.7313817330210773, 0.7323937771830044, 0.7329000780640126, 0.7323660714285714, 0.7327558892409423, 0.732907233931824, 0.7331628250955257, 0.7336768149882904, 0.733810081409613, 0.7345113902490952, 0.7345916912738011, 0.7345482045277127, 0.7348477751756441, 0.7346536660061251, 0.7346972851071213, 0.7349406155904986, 0.7352660906080919, 0.7352322404371586, 0.7352931177759313, 0.7358569964871194, 0.73579589809098, 0.736516737842678, 0.7366527266644363, 0.73683970856102, 0.7367713146401671, 0.7369730679156908, 0.7373641385936468, 0.7376009953161592, 0.7375207060033129, 0.7376561280249805, 0.7373699689559392, 0.7373895571641473, 0.7375149622690607, 0.7376221871499847, 0.7381047884797449, 0.7381818403590946, 0.7381243129570331]
    ISRUC_Stability_10_AAF1 = [0.6986579952263389, 0.716304153522082, 0.7188833419237115, 0.703448369804532, 0.7056609918144764, 0.7063100096912955, 0.7069981921547023, 0.7073648066641217, 0.705946141823257, 0.7060506250747483, 0.707452432104732, 0.7101917052794984, 0.7108858372799653, 0.7121165844920326, 0.7127228899376016, 0.7120937915890937, 0.7124031793786749, 0.7124951758522292, 0.7127491512109916, 0.7132843738956596, 0.7133459104848169, 0.7141095182109152, 0.7142483915169899, 0.7142534864771578, 0.7145814065564664, 0.7143224444393425, 0.7143249748014043, 0.7146015501407798, 0.714865639862976, 0.7148985390884948, 0.7148554476087569, 0.7153455788663801, 0.7153914019252507, 0.7162311857982011, 0.7162870367313008, 0.7165286662731671, 0.7164354490409376, 0.7166636022680981, 0.717091614674716, 0.7173386028448776, 0.7172223240196322, 0.7173171324564763, 0.7169674707868502, 0.7169070595404723, 0.7171096377032812, 0.7172777287921469, 0.7177202496301212, 0.7177484323940316, 0.717661246782961]

    ##########FACED###########
    FACE_Stability_1_AAA = [0.23958333333333334, 0.32961309523809523, 0.33829365079365076, 0.3601190476190476, 0.3547619047619047, 0.3526785714285714, 0.3656462585034013, 0.37313988095238093, 0.3683862433862434, 0.3663690476190476, 0.3694534632034632, 0.3707837301587302, 0.3736263736263736, 0.37096088435374147, 0.364781746031746, 0.36160714285714285, 0.3647584033613445, 0.361359126984127, 0.3603540100250627, 0.3620535714285714, 0.3650085034013606, 0.36295995670995673, 0.36167184265010355, 0.35993303571428575, 0.3566666666666667, 0.35760073260073266, 0.35240299823633164, 0.35193452380952384, 0.3537048440065682, 0.35649801587301594, 0.35949500768049164, 0.36142113095238093, 0.3629599567099567, 0.36436449579831937, 0.360374149659864, 0.3580935846560847, 0.3575450450450451, 0.35945332080200504, 0.35844017094017094, 0.35859375, 0.3601553426248548, 0.35866638321995464, 0.3595653377630122, 0.36116747835497837, 0.360515873015873, 0.36002199792960665, 0.36100557244174264, 0.3608320932539683, 0.3619108357628766, 0.36333333333333334, 0.36081932773109243, 0.36009043040293043, 0.36025943396226423, 0.36124889770723106, 0.36109307359307363, 0.3623511904761905, 0.3629908103592315, 0.3610170361247948, 0.3595641646489105, 0.35925099206349215, 0.35902127244340365, 0.3569268433179725]
    FACE_Stability_1_AAF1 = [0.1874819175619343, 0.2981605910572829, 0.3098620961927197, 0.33655933846452146, 0.330118317335643, 0.32907264162574107, 0.3442747493372226, 0.3527312589063031, 0.34720395360627915, 0.3441915983290368, 0.34813170646909075, 0.3498734582414788, 0.3533295078282801, 0.3500848899424024, 0.34122801428230964, 0.33767500310862, 0.34183044683274344, 0.33796731468749336, 0.33723750842682765, 0.3392838556150627, 0.3428922275196534, 0.34083085258665335, 0.3392371525556863, 0.33711446722854105, 0.33266462824157544, 0.33373408876260446, 0.32707958167730017, 0.3265058303839727, 0.3286934848342775, 0.3319406971074869, 0.33544574335546146, 0.3377737216078394, 0.33969368266719613, 0.34146164554150854, 0.3366838576649558, 0.33411342934275035, 0.33340940971957367, 0.3356132317975611, 0.3343972885633605, 0.3344528883828924, 0.3363233888654995, 0.33454053499730246, 0.33572568142036036, 0.3376111582823586, 0.3368629658010259, 0.33634102293500423, 0.3377353988571215, 0.3374118304166827, 0.33874126546140143, 0.3404489681552835, 0.33732092193581203, 0.33647836412729615, 0.33687512253425866, 0.338217036045339, 0.3379661900433812, 0.3394989869858166, 0.34028320510061943, 0.3376989222436934, 0.33586650813171276, 0.3355714329388112, 0.33524493305328107, 0.3327254504096718]

    FACE_Stability_2_AAA = [0.23958333333333334, 0.2552083333333333, 0.27480158730158727, 0.2935267857142857, 0.3083333333333333, 0.3234126984126984, 0.3380102040816326, 0.34337797619047616, 0.34441137566137564, 0.34598214285714285, 0.3521374458874459, 0.35615079365079366, 0.3571428571428571, 0.3573554421768707, 0.3620039682539682, 0.3565848214285714, 0.35110294117647056, 0.35061177248677244, 0.3542449874686716, 0.351860119047619, 0.35189909297052147, 0.3504464285714285, 0.35080227743271214, 0.35236855158730157, 0.3519047619047619, 0.35044642857142855, 0.34766313932980597, 0.34842687074829926, 0.34718801313628894, 0.34742063492063485, 0.3492703533026113, 0.3508649553571429, 0.3535353535353536, 0.3514093137254902, 0.35127551020408165, 0.35280257936507936, 0.34853603603603606, 0.3450814536340852, 0.3441697191697192, 0.3444196428571429, 0.34592770034843207, 0.34499007936507936, 0.3411198781838317, 0.3400974025974026, 0.34001322751322755, 0.3409032091097309, 0.34242021276595747, 0.34418402777777785, 0.3456632653061225, 0.3459226190476191, 0.34389589169000945, 0.3433779761904763, 0.3443676999101528, 0.34548611111111116, 0.3468073593073594, 0.3481079931972789, 0.34941520467836257, 0.3502924876847291, 0.3501311541565779, 0.35042162698412704, 0.3494096409055426, 0.35025441628264214]
    FACE_Stability_2_AAF1 = [0.1874819175619343, 0.20085155073998567, 0.2262888123830669, 0.2510347530156376, 0.27101524059589355, 0.2907765139922857, 0.30892215339003004, 0.31569578584961333, 0.318110640083932, 0.3204256291862092, 0.32849874191627537, 0.3339075167877721, 0.33563317137490495, 0.3356914381723298, 0.3410681071259026, 0.33404711954385025, 0.32734588073299403, 0.32660251835938076, 0.3308291397624472, 0.32762030839291173, 0.3275183668104835, 0.32572973495838026, 0.3261624479676183, 0.3281754427676578, 0.32783369917703437, 0.3260012966989815, 0.3228321188977737, 0.3238439033532882, 0.32250359938907064, 0.32289940591733723, 0.32535341697964015, 0.32717719180901195, 0.3302968162565446, 0.3276465193991137, 0.32739648796607446, 0.32925570302913965, 0.3238657483833681, 0.3197053601324393, 0.31860877795906983, 0.3190502674070852, 0.32093757648081056, 0.3197699923955969, 0.3149363839645936, 0.3136600421079647, 0.3136870229609139, 0.3148405492419258, 0.3167473966621957, 0.3189334408573746, 0.32076924396631923, 0.321028198802007, 0.3185296042995517, 0.3178733403117056, 0.3192403954085053, 0.3206924975776677, 0.3223187224660209, 0.32390832203619, 0.32551226883688994, 0.3265252124609242, 0.32642161102565964, 0.32675901931987544, 0.3252959165432178, 0.3262925758055534]

    FACE_Stability_3_AAA = [0.23958333333333334, 0.29910714285714285, 0.2881944444444444, 0.29910714285714285, 0.30654761904761907, 0.32341269841269843, 0.33630952380952384, 0.34635416666666663, 0.35416666666666663, 0.36086309523809523, 0.3674242424242424, 0.3702876984126984, 0.3658424908424908, 0.3657525510204081, 0.3684523809523809, 0.36783854166666663, 0.37062324929971985, 0.36251653439153436, 0.3591791979949875, 0.3592261904761905, 0.3578514739229025, 0.35978084415584416, 0.3536490683229814, 0.35001240079365087, 0.35089285714285723, 0.3525641025641026, 0.35499338624338633, 0.3532100340136055, 0.34965106732348117, 0.34811507936507946, 0.3480702764976959, 0.34816778273809523, 0.34893578643578643, 0.3477328431372549, 0.3480867346938775, 0.3498263888888889, 0.35111003861003864, 0.3529918546365915, 0.35248778998779, 0.35386904761904764, 0.35540069686411146, 0.3533517573696145, 0.3521594684385382, 0.35220508658008653, 0.35340608465608464, 0.3525491718426501, 0.35347011144883483, 0.3538876488095238, 0.35516885325558795, 0.3531547619047619, 0.3526202147525677, 0.35353708791208793, 0.3546720575022462, 0.353422619047619, 0.35300324675324674, 0.353688350340136, 0.35447994987468673, 0.35580870279146143, 0.35686541565778856, 0.3578125, 0.3585577673692428, 0.3593269969278034]
    FACE_Stability_3_AAF1 = [0.1874819175619343, 0.26276620175872706, 0.2457185034163852, 0.2601946580658958, 0.27077341516031017, 0.2928727273581814, 0.3090331503884644, 0.32170539807860177, 0.3313392383843581, 0.339705505420373, 0.3474518939607311, 0.3506530687593153, 0.3453828587990247, 0.3452939391824549, 0.34881447749526584, 0.3477676713045752, 0.35112512512218275, 0.34075994134312615, 0.33646801609617716, 0.33658725388336147, 0.33446175753899765, 0.33688107180345644, 0.3293061629185199, 0.324974532522108, 0.3264035409327486, 0.32868558258150843, 0.33171011526681976, 0.3295311528292641, 0.32476813926234943, 0.32294397539750297, 0.3230850135405988, 0.32318264242006606, 0.324112908558757, 0.3228680075234019, 0.3235791210241761, 0.32565577773558013, 0.3272592382878216, 0.32962046947071216, 0.3286526871210692, 0.33037229813799945, 0.3322603635687568, 0.32978596899877594, 0.3283813363436262, 0.3283926681236799, 0.3298586726305317, 0.32880440481595175, 0.3300003977030071, 0.33056319888870267, 0.33206780112091544, 0.3295280646176538, 0.3288139106589442, 0.32994782394241107, 0.3312572719799098, 0.3297723416904552, 0.32933967421799193, 0.33032115809027335, 0.33140490313176046, 0.33300694574539036, 0.33431980127981126, 0.3355341176469492, 0.3365194365855565, 0.33751485750219073]

    FACE_Stability_4_AAA = [0.23958333333333334, 0.3191964285714286, 0.31597222222222227, 0.31808035714285715, 0.33571428571428574, 0.3414384920634921, 0.3503316326530613, 0.34528273809523814, 0.34292328042328046, 0.3438988095238096, 0.3434794372294373, 0.3495783730158731, 0.3408882783882785, 0.33258928571428586, 0.33452380952380967, 0.3390066964285714, 0.3447128851540616, 0.3482969576719577, 0.3514254385964912, 0.34672619047619047, 0.34552154195011336, 0.3482819264069264, 0.3490553830227743, 0.3505084325396825, 0.35238095238095235, 0.35113324175824173, 0.3517416225749559, 0.35390093537414963, 0.35570607553366174, 0.35362103174603177, 0.35450268817204306, 0.3562593005952381, 0.358270202020202, 0.3600752801120448, 0.36007653061224487, 0.3594576719576719, 0.3616473616473616, 0.36207706766917286, 0.36141636141636135, 0.3625372023809524, 0.36160714285714285, 0.3617842970521542, 0.3627145625692137, 0.363873106060606, 0.3653769841269841, 0.36675077639751547, 0.3682560790273556, 0.36941964285714285, 0.36850097181729835, 0.36636904761904765, 0.36683006535947715, 0.36541323260073266, 0.36506064690026957, 0.3657407407407408, 0.3663419913419914, 0.3658854166666667, 0.3653926482873852, 0.366276683087028, 0.3658192090395481, 0.3666418650793652, 0.36411982825917266, 0.3645833333333335]
    FACE_Stability_4_AAF1 = [0.1874819175619343, 0.28531108232926056, 0.2828955992361311, 0.28769918716076626, 0.3106068617935397, 0.3197308256587364, 0.3299739358106908, 0.3237100929808845, 0.3173909905453524, 0.31788810266316625, 0.3170402722859291, 0.32466830846072164, 0.31358109939880924, 0.303431677828971, 0.3056774274959849, 0.311487515547386, 0.3184033943776558, 0.3229476445026288, 0.3269418558619077, 0.32123040314518614, 0.3197918049340479, 0.3234131674566716, 0.32455969840060184, 0.32630895689242273, 0.3285843638798256, 0.3271345556401375, 0.32803335942684675, 0.3308210350094654, 0.33301850912402214, 0.33041677342965226, 0.3316116191118639, 0.333889242091256, 0.33631398272080526, 0.33834576477575795, 0.3384291789149139, 0.3376681826597131, 0.3402075993731552, 0.3408669075020277, 0.33991262880276507, 0.3412909712398332, 0.3402095321633512, 0.3405695829580337, 0.34186423708025376, 0.3433773734329679, 0.34531763701226614, 0.3471542019852102, 0.3490191045163817, 0.35051306761294104, 0.349341209369595, 0.34687606622786105, 0.34742009234708776, 0.34572542251545124, 0.34541192565327566, 0.34634600722912395, 0.347021356476045, 0.34639618054465604, 0.34581340277250366, 0.34694417919017956, 0.3462908958564574, 0.3472586066127812, 0.34441644771150076, 0.34499441655679647]

    FACE_Stability_5_AAA = [0.23958333333333334, 0.2879464285714286, 0.2926587301587302, 0.3035714285714286, 0.3154761904761905, 0.3253968253968254, 0.3139880952380953, 0.3186383928571429, 0.3115079365079365, 0.31056547619047625, 0.3145292207792208, 0.31770833333333337, 0.3122710622710623, 0.31207482993197283, 0.3160714285714286, 0.32152157738095244, 0.3263305322128852, 0.3315145502645503, 0.33458646616541354, 0.33065476190476195, 0.3334041950113379, 0.333400974025974, 0.3363742236024845, 0.3365575396825397, 0.334702380952381, 0.33819826007326004, 0.3394510582010582, 0.34188988095238093, 0.34441707717569786, 0.34389880952380947, 0.3450460829493088, 0.346865699404762, 0.3488906926406927, 0.34768907563025214, 0.34795918367346945, 0.3487516534391535, 0.34789253539253545, 0.34778352130325824, 0.3476037851037852, 0.34468005952380953, 0.343931475029036, 0.34534438775510207, 0.3452380952380953, 0.34686147186147187, 0.3478835978835979, 0.34782608695652173, 0.34944908814589665, 0.3510974702380952, 0.3524659863945578, 0.3536607142857142, 0.3511321195144724, 0.3514766483516483, 0.3519485624438454, 0.353422619047619, 0.3532467532467532, 0.35469812925170074, 0.35596804511278196, 0.3567836617405583, 0.3580760694108152, 0.3553323412698413, 0.3524590163934427, 0.3509744623655915]
    FACE_Stability_5_AAF1 = [0.1874819175619343, 0.24966211362350893, 0.2553988660680288, 0.27019864961265116, 0.285150361277975, 0.2966230918966991, 0.28086028828457776, 0.28568208675973505, 0.2760311714071871, 0.2754308903759061, 0.2811571868613828, 0.2847839603011551, 0.2788792275199668, 0.2789188497283909, 0.2842337004143092, 0.29128506121582987, 0.29731284654166534, 0.30374104995367135, 0.30716106846721175, 0.30246180305914694, 0.3058052492182787, 0.30585686893663955, 0.3097428643928078, 0.30955991921675013, 0.3072544677058435, 0.3113419087150435, 0.31312963366358515, 0.316261123259907, 0.31935139368581444, 0.3185984058802711, 0.3201404293059544, 0.32223518309606397, 0.32463084087278044, 0.32311746405567343, 0.32359650707363496, 0.3244654787368014, 0.32340971885550357, 0.32330485165365386, 0.32304439571249516, 0.3193517611584866, 0.3185453864437334, 0.3202143055110272, 0.3199086281785002, 0.3219751340116808, 0.3231750005294956, 0.3230907951648679, 0.3251380590393603, 0.3272446441141594, 0.32898633312679765, 0.33039874450756884, 0.32749562739974897, 0.328034285244856, 0.3285885293789329, 0.33031120388055574, 0.3300244673462534, 0.33172235841211867, 0.33321544987973895, 0.3342321666279881, 0.3358342777697312, 0.3322762715970212, 0.3288107330926472, 0.32723323355856165]

    FACE_Stability_6_AAA = [0.23958333333333334, 0.23214285714285715, 0.24950396825396826, 0.2801339285714286, 0.3029761904761905, 0.29216269841269843, 0.2920918367346939, 0.2974330357142857, 0.30787037037037035, 0.3181547619047619, 0.3267045454545454, 0.33519345238095233, 0.3358516483516483, 0.34162414965986393, 0.3408730158730159, 0.3455171130952381, 0.34620098039215685, 0.3478009259259259, 0.35119047619047616, 0.35059523809523807, 0.34481292517006806, 0.34354707792207795, 0.3442675983436853, 0.3463541666666667, 0.3493452380952381, 0.34449404761904767, 0.343694885361552, 0.3436968537414966, 0.3470340722495895, 0.34384920634920635, 0.34326996927803377, 0.3451450892857143, 0.347492784992785, 0.34712009803921573, 0.346343537414966, 0.3480489417989418, 0.3486969111969112, 0.3507205513784461, 0.35271672771672774, 0.3510416666666667, 0.3508275261324042, 0.3488874716553288, 0.3493563122923588, 0.3509875541125541, 0.3501984126984127, 0.34915243271221535, 0.3491641337386018, 0.3502604166666667, 0.34873056365403304, 0.3487202380952381, 0.3494397759103642, 0.3512190934065934, 0.3528751123090746, 0.35108024691358025, 0.3516774891774892, 0.3507918792517007, 0.34998955722639935, 0.34967672413793105, 0.34902138821630346, 0.34858630952380953, 0.34955601092896177, 0.3507344470046083]
    FACE_Stability_6_AAF1 = [0.1874819175619343, 0.176697238738424, 0.2011568686908587, 0.23855704689331875, 0.2670966189888059, 0.2522107794047764, 0.25146794277978973, 0.2585069697279755, 0.272053665207883, 0.2857644577038364, 0.2967912429651366, 0.3072669860351565, 0.3080089292854042, 0.3146863678753027, 0.3138737139489915, 0.31963641859621456, 0.32059206862697914, 0.32292796825310954, 0.32732158711119297, 0.32620001577490915, 0.31897725750635597, 0.31743607441571914, 0.3186434623118934, 0.3211251932013988, 0.32469463729385867, 0.31856240203400354, 0.31759586626243014, 0.317332108683793, 0.32125189660672154, 0.3172953070353695, 0.31684383597892585, 0.3191099386332962, 0.32200502270776854, 0.32163075027256816, 0.3206534027028911, 0.3226512277091583, 0.3235766940672816, 0.3260322594909719, 0.3284396939232466, 0.3261830574672043, 0.325832565127589, 0.3232727838752352, 0.32375775635194814, 0.32572638782591196, 0.3247763972541049, 0.32345931860130245, 0.3235989979281022, 0.3249183106901197, 0.3232471491612398, 0.3232448970362523, 0.3241440830270087, 0.32628384823787254, 0.32824487201845604, 0.3258961635799056, 0.32658262884011396, 0.32526738141165107, 0.3241744419584314, 0.32377295514765764, 0.32295964825129253, 0.32248620894843655, 0.3237326418073535, 0.32521707266372496]

    FACE_Stability_7_AAA = [0.23958333333333334, 0.24479166666666669, 0.27480158730158727, 0.29873511904761907, 0.32083333333333336, 0.32415674603174605, 0.33333333333333337, 0.3208705357142857, 0.31415343915343913, 0.31339285714285714, 0.30073051948051943, 0.3013392857142857, 0.3067765567765568, 0.3122874149659864, 0.31369047619047613, 0.31184895833333337, 0.311186974789916, 0.31283068783068785, 0.31524122807017546, 0.3140625, 0.3182397959183674, 0.32264610389610393, 0.32336956521739135, 0.32446676587301587, 0.3281547619047619, 0.3286973443223443, 0.33134920634920634, 0.3315263605442177, 0.3287151067323481, 0.3294642857142857, 0.32925307219662053, 0.33165922619047616, 0.33400974025974023, 0.33390231092436967, 0.33069727891156453, 0.33089451058201047, 0.33128217503217494, 0.3329808897243107, 0.3348595848595848, 0.3365699404761905, 0.3383783391405343, 0.3398880385487528, 0.34056616832779624, 0.3423971861471861, 0.34427910052910055, 0.3421001552795031, 0.3421669199594731, 0.34350198412698413, 0.3425959669582118, 0.3437797619047619, 0.3418534080298786, 0.3414033882783883, 0.3421776729559748, 0.3431712962962962, 0.3447240259740259, 0.34404230442176875, 0.3437238930659984, 0.3423901888341544, 0.3398153753026635, 0.33980654761904766, 0.3386758391881343, 0.3383016513056836]
    FACE_Stability_7_AAF1 = [0.1874819175619343, 0.18876983436658915, 0.2277947689849519, 0.2592832615097541, 0.2883482198788414, 0.2927231623150081, 0.30394806550583653, 0.28782289616860857, 0.28049349483763747, 0.27930038618513064, 0.26355511845903296, 0.26384594267694733, 0.2713994331332803, 0.2788775272157052, 0.2804880120197247, 0.27791710573150136, 0.2769749899893599, 0.27934328799730773, 0.2823090683505047, 0.28090249633481434, 0.28613578807468787, 0.2913738995394503, 0.29244028667139643, 0.2941341823914137, 0.2987489206437582, 0.2995752333781537, 0.3030520709214251, 0.30288699826362614, 0.29912689135251164, 0.2998665284394712, 0.2995102453305767, 0.3026382779077196, 0.3056286899807938, 0.3054145040129304, 0.30120507934064816, 0.3014300120817325, 0.30218525199376095, 0.30438320786734824, 0.30678533260619967, 0.30895345688957426, 0.3112312867195317, 0.31317236612947247, 0.3139148953393589, 0.31613949301179717, 0.3183567231066731, 0.31556639971696465, 0.3155519230531722, 0.31710945340335317, 0.3158613131937675, 0.31726237060908535, 0.31475770440755363, 0.3142892494921123, 0.31535023686009755, 0.31668516435490407, 0.3185860149217953, 0.3177502078780696, 0.31747164239970127, 0.315892110254997, 0.31264489670344686, 0.3126007666005545, 0.31115354004610224, 0.3107426387687494]

    FACE_Stability_8_AAA = [0.23958333333333334, 0.32142857142857145, 0.2951388888888889, 0.3087797619047619, 0.325, 0.33283730158730157, 0.34098639455782315, 0.3487723214285714, 0.33300264550264547, 0.3254464285714286, 0.33238636363636365, 0.33035714285714285, 0.33436355311355315, 0.3396045918367347, 0.34375, 0.34719122023809523, 0.35075280112044815, 0.3551587301587301, 0.35855263157894735, 0.35959821428571426, 0.3628117913832199, 0.3660714285714285, 0.3641951345755693, 0.36371527777777785, 0.36422619047619054, 0.36355311355311354, 0.3628196649029982, 0.3656462585034014, 0.36781609195402304, 0.36899801587301595, 0.367031490015361, 0.36625744047619047, 0.3653499278499278, 0.36165091036414565, 0.36139455782312924, 0.3621445105820106, 0.3639398326898327, 0.365562343358396, 0.3634386446886447, 0.3645089285714286, 0.3628774680603949, 0.3643707482993197, 0.36288759689922473, 0.3636025432900432, 0.36494708994708985, 0.3663625776397515, 0.36505825734549135, 0.36483134920634913, 0.36579810495626813, 0.3650892857142856, 0.3660714285714285, 0.3640396062271062, 0.36388140161725063, 0.36014660493827155, 0.35833333333333334, 0.35865752551020413, 0.3598057644110276, 0.3595289408866995, 0.36062348668280875, 0.3615327380952381, 0.3615095628415301, 0.3616071428571429]
    FACE_Stability_8_AAF1 = [0.1874819175619343, 0.2880549002406961, 0.2564140109804826, 0.274975455250544, 0.2961778888895738, 0.3050026630462534, 0.3145219535868402, 0.3240382460992203, 0.30421113987031795, 0.2949969940715104, 0.30346313623357896, 0.30118170308222963, 0.30664391743964303, 0.3132198819443593, 0.3184983517719957, 0.32293095793699333, 0.32733245207051526, 0.332757251787734, 0.3369795656917007, 0.3382984511342065, 0.3419187885551859, 0.34571010990861234, 0.3434591973080049, 0.34306288784169764, 0.34381717965771263, 0.3429348986596468, 0.341919385710946, 0.34528981824842137, 0.3477562232391588, 0.34913898283840417, 0.3467454718184142, 0.3457960324734043, 0.3446500825888843, 0.3402005572978202, 0.33985934562576714, 0.34077327750807396, 0.3429040669104719, 0.3448861376744382, 0.3420487289077737, 0.34332926998426105, 0.3412854457196993, 0.34305249668283605, 0.34121487447102544, 0.3420613279522027, 0.343569265255108, 0.3452901267502041, 0.34383971273020547, 0.3435818482960819, 0.3448891747347603, 0.3437769824534749, 0.3450032789570406, 0.3423471804480465, 0.342082433745104, 0.3375911639716243, 0.3354225764417363, 0.3357773369639839, 0.33711509440577364, 0.33689632487297894, 0.3383311251593599, 0.33941573687003057, 0.33948563776271834, 0.33974920516480683]

    FACE_Stability_9_AAA = [0.23958333333333334, 0.29910714285714285, 0.29811507936507936, 0.31436011904761907, 0.3273809523809524, 0.3179563492063492, 0.3193027210884353, 0.3322172619047619, 0.32589285714285715, 0.32901785714285714, 0.3294101731601732, 0.3351934523809524, 0.3345924908424909, 0.33577806122448983, 0.33045634920634925, 0.33231026785714285, 0.3374474789915966, 0.33052248677248675, 0.33004385964912275, 0.33028273809523806, 0.3329790249433106, 0.33678300865800864, 0.33883281573498963, 0.34108382936507936, 0.3442261904761905, 0.3464972527472528, 0.34424603174603186, 0.3446003401360545, 0.34313423645320207, 0.3433531746031747, 0.34437403993855614, 0.34649367559523814, 0.34884559884559885, 0.3508841036414566, 0.35208333333333336, 0.3511078042328043, 0.3513111325611326, 0.35130795739348375, 0.3473748473748474, 0.3469494047619047, 0.34632694541231124, 0.34605300453514737, 0.3434385382059801, 0.3438176406926407, 0.3437830687830688, 0.34100025879917184, 0.3413120567375887, 0.34247891865079366, 0.34438775510204084, 0.3457142857142857, 0.34304971988795513, 0.3423763736263736, 0.3431884546271339, 0.3439704585537919, 0.344237012987013, 0.34542410714285715, 0.3465956558061821, 0.3477011494252873, 0.34806295399515735, 0.3491815476190476, 0.34940964090554255, 0.3499903993855607]
    FACE_Stability_9_AAF1 = [0.1874819175619343, 0.2632512532821868, 0.262020880706598, 0.2834187511239835, 0.2988033532207074, 0.28914293273518243, 0.2904562639592065, 0.3051813590734881, 0.29494634548449333, 0.2992870001564722, 0.299970004253276, 0.3073841095681967, 0.3068179941743591, 0.3082927258365781, 0.3023612006542675, 0.3045027700308664, 0.31068318704127235, 0.30226585625564717, 0.30171056090837706, 0.3019523235170095, 0.30529303720850426, 0.30969192002848495, 0.31234500320654535, 0.3151484004044403, 0.31882878133074394, 0.321523602396463, 0.3190157705489735, 0.31932791780102165, 0.31746763169361275, 0.3179387164239367, 0.31949100228902416, 0.32225632622973066, 0.32514006362365805, 0.327628063052299, 0.3289515061698924, 0.32775545574171133, 0.3281806945376514, 0.3278789981850094, 0.3228004239708841, 0.3221529823483969, 0.32130960910790957, 0.32093009449694615, 0.317678371012051, 0.3182209583995286, 0.3182260721625162, 0.3147726621217798, 0.3151380715159205, 0.3165476346590704, 0.31878994516285974, 0.32033600898545594, 0.3169259217173686, 0.3160111644089523, 0.31692342648507693, 0.31789322041948365, 0.3182713658859792, 0.31982768469909884, 0.3213930408177955, 0.32280218203898803, 0.3233765875531888, 0.32479469005900535, 0.32506708439073123, 0.3258493931942929]

    FACE_Stability_10_AAA = [0.23958333333333334, 0.3035714285714286, 0.2817460317460318, 0.2912946428571429, 0.29761904761904767, 0.28918650793650796, 0.303358843537415, 0.3186383928571429, 0.3096891534391535, 0.31309523809523815, 0.3177759740259741, 0.3258928571428572, 0.3205128205128206, 0.316857993197279, 0.31924603174603183, 0.322358630952381, 0.3238795518207283, 0.3227513227513228, 0.3226817042606516, 0.3275297619047619, 0.32327097505668934, 0.3223755411255411, 0.3275103519668737, 0.3314112103174603, 0.33101190476190473, 0.33270375457875456, 0.33410493827160487, 0.33641581632653056, 0.3362068965517241, 0.33715277777777775, 0.3394297235023041, 0.33607700892857145, 0.33644480519480524, 0.3349089635854342, 0.33439625850340143, 0.334077380952381, 0.33498230373230375, 0.3366228070175439, 0.33894230769230776, 0.3409970238095238, 0.3431692799070848, 0.34364370748299317, 0.34516888150609076, 0.34533955627705626, 0.3463955026455026, 0.3455292443064182, 0.34609295845997967, 0.34681919642857145, 0.34575437317784263, 0.3450000000000001, 0.34500466853408035, 0.34618246336996344, 0.34748427672955984, 0.3464781746031747, 0.34648268398268406, 0.34651360544217685, 0.34458542188805347, 0.3446479885057471, 0.34344733656174337, 0.3443204365079365, 0.3436768149882904, 0.34317396313364057]
    FACE_Stability_10_AAF1 = [0.1874819175619343, 0.26748355022872367, 0.2400849288937651, 0.2519948234778695, 0.26114174816080976, 0.25047522303888875, 0.26833989820631127, 0.28655478674081014, 0.2758130093338061, 0.28054233947267726, 0.2854143444990338, 0.2951709532428801, 0.28870214654790344, 0.2847855341429015, 0.2876347357375742, 0.29163424075653394, 0.29355175214746543, 0.2923343360567163, 0.29224613417723067, 0.29798520701485504, 0.29263319008197886, 0.29128507879707355, 0.29739202089947464, 0.3021293725399605, 0.30151921660815445, 0.3036715175647547, 0.30558946801783543, 0.3085671757930055, 0.30831532708609155, 0.3096110920470224, 0.31235302103379636, 0.3082361122922683, 0.30862097965168456, 0.30669794155277463, 0.3061558937539808, 0.3057491416972512, 0.3069817507431333, 0.30914552199391976, 0.3120172150541611, 0.314587253121556, 0.3172634030732211, 0.3178838167105577, 0.3199064725485357, 0.32000690526187875, 0.3213320392091273, 0.3204536429478702, 0.32107869070792194, 0.3218396291278565, 0.3203124428495008, 0.319270920578098, 0.3192985678391317, 0.3207179498394877, 0.3222372896535697, 0.32113897726954294, 0.32124306374658756, 0.32116884919884564, 0.3186537860397542, 0.31865223091008166, 0.31707943152167045, 0.3182557299872008, 0.31745096802166356, 0.3168646277963798]

    ##########BCI2000############
    BCI2000_Stability_1_AAA = [0.4696969696969697, 0.4652076318742986, 0.46838757949869064, 0.46857463524130194, 0.47126823793490463, 0.47278338945005616, 0.4741061407728075, 0.47474747474747475, 0.4752462900611049, 0.4762626262626263, 0.47678808284868895, 0.47685185185185186, 0.47703531036864366, 0.476350809684143, 0.47669285447063225, 0.4776936026936027, 0.478510596157655, 0.47926798852724783, 0.47959123397719894, 0.4801346801346802, 0.48049275827053617, 0.48117539026629946, 0.48148148148148157, 0.4820192667414889, 0.4824242424242424, 0.4827764827764828, 0.4828116556511618, 0.4831449414782748, 0.48347459266999493, 0.48359521137298916, 0.4838709677419355, 0.48398919753086417, 0.4842022922831003, 0.48433683237604797, 0.4846400513067179, 0.48494201271979037, 0.4850456517123182, 0.4850699982278928, 0.4851938185271517, 0.4853395061728395, 0.48546440009854636, 0.4855299021965688, 0.48559235768538084, 0.4857157432915008, 0.48579623394438204, 0.4859220221539062, 0.4860305179454115, 0.48611111111111116, 0.4859937240889622, 0.48609427609427613, 0.486157875046764, 0.4862082362082362]
    BCI2000_Stability_1_AAF1 = [0.46335815763159616, 0.4571490738515307, 0.4604361588959054, 0.4609553623273984, 0.46437724130113783, 0.46639564950851814, 0.46807689326165464, 0.4687422473009093, 0.4691407868328731, 0.47004132872951904, 0.47058471327132695, 0.4708791745145226, 0.471220805497973, 0.4708043418484288, 0.4711141162992254, 0.47228564248971444, 0.4731812031415079, 0.4741240975995998, 0.47458353005996995, 0.4753627397026395, 0.47598235631300884, 0.47674888338158855, 0.47712711169304056, 0.47761640597988825, 0.4781198506978378, 0.47861231438224106, 0.47873563472043684, 0.47899340128304274, 0.479428548884448, 0.47957707484526835, 0.4798705759335894, 0.4799912218209637, 0.4802275646706353, 0.4803570834087605, 0.48065632315962653, 0.48098866293369624, 0.4811127899402587, 0.4811940729662369, 0.4812808720073164, 0.4814824470662488, 0.48161050322533683, 0.4817204453293379, 0.48182512273245187, 0.4819574157599359, 0.48199063118612645, 0.4821516357833541, 0.48224003392539105, 0.4823198317446155, 0.4821271126576772, 0.48226249924420345, 0.4822706704111328, 0.4823133080213972]

    BCI2000_Stability_2_AAA = [0.4696969696969697, 0.47334455667789, 0.4760568649457538, 0.47727272727272724, 0.47833894500561164, 0.47755331088664416, 0.4772326438993105, 0.47853535353535354, 0.4788627010849233, 0.47940516273849604, 0.4798489950005101, 0.4792835765057987, 0.47949581282914616, 0.47935706269039596, 0.47976056864945754, 0.4799733445566779, 0.4805241962104707, 0.4811697219104627, 0.4817768326540256, 0.4818181818181818, 0.4823098711987601, 0.48199163350678503, 0.48218904016005465, 0.4825570520014964, 0.4827384960718294, 0.4827117327117327, 0.48297792742237183, 0.48296456629789963, 0.483068230194667, 0.48325851103628886, 0.48356323087505887, 0.4833929573512907, 0.483726150392817, 0.48403974384366544, 0.48441558441558435, 0.4845055493203641, 0.4848029848029848, 0.4850256955520113, 0.4852225963337074, 0.48545173961840626, 0.4856423311707865, 0.48577040243706915, 0.48568371048991205, 0.4858560350984593, 0.48590846738994886, 0.48584882642853655, 0.4859350001193972, 0.4860409652076319, 0.48621131954465296, 0.486273849607183, 0.4863339275103982, 0.4863161529828197]
    BCI2000_Stability_2_AAF1 = [0.46335815763159616, 0.46897373381419605, 0.4722242558853779, 0.47348783001094646, 0.47477175425169404, 0.4738488711187825, 0.47319434021866064, 0.474806285078735, 0.47503194387630554, 0.47576377876084913, 0.47613621239110027, 0.4754569130135227, 0.4756207128236007, 0.47556175318260585, 0.4758865538092172, 0.47616759211014387, 0.4768043603057722, 0.4774615523756377, 0.4780713373152179, 0.47823799011773704, 0.47879928773521013, 0.4783528132833597, 0.47849376018560025, 0.4788598675756039, 0.4790288566621874, 0.4790837446960128, 0.4794099989717228, 0.479550546011887, 0.4795789932702871, 0.47976224341873785, 0.4800384093399643, 0.4798814475970656, 0.4802058666995824, 0.4805682721897006, 0.48099437593391536, 0.48107758990427, 0.4813346622071947, 0.4815214862105592, 0.48169517813771595, 0.48194996559115627, 0.48222589340739525, 0.48236534343357174, 0.4822295620516647, 0.4823857721743497, 0.48241233973813585, 0.48236784960608114, 0.4824918549632249, 0.4826372862992326, 0.48279648676004255, 0.48287535891379596, 0.48290262743620943, 0.48294929529350383]

    BCI2000_Stability_3_AAA = [0.4696969696969697, 0.4744668911335578, 0.47680508791619897, 0.4758698092031425, 0.4755331088664422, 0.4774597830153386, 0.47843514510181173, 0.4797979797979798, 0.47998503554059113, 0.4813131313131313, 0.4813794510764208, 0.4812476618032174, 0.481654148320815, 0.4817620650953985, 0.4816685372240928, 0.4818672839506173, 0.4816465306661385, 0.48169971318119464, 0.4817768326540256, 0.4811167227833894, 0.4813745924857035, 0.4816855422916028, 0.4811155028546332, 0.48117751589973806, 0.4815488215488215, 0.4818699818699818, 0.48143991353867893, 0.4818422318422318, 0.4818878439568094, 0.4819865319865319, 0.4819521378661163, 0.48225308641975306, 0.48222970445192664, 0.4822902224863009, 0.4821709155042488, 0.4822452924304776, 0.4821943155276488, 0.48224939453009624, 0.4823735934847045, 0.4823372615039282, 0.4825490679149216, 0.4827374271818716, 0.4829170255526844, 0.48289715335169875, 0.48307769048509785, 0.4830185917142438, 0.4831530434367313, 0.4829545454545454, 0.48309626881055445, 0.48304152637485964, 0.4831209700490745, 0.4832189415522748]
    BCI2000_Stability_3_AAF1 = [0.46335815763159616, 0.46820647412725896, 0.4710921273919759, 0.46961113428793066, 0.4692233267325512, 0.471697262768459, 0.47272859448567844, 0.47448307029331765, 0.4746562134661917, 0.4761092939140667, 0.4761244531025303, 0.47633225529263545, 0.47660471626186646, 0.4767673384974493, 0.4765837804482894, 0.47674975158895583, 0.4764090346126967, 0.4764021415679384, 0.4765313437736584, 0.4758526907018304, 0.4761205805380537, 0.47651576130112844, 0.4760761619641247, 0.4762688507141914, 0.4767334450816714, 0.4771252703716475, 0.47668165496974907, 0.47714858791088105, 0.47715834139563024, 0.477261829343962, 0.4771786019024174, 0.47748689452281134, 0.4774572794946319, 0.4775813613250836, 0.47751050795571137, 0.4775048097830713, 0.47740818744157865, 0.4775268894220641, 0.4777090348902283, 0.4776538757285401, 0.47791710897173273, 0.4781412196023619, 0.4783707209787234, 0.4783353872302195, 0.4786033996597688, 0.47838630174962576, 0.4785337251466717, 0.47824163281923243, 0.4783639630687738, 0.47824853518845506, 0.47833479373970456, 0.47846931601127185]

    BCI2000_Stability_4_AAA = [0.4696969696969697, 0.4761503928170595, 0.4818555929667041, 0.4782547699214366, 0.4801346801346802, 0.4804526748971194, 0.481561648228315, 0.4812710437710438, 0.48166853722409286, 0.481986531986532, 0.4823997551270278, 0.4819491208380097, 0.4822153155486489, 0.48216289882956553, 0.4823419378974935, 0.4828843995510662, 0.482504786426355, 0.4826038159371493, 0.4830173075787111, 0.4828563411896745, 0.48236331569664903, 0.48278236914600553, 0.4831893817401064, 0.4833520389075945, 0.48350168350168354, 0.4838772338772339, 0.4842665336492497, 0.48454785954785956, 0.48510004257130696, 0.4855218855218855, 0.4858260019550342, 0.48593574635241304, 0.48610685984423363, 0.48621839308113823, 0.48624338624338626, 0.48654757451053743, 0.4867746534413201, 0.4866648945596314, 0.4869924314368759, 0.4870510662177329, 0.48705209274314964, 0.4871198760087649, 0.48744551457729757, 0.4874119987756352, 0.4874298540965208, 0.48759332454984633, 0.48779759772667575, 0.4878881406659185, 0.48787191644334504, 0.488013468013468, 0.4880394357518541, 0.4881507381507382]
    BCI2000_Stability_4_AAF1 = [0.46335815763159616, 0.47169634081442846, 0.4781164154886219, 0.4739871924085747, 0.47610954526258265, 0.4761664236031913, 0.4775141583056465, 0.47714671675553877, 0.4776026208811967, 0.4782042117742978, 0.47865040700370404, 0.47839919997162217, 0.47867869511101013, 0.47853192987515875, 0.47866437949299523, 0.47913468118373004, 0.4788521620482854, 0.4790276489368478, 0.47956763299595834, 0.47926847323014493, 0.4786019446520741, 0.479117709414319, 0.47961300888623265, 0.4796996174937345, 0.47969799730572577, 0.48012625768859635, 0.48051695724336213, 0.480911166998691, 0.48147328024752584, 0.4818877517949476, 0.482197338198368, 0.48242812147515063, 0.48255489400896173, 0.4826655358321447, 0.4827121270090902, 0.48305010562340833, 0.48333735288674906, 0.48332717955824583, 0.48361921124216967, 0.48368871895144805, 0.48359321314069315, 0.48358011687773034, 0.483952272013067, 0.4838704555127189, 0.4838890617560506, 0.4840807723248819, 0.48429452690253827, 0.484306049475653, 0.484340394856216, 0.4844684945075952, 0.4845422170761814, 0.4846757124231196]

    BCI2000_Stability_5_AAA = [0.4696969696969697, 0.4725028058361392, 0.4726898615787505, 0.47053872053872053, 0.4716049382716049, 0.4740927796483352, 0.47562930896264227, 0.4759399551066218, 0.4766180321735878, 0.476936026936027, 0.4777573716967657, 0.4782547699214366, 0.47876197876197885, 0.4791566458233126, 0.4789375233819679, 0.47930695847362514, 0.4798639994718426, 0.48039032298291556, 0.48080217378462986, 0.48083613916947243, 0.4812409812409812, 0.4816345270890725, 0.48150588005660466, 0.48178544706322485, 0.48190796857463525, 0.4818699818699819, 0.48220892048052544, 0.48264389931056595, 0.482584465343086, 0.4831275720164609, 0.4831468809963434, 0.48290193602693604, 0.4830969628949427, 0.4833300323496402, 0.48321308321308326, 0.4834143908217982, 0.4834683168016501, 0.48353417213066335, 0.48365420587642804, 0.4838103254769921, 0.4840956995428539, 0.48431403986959537, 0.4843264688225928, 0.484312825221916, 0.4843870806833769, 0.4846654955350606, 0.4845141724574348, 0.4845795922184812, 0.48473396092443716, 0.4847586980920315, 0.4848484848484849, 0.48489165155831826]
    BCI2000_Stability_5_AAF1 = [0.46335815763159616, 0.4667347371564011, 0.4671029313441409, 0.46501629573396763, 0.4661495142265012, 0.4689239423215195, 0.4707481508446856, 0.47088996970691754, 0.4715728462496418, 0.4717615654155316, 0.4727361847231192, 0.47315275192158973, 0.47373659703830384, 0.4742181556655482, 0.47386070938711955, 0.4744241074241233, 0.4750442428868445, 0.4756035596839572, 0.4761082699651881, 0.47612321488354, 0.4765621883477279, 0.4769356263580049, 0.4766808582274772, 0.4768389156366175, 0.4769997167261467, 0.4768905355956099, 0.47722971824500615, 0.4777407439908731, 0.47784045773643624, 0.47843843722526735, 0.47848472847203827, 0.4780787024871317, 0.4782723517025018, 0.4784490412876063, 0.47824007495385873, 0.4784890875582135, 0.4785703512140986, 0.47870485326618145, 0.4787940324843763, 0.47904746478764465, 0.4793119502574734, 0.47956469120782697, 0.4796355191142398, 0.4795409011047068, 0.47955167215872196, 0.4798637398006102, 0.4797491804456363, 0.4798604352639146, 0.4800909806564644, 0.48014247950286754, 0.48026240650745533, 0.48028582181542756]

    BCI2000_Stability_6_AAA = [0.4696969696969697, 0.4730639730639731, 0.4704451926674149, 0.4725028058361392, 0.47418630751964086, 0.4748410026187804, 0.47619047619047616, 0.4769921436588104, 0.4757451053747351, 0.476936026936027, 0.4780124477094175, 0.47890946502057624, 0.4797979797979799, 0.48003848003848015, 0.4802095024317248, 0.48042929292929293, 0.4806232257212649, 0.48076443446813816, 0.4807135684328666, 0.4810886644219977, 0.4813745924857035, 0.48196612590551974, 0.48216464158493133, 0.4826973438084549, 0.48289562289562293, 0.4823663990330657, 0.4826038159371493, 0.4826639409972744, 0.48299082781841407, 0.48316498316498324, 0.48349082220049966, 0.48355078563411896, 0.483862190932898, 0.4838086749851455, 0.48395061728395056, 0.4842249657064471, 0.48451481784815104, 0.48475987949672145, 0.4848484848484847, 0.4850028058361392, 0.4850948509485095, 0.48531612420501313, 0.48495288805366327, 0.4849887766554433, 0.48514777403666287, 0.48514126774996336, 0.48530219452205264, 0.4853979610924055, 0.485547080785176, 0.48556677890011224, 0.48568473405074714, 0.4858521108521109]
    BCI2000_Stability_6_AAF1 = [0.46335815763159616, 0.46838883758574895, 0.46480956968874704, 0.4668962337964727, 0.4694723293731175, 0.47013671441149985, 0.47181325489996545, 0.4723774756634693, 0.4707751531836506, 0.4721654722962425, 0.4735032629305093, 0.47456384782857247, 0.4755573356737395, 0.47585892751684017, 0.47615664671294816, 0.47636500347398103, 0.4765789649132243, 0.4767872030800102, 0.47685042501702657, 0.47734021883221167, 0.4775137488820404, 0.47822155724252846, 0.4784430042014948, 0.479097835860989, 0.47936788395199087, 0.4787595289330537, 0.47908615927295084, 0.4789643575278984, 0.47935588819380687, 0.47943856232135923, 0.4797219849238619, 0.4798165156841889, 0.4801486884714707, 0.48014846810483697, 0.4803208403965105, 0.4806053784090737, 0.480858082916031, 0.4810501169400828, 0.48104033639618765, 0.4811096908750393, 0.48118138911970587, 0.4813674501348497, 0.48099085014690607, 0.48107936311432303, 0.48127447261111184, 0.4813232904655084, 0.4814803092987222, 0.48165500168115055, 0.4818194693631846, 0.4818198725501295, 0.4819797164924642, 0.4821931585673751]

    BCI2000_Stability_7_AAA = [0.4696969696969697, 0.4730639730639731, 0.47624392068836513, 0.4778338945005612, 0.478675645342312, 0.47783389450056113, 0.47763347763347763, 0.4772727272727273, 0.47836388577129324, 0.47895622895622897, 0.47949188858279773, 0.47937710437710446, 0.4792799792799794, 0.4797578964245632, 0.4798353909465021, 0.47990319865319864, 0.47993001914570543, 0.4797668038408779, 0.4796798393289621, 0.47932098765432096, 0.4787558120891454, 0.4789052137536986, 0.47896842824379054, 0.4786990273101384, 0.4787878787878788, 0.4782223948890616, 0.4783846697426945, 0.4785954785954787, 0.47886915128294444, 0.47828282828282837, 0.47847652148727426, 0.47821969696969696, 0.47835254905961977, 0.47804845844061533, 0.47790604457271124, 0.47783389450056124, 0.4776746443413111, 0.4771841219209641, 0.477020921465366, 0.4765432098765432, 0.4762393583531795, 0.47589653145208705, 0.47579150679925875, 0.4756274869911234, 0.47554557924928303, 0.4753818377006783, 0.47510566659502834, 0.474992985409652, 0.47502233216518924, 0.4749494949494949, 0.4747804845844061, 0.4747366830700163]
    BCI2000_Stability_7_AAF1 = [0.46335815763159616, 0.46669541714741436, 0.470948407481403, 0.47275382666961896, 0.47376555473916593, 0.472774147572477, 0.4728899756076729, 0.4727907804420953, 0.4742038156998757, 0.4749273370206371, 0.47584850478305474, 0.47566753508863063, 0.47550901025400366, 0.47612982680971555, 0.4760922778179934, 0.47625541687402295, 0.4764231190406541, 0.4763025203595947, 0.4761203618038749, 0.47579001710929747, 0.47506134286029117, 0.4752562236062594, 0.47543351275959267, 0.47523335146995294, 0.4753389573242102, 0.4748410392017079, 0.47508613291412777, 0.4755229465230554, 0.4759022877055216, 0.47527559862580854, 0.4755803972218224, 0.4754648982272027, 0.4756525192836064, 0.4753313559418776, 0.47517028123577104, 0.47515638627532586, 0.47502542124107683, 0.47450805562313825, 0.47440804496915506, 0.4738896351466585, 0.4736146292547258, 0.47328561421351156, 0.47324506399095684, 0.473157184060311, 0.47313637362918654, 0.4730094467158505, 0.4727355017851178, 0.47262731892009135, 0.4727118511644148, 0.4726888794560857, 0.47257504694025637, 0.4725231928961191]

    BCI2000_Stability_8_AAA = [0.4696969696969697, 0.4730639730639731, 0.47231575009352794, 0.473625140291807, 0.4765432098765433, 0.47717919940142167, 0.478274811608145, 0.4786054994388328, 0.47979797979797983, 0.48097643097643095, 0.48010407101316194, 0.4801253273475496, 0.48066131399464734, 0.4813612313612314, 0.48163112607557057, 0.48256874298540964, 0.48303294381725753, 0.48366379847861324, 0.483578474806545, 0.48347362514029174, 0.4840735396290951, 0.48372615039281697, 0.4839457375689259, 0.48386644219977554, 0.484040404040404, 0.4842657342657342, 0.48416261379224335, 0.48458794292127616, 0.4847130306900421, 0.4849420127197904, 0.4846674631620867, 0.4847257295173962, 0.48478046457844437, 0.48501353403314185, 0.485040885040885, 0.48511348048385083, 0.48537931871265205, 0.4856754681316085, 0.4857693746582636, 0.48584455667789006, 0.48608031534860807, 0.48603762492651387, 0.48610132331062567, 0.48627691051933475, 0.48641975308641977, 0.48637339579368566, 0.48611409604317407, 0.48629816685372235, 0.48625712911427194, 0.48626262626262623, 0.4865870029268722, 0.48681257014590346]
    BCI2000_Stability_8_AAF1 = [0.46335815763159616, 0.4671287976056816, 0.4667280895892055, 0.46869775649471856, 0.4719412325212334, 0.4723090661589193, 0.4736253649075602, 0.47390610440782727, 0.47524480621591497, 0.47650343273115503, 0.47561109474391566, 0.47570099659090187, 0.47632456916033283, 0.47717742028802757, 0.4774720866949867, 0.4785422356886095, 0.4790305705450911, 0.47974949346148743, 0.479671477367941, 0.4797360962278104, 0.4804367034166263, 0.47996153882820525, 0.48031786481168953, 0.48010727578296747, 0.4804683619774754, 0.48072948074699406, 0.48065842642068873, 0.48109796272767547, 0.48128935902196224, 0.4815822385661016, 0.48127908892476223, 0.4814410792143943, 0.4815105275870554, 0.48172660480530993, 0.4817923635697251, 0.48191465821212165, 0.48222479970461146, 0.4826102712993747, 0.4827337415740217, 0.4827707736958476, 0.48302191270907946, 0.48298963216597635, 0.48299028805878846, 0.48316752276821495, 0.4833249490097806, 0.48331112604918736, 0.48297440660270435, 0.48317890337300523, 0.483144754575152, 0.48310513540535305, 0.48345192060802855, 0.48365374165322794]

    BCI2000_Stability_9_AAA = [0.4696969696969697, 0.4696969696969697, 0.47156752712308264, 0.47292368125701456, 0.4738496071829405, 0.4742798353909465, 0.47378547378547375, 0.47537878787878785, 0.4752462900611049, 0.47620650953984284, 0.4768901132537496, 0.47778713056490835, 0.4780281446948113, 0.4782347282347282, 0.47755331088664416, 0.47765852974186307, 0.47755331088664427, 0.47717919940142167, 0.4771102841278281, 0.47707631874298545, 0.4772593661482551, 0.4777573716967657, 0.4777972966378764, 0.477880658436214, 0.47784511784511785, 0.47774756108089445, 0.4775740948580455, 0.47739297739297737, 0.4777661674213398, 0.4773288439955107, 0.4775352087180044, 0.477114898989899, 0.477230214603952, 0.47694262890341327, 0.4770242103575437, 0.4767271480234443, 0.47677981011314347, 0.47666725736901183, 0.4764597542375321, 0.4764450056116723, 0.4765404724754318, 0.4761370316925872, 0.47594811160702627, 0.475946332006938, 0.47599451303155, 0.47579661347777286, 0.47572653246412105, 0.4755658436213992, 0.47548042786138023, 0.475331088664422, 0.4750665698378117, 0.4748553915220582]
    BCI2000_Stability_9_AAF1 = [0.46335815763159616, 0.4628443561805021, 0.46569660283962805, 0.46678041401397113, 0.46764261518031025, 0.46853428690199905, 0.46808808579076083, 0.4701370047231147, 0.4699787755166666, 0.471209019877959, 0.4720895100021755, 0.4731598943904269, 0.4732041496508843, 0.47373872849122745, 0.4727988994859726, 0.4728422956722759, 0.4728072588595045, 0.47240847415489107, 0.4724111770756352, 0.4723844372452349, 0.4726600226767614, 0.47327253966921357, 0.47342089348447125, 0.47351348648878316, 0.47344675422252763, 0.47332535411647364, 0.4731802455469509, 0.472980853226841, 0.4734985812078738, 0.47295146663373533, 0.4732908918373728, 0.47280775850688517, 0.47296024629523553, 0.47268074251151737, 0.47278688335017716, 0.4724990427399183, 0.47255446974793697, 0.47243459843295593, 0.47225125517942745, 0.4723242299792405, 0.4725185048864581, 0.4720972519335834, 0.4719637250923617, 0.47204670012219746, 0.47214511299999445, 0.4720188284065508, 0.47205528632355026, 0.47196431850686565, 0.4719171121598944, 0.47182211832257354, 0.47159389730612383, 0.471387085781056]

    BCI2000_Stability_10_AAA = [0.4696969696969697, 0.4744668911335578, 0.4779274223718668, 0.47769360269360267, 0.47687991021324355, 0.47764683875794983, 0.4769921436588103, 0.47650112233445563, 0.47661803217358767, 0.4771043771043771, 0.47699214365881026, 0.47820800598578367, 0.47755331088664416, 0.477433060766394, 0.476094276094276, 0.47625561167227837, 0.4761999075724566, 0.47639980047387454, 0.47637190619646763, 0.4764309764309765, 0.47589653145208705, 0.47609937761452914, 0.47647977358122284, 0.4767115600448934, 0.47672278338945007, 0.47615039281705945, 0.47605686494575383, 0.4762506012506012, 0.47631487286659696, 0.4762813318368873, 0.4761594439013793, 0.4763432940516274, 0.47614189028330445, 0.4758037895292797, 0.4752765752765753, 0.47502805836139167, 0.47508114174780847, 0.47489515033374685, 0.4742006964229186, 0.47410213243546584, 0.47377569735293323, 0.47358505691839037, 0.4733902330801557, 0.4733828180797879, 0.4731637361266992, 0.47296637876348036, 0.47302815387921787, 0.47283015338570894, 0.4727547584690442, 0.47271604938271605, 0.4724587927202306, 0.4722438055771389]
    BCI2000_Stability_10_AAF1 = [0.46335815763159616, 0.4687673749215607, 0.47187126774406396, 0.4724238881904941, 0.4718285601069029, 0.47300628586018206, 0.4728870420779376, 0.47254229704314543, 0.472869426336871, 0.4732501340535914, 0.47295181797101316, 0.4743185027191598, 0.4733816448789491, 0.4729184446880712, 0.4715662149477742, 0.4716726449810362, 0.4715933028360931, 0.4718900708443285, 0.47181527282689967, 0.4719643787118269, 0.4713036605772641, 0.4715865005686721, 0.4721191205980434, 0.4723451001979709, 0.47240058900624193, 0.471650373408317, 0.4715954808376527, 0.47187759816589114, 0.4719735379050379, 0.4719033831198062, 0.471765569587767, 0.471940014127866, 0.47172163110266696, 0.47138831379880874, 0.4707716272198094, 0.47047038773584215, 0.47058651250737044, 0.4703863226345094, 0.46952759589411075, 0.4694435875332109, 0.4691337614288483, 0.4689430975572201, 0.46875642198257084, 0.46877739944782415, 0.46854630671872366, 0.4683757741209726, 0.4684868822859888, 0.4683095455313176, 0.46825208946527924, 0.46821902037997304, 0.4679663883473118, 0.46784995276981167]

    BCI2000_Stability_11_AAA = [0.4696969696969697, 0.4668911335578002, 0.47025813692480356, 0.47138047138047134, 0.4734006734006734, 0.4740927796483352, 0.4754689754689755, 0.4757996632996633, 0.47755331088664416, 0.47794612794612795, 0.4787266605448423, 0.4789094650205761, 0.47919364586031243, 0.4796777296777296, 0.47991021324354655, 0.47916666666666663, 0.47854360599458634, 0.47876917321361767, 0.4792663476874003, 0.4797418630751964, 0.47990486879375766, 0.47990001020304046, 0.48031034987556714, 0.48061634867190417, 0.4806285072951739, 0.4805965639298972, 0.4801097393689986, 0.4803992303992303, 0.4806107047486357, 0.4809764309764309, 0.48126425545780377, 0.4816919191919192, 0.48187259803421423, 0.4821911929755068, 0.4824595157928492, 0.4825258760443946, 0.4827099827099828, 0.4828991671096935, 0.48322253877809435, 0.4832491582491583, 0.48326079220388163, 0.483552455774678, 0.48346514237987104, 0.4835858585858585, 0.48358897618156865, 0.4835431610793929, 0.4836783914798098, 0.48370276842499066, 0.4837605075700314, 0.4837485970819304, 0.4837261503928171, 0.4837261503928171]
    BCI2000_Stability_11_AAF1 = [0.46335815763159616, 0.46052618379105786, 0.4645066206596556, 0.4658181840742929, 0.46836862992473643, 0.4691954140168915, 0.4709919927596781, 0.47100407731588, 0.47286153675760695, 0.4732560030085608, 0.47406615133531066, 0.4741899323874342, 0.47456502518858745, 0.475128251318067, 0.4752921792074012, 0.47442733161439, 0.47386898412889106, 0.47425963510133573, 0.47495226471810104, 0.475558796784971, 0.47560659972425967, 0.4755716894992092, 0.47606970590562314, 0.47653743102704577, 0.47665024679319523, 0.4766432919318523, 0.47602011702686425, 0.4764319354485512, 0.4767099324084969, 0.47707843454059423, 0.47737194410874734, 0.47781270657114516, 0.47798058676487165, 0.4783169332891274, 0.4786195473159306, 0.478743177095753, 0.4789620835210277, 0.4792089279939026, 0.4795936180257162, 0.4796781377470706, 0.47970580586871975, 0.48000911907182275, 0.47992945294790695, 0.4799691710506792, 0.48008843355855024, 0.48009905402363773, 0.4802509010303744, 0.48027732488818514, 0.48034344414568836, 0.4803324407325619, 0.4803305518363398, 0.4803425149983205]

    BCI2000_Stability_12_AAA = [0.4696969696969697, 0.4668911335578002, 0.47081930415263745, 0.47236251402918067, 0.47530864197530864, 0.47615039281705945, 0.47835497835497837, 0.4797278338945006, 0.48023444319740616, 0.4797418630751964, 0.48015508621569225, 0.48026561915450805, 0.48066131399464734, 0.48096039762706433, 0.48136924803591474, 0.4818672839506173, 0.48194361919852113, 0.4825102880658436, 0.48275149152342134, 0.48302469135802467, 0.483271872160761, 0.4838536883991429, 0.48438491192114375, 0.48438084549195654, 0.4848035914702581, 0.4848484848484848, 0.4849524047054911, 0.4850489017155684, 0.48529354851193934, 0.4853535353535354, 0.4850657108721625, 0.4853395061728395, 0.48544366221133894, 0.4854096520763187, 0.48556998556998554, 0.48561229579748094, 0.48577365244031906, 0.48605942465591584, 0.4861147083369305, 0.4861952861952862, 0.4860940023541649, 0.48626476404254176, 0.48615352491321473, 0.4857667584940311, 0.48573388203017825, 0.48578782999072845, 0.4858753014781383, 0.4858305274971942, 0.4858219382028906, 0.4859034792368126, 0.4860588455359697, 0.4859168609168609]
    BCI2000_Stability_12_AAF1 = [0.46335815763159616, 0.45940286067376357, 0.46514111915720185, 0.4670269163158028, 0.4706322958095711, 0.472236932706058, 0.4750850683630525, 0.4766587409672106, 0.4772470331459725, 0.47644598778872993, 0.4768761201146368, 0.4770125979267938, 0.477374768096874, 0.4775038554483057, 0.4778404137135913, 0.47834844260680187, 0.4783329585797308, 0.47890490107523576, 0.47920995466005895, 0.4795392607880992, 0.47982359279839804, 0.4805297962419045, 0.48115911556055, 0.48123472294665587, 0.48173461082302266, 0.48179334863228857, 0.48194930923311036, 0.4820955122157354, 0.48244494360977014, 0.4824296314837041, 0.4820140052982629, 0.4823149108232133, 0.48245227645094696, 0.48239553604158825, 0.48259457089864405, 0.4826916671903045, 0.48288734755666046, 0.48317738258386383, 0.48327630206467476, 0.483378359791203, 0.48332456161937815, 0.48351821388951194, 0.4834123648969938, 0.48305464421414845, 0.48298627630313845, 0.48305718569277184, 0.48315809926878134, 0.48312110074373144, 0.48310678932318807, 0.4832445664342035, 0.4834184439443705, 0.48321997935543526]

    BCI2000_Stability_13_AAA = [0.4696969696969697, 0.4750280583613917, 0.47418630751964086, 0.4771324354657688, 0.4771043771043771, 0.4793303404414515, 0.47987814654481314, 0.4803591470258137, 0.4809203142536476, 0.4806958473625141, 0.479389858177737, 0.479751215862327, 0.4799706466373133, 0.48003848003848004, 0.48032173587729143, 0.4808150953984287, 0.48138245197068724, 0.4816373612669909, 0.482013113592061, 0.4821829405162739, 0.4823098711987601, 0.4825783083358841, 0.48292099741375105, 0.4828376356154134, 0.4822446689113356, 0.48199948199948206, 0.48218813650912423, 0.48224306557639895, 0.4826425171252758, 0.4827534605312384, 0.4823503855761921, 0.48253367003367004, 0.48260381593714924, 0.48291740938799765, 0.4830206830206831, 0.4830558673151266, 0.48314981648314986, 0.48328312363400083, 0.48333765000431667, 0.4834595959595959, 0.48358928033724774, 0.4837528726417614, 0.48385665439928993, 0.48393021120293833, 0.48376356154133915, 0.4836285560923241, 0.48349929555603305, 0.4835975495697718, 0.48349710254472167, 0.48361391694725037, 0.4834510684183888, 0.4834455667789002]
    BCI2000_Stability_13_AAF1 = [0.46335815763159616, 0.4687574833733854, 0.4671931902262651, 0.47091656753102606, 0.4715765133809871, 0.4742434047195298, 0.4752133995877621, 0.47622779901537, 0.476867003052678, 0.47683210132726883, 0.4754319870616735, 0.47585751614476296, 0.47612328646330354, 0.4763790341158307, 0.47665220630463845, 0.47715386419472683, 0.4777102674405804, 0.4780956972395487, 0.47849660917134484, 0.4787450043269037, 0.4789215068690116, 0.4792067967246568, 0.4795231409538585, 0.47945774313078005, 0.47876352546712747, 0.4785156601968328, 0.478684582062245, 0.47877539326295987, 0.4792355879312346, 0.4793899343831129, 0.47874314716896604, 0.4789577098251597, 0.47902032060905325, 0.4794252619362156, 0.4794676341908762, 0.47947178916481525, 0.47958624559011853, 0.4796882602664674, 0.479735427749537, 0.4798603151484608, 0.48000235384537104, 0.4801917948091256, 0.4802866576306734, 0.4804249350847472, 0.48025252162705345, 0.4800620112087955, 0.47985622054081906, 0.47997389164391663, 0.47986572226454094, 0.48004440513309954, 0.47987144768949025, 0.4799280470184166]

    BCI2000_Stability_14_AAA = [0.4696969696969697, 0.4668911335578002, 0.47081930415263745, 0.47236251402918067, 0.47530864197530864, 0.47615039281705945, 0.47835497835497837, 0.4797278338945006, 0.48023444319740616, 0.4797418630751964, 0.48015508621569225, 0.48026561915450805, 0.48066131399464734, 0.48096039762706433, 0.48136924803591474, 0.4818672839506173, 0.48194361919852113, 0.4825102880658436, 0.48275149152342134, 0.48302469135802467, 0.483271872160761, 0.4838536883991429, 0.48438491192114375, 0.48438084549195654, 0.4848035914702581, 0.4848484848484848, 0.4849524047054911, 0.4850489017155684, 0.48529354851193934, 0.4853535353535354, 0.4850657108721625, 0.4853395061728395, 0.48544366221133894, 0.4854096520763187, 0.48556998556998554, 0.48561229579748094, 0.48577365244031906, 0.48605942465591584, 0.4861147083369305, 0.4861952861952862, 0.4860940023541649, 0.48626476404254176, 0.48615352491321473, 0.4857667584940311, 0.48573388203017825, 0.48578782999072845, 0.4858753014781383, 0.4858305274971942, 0.4858219382028906, 0.4859034792368126, 0.4860588455359697, 0.4859168609168609]
    BCI2000_Stability_14_AAF1 = [0.46335815763159616, 0.45940286067376357, 0.46514111915720185, 0.4670269163158028, 0.4706322958095711, 0.472236932706058, 0.4750850683630525, 0.4766587409672106, 0.4772470331459725, 0.47644598778872993, 0.4768761201146368, 0.4770125979267938, 0.477374768096874, 0.4775038554483057, 0.4778404137135913, 0.47834844260680187, 0.4783329585797308, 0.47890490107523576, 0.47920995466005895, 0.4795392607880992, 0.47982359279839804, 0.4805297962419045, 0.48115911556055, 0.48123472294665587, 0.48173461082302266, 0.48179334863228857, 0.48194930923311036, 0.4820955122157354, 0.48244494360977014, 0.4824296314837041, 0.4820140052982629, 0.4823149108232133, 0.48245227645094696, 0.48239553604158825, 0.48259457089864405, 0.4826916671903045, 0.48288734755666046, 0.48317738258386383, 0.48327630206467476, 0.483378359791203, 0.48332456161937815, 0.48351821388951194, 0.4834123648969938, 0.48305464421414845, 0.48298627630313845, 0.48305718569277184, 0.48315809926878134, 0.48312110074373144, 0.48310678932318807, 0.4832445664342035, 0.4834184439443705, 0.48321997935543526]

    BCI2000_Stability_15_AAA = [0.4696969696969697, 0.4730639730639731, 0.47549569771791994, 0.476010101010101, 0.4773288439955106, 0.47764683875794983, 0.4781144781144781, 0.4784652076318743, 0.4792991644843496, 0.4782828282828283, 0.478675645342312, 0.4780209502431725, 0.4782008115341449, 0.4784351451018118, 0.4791619902731014, 0.47986812570145904, 0.48045817653660794, 0.4808579623394439, 0.4812156654261919, 0.48136924803591485, 0.481160814494148, 0.4815069890827468, 0.48143268433123515, 0.48171530115974565, 0.48150392817059484, 0.48154623154623155, 0.481606185309889, 0.48158168991502326, 0.4813847285111653, 0.48150018705574266, 0.48160819666196014, 0.4813061167227834, 0.4813794510764208, 0.4811348781937017, 0.48128908128908127, 0.481341189674523, 0.48129948129948125, 0.48133380589520935, 0.48132320354542574, 0.4811728395061728, 0.4813309244203553, 0.48121425899203674, 0.48125962467047734, 0.48134118967452294, 0.4814690110986406, 0.4814570829063582, 0.4813262650142082, 0.4813645716423494, 0.4812982432030051, 0.481324354657688, 0.48121740278603026, 0.48097427264093934]
    BCI2000_Stability_15_AAF1 = [0.46335815763159616, 0.46787271694662924, 0.47131445995828486, 0.47158262574721826, 0.4735385557655336, 0.47366640285893696, 0.4741782690890316, 0.474578354934612, 0.47537526790104256, 0.4743731936910268, 0.4746483816797315, 0.47379215818648923, 0.47403734973273526, 0.4744336920754066, 0.47534856734808717, 0.47607493751891616, 0.47667978938377886, 0.47714807750795946, 0.47759213807418616, 0.4778264467786736, 0.47753185557053723, 0.47790942155031785, 0.4778330432437316, 0.4782470279339786, 0.4779280040142582, 0.4778614890338434, 0.4779916698858812, 0.47802796090165783, 0.4779129683410068, 0.4780819471327849, 0.47825134120659984, 0.4779596575111987, 0.47806150154986166, 0.477663617631866, 0.47785915303462645, 0.47796456192801196, 0.47794004718813204, 0.4781257684701255, 0.47813815157626466, 0.4779822566981923, 0.47811442082027644, 0.4779935468245372, 0.4780505858123458, 0.47813125466261613, 0.47827007281001166, 0.47824037531874447, 0.47813426078434274, 0.47818323620491787, 0.4781414742333693, 0.47820489849779785, 0.47815314954412164, 0.4778682215175566]

    BCI2000_Stability_16_AAA = [0.4696969696969697, 0.47278338945005616, 0.4768050879161991, 0.47601010101010105, 0.47687991021324355, 0.4773662551440329, 0.4746673080006413, 0.4762205387205387, 0.4772415513156254, 0.4782267115600449, 0.4796449341903888, 0.48087355031799484, 0.48057498057498066, 0.4812008978675646, 0.4803591470258137, 0.48116582491582494, 0.48187759952465836, 0.48238558423743605, 0.48278102664067574, 0.48291245791245785, 0.48305809416920525, 0.4833945515763698, 0.4834089689162153, 0.48302469135802467, 0.48307519640852975, 0.4833160666494, 0.48337282287899574, 0.4832251082251083, 0.4832230349471729, 0.4834455667789001, 0.48341841352594045, 0.48370861391694725, 0.48393021120293844, 0.48407275368059677, 0.48406285072951727, 0.48399114602818294, 0.4839536506203172, 0.4841987122688876, 0.4842009842009841, 0.484090909090909, 0.4839862034983985, 0.48387312276201155, 0.48380445279670076, 0.48380267319661246, 0.48371368000997617, 0.48359195822963924, 0.4833679585452634, 0.48302469135802467, 0.4829931972789115, 0.48297418630751954, 0.4829009044695319, 0.4827872744539411]
    BCI2000_Stability_16_AAF1 = [0.46335815763159616, 0.46868363419106895, 0.47395108376411765, 0.47290125171528585, 0.47407466341890825, 0.4742542268093477, 0.4712264535745305, 0.47309456360083707, 0.4740660806446346, 0.47509461162674516, 0.476593083664403, 0.47797958097571347, 0.47763255099827806, 0.47838261169975166, 0.47726340366229564, 0.47817313556188323, 0.4789470400537785, 0.47945191585386593, 0.4798962383603501, 0.4800907078282771, 0.48025629632067246, 0.480673258760791, 0.48062187811808366, 0.48028979584680925, 0.48032770894606075, 0.48059761925127575, 0.4806483953338895, 0.4804677848815136, 0.48053414189146915, 0.48085173266214026, 0.4808344948136093, 0.48108266082570206, 0.48134628412774627, 0.4814327439773366, 0.48142139453104765, 0.4812914438932874, 0.4811576992116689, 0.48146958331638545, 0.481495296936529, 0.4814043696432234, 0.48131749801947116, 0.4812468577983166, 0.48119429494666816, 0.4811891540407846, 0.48111782700600675, 0.48099513245611336, 0.48074280739763653, 0.4803173220956976, 0.48025709272214906, 0.4802571325803193, 0.4801552365388193, 0.48004012001916163]

    BCI2000_Stability_17_AAA = [0.4696969696969697, 0.47530864197530864, 0.4766180321735877, 0.47671156004489335, 0.4773288439955106, 0.4787691732136176, 0.4789161455828122, 0.47930695847362514, 0.4794238683127572, 0.47951739618406286, 0.4790327517600245, 0.4798915076692855, 0.47971164637831304, 0.4808000641333975, 0.48069584736251403, 0.48032407407407407, 0.4803261371888823, 0.4808579623394438, 0.4814224112469726, 0.4812850729517396, 0.48148148148148145, 0.4814559738802163, 0.4815790757819744, 0.4817620650953984, 0.48202020202020196, 0.48234481567814896, 0.4822920563661304, 0.48242344075677407, 0.4824877123727699, 0.4827908716797606, 0.48233228340755224, 0.48265642536475867, 0.48279087167976054, 0.4822407077309038, 0.482010582010582, 0.48236999625888516, 0.48237631570964906, 0.48244137279224997, 0.4825894270338715, 0.4826459034792368, 0.4828638690427308, 0.4829378440489552, 0.48302142875786286, 0.4829864299561269, 0.48309016086793866, 0.4831893817401064, 0.48323662153449387, 0.4832468200523756, 0.48332531665865, 0.4832884399551066, 0.48321999955986883, 0.48315419148752475]
    BCI2000_Stability_17_AAF1 = [0.46335815763159616, 0.47072417560196056, 0.47274975768608146, 0.47313248864648755, 0.47358021270284134, 0.47533172369813587, 0.47540938664375754, 0.4753897554733453, 0.4753062160531051, 0.47528249168685105, 0.4749918354520472, 0.47585709428715367, 0.4754983001236133, 0.4766591654463276, 0.4763969092114206, 0.4758124055376014, 0.47582312123452736, 0.47647930132194943, 0.47716511971866776, 0.47699223724666756, 0.47711377123578463, 0.47688868204077706, 0.4768366034495223, 0.47711348322092223, 0.4773037207217119, 0.47770820931017555, 0.47779705778375003, 0.4779043608630022, 0.47792911463762305, 0.4781657351612664, 0.477514477518111, 0.47796103522301636, 0.4781198645993632, 0.4774727048757621, 0.47729343785948836, 0.4777186790347396, 0.4777087308278125, 0.4777595253802639, 0.4779705108302926, 0.4780678317088026, 0.47827824197695057, 0.47839591168544343, 0.4785145205215244, 0.4783396978570095, 0.47838683520013703, 0.4785210058948333, 0.4786130951567758, 0.4786711501100713, 0.4787803774107821, 0.47877823239210576, 0.4787011448709467, 0.4786694481739457]

    BCI2000_Stability_18_AAA = [0.4696969696969697, 0.4713804713804714, 0.4726898615787505, 0.4737654320987654, 0.4737373737373737, 0.4739057239057239, 0.47418630751964086, 0.4750982042648709, 0.47574510537473497, 0.47620650953984284, 0.4772982348739924, 0.47769360269360267, 0.4784166450833117, 0.47911656244989576, 0.4780396558174335, 0.4786054994388328, 0.479401861754803, 0.4797356278837761, 0.48012286608777843, 0.480611672278339, 0.48041259152370264, 0.4805121926334048, 0.4807983213780316, 0.4810839880284325, 0.48143658810325474, 0.481373564706898, 0.48185559296670405, 0.4821428571428571, 0.48210070049150505, 0.4821174710063599, 0.4824589985880308, 0.4828843995510662, 0.4826378260721695, 0.4827688651218062, 0.4830046496713163, 0.48328968699339064, 0.4834986501653168, 0.4834603343375273, 0.48362542806987247, 0.48376823793490453, 0.4839725164928416, 0.48423387312276195, 0.48437867042518196, 0.4844276094276093, 0.4844743733632621, 0.48465329624749903, 0.4848246053919812, 0.48467312008978675, 0.48464234178519894, 0.48464646464646466, 0.4846724323848507, 0.484665026331693]
    BCI2000_Stability_18_AAF1 = [0.46335815763159616, 0.46466172346106055, 0.46654307713939097, 0.4680433082518663, 0.46783137413846915, 0.46830520424114824, 0.4684075269563025, 0.4692997180011518, 0.4701219097472753, 0.47049136638495054, 0.4719064977047878, 0.47244972281990266, 0.47334958788420994, 0.4741825213433563, 0.47286333877437187, 0.4735190661181625, 0.4743424894462278, 0.4746081996054829, 0.47495388738958905, 0.47554085195352347, 0.4753782579154086, 0.47541243379141984, 0.4757730701258644, 0.476098115320229, 0.4765683043224776, 0.47670533521880726, 0.47718270866047974, 0.47743418185078584, 0.47729364757079945, 0.4774433198881907, 0.4778355031610423, 0.478353369589108, 0.47800852981959746, 0.47817460955957586, 0.4783978667411965, 0.47872418872227374, 0.47892209913480477, 0.478831036586458, 0.47904246275889845, 0.4791799622405691, 0.47940298481274185, 0.4797166437401067, 0.4798505083440413, 0.47987677078814084, 0.4799621505291901, 0.48020479427119783, 0.4803935224291995, 0.4801963193235046, 0.4801630263540905, 0.48022074279341226, 0.48029053030622343, 0.48033784815815983]

    BCI2000_Stability_19_AAA = [0.4696969696969697, 0.4713804713804714, 0.4726898615787505, 0.4737654320987654, 0.4737373737373737, 0.4739057239057239, 0.47418630751964086, 0.4750982042648709, 0.47574510537473497, 0.47620650953984284, 0.4772982348739924, 0.47769360269360267, 0.4784166450833117, 0.47911656244989576, 0.4780396558174335, 0.4786054994388328, 0.479401861754803, 0.4797356278837761, 0.48012286608777843, 0.480611672278339, 0.48041259152370264, 0.4805121926334048, 0.4807983213780316, 0.4810839880284325, 0.48143658810325474, 0.481373564706898, 0.48185559296670405, 0.482082732082732, 0.4819458957389991, 0.4818181818181817, 0.48198834220339587, 0.482077721661055, 0.481702547359113, 0.48171255034000127, 0.4815616482283148, 0.4817932410525002, 0.4817544817544816, 0.48170299486088947, 0.48168292612737046, 0.4817901234567902, 0.48183734362596153, 0.48197584308695424, 0.4820165479080208, 0.48222120191817164, 0.48224217483476745, 0.4823232323232324, 0.4825679967523939, 0.4825570520014964, 0.4826267207219588, 0.4827609427609428, 0.4827578618428292, 0.48278727445394115]
    BCI2000_Stability_19_AAF1 = [0.46335815763159616, 0.46466172346106055, 0.46654307713939097, 0.4680433082518663, 0.46783137413846915, 0.46830520424114824, 0.4684075269563025, 0.4692997180011518, 0.4701219097472753, 0.47049136638495054, 0.4719064977047878, 0.47244972281990266, 0.47334958788420994, 0.4741825213433563, 0.47286333877437187, 0.4735190661181625, 0.4743424894462278, 0.4746081996054829, 0.47495388738958905, 0.47554085195352347, 0.4753782579154086, 0.47541243379141984, 0.4757730701258644, 0.476098115320229, 0.4765683043224776, 0.47670533521880726, 0.47718270866047974, 0.4773734226107568, 0.47707439864369516, 0.47705695418650723, 0.47713833927453647, 0.47730033566930663, 0.47682656916272564, 0.47682718588890866, 0.4765858102229288, 0.47685601372905545, 0.476739580486084, 0.47667552251106554, 0.4767238187673652, 0.47683797278251117, 0.47687153155636686, 0.47698378781283796, 0.4770576138452711, 0.47726223383459043, 0.4772839435941275, 0.47739793574341133, 0.47770009788412876, 0.47769583588312053, 0.4777756605891628, 0.47796364709683686, 0.47805153121529376, 0.4781261489691099]


    # ablation_plot()
    # stability_plot()

    plot_alpha1()
    ISRUC_ConDA_AAA = [0.7204918032786886, 0.7396370023419203, 0.6753317720530835, 0.6500292740046838, 0.6107377049180328, 0.5975117096018735, 0.5753261960521913, 0.5928571428571429, 0.6055035128805621, 0.5926112412177986, 0.6007983819459229, 0.605449843871975, 0.6075346784363178, 0.6157786885245902, 0.6232357533177205, 0.628406762295082, 0.6328075492492079, 0.6357077803799115, 0.6378127696289905, 0.6408225995316159, 0.6444602431136389, 0.6479242069406004, 0.6498421749312697, 0.6517881537861046, 0.6538056206088992, 0.655933615564763, 0.6580752884031573, 0.6602354466376715, 0.6626786723734152, 0.6637646370023419, 0.6651507139079852, 0.6659781176814988, 0.6675910155418352, 0.6687405289984847, 0.6686885245901639, 0.6682279469164715, 0.6687496044053421, 0.6688108591150006, 0.6699858884285114, 0.6703922716627634, 0.6698820471811274, 0.67002481320397, 0.67050950383966, 0.6712023632105598, 0.672094717668488, 0.672491345076876, 0.6718620758383576, 0.6709943403590944, 0.6706304067294364, 0.6699121779859485]
    ISRUC_ConDA_AAF1 = [0.6986579952263389, 0.719477862977848, 0.617811768590392, 0.5852411588271865, 0.5568268913042835, 0.5503151809276913, 0.5096083724840996, 0.5337237994585313, 0.5513382339205302, 0.5259825567482236, 0.5392560142797822, 0.5474169050968074, 0.5520065322218141, 0.5631870364838287, 0.5732901503236135, 0.5807832531451949, 0.5872455876484935, 0.5917983699756529, 0.5952640087415236, 0.5996167910248023, 0.6040126981112964, 0.6084718545369717, 0.6113759427278601, 0.6140541755910429, 0.6167042464461951, 0.6196094115907419, 0.6223742562786526, 0.6250631256598199, 0.6280246390854409, 0.629817215410963, 0.6319477351794002, 0.6332300898397958, 0.6352697464839485, 0.6368596242644562, 0.6371641218358938, 0.6371301523760691, 0.6378537382506853, 0.6380630533929746, 0.6391491628367166, 0.6398231127210954, 0.6398975368806442, 0.6405291872063719, 0.6413461032179618, 0.6421719393931901, 0.6431287501788913, 0.6431293205769876, 0.642502473587488, 0.6418581567546809, 0.6415859588084097, 0.6408520013884795]

    FACED_ConDA_AAA = [0.23958333333333334, 0.3117559523809524, 0.29365079365079366, 0.2961309523809524, 0.30446428571428574, 0.31795634920634924, 0.3210034013605442, 0.32570684523809523, 0.3263888888888889, 0.32514880952380953, 0.32954545454545453, 0.3343253968253968, 0.3257783882783883, 0.3246173469387755, 0.3250992063492063, 0.32719494047619047, 0.3286064425770308, 0.32531415343915343, 0.3226817042606516, 0.3223214285714286, 0.32142857142857145, 0.321090367965368, 0.3215579710144928, 0.318328373015873, 0.31952380952380954, 0.3187957875457875, 0.3185626102292769, 0.321109693877551, 0.32466133004926107, 0.32594246031746027, 0.3289170506912442, 0.33017113095238093, 0.3287337662337662, 0.3297443977591036, 0.3297619047619047, 0.3269675925925925, 0.326295045045045, 0.32695018796992475, 0.32768620268620263, 0.3293526785714286, 0.33097415795586527, 0.333156179138322, 0.3339908637873754, 0.3344155844155844, 0.33624338624338623, 0.3355978260869565, 0.33703774062816616, 0.33795262896825395, 0.3382227891156462, 0.3395535714285714, 0.34016106442577027, 0.3391712454212454, 0.3393699460916441, 0.3375496031746031, 0.33574134199134187, 0.3357514880952381, 0.33581349206349204, 0.3357194170771757, 0.334115213882163, 0.3328621031746032, 0.3326258782201405, 0.33177323348694315]
    FACED_ConDA_AAF1 = [0.1874819175619343, 0.2779458541542663, 0.2545460542714045, 0.257764819826412, 0.2692487206860973, 0.28701182309695644, 0.2907037049970542, 0.29729449030634975, 0.2986757708467843, 0.2963110798561442, 0.30168564594755454, 0.30762671888492993, 0.2968837815014945, 0.29557674191500566, 0.296506625894973, 0.2989037831653433, 0.30054483643544566, 0.2966407756406925, 0.29358763061951715, 0.29314296921096494, 0.29182640554524175, 0.2913773057179156, 0.2915394047460815, 0.2871126524934413, 0.28864289646141117, 0.28759891494788037, 0.2873988800167429, 0.2907342643210393, 0.2952632369120969, 0.29706586241195077, 0.3008110718899231, 0.3024203455925655, 0.3008111208833682, 0.3021286502381392, 0.3021966489148389, 0.29876733329104393, 0.2978320271972494, 0.2986781211291573, 0.2996444877684718, 0.3017940765895166, 0.3039494297824962, 0.3065800211562235, 0.30762894047642375, 0.3081362667027958, 0.310263002199004, 0.30924853394757973, 0.31092474744874465, 0.3121036560117378, 0.3124769083119232, 0.3139940057076519, 0.31475878615286085, 0.31334071561315135, 0.3132985087646729, 0.3109138864362417, 0.30867900456477154, 0.308604046422121, 0.3086040404837358, 0.30846095016687053, 0.30643225409335906, 0.3048246323652251, 0.30432284342485544, 0.3029829938801072]

    BCI2000_ConDA_AAA = [0.4696969696969697, 0.4722222222222222, 0.47624392068836513, 0.4778338945005612, 0.4782267115600449, 0.4777403666292555, 0.4760301426968094, 0.47629068462401797, 0.47605686494575383, 0.4751964085297419, 0.47316600346903376, 0.4714739992517771, 0.47094880428213765, 0.4703783870450537, 0.46965955854844743, 0.46678591470258135, 0.46540569089588696, 0.46502057613168724, 0.46461692952921024, 0.464057239057239, 0.46387151942707494, 0.46342209978573606, 0.4630117601132093, 0.46237841376730265, 0.46217732884399554, 0.46158162824829496, 0.4610716215654488, 0.46069825236491907, 0.459712063160339, 0.458641975308642, 0.4579486622497375, 0.4573688271604938, 0.45604190048634496, 0.45573380867498514, 0.4554753888087222, 0.4550286818805337, 0.4542572875906209, 0.4530096284482249, 0.4519554519554519, 0.45119248035914705, 0.4503435438394788, 0.4500962000962001, 0.4498995119150158, 0.44858942965003573, 0.44735004364633996, 0.4464939247547943, 0.4454115624328391, 0.4444093714927049, 0.44328775281156235, 0.44213243546576886, 0.4408353689399441, 0.4394155227488561]
    BCI2000_ConDA_AAf1 = [0.46335815763159616, 0.4669087435978887, 0.4722653921960161, 0.47374091634773746, 0.47420991193121065, 0.47330604042766383, 0.47015474354189973, 0.4702135118191932, 0.4697824768503502, 0.4686944603797665, 0.4662972290570494, 0.46321438709521967, 0.462524732687416, 0.461690363157991, 0.46102820205116524, 0.45772802668528584, 0.45624375955963803, 0.4558125648492621, 0.45541605494581655, 0.45484310569346525, 0.45474863906573554, 0.45422532998580495, 0.45393294204699686, 0.45354186045668765, 0.45356928467215823, 0.45283518859366445, 0.4520817839485626, 0.4517036726647965, 0.45039298734360317, 0.44901824920798333, 0.44820083917580733, 0.4474713615736424, 0.44576993582277646, 0.44537020060748356, 0.4451496492444263, 0.4445113161053879, 0.44343875004390165, 0.4417339536976957, 0.44014943937883916, 0.43890545111487267, 0.4376588292446268, 0.43720146507114005, 0.43696445478786705, 0.4351603139592175, 0.4333224830931325, 0.4317886860337655, 0.4301289031857849, 0.4286851906172986, 0.42706525784796373, 0.42534790318471344, 0.4233050098116586, 0.42106667425363403]

