(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[     52967,       1338]
NotebookOptionsPosition[     46421,       1226]
NotebookOutlinePosition[     46826,       1242]
CellTagsIndexPosition[     46783,       1239]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.96635841867555*^9, 3.966358450282349*^9}, 
   3.9663584808892117`*^9},
 CellLabel->"In[88]:=",ExpressionUUID->"61c9f1a4-2075-4cc9-80ee-7bded3dbc04c"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.9671987585743856`*^9, 
  3.9671987831479073`*^9}},ExpressionUUID->"f61cc423-f130-4b15-91d1-\
07348a91919e"],

Cell[TextData[StyleBox["Importing noised data generated from Jupyter \
notebook. Setting up exponential map parameterization of rotations and \
corresponding Haar measure used to perform numeric integration. Also setting \
up region we integrate over in exponential map parameterization. Sigmas setup \
in same way as notebook.",
 Background->RGBColor[1, 1, 0.85]]], "Text",
 CellChangeTimes->{{3.967198791382806*^9, 3.967198894474215*^9}, {
  3.9671989478736267`*^9, 3.967198964107039*^9}, {3.9671993062936907`*^9, 
  3.967199314340193*^9}},
 Background->RGBColor[
  1, 1, 0.85],ExpressionUUID->"42379271-40a5-44ff-97be-9e42631f1f85"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
     "\"\<data_for_Mathematica/x.csv\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"X", "-", 
    RowBox[{"ConstantArray", "[", 
     RowBox[{
      RowBox[{"Mean", "[", "X", "]"}], ",", 
      RowBox[{"X", "//", "Length"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ys", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
     "\"\<data_for_Mathematica/ys.csv\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ys", "=", 
   RowBox[{"ArrayReshape", "[", 
    RowBox[{"Ys", ",", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Length", "[", "Ys", "]"}], "}"}], ",", 
       RowBox[{"Dimensions", "[", "X", "]"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sigmas", "=", 
   RowBox[{"0.05", "*", 
    SuperscriptBox["200", 
     RowBox[{"Subdivide", "[", "14", "]"}]]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.966355126303361*^9, 3.9663551360279427`*^9}, {
   3.9663552374676437`*^9, 3.966355277052796*^9}, {3.966355592064575*^9, 
   3.9663556000862703`*^9}, 3.966355638238693*^9, {3.96635651189598*^9, 
   3.9663565188208647`*^9}, {3.966356557964477*^9, 3.9663565890131702`*^9}, {
   3.96635662377136*^9, 3.966356632019526*^9}, {3.966357397126141*^9, 
   3.96635742841925*^9}, {3.966358154389456*^9, 3.966358154743073*^9}, {
   3.966358305371603*^9, 3.966358308891471*^9}, {3.966358385948141*^9, 
   3.9663584127953243`*^9}},
 CellLabel->"In[89]:=",ExpressionUUID->"145c222b-7ff0-4b7f-9e1a-71c6d4f0d9d9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"RotFromVec", "[", "vec_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"normed", ",", "angle"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"angle", "=", 
       RowBox[{"Norm", "[", "vec", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"normed", "=", 
       RowBox[{"vec", "/", "angle"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IdentityMatrix", "[", "3", "]"}], "-", 
            RowBox[{"Outer", "[", 
             RowBox[{"Times", ",", "normed", ",", "normed"}], "]"}]}], ")"}], 
          "*", 
          RowBox[{"Cos", "[", "angle", "]"}]}], "+", 
         RowBox[{"Outer", "[", 
          RowBox[{"Times", ",", "normed", ",", "normed"}], "]"}], "-", 
         RowBox[{
          RowBox[{
           RowBox[{"LeviCivitaTensor", "[", "3", "]"}], ".", "normed"}], "*", 
          
          RowBox[{"Sin", "[", "angle", "]"}]}]}], ",", 
        RowBox[{"Assumptions", "->", 
         RowBox[{"vec", "\[Element]", "Reals"}]}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"HaarMeasureVec", "[", "vec_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"normed", ",", "angle"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"angle", "=", 
       RowBox[{"Norm", "[", "vec", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"1", "-", 
          RowBox[{"Cos", "[", "angle", "]"}]}], 
         RowBox[{"4", 
          SuperscriptBox["\[Pi]", "2"], 
          SuperscriptBox["angle", "2"]}]], ",", 
        RowBox[{"Assumptions", "->", 
         RowBox[{"vec", "\[Element]", "Reals"}]}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ")"}]}]}], "Input",
 CellLabel->"In[94]:=",ExpressionUUID->"a9bc0472-4cb6-458f-bfac-773a0b57ad47"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"region", "=", 
   RowBox[{"ImplicitRegion", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}], "<=", 
      SuperscriptBox["\[Pi]", "2"]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"HaarMeasureVec", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "*", "t"}], ",", 
       RowBox[{"y", "*", "t"}], ",", 
       RowBox[{"z", "*", "t"}]}], "}"}], "]"}], "/.", 
    RowBox[{"t", "->", "1"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], "\[Element]", "region"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[96]:=",ExpressionUUID->"4869e405-359d-4a05-b239-09f2328405e8"],

Cell[BoxData["0.9999999985408243`"], "Output",
 CellChangeTimes->{{3.9663583555075417`*^9, 3.966358369065152*^9}, 
   3.9663584880841837`*^9},
 CellLabel->"Out[97]=",ExpressionUUID->"728ee160-fe62-4879-afc4-2f5d473c358b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Ys", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "//", "Transpose"}], ")"}], ".", "X"}], 
  "//", "Dimensions"}]], "Input",
 CellChangeTimes->{{3.9663607037615433`*^9, 3.9663607764152403`*^9}},
 CellLabel->
  "In[104]:=",ExpressionUUID->"a1cc552b-1ac5-4a3e-b2b2-d2f0e63606bf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "3"}], "}"}]], "Output",
 CellChangeTimes->{{3.966360701002408*^9, 3.966360777429256*^9}},
 CellLabel->
  "Out[104]=",ExpressionUUID->"aab9cb2a-b2e4-478c-bca8-ac57ef0d74e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingularValueDecomposition", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"Ys", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}], ".", "X"}], "]"}]], "Input",
 CellChangeTimes->{{3.966360673058675*^9, 3.966360693472354*^9}, {
  3.966360937606159*^9, 3.966360962365717*^9}},
 CellLabel->
  "In[105]:=",ExpressionUUID->"b7902bda-684d-454d-9fcf-903af0239e86"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0.19795753258663668782839065969744758007`16.346533220409718", ",", 
       RowBox[{
       "-", "0.94768593639944136688275983952235284877`16.346533220409718"}], 
       ",", "0.25040802950968774073810102799227616341`16.346533220409718"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.98020921994402851871066277486403734277`16.346533220409718", ",", 
       "0.19181705360433355673819019194937739343`16.346533220409718", ",", 
       RowBox[{
       "-", "0.04895000595782753222282985657381208246`16.346533220409718"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.00164329818651329379812532372168825245`16.346533220409718", ",", 
       RowBox[{
       "-", "0.25514228167292499817881674723420554121`16.346533220409718"}], 
       ",", 
       RowBox[{
       "-", "0.96690212310957514140265569641948546058`16.346533220409718"}]}],
       "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "491.64514620123458319118638831307529280191`16.346533220409718", ",", 
       "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", 
       "377.62935585383501537229100443383831712939`16.346533220409718", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", 
       "238.56577581290563688018821498896869563989`16.346533220409718"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0.19942003628683512551374959339427633137`16.346533220409718", ",", 
       RowBox[{
       "-", "0.94690763936105085951514069110368110807`16.346533220409718"}], 
       ",", "0.25218558968949714116123332882911496847`16.346533220409718"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.97991341428149577343723307468376963014`16.346533220409718", ",", 
       "0.1930079399236169083191047636398135264`16.346533220409718", ",", 
       RowBox[{
       "-", "0.05017604645269614619906730051985986339`16.346533220409718"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.0011617394453994301529901528458094908`16.346533220409718", ",", 
       RowBox[{
       "-", "0.2571261512295541115120358775881985359`16.346533220409718"}], 
       ",", 
       RowBox[{
       "-", "0.96637714827873360247102494416091102556`16.346533220409718"}]}],
       "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.966360963266275*^9},
 CellLabel->
  "Out[105]=",ExpressionUUID->"b0c1ee7e-8350-41db-87fd-f43e5a646f23"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"BadStandard", "[", 
   RowBox[{"x_", ",", "y_", ",", "sig_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{"IdentityMatrix", "[", "3", "]"}], 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Approx0", "[", 
   RowBox[{"x_", ",", "y_", ",", "sig_"}], "]"}], ":=", 
  RowBox[{"(", "SingularValueDecomposition", ")"}]}]}], "Input",
 CellChangeTimes->{{3.966360597777772*^9, 
  3.966360667433936*^9}},ExpressionUUID->"83dd9fb0-4dd7-452a-ae5d-\
a9e1a952298d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical integration", "Section",
 CellChangeTimes->{{3.967198920796229*^9, 
  3.9671989261800423`*^9}},ExpressionUUID->"2c75b252-8e0c-44bc-a2a4-\
e06b2bf1e113"],

Cell[TextData[StyleBox["Perform numerical integration to estimate expected \
rotation. We cycle through the noise levels \[Sigma] which have 10 different \
y samples as done in the Jupyter notebook.",
 Background->RGBColor[1, 1, 0.85]]], "Text",
 CellChangeTimes->{{3.967198933524026*^9, 3.96719893462323*^9}, {
  3.967198967745069*^9, 3.967198977654294*^9}, {3.967199023165453*^9, 
  3.967199106203372*^9}},
 Background->RGBColor[
  1, 1, 0.85],ExpressionUUID->"eed9ca2e-15b2-4485-9ba3-f14bcc1db501"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"yi", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"region", "=", 
   RowBox[{"ImplicitRegion", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}], "<=", 
      SuperscriptBox["\[Pi]", "2"]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ERs", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"sigmai", "=", "1"}], ",", 
   RowBox[{"sigmai", "<=", 
    RowBox[{"Length", "[", "Sigmas", "]"}]}], ",", 
   RowBox[{"sigmai", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "sigmai", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"sigma", "=", 
     RowBox[{"Sigmas", "[", 
      RowBox[{"[", "sigmai", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"numi", "=", "1"}], ",", 
      RowBox[{"numi", "<=", "10"}], ",", 
      RowBox[{"numi", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Y", "=", 
        RowBox[{"Ys", "[", 
         RowBox[{"[", "yi", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"F", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Transpose", "[", "Y", "]"}], ".", "X"}], "/", 
         RowBox[{"(", 
          SuperscriptBox["sigma", "2"], ")"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"USA", "=", 
        RowBox[{"SingularValueDecomposition", "[", "F", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"U", "=", 
        RowBox[{"USA", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"S", "=", 
        RowBox[{"USA", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"A", "=", 
        RowBox[{"USA", "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Signs", "=", 
        RowBox[{"DiagonalMatrix", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", 
           RowBox[{"Det", "[", 
            RowBox[{"U", ".", 
             RowBox[{"Transpose", "[", "A", "]"}]}], "]"}]}], "}"}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"SSigned", "=", 
        RowBox[{"S", ".", "Signs"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Z", "=", 
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"HaarMeasureVec", "[", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{"Tr", "[", 
             RowBox[{
              RowBox[{"Transpose", "[", "SSigned", "]"}], ".", 
              RowBox[{"RotFromVec", "[", 
               RowBox[{"{", 
                RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]}], "]"}], 
            "]"}]}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x", ",", "y", ",", "z"}], "}"}], "\[Element]", 
           "region"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"ZR", "=", 
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{"Diagonal", "[", 
           RowBox[{
            RowBox[{"HaarMeasureVec", "[", 
             RowBox[{"{", 
              RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], "*", 
            RowBox[{"Exp", "[", 
             RowBox[{"Tr", "[", 
              RowBox[{
               RowBox[{"Transpose", "[", "SSigned", "]"}], ".", 
               RowBox[{"RotFromVec", "[", 
                RowBox[{"{", 
                 RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]}], "]"}], 
             "]"}], "*", 
            RowBox[{"RotFromVec", "[", 
             RowBox[{"{", 
              RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]}], "]"}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x", ",", "y", ",", "z"}], "}"}], "\[Element]", 
           "region"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"ER", "=", 
        RowBox[{"U", ".", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"DiagonalMatrix", "[", "ZR", "]"}], "/", "Z"}], ")"}], ".",
          "Signs", ".", 
         RowBox[{"Transpose", "[", "A", "]"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"ERs", ",", "ER"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"yi", "++"}], ";"}]}], "]"}], ";"}]}], "\[IndentingNewLine]", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966358533026937*^9, 3.966358538849854*^9}, {
   3.966360379660527*^9, 3.966360460602265*^9}, {3.966360494188191*^9, 
   3.966360542289503*^9}, {3.966361031637637*^9, 3.966361157857705*^9}, {
   3.966361265035551*^9, 3.966361344914819*^9}, {3.9663613988538427`*^9, 
   3.96636147998429*^9}, {3.966361534424999*^9, 3.966361568272071*^9}, {
   3.9663615988082523`*^9, 3.966361636430842*^9}, {3.9663616923758583`*^9, 
   3.96636169432574*^9}, 3.96636189881287*^9, {3.966383826347546*^9, 
   3.966383830139887*^9}, {3.966427868678846*^9, 3.966427875911302*^9}, {
   3.966427908460622*^9, 3.966427957188664*^9}, {3.966428000003017*^9, 
   3.966428046165051*^9}, {3.966428083427388*^9, 3.966428084026491*^9}, 
   3.966428158019396*^9, {3.966428207426689*^9, 3.966428209584354*^9}, {
   3.966428247202969*^9, 3.9664282722729063`*^9}, {3.966428304953467*^9, 
   3.966428306152207*^9}, {3.966428524609177*^9, 3.966428527021635*^9}, {
   3.9664289720736837`*^9, 3.966429033440329*^9}, 3.96642907053675*^9},
 CellLabel->
  "In[262]:=",ExpressionUUID->"d559ffa8-6ada-4e3d-a4f1-16a415511389"],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellChangeTimes->{
  3.966361638074028*^9, 3.966361699202702*^9, 3.966383832529248*^9, 
   3.9664278767806597`*^9, {3.96642802491603*^9, 3.966428047348445*^9}, 
   3.9664280884213037`*^9, 3.9664281303413343`*^9, 3.966428169312595*^9, 
   3.9664282104169064`*^9, {3.966428253808386*^9, 3.966428273389955*^9}, 
   3.966428307775043*^9, 3.9664285297025833`*^9, {3.966429065225563*^9, 
   3.966429075259921*^9}},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"27383582-dfa4-437a-b21a-4536c7f5e5a3"],

Cell[BoxData["2"], "Print",
 CellChangeTimes->{
  3.966361638074028*^9, 3.966361699202702*^9, 3.966383832529248*^9, 
   3.9664278767806597`*^9, {3.96642802491603*^9, 3.966428047348445*^9}, 
   3.9664280884213037`*^9, 3.9664281303413343`*^9, 3.966428169312595*^9, 
   3.9664282104169064`*^9, {3.966428253808386*^9, 3.966428273389955*^9}, 
   3.966428307775043*^9, 3.9664285297025833`*^9, 3.966429065225563*^9, 
   3.966429116164591*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"75bc6167-5c0c-46d2-83a5-64af60a1cec5"],

Cell[BoxData["3"], "Print",
 CellChangeTimes->{
  3.966361638074028*^9, 3.966361699202702*^9, 3.966383832529248*^9, 
   3.9664278767806597`*^9, {3.96642802491603*^9, 3.966428047348445*^9}, 
   3.9664280884213037`*^9, 3.9664281303413343`*^9, 3.966428169312595*^9, 
   3.9664282104169064`*^9, {3.966428253808386*^9, 3.966428273389955*^9}, 
   3.966428307775043*^9, 3.9664285297025833`*^9, 3.966429065225563*^9, 
   3.966429153471724*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"ac76d59e-d6b6-4291-b98d-d3c55d024c6a"],

Cell[BoxData["4"], "Print",
 CellChangeTimes->{
  3.966361638074028*^9, 3.966361699202702*^9, 3.966383832529248*^9, 
   3.9664278767806597`*^9, {3.96642802491603*^9, 3.966428047348445*^9}, 
   3.9664280884213037`*^9, 3.9664281303413343`*^9, 3.966428169312595*^9, 
   3.9664282104169064`*^9, {3.966428253808386*^9, 3.966428273389955*^9}, 
   3.966428307775043*^9, 3.9664285297025833`*^9, 3.966429065225563*^9, 
   3.966429191149231*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"cba218ef-af36-4d1b-92b3-9be7d3815408"],

Cell[BoxData["5"], "Print",
 CellChangeTimes->{
  3.966361638074028*^9, 3.966361699202702*^9, 3.966383832529248*^9, 
   3.9664278767806597`*^9, {3.96642802491603*^9, 3.966428047348445*^9}, 
   3.9664280884213037`*^9, 3.9664281303413343`*^9, 3.966428169312595*^9, 
   3.9664282104169064`*^9, {3.966428253808386*^9, 3.966428273389955*^9}, 
   3.966428307775043*^9, 3.9664285297025833`*^9, 3.966429065225563*^9, 
   3.966429233190543*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"118a97f1-df45-482e-889c-b0d518348c38"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "slwcon", 
   "\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"", 2, 265, 61, 
   24873747551375855977, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.966429242729279*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"4b7719e3-6823-465c-ba15-e0a6728f56bf"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "slwcon", 
   "\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"", 2, 265, 62, 
   24873747551375855977, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.966429243963076*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"a6585c13-1435-42c0-ab36-e7963d756d73"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "slwcon", 
   "\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"", 2, 265, 63, 
   24873747551375855977, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.966429244742066*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"c0a8c4cb-4a1a-4452-89ce-0f0088a917f1"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"slwcon\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 265, 64, 24873747551375855977, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9664292447533007`*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"c2c42da4-444f-4e80-9ed2-2b110322f55e"],

Cell[CellGroupData[{

Cell[BoxData["6"], "Print",
 CellChangeTimes->{
  3.966361638074028*^9, 3.966361699202702*^9, 3.966383832529248*^9, 
   3.9664278767806597`*^9, {3.96642802491603*^9, 3.966428047348445*^9}, 
   3.9664280884213037`*^9, 3.9664281303413343`*^9, 3.966428169312595*^9, 
   3.9664282104169064`*^9, {3.966428253808386*^9, 3.966428273389955*^9}, 
   3.966428307775043*^9, 3.9664285297025833`*^9, 3.966429065225563*^9, 
   3.966429275661356*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"641e2c72-30a0-4b18-bdfd-a19c01c0922a"],

Cell[BoxData["7"], "Print",
 CellChangeTimes->{
  3.966361638074028*^9, 3.966361699202702*^9, 3.966383832529248*^9, 
   3.9664278767806597`*^9, {3.96642802491603*^9, 3.966428047348445*^9}, 
   3.9664280884213037`*^9, 3.9664281303413343`*^9, 3.966428169312595*^9, 
   3.9664282104169064`*^9, {3.966428253808386*^9, 3.966428273389955*^9}, 
   3.966428307775043*^9, 3.9664285297025833`*^9, 3.966429065225563*^9, 
   3.9664293254412613`*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"74085eb9-70af-4e8b-999f-56e840fda392"],

Cell[BoxData["8"], "Print",
 CellChangeTimes->{
  3.966361638074028*^9, 3.966361699202702*^9, 3.966383832529248*^9, 
   3.9664278767806597`*^9, {3.96642802491603*^9, 3.966428047348445*^9}, 
   3.9664280884213037`*^9, 3.9664281303413343`*^9, 3.966428169312595*^9, 
   3.9664282104169064`*^9, {3.966428253808386*^9, 3.966428273389955*^9}, 
   3.966428307775043*^9, 3.9664285297025833`*^9, 3.966429065225563*^9, 
   3.9664293729956017`*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"577b67b6-a981-458e-b4fa-940412b1d809"],

Cell[BoxData["9"], "Print",
 CellChangeTimes->{
  3.966361638074028*^9, 3.966361699202702*^9, 3.966383832529248*^9, 
   3.9664278767806597`*^9, {3.96642802491603*^9, 3.966428047348445*^9}, 
   3.9664280884213037`*^9, 3.9664281303413343`*^9, 3.966428169312595*^9, 
   3.9664282104169064`*^9, {3.966428253808386*^9, 3.966428273389955*^9}, 
   3.966428307775043*^9, 3.9664285297025833`*^9, 3.966429065225563*^9, 
   3.9664294186525087`*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"cab720f7-e4f3-4c02-b38b-56e6dd9942a2"],

Cell[BoxData["10"], "Print",
 CellChangeTimes->{
  3.966361638074028*^9, 3.966361699202702*^9, 3.966383832529248*^9, 
   3.9664278767806597`*^9, {3.96642802491603*^9, 3.966428047348445*^9}, 
   3.9664280884213037`*^9, 3.9664281303413343`*^9, 3.966428169312595*^9, 
   3.9664282104169064`*^9, {3.966428253808386*^9, 3.966428273389955*^9}, 
   3.966428307775043*^9, 3.9664285297025833`*^9, 3.966429065225563*^9, 
   3.966429462497253*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"1ac34b4d-0f77-4589-81c4-4c5f6171603c"],

Cell[BoxData["11"], "Print",
 CellChangeTimes->{
  3.966361638074028*^9, 3.966361699202702*^9, 3.966383832529248*^9, 
   3.9664278767806597`*^9, {3.96642802491603*^9, 3.966428047348445*^9}, 
   3.9664280884213037`*^9, 3.9664281303413343`*^9, 3.966428169312595*^9, 
   3.9664282104169064`*^9, {3.966428253808386*^9, 3.966428273389955*^9}, 
   3.966428307775043*^9, 3.9664285297025833`*^9, 3.966429065225563*^9, 
   3.966429478506393*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"4cb5c73a-09bb-4c7d-bb49-74fc3ce3340a"],

Cell[BoxData["12"], "Print",
 CellChangeTimes->{
  3.966361638074028*^9, 3.966361699202702*^9, 3.966383832529248*^9, 
   3.9664278767806597`*^9, {3.96642802491603*^9, 3.966428047348445*^9}, 
   3.9664280884213037`*^9, 3.9664281303413343`*^9, 3.966428169312595*^9, 
   3.9664282104169064`*^9, {3.966428253808386*^9, 3.966428273389955*^9}, 
   3.966428307775043*^9, 3.9664285297025833`*^9, 3.966429065225563*^9, 
   3.9664295029105663`*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"cd952139-bbf2-478a-9a93-d5650fba18b7"],

Cell[BoxData["13"], "Print",
 CellChangeTimes->{
  3.966361638074028*^9, 3.966361699202702*^9, 3.966383832529248*^9, 
   3.9664278767806597`*^9, {3.96642802491603*^9, 3.966428047348445*^9}, 
   3.9664280884213037`*^9, 3.9664281303413343`*^9, 3.966428169312595*^9, 
   3.9664282104169064`*^9, {3.966428253808386*^9, 3.966428273389955*^9}, 
   3.966428307775043*^9, 3.9664285297025833`*^9, 3.966429065225563*^9, 
   3.966429541058235*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"3f89c781-f77d-431a-be23-04ad618aadd1"],

Cell[BoxData["14"], "Print",
 CellChangeTimes->{
  3.966361638074028*^9, 3.966361699202702*^9, 3.966383832529248*^9, 
   3.9664278767806597`*^9, {3.96642802491603*^9, 3.966428047348445*^9}, 
   3.9664280884213037`*^9, 3.9664281303413343`*^9, 3.966428169312595*^9, 
   3.9664282104169064`*^9, {3.966428253808386*^9, 3.966428273389955*^9}, 
   3.966428307775043*^9, 3.9664285297025833`*^9, 3.966429065225563*^9, 
   3.966429586004821*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"9c32c697-42e5-4e99-bd9f-c9544da2c70d"],

Cell[BoxData["15"], "Print",
 CellChangeTimes->{
  3.966361638074028*^9, 3.966361699202702*^9, 3.966383832529248*^9, 
   3.9664278767806597`*^9, {3.96642802491603*^9, 3.966428047348445*^9}, 
   3.9664280884213037`*^9, 3.9664281303413343`*^9, 3.966428169312595*^9, 
   3.9664282104169064`*^9, {3.966428253808386*^9, 3.966428273389955*^9}, 
   3.966428307775043*^9, 3.9664285297025833`*^9, 3.966429065225563*^9, 
   3.966429627870675*^9},
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"cfbcf7ad-c129-4f09-b58c-d3dd236d362e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "ERs", "]"}]], "Input",
 CellChangeTimes->{{3.9664304305571547`*^9, 3.966430433891919*^9}},
 CellLabel->
  "In[266]:=",ExpressionUUID->"c99a18e7-6467-4db6-a468-805d1dd93ccc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"150", ",", "3", ",", "3"}], "}"}]], "Output",
 CellChangeTimes->{3.966430434691329*^9},
 CellLabel->
  "Out[266]=",ExpressionUUID->"4583c80e-3d80-40e2-9d96-1639da8c3e5f"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FlatERs", "=", 
   RowBox[{"ArrayReshape", "[", 
    RowBox[{"ERs", ",", 
     RowBox[{"{", 
      RowBox[{"150", ",", "9"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
     "\"\<data_for_Mathematica/FlatERs.csv\>\""}], ",", "FlatERs"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9664306340666857`*^9, 3.966430754345175*^9}, {
  3.96643090412869*^9, 3.9664309165674686`*^9}},
 CellLabel->
  "In[281]:=",ExpressionUUID->"286c55a8-f2f2-4404-91c2-d2d053dd2880"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"Transpose", "[", 
   SuperscriptBox["X", "2"], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.966428641667766*^9, 3.9664286690026827`*^9}},
 CellLabel->
  "In[257]:=",ExpressionUUID->"fa3aaf20-7912-4c78-ab7f-79aea0c1e7c4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "21.21902657075548939019948921950006655787`17.962664372475313", ",", 
   "18.44540474134719080450786612212982995107`17.946780840152194", ",", 
   "22.72240194115706387341643900222012318889`17.925913905016994", ",", 
   "30.20082850392636609917257639027573061273`18.051823301594577", ",", 
   "13.87573079228358565026236468286404942147`17.858916727286307", ",", 
   "20.45964764396697367699302453689475957713`17.902440167951294", ",", 
   "14.6855936720132935745624127438494893365`17.84239488207127", ",", 
   "24.21518580430968281390476063924140616056`17.95775877701616", ",", 
   "11.51717272052437155672857497293890299522`17.885094868868272", ",", 
   "13.99248560962170051971625516836998593081`17.818111907004283", ",", 
   "6.52278785281795997314293112883827210578`17.71867297623068", ",", 
   "7.11268269938349788918967798100130809664`17.66290276165636", ",", 
   "5.93401767328993984671243611380325176021`17.766686198113966", ",", 
   "8.93417474068121075801842474873723765625`17.758072105799098", ",", 
   "6.05967543770726901925696900691846436445`17.68111748723248", ",", 
   "8.62812522755021725442870614003146875814`17.76164052990449", ",", 
   "14.82479412462133662955716486869294531342`17.8132984806771", ",", 
   "15.91169784285978444799266598299849608312`17.822764100691913", ",", 
   "18.58225398573810673210466333792696331619`17.87295236249852", ",", 
   "25.86919130516539659134495160080565001075`17.961564352257763", ",", 
   "24.73357538177041370793444742223541382099`18.017503296186216", ",", 
   "35.48834037462791563125164753852074195871`18.01331693626441", ",", 
   "32.56380508364073849150594364778795251476`18.06309225593535", ",", 
   "30.37853307867358730635188624692742874131`18.03499250444567", ",", 
   "47.07707579265837292613735504944265665736`18.15740484496427", ",", 
   "3.55164764029630588484263779691666636514`17.665563736354837", ",", 
   "8.52046740344040024016385164194007818041`17.902283151741987", ",", 
   "1.46843765361953733621842281605426304491`17.648409434593155", ",", 
   "1.22742447508307229647538071038794865118`17.47332931881342", ",", 
   "5.28668117652672354076011585635347658367`17.644955925778454", ",", 
   "9.96305291774674175401663437480211024668`17.72628538008283", ",", 
   "8.90451551400540265475051293130578776622`17.78866154388032", ",", 
   "7.65482177609322884475184309843936985902`17.807374457663418", ",", 
   "14.61092722718653409090797134698567394552`17.96631087914061", ",", 
   "15.2523474542223029533181779892661487558`17.886897767082413", ",", 
   "20.32251381823514310344661627359381943515`17.93482682461902", ",", 
   "12.84355311960325318608129092025485224718`17.861222384299744", ",", 
   "26.1191148623884287874029297073609421725`17.958684400039896", ",", 
   "28.14800369969697394075472871963449220625`17.965128848709746", ",", 
   "39.18325906007707000730158200261776496905`18.07905732430451", ",", 
   "50.58088819685493354562547740144064637682`18.097464733110765", ",", 
   "41.38511087861871247557206110038930222211`18.10562258918779", ",", 
   "8.57383439759639355019192924543530020754`17.751111984381012", ",", 
   "17.0447187973245229087679161548394446563`17.900292281118983", ",", 
   "7.74589371117946842667528370321374595252`17.722238162571283", ",", 
   "4.8618831220337168749794812956338074661`17.64041942305155", ",", 
   "17.55599498504956600758966259418348911537`17.866316416986056", ",", 
   "24.14987287396535233602809591536877285722`17.929637029235455", ",", 
   "21.62534206919930643519954654358573529774`17.969168492313397", ",", 
   "32.98240260777274996134802225589872057249`18.06844007242759", ",", 
   "23.17495807106679146989849274886560408835`17.962452890306114", ",", 
   "19.08960233105241681531547286314425598843`17.980205081020877", ",", 
   "24.04414278388501164464509028883123568676`17.96738709088255", ",", 
   "16.05595236785847862799009272377742189558`18.052618120045114", ",", 
   "18.04259602603219276081887711511271251549`18.03369139234024", ",", 
   "14.73443654673851474178513138472348723457`18.01457086710187", ",", 
   "23.59947333681673761504191344373632052285`17.926646515863137", ",", 
   "20.48920850829788732221542599430096118205`17.961717894412303", ",", 
   "36.52807998642775190223871337441137048224`18.0173788035909"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.966428648705223*^9, 3.9664286700249977`*^9}},
 CellLabel->
  "Out[257]=",ExpressionUUID->"5a33d410-1fa2-4129-b0d5-d359e81eaca3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["F"], "Input",
 CellChangeTimes->{
  3.966428201241366*^9, 3.966428504541197*^9, {3.966428574875834*^9, 
   3.966428577203679*^9}},
 CellLabel->
  "In[243]:=",ExpressionUUID->"2354c628-ba52-4819-9d03-b6b9c54ca905"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "2.5134450359765617`", ",", "0.09671998941866485`", ",", 
     "0.42015089155635726`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3649542826119873`", ",", "5.370872896517285`", ",", 
     RowBox[{"-", "4.814127881339084`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.7798883534855876`", ",", "1.7672545016260628`", ",", 
     "3.7171287847628545`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.966428201961413*^9, 3.966428217182906*^9}, 
   3.966428505291374*^9, 3.966428535579925*^9, 3.9664285776742973`*^9},
 CellLabel->
  "Out[243]=",ExpressionUUID->"ee6ff104-f9cc-4d12-a29b-8703719d79cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ER", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.966427886389502*^9, 3.966427886536434*^9}, {
  3.9664280584427433`*^9, 3.96642805979408*^9}},
 CellLabel->
  "In[242]:=",ExpressionUUID->"bb3179cd-f9df-4259-b27f-a9447423486c"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.8452619609052971`", 
      RowBox[{"-", "0.15615467982406683`"}], 
      RowBox[{"-", "0.10951683114939963`"}]},
     {"0.061546016507686686`", "0.7174510292571068`", 
      RowBox[{"-", "0.5404280339623343`"}]},
     {"0.19113924428972975`", "0.49483476152011907`", "0.6977024249188264`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.9664278882728157`*^9, {3.966428034707285*^9, 3.966428060289747*^9}, {
   3.966428113269244*^9, 3.966428138760934*^9}, 3.966428176618249*^9, 
   3.9664282213993273`*^9, 3.966428261985632*^9, {3.966428293873592*^9, 
   3.966428315543652*^9}, 3.966428539124318*^9},
 CellLabel->
  "Out[242]//MatrixForm=",ExpressionUUID->"cfb8ca38-fc26-4997-a340-\
234db867c99f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Z"], "Input",
 CellChangeTimes->{3.9663619060354233`*^9},
 CellLabel->
  "In[130]:=",ExpressionUUID->"2a957c1b-e0ce-4d23-9da6-b7234d9e090f"],

Cell[BoxData["Z"], "Output",
 CellChangeTimes->{3.966361907288967*^9},
 CellLabel->
  "Out[130]=",ExpressionUUID->"6f9f5591-49fb-4051-9d1a-98a1827fb1cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"USA", "=", 
   RowBox[{"SingularValueDecomposition", "[", "F", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"USA", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "=", 
   RowBox[{"USA", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"USA", "[", 
    RowBox[{"[", "3", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SSigned", "=", 
  RowBox[{"S", ".", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", 
      RowBox[{"Det", "[", 
       RowBox[{"U", ".", 
        RowBox[{"Transpose", "[", "A", "]"}]}], "]"}]}], "}"}], 
    "]"}]}]}]}], "Input",
 CellChangeTimes->{
  3.966361916331856*^9, {3.966362007114287*^9, 3.966362015165452*^9}, {
   3.966362110465365*^9, 3.966362175448636*^9}, {3.9663622429277554`*^9, 
   3.966362297167351*^9}, {3.966428586620751*^9, 3.966428593451849*^9}},
 CellLabel->
  "In[283]:=",ExpressionUUID->"72cb947d-ab5d-4497-b6ce-335a38efcab6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6.200945989238999`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "3.642516303721961`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "2.399821824540354`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.966362276254167*^9, 3.966362298913493*^9}, 
   3.96642796174433*^9, 3.966428146198004*^9, 3.96642818457134*^9, {
   3.966428581055996*^9, 3.9664285945411367`*^9}, 3.9664311608361483`*^9},
 CellLabel->
  "Out[287]=",ExpressionUUID->"b3b5bdd5-7c61-4c45-b5b8-57a86817cbc2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"F", ",", 
   RowBox[{"U", ".", "S", ".", 
    RowBox[{"Transpose", "[", "A", "]"}]}]}], "}"}]], "Input",
 CellChangeTimes->{{3.966431164852049*^9, 3.966431177213504*^9}},
 CellLabel->
  "In[289]:=",ExpressionUUID->"dd094840-092f-4985-be37-95841b3712b2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "4.264238543097918`", ",", "1.3724294284569205`", ",", 
       "0.74680787761912`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.17052452583956304`"}], ",", "2.546999932132475`", ",", 
       
       RowBox[{"-", "0.30416786437040705`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.9380008458321765`"}], ",", 
       RowBox[{"-", "1.4336524017544952`"}], ",", "4.42241704751949`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "4.264238543097918`", ",", "1.372429428456921`", ",", 
       "0.7468078776191182`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.17052452583956285`"}], ",", "2.546999932132473`", ",", 
       
       RowBox[{"-", "0.3041678643704074`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.938000845832176`"}], ",", 
       RowBox[{"-", "1.4336524017544947`"}], ",", "4.422417047519489`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.966431165560108*^9, 3.966431177689109*^9}},
 CellLabel->
  "Out[289]=",ExpressionUUID->"ff38ca0f-d0df-42b2-b6b1-e66a27013b06"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Det", "[", 
    RowBox[{"U", ".", 
     RowBox[{"Transpose", "[", "A", "]"}]}], "]"}], ",", "F"}], 
  "}"}]], "Input",
 CellChangeTimes->{{3.966362179905148*^9, 3.9663622302232933`*^9}},
 CellLabel->
  "In[148]:=",ExpressionUUID->"c5eb59a1-a4b3-4ff6-b676-b7a2b98bf7bd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9999999999999996`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "149338.9762879956`", ",", "9319.980234447541`", ",", 
       "13760.656209031913`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9827.436182629419`", ",", "194720.67871159516`", ",", 
       RowBox[{"-", "2712.044233660925`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13289.334125167617`", ",", 
       RowBox[{"-", "2492.150405082667`"}], ",", "99075.5286814021`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9663621821191273`*^9, 3.966362230971367*^9}},
 CellLabel->
  "Out[148]=",ExpressionUUID->"dbeda9b5-bc93-4252-8613-41ddcb835f81"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"HaarMeasureVec", "[", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], "*", 
     RowBox[{"Exp", "[", 
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "SSigned", "]"}], ".", 
        RowBox[{"RotFromVec", "[", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]}], "]"}], "]"}]}], 
    ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], "\[Element]", "region"}]}], 
   "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.966362303280262*^9, 3.966362304766762*^9}, {
   3.966383768544031*^9, 3.9663837832305517`*^9}, 3.9663839474056807`*^9},
 CellLabel->
  "In[175]:=",ExpressionUUID->"b3fd1ca1-c528-4439-b188-2b4143e4814d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.344792`", ",", 
   "4.660496330885337874523513622308253`15.954589770191005*^192442"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.966362103423818*^9, 3.966362393545454*^9, 3.9663838091785927`*^9, {
   3.9663839359655*^9, 3.966383950131098*^9}},
 CellLabel->
  "Out[175]=",ExpressionUUID->"1d0dba1b-b678-4f9c-8ba4-17cb23a9f31f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"HaarMeasureVec", "[", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], "*", 
     RowBox[{"Exp", "[", 
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "SSigned", "]"}], ".", 
        RowBox[{"RotFromVec", "[", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]}], "]"}], "]"}], 
     "*", 
     RowBox[{"Diagonal", "[", 
      RowBox[{"RotFromVec", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], "\[Element]", "region"}]}], 
   "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.966383959301238*^9, 3.966383961985594*^9}, {
  3.966415493586707*^9, 3.9664155117957363`*^9}},
 CellLabel->
  "In[177]:=",ExpressionUUID->"3a8d93c8-4e85-4f16-b945-3d67b52d7485"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.050139`", ",", 
   RowBox[{"{", 
    RowBox[{
    "4.660481651172778772239727607533698`15.954589770191005*^192442", ",", 
     "4.660480174986731893097393095208099`15.954589770191005*^192442", ",", 
     "4.660478898691974094059131611354398`15.954589770191005*^192442"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.966384108463863*^9, 3.966415519833044*^9},
 CellLabel->
  "Out[177]=",ExpressionUUID->"334ea7b5-2dd7-474e-a204-cfe2a200d93a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"Tr", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", "SSigned", "]"}], ".", 
    RowBox[{"RotFromVec", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9663837477217216`*^9, 3.966383763663323*^9}},
 CellLabel->
  "In[162]:=",ExpressionUUID->"ac4c6d66-7470-4157-a34e-d57ca6e15b35"],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"0.`", "\[VeryThinSpace]", "+", 
   FractionBox[
    RowBox[{"95426.31032516221`", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["z", "2"], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}]], "]"}]}]}], ")"}]}], 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"], "+", 
     SuperscriptBox["z", "2"]}]], "+", 
   FractionBox[
    RowBox[{"151051.74234153394`", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["y", "2"], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}]], "]"}]}]}], ")"}]}], 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"], "+", 
     SuperscriptBox["z", "2"]}]], "+", 
   FractionBox[
    RowBox[{"196658.0584804937`", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}]], "]"}]}]}], ")"}]}], 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"], "+", 
     SuperscriptBox["z", "2"]}]]}]]], "Output",
 CellChangeTimes->{{3.9663837353174667`*^9, 3.9663837644084682`*^9}},
 CellLabel->
  "Out[162]=",ExpressionUUID->"cbc9d3ae-caca-44a7-bb9c-44760167e823"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"1", "+", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.9663837855045156`*^9, 3.966383799967656*^9}},
 CellLabel->
  "In[169]:=",ExpressionUUID->"dabb6e3a-e4df-47b9-a2c2-d6e2c6a4c224"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7.`*^-6", ",", "2"}], "}"}]], "Output",
 CellChangeTimes->{{3.9663837887144833`*^9, 3.966383806000051*^9}},
 CellLabel->
  "Out[169]=",ExpressionUUID->"89b01791-4950-47e5-950a-f7441a19f828"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1915.5, 1055.25},
WindowMargins->{{Automatic, -227.25}, {922.5, Automatic}},
FrontEndVersion->"14.1 for Linux x86 (64-bit) (July 16, 2024)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"6e0d629d-c581-4fbd-af10-53f8302eb145"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[554, 20, 248, 4, 29, "Input",ExpressionUUID->"61c9f1a4-2075-4cc9-80ee-7bded3dbc04c"],
Cell[CellGroupData[{
Cell[827, 28, 154, 3, 65, "Section",ExpressionUUID->"f61cc423-f130-4b15-91d1-07348a91919e"],
Cell[984, 33, 635, 10, 71, "Text",ExpressionUUID->"42379271-40a5-44ff-97be-9e42631f1f85"],
Cell[1622, 45, 1753, 46, 109, "Input",ExpressionUUID->"145c222b-7ff0-4b7f-9e1a-71c6d4f0d9d9"],
Cell[3378, 93, 2193, 56, 357, "Input",ExpressionUUID->"a9bc0472-4cb6-458f-bfac-773a0b57ad47"],
Cell[CellGroupData[{
Cell[5596, 153, 899, 28, 51, "Input",ExpressionUUID->"4869e405-359d-4a05-b239-09f2328405e8"],
Cell[6498, 183, 221, 3, 33, "Output",ExpressionUUID->"728ee160-fe62-4879-afc4-2f5d473c358b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6756, 191, 355, 10, 29, "Input",ExpressionUUID->"a1cc552b-1ac5-4a3e-b2b2-d2f0e63606bf"],
Cell[7114, 203, 222, 5, 33, "Output",ExpressionUUID->"aab9cb2a-b2e4-478c-bca8-ac57ef0d74e9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7373, 213, 394, 9, 29, "Input",ExpressionUUID->"b7902bda-684d-454d-9fcf-903af0239e86"],
Cell[7770, 224, 2613, 71, 73, "Output",ExpressionUUID->"b0c1ee7e-8350-41db-87fd-f43e5a646f23"]
}, Open  ]],
Cell[10398, 298, 496, 13, 49, "Input",ExpressionUUID->"83dd9fb0-4dd7-452a-ae5d-a9e1a952298d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10931, 316, 168, 3, 65, "Section",ExpressionUUID->"2c75b252-8e0c-44bc-a2a4-e06b2bf1e113"],
Cell[11102, 321, 501, 8, 49, "Text",ExpressionUUID->"eed9ca2e-15b2-4485-9ba3-f14bcc1db501"],
Cell[CellGroupData[{
Cell[11628, 333, 5704, 135, 443, "Input",ExpressionUUID->"d559ffa8-6ada-4e3d-a4f1-16a415511389"],
Cell[CellGroupData[{
Cell[17357, 472, 543, 10, 23, "Print",ExpressionUUID->"27383582-dfa4-437a-b21a-4536c7f5e5a3"],
Cell[17903, 484, 541, 10, 23, "Print",ExpressionUUID->"75bc6167-5c0c-46d2-83a5-64af60a1cec5"],
Cell[18447, 496, 541, 10, 23, "Print",ExpressionUUID->"ac76d59e-d6b6-4291-b98d-d3c55d024c6a"],
Cell[18991, 508, 541, 10, 23, "Print",ExpressionUUID->"cba218ef-af36-4d1b-92b3-9be7d3815408"],
Cell[19535, 520, 541, 10, 23, "Print",ExpressionUUID->"118a97f1-df45-482e-889c-b0d518348c38"]
}, Open  ]],
Cell[20091, 533, 486, 11, 26, "Message",ExpressionUUID->"4b7719e3-6823-465c-ba15-e0a6728f56bf"],
Cell[20580, 546, 486, 11, 26, "Message",ExpressionUUID->"a6585c13-1435-42c0-ab36-e7963d756d73"],
Cell[21069, 559, 486, 11, 26, "Message",ExpressionUUID->"c0a8c4cb-4a1a-4452-89ce-0f0088a917f1"],
Cell[21558, 572, 461, 10, 26, "Message",ExpressionUUID->"c2c42da4-444f-4e80-9ed2-2b110322f55e"],
Cell[CellGroupData[{
Cell[22044, 586, 541, 10, 23, "Print",ExpressionUUID->"641e2c72-30a0-4b18-bdfd-a19c01c0922a"],
Cell[22588, 598, 543, 10, 23, "Print",ExpressionUUID->"74085eb9-70af-4e8b-999f-56e840fda392"],
Cell[23134, 610, 543, 10, 23, "Print",ExpressionUUID->"577b67b6-a981-458e-b4fa-940412b1d809"],
Cell[23680, 622, 543, 10, 23, "Print",ExpressionUUID->"cab720f7-e4f3-4c02-b38b-56e6dd9942a2"],
Cell[24226, 634, 542, 10, 23, "Print",ExpressionUUID->"1ac34b4d-0f77-4589-81c4-4c5f6171603c"],
Cell[24771, 646, 542, 10, 23, "Print",ExpressionUUID->"4cb5c73a-09bb-4c7d-bb49-74fc3ce3340a"],
Cell[25316, 658, 544, 10, 23, "Print",ExpressionUUID->"cd952139-bbf2-478a-9a93-d5650fba18b7"],
Cell[25863, 670, 542, 10, 23, "Print",ExpressionUUID->"3f89c781-f77d-431a-be23-04ad618aadd1"],
Cell[26408, 682, 542, 10, 23, "Print",ExpressionUUID->"9c32c697-42e5-4e99-bd9f-c9544da2c70d"],
Cell[26953, 694, 542, 10, 23, "Print",ExpressionUUID->"cfbcf7ad-c129-4f09-b58c-d3dd236d362e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27544, 710, 216, 4, 29, "Input",ExpressionUUID->"c99a18e7-6467-4db6-a468-805d1dd93ccc"],
Cell[27763, 716, 210, 5, 33, "Output",ExpressionUUID->"4583c80e-3d80-40e2-9d96-1639da8c3e5f"]
}, Open  ]],
Cell[27988, 724, 625, 18, 49, "Input",ExpressionUUID->"286c55a8-f2f2-4404-91c2-d2d053dd2880"],
Cell[CellGroupData[{
Cell[28638, 746, 270, 6, 30, "Input",ExpressionUUID->"fa3aaf20-7912-4c78-ab7f-79aea0c1e7c4"],
Cell[28911, 754, 4464, 65, 133, "Output",ExpressionUUID->"5a33d410-1fa2-4129-b0d5-d359e81eaca3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33412, 824, 227, 5, 29, "Input",ExpressionUUID->"2354c628-ba52-4819-9d03-b6b9c54ca905"],
Cell[33642, 831, 686, 17, 33, "Output",ExpressionUUID->"ee6ff104-f9cc-4d12-a29b-8703719d79cf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34365, 853, 259, 5, 29, "Input",ExpressionUUID->"bb3179cd-f9df-4259-b27f-a9447423486c"],
Cell[34627, 860, 1132, 27, 76, "Output",ExpressionUUID->"cfb8ca38-fc26-4997-a340-234db867c99f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35796, 892, 154, 3, 29, "Input",ExpressionUUID->"2a957c1b-e0ce-4d23-9da6-b7234d9e090f"],
Cell[35953, 897, 153, 3, 33, "Output",ExpressionUUID->"6f9f5591-49fb-4051-9d1a-98a1827fb1cb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36143, 905, 1113, 31, 109, "Input",ExpressionUUID->"72cb947d-ab5d-4497-b6ce-335a38efcab6"],
Cell[37259, 938, 619, 14, 33, "Output",ExpressionUUID->"b3b5bdd5-7c61-4c45-b5b8-57a86817cbc2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37915, 957, 293, 7, 29, "Input",ExpressionUUID->"dd094840-092f-4985-be37-95841b3712b2"],
Cell[38211, 966, 1278, 37, 53, "Output",ExpressionUUID->"ff38ca0f-d0df-42b2-b6b1-e66a27013b06"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39526, 1008, 321, 9, 29, "Input",ExpressionUUID->"c5eb59a1-a4b3-4ff6-b676-b7a2b98bf7bd"],
Cell[39850, 1019, 713, 18, 33, "Output",ExpressionUUID->"dbeda9b5-bc93-4252-8613-41ddcb835f81"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40600, 1042, 846, 23, 29, "Input",ExpressionUUID->"b3fd1ca1-c528-4439-b188-2b4143e4814d"],
Cell[41449, 1067, 374, 10, 34, "Output",ExpressionUUID->"1d0dba1b-b678-4f9c-8ba4-17cb23a9f31f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41860, 1082, 978, 27, 29, "Input",ExpressionUUID->"3a8d93c8-4e85-4f16-b945-3d67b52d7485"],
Cell[42841, 1111, 492, 11, 34, "Output",ExpressionUUID->"334ea7b5-2dd7-474e-a204-cfe2a200d93a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43370, 1127, 409, 11, 29, "Input",ExpressionUUID->"ac4c6d66-7470-4157-a34e-d57ca6e15b35"],
Cell[43782, 1140, 2108, 65, 52, "Output",ExpressionUUID->"cbc9d3ae-caca-44a7-bb9c-44760167e823"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45927, 1210, 233, 5, 29, "Input",ExpressionUUID->"dabb6e3a-e4df-47b9-a2c2-d6e2c6a4c224"],
Cell[46163, 1217, 230, 5, 34, "Output",ExpressionUUID->"89b01791-4950-47e5-950a-f7441a19f828"]
}, Open  ]]
}, Open  ]]
}
]
*)

