(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    271078,       6604]
NotebookOptionsPosition[    263383,       6475]
NotebookOutlinePosition[    263775,       6491]
CellTagsIndexPosition[    263732,       6488]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Expansions for matrix-Fisher distributions over SO(3)", "Title",
 CellChangeTimes->{{3.955120887077941*^9, 
  3.955120937992585*^9}},ExpressionUUID->"65571dda-a78f-4253-81c7-\
6fc46cd0f2cf"],

Cell[CellGroupData[{

Cell["Exponential map parameterization of rotations", "Section",
 CellChangeTimes->{{3.9551212289421043`*^9, 3.95512124317415*^9}, {
  3.9551212857118177`*^9, 3.955121298178825*^9}, {3.955121331066568*^9, 
  3.95512135036279*^9}},ExpressionUUID->"15821792-2a6f-4042-9730-\
43868f841535"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"RotFromVec", "[", "vec_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"normed", ",", "angle"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"angle", "=", 
       RowBox[{"Norm", "[", "vec", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"normed", "=", 
       RowBox[{"vec", "/", "angle"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IdentityMatrix", "[", "3", "]"}], "-", 
            RowBox[{"Outer", "[", 
             RowBox[{"Times", ",", "normed", ",", "normed"}], "]"}]}], ")"}], 
          "*", 
          RowBox[{"Cos", "[", "angle", "]"}]}], "+", 
         RowBox[{"Outer", "[", 
          RowBox[{"Times", ",", "normed", ",", "normed"}], "]"}], "-", 
         RowBox[{
          RowBox[{
           RowBox[{"LeviCivitaTensor", "[", "3", "]"}], ".", "normed"}], "*", 
          
          RowBox[{"Sin", "[", "angle", "]"}]}]}], ",", 
        RowBox[{"Assumptions", "->", 
         RowBox[{"vec", "\[Element]", "Reals"}]}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"HaarMeasureVec", "[", "vec_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"normed", ",", "angle"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"angle", "=", 
       RowBox[{"Norm", "[", "vec", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"1", "-", 
          RowBox[{"Cos", "[", "angle", "]"}]}], 
         RowBox[{"4", 
          SuperscriptBox["\[Pi]", "2"], 
          SuperscriptBox["angle", "2"]}]], ",", 
        RowBox[{"Assumptions", "->", 
         RowBox[{"vec", "\[Element]", "Reals"}]}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ")"}]}]}], "Input",
 CellChangeTimes->{{3.949492902943914*^9, 3.949492905534666*^9}, {
  3.9494929564070187`*^9, 3.949493143618741*^9}, {3.949493183834915*^9, 
  3.94949318502984*^9}, {3.949493241485187*^9, 3.949493297714116*^9}, {
  3.949493332452249*^9, 3.949493357483252*^9}, {3.949493394539239*^9, 
  3.949493437322092*^9}, {3.949493470090188*^9, 3.949493477233945*^9}, {
  3.949493518367272*^9, 3.9494935292009583`*^9}, {3.949493561540102*^9, 
  3.949493587724668*^9}, {3.949493667464532*^9, 3.949493668391842*^9}, {
  3.949505142710785*^9, 3.949505210239058*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"1f0b8c2e-e327-4cb0-8ec4-a69c4f9d557a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Large \[Lambda] approximation (saddle expansion)", "Section",
 CellFrame->{{0, 0}, {0, 1}},
 CellChangeTimes->{{3.94976289932582*^9, 3.9497629177096663`*^9}},
 Background->None,ExpressionUUID->"e4ff8eb2-42ae-410c-a2c9-3cb3f1517c8f"],

Cell[TextData[{
 "The matrix-Fisher distribution weights the probability of any particular \
rotation ",
 Cell[BoxData[
  FormBox[
   StyleBox["R",
    FontWeight->"Bold"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "bc9d5c90-4891-4a5c-8643-2702285f732a"],
 " by ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       SuperscriptBox[
        StyleBox["e", "TI"], 
        RowBox[{
          StyleBox["Tr", FontSlant -> "Plain"], "(", 
          RowBox[{"\[Lambda]", 
            SuperscriptBox[
             StyleBox["F", "TB"], 
             StyleBox["T", "TI"]], 
            StyleBox["R", "TB"]}], ")"}]], TraditionalForm], "errors" -> {}, 
     "input" -> "e^{\\mathrm{Tr}(\\lambda\\textbf{F}^T\\textbf{R})}", "state" -> 
     "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "77f92dd2-36e9-4d8f-bfb1-d654cf4780dd"],
 ". We are interested in estimating ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{
         SubscriptBox[
          StyleBox["E", FontSlant -> "Plain"], 
          RowBox[{
            StyleBox["R", "TB"], "\[Tilde]", 
            SubscriptBox[
             StyleBox["D", "TI"], 
             StyleBox["F", "TI"]]}]], 
         RowBox[{"[", 
           StyleBox["R", "TB"], "]"}]}], TraditionalForm], "errors" -> {}, 
     "input" -> "\\mathbb{E}_{\\textbf{R}\\sim \\mathcal{D}_F}[\\textbf{R}]", 
     "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "f1d63356-aae7-4790-a32c-6c940e08a66f"],
 " for arbitrary ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       StyleBox["F", "TB"], TraditionalForm], "errors" -> {}, "input" -> 
     "\\textbf{F}", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "cbe0d651-d29f-4bc5-ae20-85641011a1de"],
 " in the limit ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{"\[Lambda]", "\[Rule]", "\[Infinity]"}], TraditionalForm], 
     "errors" -> {}, "input" -> "\\lambda\\to\\infty", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "a07cdb1d-fbfd-4a23-bff4-b671a427d6c8"],
 ".\nIt turns out that it suffices to solve this problem for diagonal ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{
         StyleBox["F", "TB"], "\[LongEqual]", 
         StyleBox["diag", FontSlant -> "Plain"], 
         RowBox[{"(", 
           RowBox[{
             SubscriptBox[
              StyleBox["s", "TI"], "1"], ",", 
             SubscriptBox[
              StyleBox["s", "TI"], "2"], ",", 
             SubscriptBox[
              StyleBox["s", "TI"], "3"]}], ")"}]}], TraditionalForm], 
     "errors" -> {}, "input" -> "\\textbf{F}=\\mathrm{diag}(s_1,s_2,s_3)", 
     "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "c3d121dd-3d7c-40d4-8bc2-2d44c16f7198"],
 " where ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{
         SubscriptBox[
          StyleBox["s", "TI"], "1"], "\[GreaterEqual]", 
         SubscriptBox[
          StyleBox["s", "TI"], "2"], "\[GreaterEqual]", "|", 
         SubscriptBox[
          StyleBox["s", "TI"], "3"], "|"}], TraditionalForm], "errors" -> {}, 
     "input" -> "s_1\\geq s_2 \\geq |s_3|", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "ddb9f4ba-91fb-4189-92a3-ebc1b7cd932e"],
 ". In fact, all we need to do is compute the partition function\n",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{
         StyleBox["c", "TI"], 
         RowBox[{"(", 
           StyleBox["F", "TB"], ")"}], "\[LongEqual]", 
         SubscriptBox["\[Integral]", 
          RowBox[{
            StyleBox["S", "TI"], 
            StyleBox["O", "TI"], 
            RowBox[{"(", "3", ")"}]}]], 
         SuperscriptBox[
          StyleBox["e", "TI"], 
          RowBox[{
            StyleBox["Tr", FontSlant -> "Plain"], "(", 
            RowBox[{"\[Lambda]", 
              SuperscriptBox[
               StyleBox["F", "TB"], 
               StyleBox["T", "TI"]], 
              StyleBox["R", "TB"]}], ")"}]], 
         StyleBox["d", "TI"], 
         StyleBox["R", "TB"]}], TraditionalForm], "errors" -> {}, "input" -> 
     "c(\\textbf{F})=\\int_{SO(3)}e^{\\mathrm{Tr}(\\lambda\\textbf{F}^T\\\
textbf{R})}d\\textbf{R}", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "72ee2a99-b777-465e-9c11-f5f01cd07a56"],
 "\nTo provide such an approximation, we employ Laplace\[CloseCurlyQuote]s \
method (also known as saddle-point expansion to physicists). It is not hard \
to see that for such a diagonal ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       StyleBox["F", "TB"], TraditionalForm], "errors" -> {}, "input" -> 
     "\\textbf{F}", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "8fde2f13-54bd-4ee9-8ec3-80e88a097845"],
 ", the rotation ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       StyleBox["R", "TB"], TraditionalForm], "errors" -> {}, "input" -> 
     "\\textbf{R}", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "fd6e94a5-3469-4212-8b71-70174d59809d"],
 " maximizing the argument ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{
         StyleBox["Tr", FontSlant -> "Plain"], "(", 
         RowBox[{"\[Lambda]", 
           SuperscriptBox[
            StyleBox["F", "TB"], 
            StyleBox["T", "TI"]], 
           StyleBox["R", "TB"]}], ")"}], TraditionalForm], "errors" -> {}, 
     "input" -> "\\mathrm{Tr}(\\lambda\\textbf{F}^T\\textbf{R})", "state" -> 
     "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "2ffbc523-c8dd-4c2b-bae8-c321dead5e30"],
 " is the identity rotation so we want to expand around this rotation.\n\n\
First, we work with the exponential map expansion parameterization of SO(3). \
So we view the argument as some function ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{
         SubscriptBox[
          StyleBox["A", "TI"], 
          StyleBox["F", "TB"]], "(", 
         StyleBox["u", "TB"], ")"}], TraditionalForm], "errors" -> {}, 
     "input" -> "A_\\textbf{F}(\\textbf{u})", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "ce76719d-ee01-463c-bb48-11d8b4303f57"],
 " where ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{
         StyleBox["u", "TB"], "\[Element]", 
         SuperscriptBox[
          StyleBox["R", FontSlant -> "Plain"], "3"]}], TraditionalForm], 
     "errors" -> {}, "input" -> "\\textbf{u}\\in\\mathbb{R}^3", "state" -> 
     "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "1ec68d21-5b35-4e07-94bb-c541ff3f9cda"],
 " is a vector parameterizing our rotation. Since ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{
         StyleBox["u", "TB"], "\[LongEqual]", 
         RowBox[{"(", 
           RowBox[{"0", ",", "0", ",", "0"}], ")"}]}], TraditionalForm], 
     "errors" -> {}, "input" -> "\\textbf{u}=(0,0,0)", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "5ed0a54b-37fb-4491-a547-5b19c189a831"],
 " corresponds to the identity which we saw maximizes ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       SubscriptBox[
        StyleBox["A", "TI"], 
        StyleBox["F", "TB"]], TraditionalForm], "errors" -> {}, "input" -> 
     "A_\\textbf{F}", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "e824fcc2-5dcf-4691-8d91-c0bb43c8e89e"],
 ", we can expand\n",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{
         SubscriptBox[
          StyleBox["A", "TI"], 
          StyleBox["F", "TB"]], 
         RowBox[{"(", 
           StyleBox["u", "TB"], ")"}], "\[LongEqual]", 
         SubscriptBox[
          StyleBox["A", "TI"], "0"], "+", 
         UnderscriptBox["\[Sum]", 
          RowBox[{
            StyleBox["i", "TI"], ",", 
            StyleBox["j", "TI"]}], LimitsPositioning -> True], 
         SubscriptBox[
          StyleBox["A", "TI"], 
          RowBox[{"2", ",", 
            StyleBox["i", "TI"], 
            StyleBox["j", "TI"]}]], 
         SubscriptBox[
          StyleBox["u", "TI"], 
          StyleBox["i", "TI"]], 
         SubscriptBox[
          StyleBox["u", "TI"], 
          StyleBox["j", "TI"]], "+", 
         UnderscriptBox["\[Sum]", 
          RowBox[{
            StyleBox["i", "TI"], ",", 
            StyleBox["j", "TI"], ",", 
            StyleBox["k", "TI"]}], LimitsPositioning -> True], 
         SubscriptBox[
          StyleBox["A", "TI"], 
          RowBox[{"3", ",", 
            StyleBox["i", "TI"], 
            StyleBox["j", "TI"], 
            StyleBox["k", "TI"]}]], 
         SubscriptBox[
          StyleBox["u", "TI"], 
          StyleBox["i", "TI"]], 
         SubscriptBox[
          StyleBox["u", "TI"], 
          StyleBox["j", "TI"]], 
         SubscriptBox[
          StyleBox["u", "TI"], 
          StyleBox["k", "TI"]], "+", "\[Ellipsis]"}], TraditionalForm], 
     "errors" -> {}, "input" -> 
     "A_\\textbf{F}(\\textbf{u})=A_0+\\sum_{i,j} \
A_{2,ij}u_iu_j+\\sum_{i,j,k}A_{3,ijk}u_iu_ju_k+\\ldots", "state" -> "Boxes"|>,
    
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "75028c01-f8bb-4f2e-ab3c-f2f80c5b4ad1"],
 "\nwhere the matrix ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       SubscriptBox[
        StyleBox["A", "TI"], 
        RowBox[{"2", ",", 
          StyleBox["i", "TI"], 
          StyleBox["j", "TI"]}]], TraditionalForm], "errors" -> {}, "input" -> 
     "A_{2,ij}", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "e8232400-1148-451f-ac9c-112ec18555b5"],
 " must be negative definite. Hence, we can separate the second order terms \
as a Gaussian and obtain\n",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{
         SuperscriptBox[
          StyleBox["e", "TI"], 
          RowBox[{
            SubscriptBox[
             StyleBox["A", "TI"], 
             StyleBox["F", "TB"]], "(", 
            StyleBox["u", "TB"], ")"}]], "\[LongEqual]", 
         SuperscriptBox[
          StyleBox["e", "TI"], 
          RowBox[{
            SubscriptBox[
             StyleBox["A", "TI"], "0"], "+", 
            SuperscriptBox[
             StyleBox["u", "TB"], 
             StyleBox["T", "TI"]], 
            SubscriptBox[
             StyleBox["A", "TB"], "2"], 
            StyleBox["u", "TB"]}]], 
         StyleBox["B", "TI"], 
         RowBox[{"(", 
           StyleBox["u", "TB"], ")"}]}], TraditionalForm], "errors" -> {}, 
     "input" -> 
     "e^{A_{\\textbf{F}}(\\textbf{u})}=e^{A_0+\\textbf{u}^T\\textbf{A}_2\\\
textbf{u}}B(\\textbf{u})", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "b4175923-73e5-46e9-a6c7-14963681b6d5"],
 "            where             ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{
         StyleBox["B", "TI"], 
         RowBox[{"(", 
           StyleBox["u", "TB"], ")"}], "\[LongEqual]", 
         SuperscriptBox[
          StyleBox["e", "TI"], 
          RowBox[{
            SubscriptBox[
             StyleBox["A", "TI"], 
             StyleBox["F", "TB"]], 
            RowBox[{"(", 
              StyleBox["u", "TB"], ")"}], "-", 
            SubscriptBox[
             StyleBox["A", "TI"], "0"], "-", 
            SuperscriptBox[
             StyleBox["u", "TB"], 
             StyleBox["T", "TI"]], 
            SubscriptBox[
             StyleBox["A", "TB"], "2"], 
            StyleBox["u", "TB"]}]]}], TraditionalForm], "errors" -> {}, 
     "input" -> 
     "B(\\textbf{u})=e^{A_{\\textbf{F}}(\\textbf{u})-A_0-\\textbf{u}^T\\\
textbf{A}_2\\textbf{u}}", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "f9e42eb5-bc23-44bd-8a61-1805e3f44ce1"]
}], "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQB2IQ3RC09MLp8reOBt+0boJoy/dV90B0zrbzz0F0nua3
1yD6xsS3b0B0wX/3ryD6m+anbyBaQnXebxBdUfnlP4guMoiTOgOkrZ59kQbR
IfdvKoDoO40bVUH0Oudj2iC64PwjMH3qx15rEP3I7YMziJbqCPcC0c9E7/mD
6E3u80NBdMVcq2gQve/8w14Q3cXrPhFExwh8mQmiFbb3zgLRJj9TF4Jolx6T
FSBafu+FtSD68YfHm8H2Hs44BKJFNZPOgOhb203eguhw/zgwzRfw8w+IjhL+
KXkWSL9OMtUC0T3Ri/VBtHfUijsvgPR8puIXIHrKhU7Ol0D6xH5FLhC9OZ5V
AUSf+RCpBKJt+wKNQfQ0kwNWIBoAYkrUwA==
  "],
 Background->RGBColor[
  1, 1, 0.85],ExpressionUUID->"19831b70-a0bd-483d-bb15-17dec9451b09"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"order", "=", "7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"arg", "=", 
   RowBox[{"\[Lambda]", "*", 
    RowBox[{"Tr", "[", 
     RowBox[{
      RowBox[{"DiagonalMatrix", "[", 
       RowBox[{"{", 
        RowBox[{"s1", ",", "s2", ",", "s3"}], "}"}], "]"}], ".", 
      RowBox[{"RotFromVec", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "*", "t"}], ",", 
         RowBox[{"y", "*", "t"}], ",", 
         RowBox[{"z", "*", "t"}]}], "}"}], "]"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zeroth", "=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"arg", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"second", "=", 
   RowBox[{
    RowBox[{"Normal", "[", 
     RowBox[{"Series", "[", 
      RowBox[{"arg", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "3"}], "}"}]}], "]"}], "]"}], "-", 
    "zeroth"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"measure", "=", 
   RowBox[{"HaarMeasureVec", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "*", "t"}], ",", 
      RowBox[{"y", "*", "t"}], ",", 
      RowBox[{"z", "*", "t"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"term2", "=", 
   RowBox[{"Exp", "[", 
    RowBox[{"arg", "-", "zeroth", "-", "second"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.949504676193653*^9, 3.949504817896929*^9}, {
   3.949504899511489*^9, 3.9495049616599817`*^9}, {3.949505006870885*^9, 
   3.949505127264453*^9}, {3.949505224947447*^9, 3.949505245576037*^9}, {
   3.949505423143383*^9, 3.9495054240717897`*^9}, {3.9495101195985394`*^9, 
   3.949510125954544*^9}, {3.949510472177772*^9, 3.949510472227068*^9}, {
   3.9495107826893578`*^9, 3.949510810738699*^9}, {3.949510872755129*^9, 
   3.949510900440366*^9}, {3.949535961696802*^9, 3.949535961838764*^9}, {
   3.949567927273294*^9, 3.949567927644861*^9}, {3.949571510966745*^9, 
   3.949571521971314*^9}, {3.949573491434102*^9, 3.949573491910901*^9}, 
   3.949574767701973*^9, {3.955187413675469*^9, 3.9551874137780533`*^9}, {
   3.955187463450869*^9, 3.955187463929263*^9}, {3.955188900580926*^9, 
   3.955188901097026*^9}, 3.955196866534992*^9},
 CellLabel->
  "In[184]:=",ExpressionUUID->"84b5851d-6681-4e0d-94e4-78ca64eb0659"],

Cell[TextData[{
 "In the exponential parameterization, our integral over SO(3) becomes\n",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{
         StyleBox["c", "TI"], 
         RowBox[{"(", 
           StyleBox["F", "TB"], ")"}], "\[LongEqual]", 
         SubscriptBox["\[Integral]", 
          RowBox[{"||", 
            StyleBox["u", "TB"], "||", "\[LessEqual]", "\[Pi]"}]], 
         SuperscriptBox[
          StyleBox["e", "TI"], 
          RowBox[{
            StyleBox["Tr", FontSlant -> "Plain"], "(", 
            RowBox[{
              SuperscriptBox[
               StyleBox["F", "TB"], 
               StyleBox["T", "TI"]], 
              StyleBox["R", "TB"]}], ")"}]], "\[Mu]", 
         RowBox[{"(", 
           StyleBox["u", "TB"], ")"}], 
         StyleBox["d", "TI"], 
         StyleBox["u", "TB"], "\[LongEqual]", 
         SubscriptBox["\[Integral]", 
          RowBox[{"||", 
            StyleBox["u", "TB"], "||", "\[LessEqual]", "\[Pi]"}]], 
         SuperscriptBox[
          StyleBox["e", "TI"], 
          RowBox[{
            SubscriptBox[
             StyleBox["A", "TI"], "0"], "+", 
            SuperscriptBox[
             StyleBox["u", "TB"], 
             StyleBox["T", "TI"]], 
            SubscriptBox[
             StyleBox["A", "TB"], "2"], 
            StyleBox["u", "TB"]}]], 
         StyleBox["B", "TI"], 
         RowBox[{"(", 
           StyleBox["u", "TB"], ")"}], "\[Mu]", 
         RowBox[{"(", 
           StyleBox["u", "TB"], ")"}], 
         StyleBox["d", "TI"], 
         StyleBox["u", "TB"]}], TraditionalForm], "errors" -> {}, "input" -> 
     "c(\\textbf{F})=\\int_{||\\textbf{u}||\\leq\\pi}e^{\\mathrm{Tr}(\\textbf{\
F}^T\\textbf{R})}\\mu(\\textbf{u})d\\textbf{u}=\\int_{||\\textbf{u}||\\leq\\\
pi}e^{A_0+\\textbf{u}^T\\textbf{A}_2\\textbf{u}}B(\\textbf{u})\\mu(\\textbf{u}\
)d\\textbf{u}", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "ae1fb206-cc60-4f13-a7a3-b13cff7820ca"],
 "\nIn the limit ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{"\[Lambda]", "\[Rule]", "\[Infinity]"}], TraditionalForm], 
     "errors" -> {}, "input" -> "\\lambda\\to\\infty", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "320cb1f3-6818-4d30-99e3-dc98f483fd0f"],
 ", the eigenvalues of ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       SubscriptBox[
        StyleBox["A", "TB"], "2"], TraditionalForm], "errors" -> {}, "input" -> 
     "\\textbf{A}_2", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "3d770ec9-f319-4c1f-9cd8-2ab990ecfbc6"],
 " also go to ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|
    "boxes" -> FormBox["\[Infinity]", TraditionalForm], "errors" -> {}, 
     "input" -> "\\infty", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "6103abdb-c8b2-4125-b70f-11804a82e35a"],
 " giving us a very sharp Gaussian peak around ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{
         StyleBox["u", "TB"], "\[LongEqual]", "0"}], TraditionalForm], 
     "errors" -> {}, "input" -> "\\textbf{u}=0", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "a3886330-48ca-4e7a-a4c5-f705b56f329a"],
 ". "
}], "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellChangeTimes->{{3.955182189523794*^9, 3.955182199587916*^9}, {
  3.955182295898975*^9, 3.955182313465603*^9}, {3.955184930700078*^9, 
  3.955184997803549*^9}, {3.9551853678469563`*^9, 3.955185524120984*^9}},
 Background->RGBColor[
  1, 1, 0.85],ExpressionUUID->"380894f6-e983-4edc-bbf0-f6197b1174ed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"constRatio", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", "zeroth", "]"}], "*", 
      RowBox[{
       RowBox[{"Exp", "[", "second", "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"8", 
         SuperscriptBox["\[Pi]", "2"]}], ")"}]}]}], "/.", 
     RowBox[{"t", "->", "1"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
    RowBox[{"Assumptions", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"s1", ">", "0"}], ",", 
       RowBox[{"s2", ">", "0"}], ",", 
       RowBox[{"s3", ">", "0"}], ",", 
       RowBox[{"\[Lambda]", ">", "0"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{3.949571529022627*^9},
 CellLabel->
  "In[166]:=",ExpressionUUID->"2fd5f3ae-5ce1-41f7-8c28-d98d0c320131"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"s1", "+", "s2", "+", "s3"}], ")"}], " ", "\[Lambda]"}]], 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", "\[Lambda]", " ", 
   SqrtBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"s1", "+", "s2"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"s1", "+", "s3"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"s2", "+", "s3"}], ")"}], " ", "\[Lambda]"}]]}]]], "Output",
 CellChangeTimes->{3.9495715341850653`*^9, 3.949591592818554*^9, 
  3.9497660968026876`*^9, 3.949773389151601*^9, 3.9551850469459248`*^9, 
  3.955188559419409*^9},
 CellLabel->
  "Out[166]=",ExpressionUUID->"491a304f-8505-4eed-9998-5c5ae2b1a381"]
}, Open  ]],

Cell[TextData[{
 "Hence only a small neighborhood around ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|
    "boxes" -> FormBox["0", TraditionalForm], "errors" -> {}, "input" -> "0", 
     "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "9628c56c-6ceb-4d65-aab6-581b79c1d7b8"],
 " really matters so we expand ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{
         StyleBox["B", "TI"], 
         RowBox[{"(", 
           StyleBox["u", "TB"], ")"}], "\[Mu]", 
         RowBox[{"(", 
           StyleBox["u", "TB"], ")"}]}], TraditionalForm], "errors" -> {}, 
     "input" -> "B(\\textbf{u})\\mu(\\textbf{u})", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "a806249d-cee3-4764-a957-07b6bcbf0bba"],
 " around ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|
    "boxes" -> FormBox["0", TraditionalForm], "errors" -> {}, "input" -> "0", 
     "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "5e9dbf2b-c40e-4c28-a8a4-92aead6f0bf3"],
 ". "
}], "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellChangeTimes->{{3.955185530727935*^9, 3.955185540894044*^9}},
 Background->RGBColor[
  1, 1, 0.85],ExpressionUUID->"252cf1c3-48e4-453e-9520-4fb2dd00b6a0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"integrandMult", "=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"term2", "*", "measure"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "order"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.949505288173685*^9, 3.949505305078136*^9}, {
   3.949505339846341*^9, 3.949505369399869*^9}, {3.949510160625167*^9, 
   3.949510262300665*^9}, {3.949510302329976*^9, 3.949510356490981*^9}, 
   3.9495103884263983`*^9, {3.949573533152288*^9, 3.949573535112378*^9}},
 CellLabel->
  "In[190]:=",ExpressionUUID->"185149fc-acd5-4ff7-852f-ad6fad984e6f"],

Cell[CellGroupData[{

Cell[BoxData["integrandMult"], "Input",
 CellChangeTimes->{{3.949510399609633*^9, 3.949510400499941*^9}},
 CellLabel->
  "In[191]:=",ExpressionUUID->"9b7e0c93-48ec-4460-9cef-423eb13fb446"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", 
    SuperscriptBox["\[Pi]", "2"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["t", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"]}], ")"}]}], 
   RowBox[{"96", " ", 
    SuperscriptBox["\[Pi]", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["t", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["1", "720"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], "3"]}], "-", 
      RowBox[{
       FractionBox["1", "48"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["x", "2"]}], "-", 
         SuperscriptBox["y", "2"], "-", 
         SuperscriptBox["z", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"s2", " ", 
          SuperscriptBox["x", "4"]}], "+", 
         RowBox[{"s3", " ", 
          SuperscriptBox["x", "4"]}], "+", 
         RowBox[{"s1", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"s2", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"2", " ", "s3", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"s1", " ", 
          SuperscriptBox["y", "4"]}], "+", 
         RowBox[{"s3", " ", 
          SuperscriptBox["y", "4"]}], "+", 
         RowBox[{"s1", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"2", " ", "s2", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"s3", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"2", " ", "s1", " ", 
          SuperscriptBox["y", "2"], " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"s2", " ", 
          SuperscriptBox["y", "2"], " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"s3", " ", 
          SuperscriptBox["y", "2"], " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"s1", " ", 
          SuperscriptBox["z", "4"]}], "+", 
         RowBox[{"s2", " ", 
          SuperscriptBox["z", "4"]}]}], ")"}], " ", "\[Lambda]"}]}], ")"}]}], 
   
   RowBox[{"4", " ", 
    SuperscriptBox["\[Pi]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["t", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], ")"}], "4"], "40320"]}], "-", 
      RowBox[{
       FractionBox["1", "576"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"s2", " ", 
          SuperscriptBox["x", "4"]}], "+", 
         RowBox[{"s3", " ", 
          SuperscriptBox["x", "4"]}], "+", 
         RowBox[{"s1", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"s2", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"2", " ", "s3", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"s1", " ", 
          SuperscriptBox["y", "4"]}], "+", 
         RowBox[{"s3", " ", 
          SuperscriptBox["y", "4"]}], "+", 
         RowBox[{"s1", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"2", " ", "s2", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"s3", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"2", " ", "s1", " ", 
          SuperscriptBox["y", "2"], " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"s2", " ", 
          SuperscriptBox["y", "2"], " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"s3", " ", 
          SuperscriptBox["y", "2"], " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"s1", " ", 
          SuperscriptBox["z", "4"]}], "+", 
         RowBox[{"s2", " ", 
          SuperscriptBox["z", "4"]}]}], ")"}], " ", "\[Lambda]"}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["x", "2"]}], "-", 
          SuperscriptBox["y", "2"], "-", 
          SuperscriptBox["z", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"s2", " ", 
           SuperscriptBox["x", "6"]}], "+", 
          RowBox[{"s3", " ", 
           SuperscriptBox["x", "6"]}], "+", 
          RowBox[{"s1", " ", 
           SuperscriptBox["x", "4"], " ", 
           SuperscriptBox["y", "2"]}], "+", 
          RowBox[{"2", " ", "s2", " ", 
           SuperscriptBox["x", "4"], " ", 
           SuperscriptBox["y", "2"]}], "+", 
          RowBox[{"3", " ", "s3", " ", 
           SuperscriptBox["x", "4"], " ", 
           SuperscriptBox["y", "2"]}], "+", 
          RowBox[{"2", " ", "s1", " ", 
           SuperscriptBox["x", "2"], " ", 
           SuperscriptBox["y", "4"]}], "+", 
          RowBox[{"s2", " ", 
           SuperscriptBox["x", "2"], " ", 
           SuperscriptBox["y", "4"]}], "+", 
          RowBox[{"3", " ", "s3", " ", 
           SuperscriptBox["x", "2"], " ", 
           SuperscriptBox["y", "4"]}], "+", 
          RowBox[{"s1", " ", 
           SuperscriptBox["y", "6"]}], "+", 
          RowBox[{"s3", " ", 
           SuperscriptBox["y", "6"]}], "+", 
          RowBox[{"s1", " ", 
           SuperscriptBox["x", "4"], " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"3", " ", "s2", " ", 
           SuperscriptBox["x", "4"], " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"2", " ", "s3", " ", 
           SuperscriptBox["x", "4"], " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"4", " ", "s1", " ", 
           SuperscriptBox["x", "2"], " ", 
           SuperscriptBox["y", "2"], " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"4", " ", "s2", " ", 
           SuperscriptBox["x", "2"], " ", 
           SuperscriptBox["y", "2"], " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"4", " ", "s3", " ", 
           SuperscriptBox["x", "2"], " ", 
           SuperscriptBox["y", "2"], " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"3", " ", "s1", " ", 
           SuperscriptBox["y", "4"], " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"s2", " ", 
           SuperscriptBox["y", "4"], " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"2", " ", "s3", " ", 
           SuperscriptBox["y", "4"], " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"2", " ", "s1", " ", 
           SuperscriptBox["x", "2"], " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"3", " ", "s2", " ", 
           SuperscriptBox["x", "2"], " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"s3", " ", 
           SuperscriptBox["x", "2"], " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"3", " ", "s1", " ", 
           SuperscriptBox["y", "2"], " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"2", " ", "s2", " ", 
           SuperscriptBox["y", "2"], " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"s3", " ", 
           SuperscriptBox["y", "2"], " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"s1", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"s2", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", "\[Lambda]"}], "1440"]}],
      ")"}]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["\[Pi]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{
  3.949510401394487*^9, 3.949510476744542*^9, {3.949510806430831*^9, 
   3.9495108184375896`*^9}, {3.949510878970667*^9, 3.949510908105206*^9}, 
   3.949535970123159*^9, 3.94956794910213*^9, 3.9495735399534597`*^9, 
   3.9495915968532553`*^9, 3.955188919842266*^9, 3.9551968731454687`*^9},
 CellLabel->
  "Out[191]=",ExpressionUUID->"8787f395-f0a3-4be1-922b-935f2828dd81"]
}, Open  ]],

Cell[TextData[{
 "Further, the boundary of ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{"||", 
         StyleBox["u", "TB"], "||", "\[LessEqual]", "\[Pi]"}], 
       TraditionalForm], "errors" -> {}, "input" -> 
     "||\\textbf{u}||\\leq\\pi", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "34b94a0b-d886-420b-a70b-61abcb8d77df"],
 " does not matter that much and for simplicity, we can assume we integrate \
over ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       SuperscriptBox[
        StyleBox["R", FontSlant -> "Plain"], "3"], TraditionalForm], 
     "errors" -> {}, "input" -> "\\mathbb{R}^3", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "28befcc8-b7e8-4e2a-9cd8-37c8a22ae379"],
 " so that the expression becomes a Gaussian integral which can easily be \
evaluated."
}], "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellChangeTimes->{
  3.955185546752857*^9, {3.955185654524201*^9, 3.95518566029993*^9}},
 Background->RGBColor[
  1, 1, 0.85],ExpressionUUID->"6af9bfc7-8501-4190-8432-b933a557f1c1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expandedC", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"integrandMult", "*", 
     RowBox[{"Exp", "[", "zeroth", "]"}], "*", 
     RowBox[{"Exp", "[", "second", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
    RowBox[{"Assumptions", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"s1", ">", "0"}], ",", 
       RowBox[{"s2", ">", "0"}], ",", 
       RowBox[{"s3", ">", "0"}], ",", 
       RowBox[{"\[Lambda]", ">", "0"}], ",", 
       RowBox[{"t", ">", "0"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.94951039615486*^9, {3.949510449636526*^9, 3.949510459206717*^9}, {
   3.949510525820015*^9, 3.949510527677218*^9}, {3.949510833554387*^9, 
   3.949510848099393*^9}, {3.949511281527326*^9, 3.949511286016521*^9}, {
   3.949572517261248*^9, 3.9495725233486547`*^9}},
 CellLabel->
  "In[192]:=",ExpressionUUID->"3ec77093-6a38-4d9f-ad18-653f78bf497e"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"13440", " ", 
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"s1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"s1", "+", "s3"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"s2", "+", "s3"}], ")"}]}], ")"}], 
     RowBox[{"7", "/", "2"}]], " ", 
    SuperscriptBox["t", "3"], " ", 
    SuperscriptBox["\[Lambda]", 
     RowBox[{"9", "/", "2"}]]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"s1", "+", "s2", "+", "s3"}], ")"}], " ", "\[Lambda]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5"}], " ", 
      SuperscriptBox["s3", "6"]}], "-", 
     RowBox[{"21", " ", "s2", " ", 
      SuperscriptBox["s3", "5"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"30", " ", "s3", " ", "\[Lambda]"}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["s2", "2"], " ", 
      SuperscriptBox["s3", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "19"}], "-", 
        RowBox[{"1365", " ", "s3", " ", "\[Lambda]"}], "+", 
        RowBox[{"420", " ", 
         SuperscriptBox["s3", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}], "+", 
     RowBox[{"21", " ", 
      SuperscriptBox["s2", "5"], " ", "s3", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"130", " ", "s3", " ", "\[Lambda]"}], "+", 
        RowBox[{"200", " ", 
         SuperscriptBox["s3", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"]}], "+", 
        RowBox[{"960", " ", 
         SuperscriptBox["s3", "3"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
     RowBox[{"7", " ", 
      SuperscriptBox["s2", "3"], " ", 
      SuperscriptBox["s3", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "7"}], "-", 
        RowBox[{"810", " ", "s3", " ", "\[Lambda]"}], "+", 
        RowBox[{"600", " ", 
         SuperscriptBox["s3", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"]}], "+", 
        RowBox[{"960", " ", 
         SuperscriptBox["s3", "3"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["s2", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "5"}], "-", 
        RowBox[{"630", " ", "s3", " ", "\[Lambda]"}], "+", 
        RowBox[{"840", " ", 
         SuperscriptBox["s3", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"]}], "+", 
        RowBox[{"6720", " ", 
         SuperscriptBox["s3", "3"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["s2", "4"], " ", 
      SuperscriptBox["s3", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "19"}], "-", 
        RowBox[{"2835", " ", "s3", " ", "\[Lambda]"}], "+", 
        RowBox[{"3360", " ", 
         SuperscriptBox["s3", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"]}], "+", 
        RowBox[{"10080", " ", 
         SuperscriptBox["s3", "3"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
     RowBox[{"5", " ", 
      SuperscriptBox["s1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"126", " ", "s3", " ", "\[Lambda]"}], "+", 
        RowBox[{"168", " ", 
         SuperscriptBox["s3", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"]}], "+", 
        RowBox[{"1344", " ", 
         SuperscriptBox["s2", "3"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}], "+", 
        RowBox[{"1344", " ", 
         SuperscriptBox["s3", "3"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}], "+", 
        RowBox[{"168", " ", 
         SuperscriptBox["s2", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"24", " ", "s3", " ", "\[Lambda]"}]}], ")"}]}], "+", 
        RowBox[{"42", " ", "s2", " ", "\[Lambda]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           RowBox[{"8", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"96", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"21", " ", 
      SuperscriptBox["s1", "5"], " ", 
      RowBox[{"(", 
       RowBox[{"s2", "+", "s3"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"130", " ", "s3", " ", "\[Lambda]"}], "+", 
        RowBox[{"200", " ", 
         SuperscriptBox["s3", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"]}], "+", 
        RowBox[{"960", " ", 
         SuperscriptBox["s2", "3"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}], "+", 
        RowBox[{"960", " ", 
         SuperscriptBox["s3", "3"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}], "+", 
        RowBox[{"40", " ", 
         SuperscriptBox["s2", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5", "+", 
           RowBox[{"72", " ", "s3", " ", "\[Lambda]"}]}], ")"}]}], "+", 
        RowBox[{"10", " ", "s2", " ", "\[Lambda]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "13"}], "+", 
           RowBox[{"40", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"288", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"7", " ", "s1", " ", 
      RowBox[{"(", 
       RowBox[{"s2", "+", "s3"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["s3", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"30", " ", "s3", " ", "\[Lambda]"}]}], ")"}]}], "+", 
        RowBox[{"10", " ", "s2", " ", 
         SuperscriptBox["s3", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           RowBox[{"69", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"24", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"30", " ", 
         SuperscriptBox["s2", "5"], " ", "\[Lambda]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           RowBox[{"8", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"96", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"10", " ", 
         SuperscriptBox["s2", "3"], " ", "s3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           RowBox[{"201", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"264", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"864", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["s2", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           RowBox[{"230", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"520", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"2880", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["s2", "2"], " ", 
         SuperscriptBox["s3", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "17"}], "-", 
           RowBox[{"2010", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"1560", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"2880", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"7", " ", 
      SuperscriptBox["s1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"s2", "+", "s3"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"960", " ", 
         SuperscriptBox["s2", "5"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}], "+", 
        RowBox[{"120", " ", 
         SuperscriptBox["s2", "4"], " ", 
         SuperscriptBox["\[Lambda]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5", "+", 
           RowBox[{"88", " ", "s3", " ", "\[Lambda]"}]}], ")"}]}], "+", 
        RowBox[{"30", " ", 
         SuperscriptBox["s2", "3"], " ", "\[Lambda]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "27"}], "+", 
           RowBox[{"120", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"896", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["s3", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "7"}], "-", 
           RowBox[{"810", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"600", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"960", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{"10", " ", "s2", " ", "s3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "-", 
           RowBox[{"321", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"360", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"1056", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["s2", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "7"}], "-", 
           RowBox[{"3210", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"6000", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"26880", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["s1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"20160", " ", 
         SuperscriptBox["s2", "5"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}], "+", 
        RowBox[{"6720", " ", 
         SuperscriptBox["s2", "4"], " ", 
         SuperscriptBox["\[Lambda]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"18", " ", "s3", " ", "\[Lambda]"}]}], ")"}]}], "+", 
        RowBox[{"210", " ", 
         SuperscriptBox["s2", "3"], " ", "\[Lambda]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "27"}], "+", 
           RowBox[{"140", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"1248", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["s3", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "19"}], "-", 
           RowBox[{"2835", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"3360", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"10080", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{"7", " ", "s2", " ", "s3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "13"}], "-", 
           RowBox[{"2700", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"4200", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"17280", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["s2", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "19"}], "-", 
           RowBox[{"9450", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"22680", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"131040", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["s1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"840", " ", 
         SuperscriptBox["s2", "6"], " ", 
         SuperscriptBox["\[Lambda]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"24", " ", "s3", " ", "\[Lambda]"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["s3", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "19"}], "-", 
           RowBox[{"1365", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"420", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"210", " ", 
         SuperscriptBox["s2", "5"], " ", "\[Lambda]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "13"}], "+", 
           RowBox[{"60", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"576", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"63", " ", "s2", " ", 
         SuperscriptBox["s3", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "-", 
           RowBox[{"300", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"200", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"320", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{"21", " ", 
         SuperscriptBox["s2", "3"], " ", "s3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "9"}], "-", 
           RowBox[{"2140", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"3200", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"12480", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["s2", "2"], " ", 
         SuperscriptBox["s3", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "317"}], "-", 
           RowBox[{"44940", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"45360", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"120960", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["s2", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "19"}], "-", 
           RowBox[{"9450", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"22680", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"131040", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{{3.9495104666905403`*^9, 3.949510484908979*^9}, 
   3.949510689557448*^9, {3.9495108697648478`*^9, 3.949510883866419*^9}, 
   3.9495109174192142`*^9, 3.949511292776*^9, 3.949535999563356*^9, 
   3.949571549393456*^9, 3.949572535334662*^9, 3.9495735068091784`*^9, 
   3.9495735767025433`*^9, 3.949574806032261*^9, 3.949591658085945*^9, 
   3.949766178273184*^9, 3.9551851153750343`*^9, 3.95518745844268*^9, 
   3.955188631450334*^9, 3.955189249908977*^9, 3.955196939120496*^9},
 CellLabel->
  "Out[192]=",ExpressionUUID->"2e58ca00-9221-4478-a8c7-7c236e339308"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"expansion", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"expandedC", "/", "constRatio"}], "/.", 
      RowBox[{"t", "->", "1"}]}], ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{"{", 
       RowBox[{"\[Lambda]", ">", "0"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CoefficientList", "[", 
   RowBox[{"expansion", ",", 
    RowBox[{"1", "/", "\[Lambda]"}]}], "]"}], "//", "Simplify"}]}], "Input",
 CellChangeTimes->{{3.94951144837477*^9, 3.9495114723551083`*^9}, {
  3.949536052279233*^9, 3.9495360727329483`*^9}, {3.949567843578693*^9, 
  3.949567853249908*^9}, {3.9495679128176603`*^9, 3.949567913676223*^9}, {
  3.9495726085080137`*^9, 3.949572611209758*^9}},
 CellLabel->
  "In[193]:=",ExpressionUUID->"cdbcc8b8-6d76-45a6-be22-0be958a235d9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["s1", "2"], "+", 
     SuperscriptBox["s2", "2"], "+", 
     RowBox[{"3", " ", "s2", " ", "s3"}], "+", 
     SuperscriptBox["s3", "2"], "+", 
     RowBox[{"3", " ", "s1", " ", 
      RowBox[{"(", 
       RowBox[{"s2", "+", "s3"}], ")"}]}]}], 
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{"s1", "+", "s2"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"s1", "+", "s3"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"s2", "+", "s3"}], ")"}]}]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["s1", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["s2", "4"]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["s2", "3"], " ", "s3"}], "+", 
      RowBox[{"17", " ", 
       SuperscriptBox["s2", "2"], " ", 
       SuperscriptBox["s3", "2"]}], "+", 
      RowBox[{"10", " ", "s2", " ", 
       SuperscriptBox["s3", "3"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["s3", "4"]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["s1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"s2", "+", "s3"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["s1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"17", " ", 
          SuperscriptBox["s2", "2"]}], "+", 
         RowBox[{"40", " ", "s2", " ", "s3"}], "+", 
         RowBox[{"17", " ", 
          SuperscriptBox["s3", "2"]}]}], ")"}]}], "+", 
      RowBox[{"10", " ", "s1", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["s2", "3"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["s2", "2"], " ", "s3"}], "+", 
         RowBox[{"4", " ", "s2", " ", 
          SuperscriptBox["s3", "2"]}], "+", 
         SuperscriptBox["s3", "3"]}], ")"}]}]}], 
     RowBox[{"32", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"s1", "+", "s2"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"s1", "+", "s3"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"s2", "+", "s3"}], ")"}], "2"]}]]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["s1", "6"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["s2", "6"]}], "+", 
      RowBox[{"21", " ", 
       SuperscriptBox["s2", "5"], " ", "s3"}], "+", 
      RowBox[{"38", " ", 
       SuperscriptBox["s2", "4"], " ", 
       SuperscriptBox["s3", "2"]}], "+", 
      RowBox[{"49", " ", 
       SuperscriptBox["s2", "3"], " ", 
       SuperscriptBox["s3", "3"]}], "+", 
      RowBox[{"38", " ", 
       SuperscriptBox["s2", "2"], " ", 
       SuperscriptBox["s3", "4"]}], "+", 
      RowBox[{"21", " ", "s2", " ", 
       SuperscriptBox["s3", "5"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["s3", "6"]}], "+", 
      RowBox[{"21", " ", 
       SuperscriptBox["s1", "5"], " ", 
       RowBox[{"(", 
        RowBox[{"s2", "+", "s3"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["s1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"38", " ", 
          SuperscriptBox["s2", "2"]}], "+", 
         RowBox[{"91", " ", "s2", " ", "s3"}], "+", 
         RowBox[{"38", " ", 
          SuperscriptBox["s3", "2"]}]}], ")"}]}], "+", 
      RowBox[{"7", " ", 
       SuperscriptBox["s1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["s2", "3"]}], "+", 
         RowBox[{"27", " ", 
          SuperscriptBox["s2", "2"], " ", "s3"}], "+", 
         RowBox[{"27", " ", "s2", " ", 
          SuperscriptBox["s3", "2"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["s3", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["s1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"38", " ", 
          SuperscriptBox["s2", "4"]}], "+", 
         RowBox[{"189", " ", 
          SuperscriptBox["s2", "3"], " ", "s3"}], "+", 
         RowBox[{"317", " ", 
          SuperscriptBox["s2", "2"], " ", 
          SuperscriptBox["s3", "2"]}], "+", 
         RowBox[{"189", " ", "s2", " ", 
          SuperscriptBox["s3", "3"]}], "+", 
         RowBox[{"38", " ", 
          SuperscriptBox["s3", "4"]}]}], ")"}]}], "+", 
      RowBox[{"7", " ", "s1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["s2", "5"]}], "+", 
         RowBox[{"13", " ", 
          SuperscriptBox["s2", "4"], " ", "s3"}], "+", 
         RowBox[{"27", " ", 
          SuperscriptBox["s2", "3"], " ", 
          SuperscriptBox["s3", "2"]}], "+", 
         RowBox[{"27", " ", 
          SuperscriptBox["s2", "2"], " ", 
          SuperscriptBox["s3", "3"]}], "+", 
         RowBox[{"13", " ", "s2", " ", 
          SuperscriptBox["s3", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["s3", "5"]}]}], ")"}]}]}], 
     RowBox[{"6720", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"s1", "+", "s2"}], ")"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"s1", "+", "s3"}], ")"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"s2", "+", "s3"}], ")"}], "3"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.949511454653903*^9, 3.949511472967518*^9}, 
   3.94953600651355*^9, 3.949536074015924*^9, 3.949567854557523*^9, 
   3.9495679145027437`*^9, 3.949567953838695*^9, 3.94957155589412*^9, 
   3.949572611787896*^9, 3.949573511378354*^9, 3.949573582241497*^9, 
   3.949574811335001*^9, 3.949591664052373*^9, 3.9551852329376583`*^9, 
   3.955186781474945*^9, 3.955187041108615*^9, 3.955188672595487*^9, 
   3.955191820395543*^9, 3.9551969411853533`*^9},
 CellLabel->
  "Out[194]=",ExpressionUUID->"741aa644-db2d-47f8-a97a-f01da353847a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["expandedC"], "Input",
 CellChangeTimes->{{3.949572829329563*^9, 3.949572830729403*^9}},
 CellLabel->
  "In[195]:=",ExpressionUUID->"3729e6b5-6391-453d-880f-68c1f4bb0396"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"13440", " ", 
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"s1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"s1", "+", "s3"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"s2", "+", "s3"}], ")"}]}], ")"}], 
     RowBox[{"7", "/", "2"}]], " ", 
    SuperscriptBox["t", "3"], " ", 
    SuperscriptBox["\[Lambda]", 
     RowBox[{"9", "/", "2"}]]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"s1", "+", "s2", "+", "s3"}], ")"}], " ", "\[Lambda]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5"}], " ", 
      SuperscriptBox["s3", "6"]}], "-", 
     RowBox[{"21", " ", "s2", " ", 
      SuperscriptBox["s3", "5"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"30", " ", "s3", " ", "\[Lambda]"}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["s2", "2"], " ", 
      SuperscriptBox["s3", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "19"}], "-", 
        RowBox[{"1365", " ", "s3", " ", "\[Lambda]"}], "+", 
        RowBox[{"420", " ", 
         SuperscriptBox["s3", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}], "+", 
     RowBox[{"21", " ", 
      SuperscriptBox["s2", "5"], " ", "s3", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"130", " ", "s3", " ", "\[Lambda]"}], "+", 
        RowBox[{"200", " ", 
         SuperscriptBox["s3", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"]}], "+", 
        RowBox[{"960", " ", 
         SuperscriptBox["s3", "3"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
     RowBox[{"7", " ", 
      SuperscriptBox["s2", "3"], " ", 
      SuperscriptBox["s3", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "7"}], "-", 
        RowBox[{"810", " ", "s3", " ", "\[Lambda]"}], "+", 
        RowBox[{"600", " ", 
         SuperscriptBox["s3", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"]}], "+", 
        RowBox[{"960", " ", 
         SuperscriptBox["s3", "3"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["s2", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "5"}], "-", 
        RowBox[{"630", " ", "s3", " ", "\[Lambda]"}], "+", 
        RowBox[{"840", " ", 
         SuperscriptBox["s3", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"]}], "+", 
        RowBox[{"6720", " ", 
         SuperscriptBox["s3", "3"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["s2", "4"], " ", 
      SuperscriptBox["s3", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "19"}], "-", 
        RowBox[{"2835", " ", "s3", " ", "\[Lambda]"}], "+", 
        RowBox[{"3360", " ", 
         SuperscriptBox["s3", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"]}], "+", 
        RowBox[{"10080", " ", 
         SuperscriptBox["s3", "3"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
     RowBox[{"5", " ", 
      SuperscriptBox["s1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"126", " ", "s3", " ", "\[Lambda]"}], "+", 
        RowBox[{"168", " ", 
         SuperscriptBox["s3", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"]}], "+", 
        RowBox[{"1344", " ", 
         SuperscriptBox["s2", "3"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}], "+", 
        RowBox[{"1344", " ", 
         SuperscriptBox["s3", "3"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}], "+", 
        RowBox[{"168", " ", 
         SuperscriptBox["s2", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"24", " ", "s3", " ", "\[Lambda]"}]}], ")"}]}], "+", 
        RowBox[{"42", " ", "s2", " ", "\[Lambda]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           RowBox[{"8", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"96", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"21", " ", 
      SuperscriptBox["s1", "5"], " ", 
      RowBox[{"(", 
       RowBox[{"s2", "+", "s3"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"130", " ", "s3", " ", "\[Lambda]"}], "+", 
        RowBox[{"200", " ", 
         SuperscriptBox["s3", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"]}], "+", 
        RowBox[{"960", " ", 
         SuperscriptBox["s2", "3"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}], "+", 
        RowBox[{"960", " ", 
         SuperscriptBox["s3", "3"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}], "+", 
        RowBox[{"40", " ", 
         SuperscriptBox["s2", "2"], " ", 
         SuperscriptBox["\[Lambda]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5", "+", 
           RowBox[{"72", " ", "s3", " ", "\[Lambda]"}]}], ")"}]}], "+", 
        RowBox[{"10", " ", "s2", " ", "\[Lambda]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "13"}], "+", 
           RowBox[{"40", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"288", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"7", " ", "s1", " ", 
      RowBox[{"(", 
       RowBox[{"s2", "+", "s3"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["s3", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"30", " ", "s3", " ", "\[Lambda]"}]}], ")"}]}], "+", 
        RowBox[{"10", " ", "s2", " ", 
         SuperscriptBox["s3", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           RowBox[{"69", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"24", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"30", " ", 
         SuperscriptBox["s2", "5"], " ", "\[Lambda]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           RowBox[{"8", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"96", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"10", " ", 
         SuperscriptBox["s2", "3"], " ", "s3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           RowBox[{"201", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"264", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"864", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["s2", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           RowBox[{"230", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"520", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"2880", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["s2", "2"], " ", 
         SuperscriptBox["s3", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "17"}], "-", 
           RowBox[{"2010", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"1560", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"2880", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"7", " ", 
      SuperscriptBox["s1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"s2", "+", "s3"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"960", " ", 
         SuperscriptBox["s2", "5"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}], "+", 
        RowBox[{"120", " ", 
         SuperscriptBox["s2", "4"], " ", 
         SuperscriptBox["\[Lambda]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5", "+", 
           RowBox[{"88", " ", "s3", " ", "\[Lambda]"}]}], ")"}]}], "+", 
        RowBox[{"30", " ", 
         SuperscriptBox["s2", "3"], " ", "\[Lambda]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "27"}], "+", 
           RowBox[{"120", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"896", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["s3", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "7"}], "-", 
           RowBox[{"810", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"600", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"960", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{"10", " ", "s2", " ", "s3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "-", 
           RowBox[{"321", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"360", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"1056", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["s2", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "7"}], "-", 
           RowBox[{"3210", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"6000", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"26880", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["s1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"20160", " ", 
         SuperscriptBox["s2", "5"], " ", 
         SuperscriptBox["\[Lambda]", "3"]}], "+", 
        RowBox[{"6720", " ", 
         SuperscriptBox["s2", "4"], " ", 
         SuperscriptBox["\[Lambda]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"18", " ", "s3", " ", "\[Lambda]"}]}], ")"}]}], "+", 
        RowBox[{"210", " ", 
         SuperscriptBox["s2", "3"], " ", "\[Lambda]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "27"}], "+", 
           RowBox[{"140", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"1248", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["s3", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "19"}], "-", 
           RowBox[{"2835", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"3360", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"10080", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{"7", " ", "s2", " ", "s3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "13"}], "-", 
           RowBox[{"2700", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"4200", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"17280", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["s2", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "19"}], "-", 
           RowBox[{"9450", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"22680", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"131040", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["s1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"840", " ", 
         SuperscriptBox["s2", "6"], " ", 
         SuperscriptBox["\[Lambda]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"24", " ", "s3", " ", "\[Lambda]"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["s3", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "19"}], "-", 
           RowBox[{"1365", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"420", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"210", " ", 
         SuperscriptBox["s2", "5"], " ", "\[Lambda]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "13"}], "+", 
           RowBox[{"60", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"576", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"63", " ", "s2", " ", 
         SuperscriptBox["s3", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "-", 
           RowBox[{"300", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"200", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"320", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{"21", " ", 
         SuperscriptBox["s2", "3"], " ", "s3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "9"}], "-", 
           RowBox[{"2140", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"3200", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"12480", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["s2", "2"], " ", 
         SuperscriptBox["s3", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "317"}], "-", 
           RowBox[{"44940", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"45360", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"120960", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["s2", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "19"}], "-", 
           RowBox[{"9450", " ", "s3", " ", "\[Lambda]"}], "+", 
           RowBox[{"22680", " ", 
            SuperscriptBox["s3", "2"], " ", 
            SuperscriptBox["\[Lambda]", "2"]}], "+", 
           RowBox[{"131040", " ", 
            SuperscriptBox["s3", "3"], " ", 
            SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.9495728313985157`*^9, 3.949591667171041*^9, 
  3.955185238027307*^9, 3.9551886997056*^9, 3.9551978968870077`*^9},
 CellLabel->
  "Out[195]=",ExpressionUUID->"c7cae22e-77b8-4ae3-87d9-936a2a11be62"]
}, Open  ]],

Cell["\<\
Finally, it is not hard to see the expected rotation must be diagonal and can \
be obtained from the partition function through differentiation.\
\>", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellChangeTimes->{{3.955185684595353*^9, 3.955185721475131*^9}},
 Background->RGBColor[
  1, 1, 0.85],ExpressionUUID->"97c9c57e-ef45-4c90-8a17-4fb09ec9776d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"expectedR", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Normal", "[", 
       RowBox[{"Series", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"expandedC", ",", 
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"s1", ",", "s2", ",", "s3"}], "}"}], "}"}]}], "]"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{"expandedC", "*", "\[Lambda]"}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "order"}], "}"}]}], "]"}], "]"}], "/.", 
      
      RowBox[{"{", 
       RowBox[{"t", "->", "1"}], "}"}]}], ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"s1", ">", "0"}], ",", 
        RowBox[{"s2", ">", "0"}], ",", 
        RowBox[{"s3", ">", "0"}], ",", 
        RowBox[{"\[Lambda]", ">", "0"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.949572444254239*^9, 3.949572447468162*^9}, {
   3.94957248147691*^9, 3.949572489755601*^9}, {3.949572644539413*^9, 
   3.949572730827187*^9}, {3.949572790231729*^9, 3.949572803552889*^9}, {
   3.949573040022526*^9, 3.949573055806109*^9}, {3.949573103301406*^9, 
   3.949573182820182*^9}, 3.949575337118932*^9},
 CellLabel->
  "In[196]:=",ExpressionUUID->"5decfcee-a4f5-44d8-bc14-fbbb7c383bcd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"expandedR", "=", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"CoefficientList", "[", 
       RowBox[{
        RowBox[{"Series", "[", 
         RowBox[{"expectedR", ",", 
          RowBox[{"{", 
           RowBox[{"\[Lambda]", ",", "\[Infinity]", ",", "order"}], "}"}]}], 
         "]"}], ",", 
        RowBox[{"1", "/", "\[Lambda]"}]}], "]"}], ",", 
      RowBox[{"Assumptions", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"s1", ">", "0"}], ",", 
         RowBox[{"s2", ">", "0"}], ",", 
         RowBox[{"s3", ">", "0"}]}], "}"}]}]}], "]"}], "//", "Apart"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.949573704209023*^9, 3.9495737450879173`*^9}, {
  3.94957378397512*^9, 3.9495738097982283`*^9}, {3.949574744725808*^9, 
  3.949574746797134*^9}, {3.9495753275845213`*^9, 3.9495753398047123`*^9}, {
  3.949591710844431*^9, 3.9495917151884727`*^9}, {3.94967722345043*^9, 
  3.949677246873598*^9}},
 CellLabel->
  "In[197]:=",ExpressionUUID->"330a868e-28a5-4232-8f5f-7f42822ee8b6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expandedR", "//", "Transpose"}]], "Input",
 CellChangeTimes->{{3.949591718210464*^9, 3.949591728084963*^9}},
 CellLabel->
  "In[198]:=",ExpressionUUID->"7a4912fd-4e01-447a-80b5-83eaceca661f"],

Cell[BoxData[
 TemplateBox[<|"shortenedBoxes" -> TagBox[
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{"-", 
                 FractionBox["1", 
                  RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}]}]]}], "-", 
               FractionBox["1", 
                RowBox[{"2", " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}]}]]}], ",", 
             RowBox[{
               RowBox[{"-", 
                 FractionBox["1", 
                  RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}]}]]}], "-", 
               FractionBox["1", 
                RowBox[{"2", " ", 
                  RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}]}]]}], ",", 
             RowBox[{
               RowBox[{"-", 
                 FractionBox["1", 
                  RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}]}]]}], "-", 
               FractionBox["1", 
                RowBox[{"2", " ", 
                  RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}]}]]}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{"-", 
                 FractionBox["1", 
                  RowBox[{"8", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "2"]}]]}], "-", 
               FractionBox["1", 
                RowBox[{"8", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}], "2"]}]]}], ",", 
             RowBox[{
               RowBox[{"-", 
                 FractionBox["1", 
                  RowBox[{"8", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "2"]}]]}], "-", 
               FractionBox["1", 
                RowBox[{"8", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}], "2"]}]]}], ",", 
             RowBox[{
               RowBox[{"-", 
                 FractionBox["1", 
                  RowBox[{"8", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}], "2"]}]]}], "-", 
               FractionBox["1", 
                RowBox[{"8", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}], "2"]}]]}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               FractionBox["13", 
                RowBox[{"64", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "3"]}]], "+", 
               FractionBox["13", 
                RowBox[{"64", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}], "3"]}]], "-", 
               FractionBox[
                RowBox[{"5", " ", "s2"}], 
                RowBox[{"32", " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}], "2"]}]], "-", 
               FractionBox[
                RowBox[{"5", " ", "s1", " ", "s2"}], 
                RowBox[{"16", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "2"], " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}]}]], "+", 
               FractionBox[
                RowBox[{"5", " ", 
                  RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["s1", "2"], "+", 
                    SuperscriptBox["s2", "2"]}], ")"}]}], 
                RowBox[{"32", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "2"], " ", 
                  RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}]}]]}], ",", 
             RowBox[{
               FractionBox["13", 
                RowBox[{"64", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "3"]}]], "+", 
               FractionBox[
                RowBox[{"5", " ", 
                  RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["s1", "2"], "+", 
                    SuperscriptBox["s2", "2"]}], ")"}]}], 
                RowBox[{"32", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "2"], " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}]}]], "+", 
               FractionBox["13", 
                RowBox[{"64", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}], "3"]}]], "+", 
               FractionBox[
                RowBox[{"5", " ", "s1"}], 
                RowBox[{"32", " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}], "2"]}]], "-", 
               FractionBox[
                RowBox[{"5", " ", "s1", " ", "s2"}], 
                RowBox[{"16", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "2"], " ", 
                  RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}]}]]}], ",", 
             RowBox[{
               FractionBox["13", 
                RowBox[{"64", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}], "3"]}]], "-", 
               FractionBox[
                RowBox[{"5", " ", "s2"}], 
                RowBox[{"32", " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}], "2"]}]], "+", 
               FractionBox["13", 
                RowBox[{"64", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}], "3"]}]], "+", 
               FractionBox[
                RowBox[{"5", " ", "s1"}], 
                RowBox[{"32", " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}], "2"]}]]}]}], "}"}], ",", 
         TemplateBox[{"1"}, "OutputSizeLimit`Skeleton"], ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               FractionBox["2005", 
                RowBox[{"86016", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "5"]}]], "+", 
               FractionBox["2005", 
                RowBox[{"86016", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}], "5"]}]], "-", 
               FractionBox[
                RowBox[{"4241", " ", "s2"}], 
                RowBox[{"71680", " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}], "4"]}]], "+", 
               FractionBox[
                RowBox[{
                  RowBox[{"1607", " ", 
                    SuperscriptBox["s1", "2"]}], "-", 
                  RowBox[{"16964", " ", "s1", " ", "s2"}], "+", 
                  RowBox[{"17229", " ", 
                    SuperscriptBox["s2", "2"]}]}], 
                RowBox[{"215040", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}], "3"]}]], "+", 
               FractionBox[
                RowBox[{
                  RowBox[{"4821", " ", 
                    SuperscriptBox["s1", "3"]}], "-", 
                  RowBox[{"14827", " ", 
                    SuperscriptBox["s1", "2"], " ", "s2"}], "+", 
                  RowBox[{"108195", " ", "s1", " ", 
                    SuperscriptBox["s2", "2"]}], "-", 
                  RowBox[{"15357", " ", 
                    SuperscriptBox["s2", "3"]}]}], 
                RowBox[{"430080", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}], "2"]}]], "+", 
               FractionBox[
                RowBox[{
                  RowBox[{"4821", " ", 
                    SuperscriptBox["s1", "4"]}], "+", 
                  RowBox[{"42476", " ", 
                    SuperscriptBox["s1", "3"], " ", "s2"}], "+", 
                  RowBox[{"185146", " ", 
                    SuperscriptBox["s1", "2"], " ", 
                    SuperscriptBox["s2", "2"]}], "-", 
                  RowBox[{"20012", " ", "s1", " ", 
                    SuperscriptBox["s2", "3"]}], "+", 
                  RowBox[{"36065", " ", 
                    SuperscriptBox["s2", "4"]}]}], 
                RowBox[{"430080", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "4"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "4"], " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}]}]], "+", 
               FractionBox[
                RowBox[{"4241", " ", 
                  RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["s1", "2"], "+", 
                    SuperscriptBox["s2", "2"]}], ")"}]}], 
                RowBox[{"215040", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}], "3"]}]], "+", 
               FractionBox[
                RowBox[{
                  RowBox[{"17229", " ", 
                    SuperscriptBox["s1", "3"]}], "-", 
                  RowBox[{"12723", " ", 
                    SuperscriptBox["s1", "2"], " ", "s2"}], "+", 
                  RowBox[{"20443", " ", "s1", " ", 
                    SuperscriptBox["s2", "2"]}], "-", 
                  RowBox[{"4241", " ", 
                    SuperscriptBox["s2", "3"]}]}], 
                RowBox[{"215040", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}], "2"]}]], "+", 
               FractionBox[
                RowBox[{
                  RowBox[{"20625", " ", 
                    SuperscriptBox["s1", "4"]}], "-", 
                  RowBox[{"144260", " ", 
                    SuperscriptBox["s1", "3"], " ", "s2"}], "-", 
                  RowBox[{"32470", " ", 
                    SuperscriptBox["s1", "2"], " ", 
                    SuperscriptBox["s2", "2"]}], "-", 
                  RowBox[{"81772", " ", "s1", " ", 
                    SuperscriptBox["s2", "3"]}], "-", 
                  RowBox[{"10619", " ", 
                    SuperscriptBox["s2", "4"]}]}], 
                RowBox[{"430080", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "4"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "4"], " ", 
                  RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}]}]]}], ",", 
             RowBox[{
               FractionBox["2005", 
                RowBox[{"86016", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "5"]}]], "+", 
               FractionBox[
                RowBox[{"4241", " ", 
                  RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["s1", "2"], "+", 
                    SuperscriptBox["s2", "2"]}], ")"}]}], 
                RowBox[{"215040", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}], "3"]}]], "+", 
               FractionBox[
                RowBox[{
                  RowBox[{"4241", " ", 
                    SuperscriptBox["s1", "3"]}], "-", 
                  RowBox[{"20443", " ", 
                    SuperscriptBox["s1", "2"], " ", "s2"}], "+", 
                  RowBox[{"12723", " ", "s1", " ", 
                    SuperscriptBox["s2", "2"]}], "-", 
                  RowBox[{"17229", " ", 
                    SuperscriptBox["s2", "3"]}]}], 
                RowBox[{"215040", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}], "2"]}]], "+", 
               FractionBox[
                RowBox[{
                  RowBox[{
                    RowBox[{"-", "10619"}], " ", 
                    SuperscriptBox["s1", "4"]}], "-", 
                  RowBox[{"81772", " ", 
                    SuperscriptBox["s1", "3"], " ", "s2"}], "-", 
                  RowBox[{"32470", " ", 
                    SuperscriptBox["s1", "2"], " ", 
                    SuperscriptBox["s2", "2"]}], "-", 
                  RowBox[{"144260", " ", "s1", " ", 
                    SuperscriptBox["s2", "3"]}], "+", 
                  RowBox[{"20625", " ", 
                    SuperscriptBox["s2", "4"]}]}], 
                RowBox[{"430080", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "4"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "4"], " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}]}]], "+", 
               FractionBox["2005", 
                RowBox[{"86016", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}], "5"]}]], "+", 
               FractionBox[
                RowBox[{"4241", " ", "s1"}], 
                RowBox[{"71680", " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}], "4"]}]], "+", 
               FractionBox[
                RowBox[{
                  RowBox[{"17229", " ", 
                    SuperscriptBox["s1", "2"]}], "-", 
                  RowBox[{"16964", " ", "s1", " ", "s2"}], "+", 
                  RowBox[{"1607", " ", 
                    SuperscriptBox["s2", "2"]}]}], 
                RowBox[{"215040", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}], "3"]}]], "+", 
               FractionBox[
                RowBox[{
                  RowBox[{"15357", " ", 
                    SuperscriptBox["s1", "3"]}], "-", 
                  RowBox[{"108195", " ", 
                    SuperscriptBox["s1", "2"], " ", "s2"}], "+", 
                  RowBox[{"14827", " ", "s1", " ", 
                    SuperscriptBox["s2", "2"]}], "-", 
                  RowBox[{"4821", " ", 
                    SuperscriptBox["s2", "3"]}]}], 
                RowBox[{"430080", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}], "2"]}]], "+", 
               FractionBox[
                RowBox[{
                  RowBox[{"36065", " ", 
                    SuperscriptBox["s1", "4"]}], "-", 
                  RowBox[{"20012", " ", 
                    SuperscriptBox["s1", "3"], " ", "s2"}], "+", 
                  RowBox[{"185146", " ", 
                    SuperscriptBox["s1", "2"], " ", 
                    SuperscriptBox["s2", "2"]}], "+", 
                  RowBox[{"42476", " ", "s1", " ", 
                    SuperscriptBox["s2", "3"]}], "+", 
                  RowBox[{"4821", " ", 
                    SuperscriptBox["s2", "4"]}]}], 
                RowBox[{"430080", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "4"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "4"], " ", 
                  RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}]}]]}], ",", 
             RowBox[{
               FractionBox["2005", 
                RowBox[{"86016", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}], "5"]}]], "-", 
               FractionBox[
                RowBox[{"4241", " ", "s2"}], 
                RowBox[{"71680", " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}], "4"]}]], "+", 
               FractionBox[
                RowBox[{
                  RowBox[{"1607", " ", 
                    SuperscriptBox["s1", "2"]}], "-", 
                  RowBox[{"8482", " ", "s1", " ", "s2"}], "+", 
                  RowBox[{"17229", " ", 
                    SuperscriptBox["s2", "2"]}]}], 
                RowBox[{"215040", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}], "3"]}]], "+", 
               FractionBox[
                RowBox[{
                  RowBox[{"1607", " ", 
                    SuperscriptBox["s1", "3"]}], "+", 
                  RowBox[{"10619", " ", 
                    SuperscriptBox["s1", "2"], " ", "s2"}], "+", 
                  RowBox[{"36065", " ", "s1", " ", 
                    SuperscriptBox["s2", "2"]}], "-", 
                  RowBox[{"6875", " ", 
                    SuperscriptBox["s2", "3"]}]}], 
                RowBox[{"430080", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s3"}], ")"}], "2"]}]], "+", 
               FractionBox["2005", 
                RowBox[{"86016", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}], "5"]}]], "+", 
               FractionBox[
                RowBox[{"4241", " ", "s1"}], 
                RowBox[{"71680", " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], " ", 
                  RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}], "4"]}]], "+", 
               FractionBox[
                RowBox[{
                  RowBox[{"17229", " ", 
                    SuperscriptBox["s1", "2"]}], "-", 
                  RowBox[{"8482", " ", "s1", " ", "s2"}], "+", 
                  RowBox[{"1607", " ", 
                    SuperscriptBox["s2", "2"]}]}], 
                RowBox[{"215040", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}], "3"]}]], "+", 
               FractionBox[
                RowBox[{
                  RowBox[{"6875", " ", 
                    SuperscriptBox["s1", "3"]}], "-", 
                  RowBox[{"36065", " ", 
                    SuperscriptBox["s1", "2"], " ", "s2"}], "-", 
                  RowBox[{"10619", " ", "s1", " ", 
                    SuperscriptBox["s2", "2"]}], "-", 
                  RowBox[{"1607", " ", 
                    SuperscriptBox["s2", "3"]}]}], 
                RowBox[{"430080", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "-", "s2"}], ")"}], "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s1", "+", "s2"}], ")"}], "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"s2", "+", "s3"}], ")"}], "2"]}]]}]}], "}"}], ",", 
         TemplateBox[{"1"}, "OutputSizeLimit`Skeleton"], ",", 
         RowBox[{"{", 
           TemplateBox[{"1"}, "OutputSizeLimit`Skeleton"], "}"}]}], "}"}], 
     Short[#, 8]& ], "line" -> 198, "sessionID" -> 24800117104881129101, 
   "byteCount" -> 1660936, "size" -> 8, "stored" -> False, "expr" -> 
   Missing["NotStored"], "wrap" -> OutputSizeLimit`Defer, "version" -> 1|>,
  "OutputSizeLimitTemplate"]], "Output",
 CellChangeTimes->{3.949591728754077*^9, 3.949677264725111*^9, 
  3.9497662605272017`*^9, 3.95518529885046*^9, 3.955197937544026*^9},
 CellLabel->
  "Out[198]=",ExpressionUUID->"b43e8ec6-fd1c-4e37-8246-1d93b7b8f372"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expandedR", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"s1", "->", "tests1"}], ",", 
    RowBox[{"s2", "->", "tests2"}], ",", 
    RowBox[{"s3", "->", "tests3"}], ",", 
    RowBox[{"\[Lambda]", "->", "1"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.949573222356745*^9, 3.949573256428802*^9}, {
  3.949573670880011*^9, 3.949573680542554*^9}, {3.9495753651918793`*^9, 
  3.949575367140161*^9}},
 CellLabel->
  "In[406]:=",ExpressionUUID->"5fab89f3-ade1-48ff-b97a-9b3a0f7c95f9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "0.3666666666666667`"}], ",", 
     RowBox[{"-", "0.033888888888888885`"}], ",", "0.0026992798353909463`", 
     ",", 
     RowBox[{"-", "0.0001531490054869683`"}], ",", "1.3745263996849878`*^-6", 
     ",", "1.2020836971731085`*^-6", ",", 
     RowBox[{"-", "2.2331234630109453`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "0.5`"}], ",", 
     RowBox[{"-", "0.06944444444444445`"}], ",", "0.004128086419753086`", ",", 
     RowBox[{"-", "0.00006826560356652952`"}], ",", 
     RowBox[{"-", "0.000026939074169333917`"}], ",", "5.357383109525572`*^-6",
      ",", 
     RowBox[{"-", "6.837826171150974`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "0.5333333333333333`"}], ",", 
     RowBox[{"-", "0.07555555555555556`"}], ",", "0.004517695473251029`", ",", 
     RowBox[{"-", "0.00007888203017832645`"}], ",", 
     RowBox[{"-", "0.000028751220596453806`"}], ",", "5.774512851614761`*^-6",
      ",", 
     RowBox[{"-", "7.397103500808022`*^-7"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.949573247651762*^9, 3.949573257124691*^9}, {
   3.949573414681402*^9, 3.949573421842063*^9}, 3.949573616429233*^9, {
   3.949573667119672*^9, 3.949573681210634*^9}, 3.949575369443811*^9},
 CellLabel->
  "Out[406]=",ExpressionUUID->"86a06b0c-6565-484d-baed-12c5065db219"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Small \[Lambda] approximation", "Section",
 CellChangeTimes->{{3.949762872827639*^9, 
  3.9497628800191393`*^9}},ExpressionUUID->"3e788e49-ce48-4ecf-88fe-\
ba9ef51e07f9"],

Cell["\<\
Taken from
Sei, T., Shibata, H., Takemura, A., Ohara, K., & Takayama, N. (2013). \
Properties and applications of Fisher distribution on the rotation group. \
Journal of Multivariate Analysis, 116, 440-455.\
\>", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellChangeTimes->{{3.9551861322538147`*^9, 3.955186136017807*^9}},
 Background->RGBColor[
  1, 1, 0.85],ExpressionUUID->"990b261c-bafc-443d-b4d0-40f2ba940581"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Imn", "[", 
   RowBox[{"m_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Factorial2", "[", 
     RowBox[{"m", "-", "1"}], "]"}], "*", 
    RowBox[{
     RowBox[{"Factorial2", "[", 
      RowBox[{"n", "-", "1"}], "]"}], "/", 
     RowBox[{"Factorial2", "[", 
      RowBox[{"m", "+", "n"}], "]"}]}]}], "\[IndentingNewLine]", 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eklm", "[", 
   RowBox[{"k_", ",", "l_", ",", "m_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", "i", ",", "sum"}], "}"}], ",", "\[IndentingNewLine]", 
     
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Mod", "[", 
          RowBox[{"k", ",", "2"}], "]"}], "==", 
         RowBox[{"Mod", "[", 
          RowBox[{"l", ",", "2"}], "]"}]}], "&&", 
        RowBox[{
         RowBox[{"Mod", "[", 
          RowBox[{"k", ",", "2"}], "]"}], "==", 
         RowBox[{"Mod", "[", 
          RowBox[{"m", ",", "2"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"sum", "=", "0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "0"}], ",", 
          RowBox[{"i", "<=", 
           RowBox[{"l", "/", "2"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"n", "=", 
            RowBox[{"l", "-", 
             RowBox[{"2", "*", "i"}]}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sum", "+=", 
            RowBox[{
             RowBox[{"Binomial", "[", 
              RowBox[{"l", ",", "n"}], "]"}], "*", 
             RowBox[{"Imn", "[", 
              RowBox[{
               RowBox[{"k", "+", "m", "+", "1"}], ",", 
               RowBox[{"l", "-", "n"}]}], "]"}], "*", 
             RowBox[{"Imn", "[", 
              RowBox[{
               RowBox[{"k", "+", "n"}], ",", 
               RowBox[{"l", "-", "n"}]}], "]"}], "*", 
             RowBox[{"Imn", "[", 
              RowBox[{
               RowBox[{"m", "+", "n"}], ",", 
               RowBox[{"l", "-", "n"}]}], "]"}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"i", "++"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", "sum"}], ",", "\[IndentingNewLine]", "0"}], 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", ")"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExpandC", "[", 
   RowBox[{"order_", ",", "s1_", ",", "s2_", ",", "s3_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", "l", ",", "m", ",", "sum"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sum", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"k", "=", "0"}], ",", 
        RowBox[{"k", "<=", "order"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"For", "[", 
          RowBox[{
           RowBox[{"l", "=", "0"}], ",", 
           RowBox[{"l", "<=", 
            RowBox[{"order", "-", "k"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"For", "[", 
             RowBox[{
              RowBox[{"m", "=", "0"}], ",", 
              RowBox[{"m", "<=", 
               RowBox[{"order", "-", "k", "-", "l"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"sum", "+=", 
                RowBox[{
                 RowBox[{"Eklm", "[", 
                  RowBox[{"k", ",", "l", ",", "m"}], "]"}], "*", 
                 SuperscriptBox["s1", "k"], "*", 
                 SuperscriptBox["s2", "l"], "*", 
                 SuperscriptBox["s3", "m"], "*", 
                 FractionBox["1", 
                  RowBox[{
                   RowBox[{"k", "!"}], "*", 
                   RowBox[{"l", "!"}], "*", 
                   RowBox[{"m", "!"}]}]]}]}], ";", "\[IndentingNewLine]", 
               RowBox[{"m", "++"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
            ";", "\[IndentingNewLine]", 
            RowBox[{"l", "++"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"k", "++"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", "sum"}]}], "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", ")"}]}]}], "Input",
 CellChangeTimes->{{3.949762931720563*^9, 3.9497629694529552`*^9}, {
   3.949770564734886*^9, 3.949770641225463*^9}, {3.94977082681364*^9, 
   3.949770835147502*^9}, {3.9497708741525*^9, 3.949771038442833*^9}, {
   3.9497710946040373`*^9, 3.949771124936647*^9}, {3.9497713972284927`*^9, 
   3.949771458871935*^9}, 3.9497716390615807`*^9, {3.949771677051433*^9, 
   3.949771684130965*^9}, {3.949771734664126*^9, 3.949771746442534*^9}, {
   3.9497719132304983`*^9, 3.949771990562928*^9}, {3.9497724445501347`*^9, 
   3.949772606584744*^9}, {3.949772647074256*^9, 3.94977272356225*^9}, {
   3.949772777999803*^9, 3.949772800161614*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"2eb26d9d-8944-44d6-b258-52b9995d112b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"order", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expansion", "=", 
   RowBox[{
    RowBox[{"ExpandC", "[", 
     RowBox[{"order", ",", 
      RowBox[{"s1", "*", "\[Lambda]"}], ",", 
      RowBox[{"s2", "*", "\[Lambda]"}], ",", 
      RowBox[{"s3", "*", "\[Lambda]"}]}], "]"}], "/", "constRatio"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.949771128292221*^9, 3.949771134575556*^9}, {
   3.949771411394291*^9, 3.949771432983675*^9}, {3.94977164916541*^9, 
   3.949771653317377*^9}, {3.949771752209135*^9, 3.949771752550457*^9}, {
   3.949771996374304*^9, 3.9497720101639147`*^9}, {3.949772422900722*^9, 
   3.949772434530047*^9}, {3.949772759988593*^9, 3.949772769105256*^9}, {
   3.9497728174303226`*^9, 3.9497728413334227`*^9}, 3.949773160502674*^9, {
   3.949773204215403*^9, 3.9497732511025267`*^9}, {3.949773404247452*^9, 
   3.949773406292163*^9}, {3.949777113127674*^9, 3.9497771423386583`*^9}, {
   3.949777372460772*^9, 3.949777412291739*^9}, {3.9497774730535097`*^9, 
   3.94977747552004*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"baff9253-97b3-4afc-9cd2-e6a4f16af816"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Integration", "Section",
 CellChangeTimes->{{3.949536671099468*^9, 3.9495366720932093`*^9}, {
  3.949567781982986*^9, 
  3.9495677862980347`*^9}},ExpressionUUID->"79674b73-5a96-4a9c-8572-\
ac89011add26"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"region", "=", 
   RowBox[{"ImplicitRegion", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}], "<=", 
      SuperscriptBox["\[Pi]", "2"]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"HaarMeasureVec", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "*", "t"}], ",", 
       RowBox[{"y", "*", "t"}], ",", 
       RowBox[{"z", "*", "t"}]}], "}"}], "]"}], "/.", 
    RowBox[{"t", "->", "1"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], "\[Element]", "region"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.949527115817555*^9, 3.949527127446493*^9}, {
   3.9495361753903503`*^9, 3.949536319241261*^9}, {3.949536382503845*^9, 
   3.949536411287137*^9}, 3.949536533094307*^9, {3.9495676322388678`*^9, 
   3.949567689670908*^9}, {3.949567728587514*^9, 3.949567743835472*^9}, 
   3.949567810581274*^9},
 CellLabel->"In[21]:=",ExpressionUUID->"bf287cb9-ef86-4554-a9ee-89932bdd07c9"],

Cell[BoxData["0.9999999985408243`"], "Output",
 CellChangeTimes->{{3.949536176789097*^9, 3.949536182296665*^9}, 
   3.9495364121611233`*^9, 3.949536591447855*^9, 3.9495395045895567`*^9, 
   3.949567745843956*^9, 3.94956781149203*^9, {3.949773259616891*^9, 
   3.949773272061694*^9}, 3.9551861852879333`*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"a14ebf68-52be-46f6-a74d-4318e265f0ff"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tests1", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tests2", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tests3", "=", 
   RowBox[{"-", "0.5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lambdaRange", "=", 
   SuperscriptBox["10", 
    RowBox[{"Subdivide", "[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "4", ",", "20"}], "]"}]]}], ";"}]}], "Input",
 CellChangeTimes->{{3.949568145059042*^9, 3.9495681864229803`*^9}, {
   3.9495682204864817`*^9, 3.9495683473994503`*^9}, {3.949568408073517*^9, 
   3.949568428747121*^9}, {3.949568500595147*^9, 3.949568503649703*^9}, {
   3.949568837501733*^9, 3.949568859380875*^9}, {3.949568932003976*^9, 
   3.949568948486719*^9}, {3.949568979965684*^9, 3.949568981258841*^9}, {
   3.9495714472659817`*^9, 3.949571448425396*^9}, {3.949573399494726*^9, 
   3.949573419062749*^9}, {3.94957366291287*^9, 3.9495736632152433`*^9}, {
   3.949575992552524*^9, 3.949575992686553*^9}, {3.949577535883215*^9, 
   3.949577536908804*^9}, {3.949586553004218*^9, 3.949586554053845*^9}, {
   3.949587071473318*^9, 3.949587071540728*^9}, {3.9495873862817574`*^9, 
   3.949587389778315*^9}, {3.949773279382599*^9, 3.949773280834672*^9}, {
   3.955187104371072*^9, 3.955187108557292*^9}, 3.955187664976384*^9, {
   3.955187849486223*^9, 3.955187850525145*^9}, 3.955188157338769*^9},
 CellLabel->
  "In[152]:=",ExpressionUUID->"b6a7c1fd-8556-4949-9a83-86ece6247313"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"numericVals", "=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"HaarMeasureVec", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x", "*", "t"}], ",", 
          RowBox[{"y", "*", "t"}], ",", 
          RowBox[{"z", "*", "t"}]}], "}"}], "]"}], "*", 
       RowBox[{"Exp", "[", "arg", "]"}]}], ")"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"t", "->", "1"}], ",", 
       RowBox[{"s1", "->", "tests1"}], ",", 
       RowBox[{"s2", "->", "tests2"}], ",", 
       RowBox[{"s3", "->", "tests3"}], ",", 
       RowBox[{"\[Lambda]", "->", "lambdaRange"}]}], "}"}]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], "\[Element]", "region"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{3.949576000435834*^9},
 CellLabel->
  "In[124]:=",ExpressionUUID->"7fc33ee8-3e79-4ecd-91f3-a325df861ef7"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "slwcon", 
   "\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"", 2, 124, 24, 
   24800117104881129101, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.955187115955633*^9, 3.955187671439239*^9, 
  3.9551878601983633`*^9},
 CellLabel->
  "During evaluation of \
In[124]:=",ExpressionUUID->"d0bcd6fd-ffb3-4463-bd5c-37ffa6068ba9"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "slwcon", 
   "\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"", 2, 124, 25, 
   24800117104881129101, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.955187115955633*^9, 3.955187671439239*^9, 
  3.9551878646953506`*^9},
 CellLabel->
  "During evaluation of \
In[124]:=",ExpressionUUID->"deef273b-dd63-462a-8594-d1507569eaff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.008949322523861`", ",", "1.0289421252696913`", ",", 
   "1.0962924888072945`", ",", "1.345528234413161`", ",", 
   "2.544963785507141`", ",", "14.490017489865828`", ",", 
   "722.6813932224396`", ",", "1.6278056200111948`*^6", ",", 
   "3.037470027779825`*^12", ",", "8.591368199169788`*^23", ",", 
   "3.929402676614861`*^44", ",", "4.248849365119726`*^81", ",", 
   "5.9997796553574984`*^147", ",", "5.05428057214556`*^265", ",", 
   "5.01709954855309665776686341742078`15.954589770191005*^475", ",", 
   "2.6638496666571637205576827801290465554454`15.954589770191005*^849", ",", 
   "2.018675408152660549101092156496`15.954589770191005*^1514", ",", 
   "8.6819897704282609751264904198001763637`15.954589770191005*^2696", ",", 
   "1.92048553720128012821863039631407749646892`15.954589770191005*^4800", 
   ",", "8.12875406165709090854060539931154790414339428`15.\
954589770191005*^8540", ",", 
   "1.2055299738340721937077833878598`15.954589770191005*^15193"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.949573409710225*^9, 3.9495760065743647`*^9, 3.9495775538395147`*^9, 
   3.949586574859223*^9, 3.949587085076582*^9, 3.949587435573515*^9, {
   3.949773285268272*^9, 3.949773307148337*^9}, 3.955186735414081*^9, 
   3.955187155879469*^9, 3.95518767880728*^9, 3.9551878673691893`*^9},
 CellLabel->
  "Out[124]=",ExpressionUUID->"cbddd351-3020-4f2e-b549-9668c5e67bb0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"numericDev", "=", 
  RowBox[{"numericVals", "/", 
   RowBox[{"(", 
    RowBox[{"constRatio", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"s1", "->", "tests1"}], ",", 
       RowBox[{"s2", "->", "tests2"}], ",", 
       RowBox[{"s3", "->", "tests3"}], ",", 
       RowBox[{"\[Lambda]", "->", "lambdaRange"}]}], "}"}]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.949568476379814*^9, 3.949568522624236*^9}, {
  3.9495686379126368`*^9, 3.9495686445591288`*^9}},
 CellLabel->
  "In[125]:=",ExpressionUUID->"10d7fc81-400d-47cc-9856-d73ed0f7a7f0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.3780615194495948`", ",", "0.6962788631578795`", ",", 
   "1.0837939474358125`", ",", "1.3329471664547512`", ",", 
   "1.292251697027568`", ",", "1.1447900024230655`", ",", 
   "1.0663112249599098`", ",", "1.0340416403785393`", ",", 
   "1.0183599842539957`", ",", "1.0101033136869941`", ",", 
   "1.0056153541443806`", ",", "1.003137483386334`", ",", 
   "1.001758015143199`", ",", "1.000986605412709`", ",", 
   "1.00055413108248656544205797128247700264`15.653559774527023", ",", 
   "1.00031144055150808420430251483251429132`15.653559774527023", ",", 
   "1.00017506265415943653603490324799236915`15.653559774527023", ",", 
   "1.0000984256230955884773645186788554358`15.653559774527023", ",", 
   "1.00005533795986030859029566755444320037`15.653559774527023", ",", 
   "1.00003109346240520036160595201497497823`15.653559774527023", ",", 
   "1.00001747730687685424079622349382148099`15.653559774527023"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.949568490768371*^9, 3.949568523150219*^9, 
  3.949568658305348*^9, 3.949569001812791*^9, 3.949571461354488*^9, 
  3.9495871465312767`*^9, 3.9495874555252867`*^9, 3.9497733962260523`*^9, 
  3.9551867385989923`*^9, 3.9551871669943333`*^9, 3.955187540205483*^9, 
  3.95518768848536*^9, 3.9551878714271727`*^9},
 CellLabel->
  "Out[125]=",ExpressionUUID->"ea7bf538-3260-4a3b-9330-353e0704f567"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expansionDev", "=", 
  RowBox[{
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"expansion", ",", 
      RowBox[{"{", 
       RowBox[{"\[Lambda]", ",", "\[Infinity]", ",", "5"}], "}"}]}], "]"}], 
    "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s1", "->", "tests1"}], ",", 
     RowBox[{"s2", "->", "tests2"}], ",", 
     RowBox[{"s3", "->", "tests3"}], ",", 
     RowBox[{"\[Lambda]", "->", "lambdaRange"}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.949568548408124*^9, 3.9495685574995537`*^9}, {
  3.9495686498716507`*^9, 3.949568654432457*^9}, {3.955187475194351*^9, 
  3.9551874893048067`*^9}, {3.955187527354056*^9, 3.955187533054607*^9}, {
  3.955187578047471*^9, 3.955187594879746*^9}, {3.955187649649472*^9, 
  3.955187649757638*^9}, {3.955187753639872*^9, 3.955187753974409*^9}, {
  3.9551879438142023`*^9, 3.955187988458199*^9}},
 CellLabel->
  "In[139]:=",ExpressionUUID->"7f1af074-8863-4c08-a8c5-ecd2175a9eb5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8.439153439153438`"}], ",", 
   RowBox[{"-", "1.4723004997570202`"}], ",", "0.4749578596706655`", ",", 
   "0.9727566319755726`", ",", "1.0684358465608466`", ",", 
   "1.064793110905615`", ",", "1.0447239183220878`", ",", 
   "1.0277654250925143`", ",", "1.0164396858465607`", ",", 
   "1.00950575433799`", ",", "1.0054279949645637`", ",", 
   "1.0030784742798011`", ",", "1.0017394021858466`", ",", 
   "1.0009807460779119`", ",", "1.0005523388495887`", ",", 
   "1.0003108637798372`", ",", "1.0001748940271857`", ",", 
   "1.000098376220444`", ",", "1.000055329261812`", ",", 
   "1.0000311165385365`", ",", "1.0000174989402772`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.9495685580445757`*^9, 3.9495686567995*^9, 3.949569005660556*^9, 
   3.949571466570572*^9, 3.949571562995706*^9, 3.9495871492953033`*^9, 
   3.9495874583571863`*^9, 3.949773411921645*^9, {3.94977711941687*^9, 
   3.949777147539864*^9}, 3.955186741822742*^9, 3.955186797452779*^9, {
   3.95518688828384*^9, 3.9551868974439383`*^9}, 3.95518708416436*^9, 
   3.955187173057446*^9, 3.9551874899452257`*^9, {3.955187533542708*^9, 
   3.95518754485294*^9}, {3.955187578678172*^9, 3.9551875963659143`*^9}, 
   3.955187650465685*^9, 3.955187692478324*^9, 3.955187754810515*^9, 
   3.9551878744310503`*^9, {3.9551879458587008`*^9, 3.9551879892533007`*^9}},
 CellLabel->
  "Out[139]=",ExpressionUUID->"7ba27a8d-9eb5-4fb6-9855-580064d8b5f5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"expansion", ",", 
     RowBox[{"{", 
      RowBox[{"\[Lambda]", ",", "\[Infinity]", ",", "1"}], "}"}]}], "]"}], 
   "]"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.955187563729518*^9, 3.955187582085935*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"5d50381f-9a28-4ef7-a187-59eddf30237f"],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["s1", "2"], "+", 
    SuperscriptBox["s2", "2"], "+", 
    RowBox[{"3", " ", "s2", " ", "s3"}], "+", 
    SuperscriptBox["s3", "2"], "+", 
    RowBox[{"3", " ", "s1", " ", 
     RowBox[{"(", 
      RowBox[{"s2", "+", "s3"}], ")"}]}]}], 
   RowBox[{"8", " ", 
    RowBox[{"(", 
     RowBox[{"s1", "+", "s2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"s1", "+", "s3"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"s2", "+", "s3"}], ")"}], " ", "\[Lambda]"}]]}]], "Output",
 CellChangeTimes->{{3.955187554534384*^9, 3.9551875827637672`*^9}},
 CellLabel->"Out[94]=",ExpressionUUID->"3aebd244-9110-4287-aa9b-377daa05c3e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Log10", "[", "lambdaRange", "]"}], ",", "numericDev"}], 
       "}"}], "//", "Transpose"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"expansion", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"s1", "->", "tests1"}], ",", 
        RowBox[{"s2", "->", "tests2"}], ",", 
        RowBox[{"s3", "->", "tests3"}], ",", 
        RowBox[{"\[Lambda]", "->", 
         SuperscriptBox["10", "x"]}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
     RowBox[{"PlotStyle", "->", "Orange"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p1", ",", "p2", ",", 
   RowBox[{"PlotRange", "->", "All"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.949777215523541*^9, 3.9497773632191057`*^9}, {
   3.949777421787121*^9, 3.949777444604933*^9}, {3.949777494330185*^9, 
   3.9497774945904903`*^9}, 3.955186949135757*^9, {3.9551869992234383`*^9, 
   3.955187007252033*^9}, {3.955187180660529*^9, 3.955187183564733*^9}},
 CellLabel->
  "In[128]:=",ExpressionUUID->"4bf96461-8fbc-4c73-8277-4936b57cb23f"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
         0.012833333333333334`], AbsoluteThickness[2], 
         PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf9lfHV33UMLphD+G/2H9U3HXOK/dnUP6D/Vfy
aoMswj9C+Rf2KzQWZxwI/moPM8HtY5+swNovMHl7ZrngIP7ATzD99re/v4ie
ww/T/8I+jsfJPr/7A5T/wf76hX3XjL1h/C/2m+7NFU/ShPF/2FvVqikwiMP4
f+yXTz7x+CYPjM/gwL9nRqYxO4zP5HBuy/12LhYYn8VBkiOPx5UJxmdzeLF7
/UQ3RhifwyH9L+vE7QwwPpcDZ+Bbk3Q4n8dBb+lqNis4n88hrXzaLAU4X8BB
Kak9WAjIBwCKzl5A
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      StyleBox[
       DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
         Slot["HighlightElements"], 
         Slot["LayoutOptions"], 
         Slot["Meta"], 
         Charting`HighlightActionFunction["DynamicHighlight", {{
            Annotation[{
              Directive[
               PointSize[0.012833333333333334`], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2]], 
              Point[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf9lfHV33UMLphD+G/2H9U3HXOK/dnUP6D/Vfy
aoMswj9C+Rf2KzQWZxwI/moPM8HtY5+swNovMHl7ZrngIP7ATzD99re/v4ie
ww/T/8I+jsfJPr/7A5T/wf76hX3XjL1h/C/2m+7NFU/ShPF/2FvVqikwiMP4
f+yXTz7x+CYPjM/gwL9nRqYxO4zP5HBuy/12LhYYn8VBkiOPx5UJxmdzeLF7
/UQ3RhifwyH9L+vE7QwwPpcDZ+Bbk3Q4n8dBb+lqNis4n88hrXzaLAU4X8BB
Kak9WAjIBwCKzl5A
               "]]}, "Charting`Private`Tag#1"]}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, 
             "PlotRange" -> {{-1., 4.}, {0.8557728449526506, 
              1.2094382283959233`}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0.8557728449526506}, 
             "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
             "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
             "DefaultStyle" -> {
               Directive[
                PointSize[0.012833333333333334`], 
                RGBColor[0.368417, 0.506779, 0.709798], 
                AbsoluteThickness[2]]}, 
             "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                 Identity[
                  Part[#, 1]], 
                 Identity[
                  Part[#, 2]]}& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{-1., 4.}, {0.8557728449526506, 
             1.2094382283959233`}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0.8557728449526506}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>],
        ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
         4.503599627370496*^15, -4.503599627370496*^15}}],
       Selectable->False]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf9lfHV33UMLphD+G/2H9U3HXOK/dnUP6D/Vfy
aoMswj9C+Rf2KzQWZxwI/moPM8HtY5+swNovMHl7ZrngIP7ATzD99re/v4ie
ww/T/8I+jsfJPr/7A5T/wf76hX3XjL1h/C/2m+7NFU/ShPF/2FvVqikwiMP4
f+yXTz7x+CYPjM/gwL9nRqYxO4zP5HBuy/12LhYYn8VBkiOPx5UJxmdzeLF7
/UQ3RhifwyH9L+vE7QwwPpcDZ+Bbk3Q4n8dBb+lqNis4n88hrXzaLAU4X8BB
Kak9WAjIBwCKzl5A
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PanelPlotLayout" -> <||>, 
         "PlotRange" -> {{-1., 4.}, {0.8557728449526506, 
          1.2094382283959233`}}, "Frame" -> {{False, False}, {False, False}}, 
         "AxesOrigin" -> {0, 0.8557728449526506}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[1, 0.5, 0], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwV13c8Vl8cB3B780RJQmaKpIiy6nsaKBkllCi7KGlLforMjMgeicpIQpK9
LhKRla2ojMxwHyMj43eev57X+3Vf55x7nvs93/u54tbXDe0Y6OjoYujp6Gi/
dx/Fs3aJfSUGpva7pzyfAiWj8ndHiluI/c0/pNKapmCoPdnwcmIL8aC8Km7g
2xSEGwfOB3q3EPXdziX/hqdgxuSceod+C3Go/Nn2L2tTYPlh6ElzTTNhLOEU
OSw3DabluqWCgk0EZwdduZ7XNBQSggw2g40E/WCzdcSTadhSOaydkdlIaDGe
3FAePQ2dHz3aDh1pJIJ+HPUveTsNhnW54zZXGwgm+gKqXes06LQLC2aV1ROj
x/1vnOUm4U3H2MUFv3pi+d+pkpe8JLB15Scjw3rCXPjznZ/8JNT0nNrbNlxH
fJ74nKK8jYQjP721Fyl1RMPbA7yn5ElQG/9z94h1LZFrxt1jpEuC7/Wh4R17
a4mf1CrRVAMSWue+n+VeqyG0Q8omJg1JuLJer9odW0NECuTZWpmSELfpzeq1
r5+ISaoDxzc7EpYP2fnEomri+JZhSckHJGhVm/99yFNNOBy2nvntTkLYCaPL
tr0fiaDYB/dfeJIga3T0xB6Xj4SkpOnSih8J5x3EuT+9qyKqBu2yjMNIKA7v
iyC3VRJZFodnI1JIYBHsYO78U0EE3X1y7ftrEgwTGpxLiisIL37B7K3pJIyn
lZzzNakg8mxMG72ySFBy26eqIkwQ3r/DRRgKSJhreXs8ZLmE6GZJMi2tISHo
e5zs+agSwipq0jfqMwlSw/5c2xVLiKyX1o5X6kkw+ne5pdihmGBOqY9ebyQh
d7vUueHuQuI9//2ZX+0k3HaNv3ywII8IyW+8FthPwksZmwMROnmE5YVTx3YM
ktDcLcM60ZdLKHv75pQOkbDrQEFqDFMuwcG4HNE+QsLg7Nffs6dzCDsZLsni
SRJ4k2LydH6/J1IPyTlITZMAhhY+L13eE6Wz1ysfkyQ8y/4jZZCYTViPyAzC
LAkp33g+G/VkEjejxt0dFkmgU42/zECXSaRxB/9JWSLBPFqGNVs6gyB25vT1
LpOwyeiYFueddIL8YOWttkqCd+P96kqe10QVi/iFfHoq2FYMVcgfe0FcFeN8
W8JOBY+DQxWFHQkERVcuLJWDCirLa+sbJZ8T/ecMGoI4qZB2W+lhfVksUcF2
x+EkNxX8LiW6HpgNI8SErz8N20AFkCwuCkOhxFXmMFNTXipMEW+o34VCCJXU
2lYhPio05myaOn76MdGvyccQsZEKWxQ6GjVd7hL38sz9DDdTYVrbI8LO7BoR
FrXCtIhtbpax1T3IgpAU8vOPFcDrc6/QC342gQhg/tqyhQp/nznskHHygCPo
iAuvEBV8JZTe3GrzAiHqPd0Y7M1v1mRLVfxAnTveRUiYCgfyw+UNGINhXSFw
fbMIFTRGf8SpNUSCj5xR2+A2Kghz3WBYs4oGtS4GF21RKqzuob9SuRADC9bK
8mnY5fckVY9LxoNtZNofSzEqJDzLfcFZ9Bx+sXszFmG7E5pszfqJsLBf8ASP
OBVeMOZOyB58CfzV627Z2E8j3RK52F6Btc3t+6vYHjs0z0y1voINd35XaEtQ
wepkZ/F7+2Qgei/rtmNLhC/6q0S8hk8PlDY1SVKBb3vlwa0WadBgd3oHixQV
GAr8qf9k3gB/CZSoYw9+22pKEOlwPemGeyJ2u+Mg18uAt2C671FpI3b12tsK
T+MMcLJYD1/CTpY4uFNrIhP69urt0tlOhYhc5t4d+VnQoeCx4ITtrdUUwv7o
HXQXjTiHYqs5fnk5vz0b2mYj3r3HVsx799+lwGy4cCDodTO27Fq4cReZDcPi
n2wnsCW0XfYcN3kPme9kJ5mkqbD1qTl7Ucl7CDR6piWMvbEHDcqI58DTTWPO
CthcEtvL4nxz4Gp8j9cxbKar7NGcf3IgzVT6tjH2yofJG26nP0BdmJuOLfbc
yledyfwPsMn9AeUm9h/NfKmLwrlgdrG89j/soeC4taZHuXDn6WcXb+zerofd
MJILcRmCOwOx28VscrJ18yA2RvJ7CHaDg3aQeE4e1CTqRodhV+fsuhQmkA+D
/tNW4dil/yiI8UE+fHxvhmjXc4/NCd4ZyIcioY4DtPEZT7pnh7QLgDEoQi8A
O7mztNE4swAG4mt9vbDjRV++ruErhOftT0ddsSPtfR4dcCkEkxJWlxvYwe8d
zNL6CiGHVFGj7c93WU9Z8GgRmB2WVjLBfnhUkRKQVgS4mV3RwnYO2jy2zF0M
Rz+zDCphO3UsV129XQwHVT6/FMe+tO1nfG93MQxYDrzlwjbJfn2qPKkEhhR0
8vrw89FfCpTdw14Kp6r5yj9iax25wfTCqRTkuGS3p2Hvb1cpfKRaBlbz9WKO
2PIiImEzCWWQXfKw/CS29CV6RxumcmhO62iQwRZYrBPVbC6HMh5jvX5cX3+Z
vIQKFAnw3sMWXILdyashIBNFQMjtnxYR2F/4z/r5yldAPotO7WHsgD11D6/M
V8CwsSl/EK735bwUN8kdlfDGNM/ADPuKhqdr77lKCD72V00G+8QJdWf90krw
GLq8rxKfFzabzGuKXlXQwcnJP4DPl8uY/9WJ3CpIlauD19ij1y85JA9XgSeH
iOpV7Fo3UbvNOh/BK+BzyjQ+v75RoebLG6oh/blR3Tg+70z1d09WJXwC379L
Cpm4X9w5ZXjiv5ZPcJhiOmCJPdQpr63EUANaEv+iNmJ/HBw5kmpXA+93uAo6
437juWqqFiBXCwzNLD17cD+iUzgkY1j8GfJFWnpccP9ajWZhHej4AgGRsWfu
4P4oobvA3cHZAJMK5VbM2Fp0o5s+H24A2fyvWZG4nz61r5PIymyAbI163lzc
b6VUgw65+jTCoSF/vVEeKuh843XmU26GhIsHBBVwvz4ZHHxLXOcr0Nfm+Jow
UiG6Jbb/9Jt2OKP9dfLGDAmhXRbnd899g93e24IPfyUhqr5jWWrwFzzk9f1h
jd+nCZ/Fz2poDAGlurfRPYSELr9PdKFmI7Be+3Lc0RnnC4n3HcIOI/BRX+MM
G3ZGaXx6mvMIdNVo0SffJcGDetuoInQE9gm77u69Q8JOM4m06doRmHg9UW1w
mwRXeXcDfaVRuJV6fvDoDRKEO1QSOLnHwMJDwd7iCgmWEhnqvuXjMBsmOX/R
Ar9fhRqZd30Zhx+rzMUbsA/xTzU3d43Dp/Dy/KqLeDzbXltB6jiMEsZnd2B3
TX4IypCcgFO6wYqz5iToF5X0tT7G1rTUiDxPwsFTX9xFz/yB8lG1GXoTErY+
HP9YODIJSoGWJ130SPjreWqD4/wk3EoXaVfAbvXLNxdlnIJz2T+iJnB+Cgj1
nPfZNgXJfP11Ftj/krfuOGM8BeLJ/AM6J0no/aITMFk1BdE3o0t3nSAhUfDt
KYmEaaBUREkKaOJ89C1vShPnmGPfAtaDDuL9yLC8Xs8mgX/kyaoR9sQ9E4si
nGOO+jDsEsE+xr/QLPeJBJeo0o1ZGvj+DFTeb/yFc6D3ty2t6jhPfSq+3c9P
BVEfjg4JNRIks4lFt0dUSO+zUxjej/OMTx1D7rkZ8FUscJvci/OIV67y8sUZ
sGw9Z/ERm88z0R7ZzQDnvLltLPaNh3ebGm7OwOMI2Q5N7F33xON+B8xA5nF5
gxd7SHhlf19BoGwGrm0ODzHD+TL0pIylq/gsPDo0FTu+iwQnXv8yND4LL99s
KLHbgfNVZJQCD3UWOjl4niFsVcHklO8LsxDlkhIvhM0kTjxxZp6D1I1KTK3S
OG/unb+QITYHs7LNVgi7xsBqTeDsHGw5ugskt5MgGqwK0x/nIPeXXS2dJAkt
HOMVz5/PQx5dmyO/KAkqh8LeLSTNw8ixYz1LOA+/uKmWcDp9Hjh6b1z4gX2j
O+A/5oJ5eNz3LuM19obUXfuvtcwD51iOrTq2weFrbzUY/0LcSVvZyyIkNN0j
I7/b/4WzO8oDm4VI+DL094qg0gKo7dpQ93MLCbdsS6+eUVuAJbsk5nrsLUOP
HJ+gBfhd0GyUi207yOVEr7cAR84WyPpjr/VL3ByzWwCJjm0f9mEr/tS/VxS9
AE/ASCZIgISYnlQv038LcG0kQ1NnMx7fZBIfW7UIo6POiosbSahsO/TjfN0i
sO2O3fkbe1uPtJhwyyLwyjzZ24rdPfg3KaFvEcIPpt/NwNZdinqbtLgIqbb/
Wq2wlaS6ijPll2BnjEpDMx/+/13P9lTGLUHu/Vy9Qvx9kbz93ObxW8uwR4nx
fCEF58dv31oP3F8GfiZNg3Rsm5ALIT7uy3DEdehUPLbEkjWbeNAynBPlu++B
ndhwbflsyjI0BDKYn8COu+3141PXMhTAdps+HhKeVmalvtT4BwKsgXt4sB9c
YD5gyrICg4ZpSU+5cH6NSVeS516BHb2qN72x01sNFBk3rcDXNx46Ltid2nG7
M8VXoEyRQcwSW15xjxT9wRXQXU8y3ov9g8WU983tFWjSXe5v5cTnKztjYvHX
Chj8fqEsht0+fnqscWQFjosY2PFjX9m+MPxqagVM3tolcmBHxR0e0F1ZgZ7Q
ZMV5DhKmvDu7XwisQtD0ufZ67ARTuprj+qvQV79v5R72OoPRi5iSVXDVUYzv
Ycfz+2/O1qtahcGjmvtasNM29BAMdatw8d3hthrsU9su/nTsXAW2ko7dudiv
VO23Haauwplz3roh2Fo33OLHpNfgyfH+ndrYwX3JMWphazDyDKTL2PDzLpx/
2mu/DrLvzodUsJJwd8pQaNv1dRASeZpUhN0glZ1icXcdqstGy3Kw74deKR54
tA7mklNMKdjtV34Ojsatg8yZ3O/+2IEidfvnG9Zhd3L4ayNst8P6U75b6FBy
dnbEFAv+3koVj0h0o0PrMqM5ithU7/4lRg86tGlDV7Yc9qL1Swt7Lzp0dOpp
rjQ2s6j4LoUAOjT60KBxK7ZYtFhVVTQd+ux98SgjtomfKPk7hw5J2rEf7GAm
oeqyiK7cGB1q1q88/AA7dqcgU5ExPZK/1Hi/lwm/Dy5Kvx48R49O+B7j68be
GbFPh8ecHsUv52a1YReu6z21saZHXum3Z+uxuzs9hXmu06NPFswZRdhbfP4o
2TymR410Tp3R2NH9hB13CZ4/LXTRBDsy7lKtlRgD0gkMLfvJiPfv7HnbTZIB
6TqSJ3uxbQ0TRKOlGVDBHfO+bmxFjs57DXIMSBqdZm/FbrqvufOAKgPKE7fx
qcZmM5Xy5zJkQN3Pv3GmY7sKDOgUeDGgX3sl0T1si4gLTVwjDKhJ3b9MEFvi
A4fQ1XEGdMXyP2Iz9tDXgst1k3j8iH71Rmx7Ch+97xyeXzCkkxv7VkDNvnV6
RkS9s0OEAdvXY08sVZgRXes02zvBQEKWI71tpyEjkiDumhPYq8dSlhLLGZF9
xSV0HdujJNGrupIRMRfW81zDZlKM4x6rZkQfcnf8vILNJRoirviFEfVkfvK5
hL11yeVEdRcjGgqwHL+ArZKpGztKMiJhy2CKHvYt/jkVBUkm9P7Oapkc9ujv
Iy5VfkwoIMb7NJWeBO3EpleygUxol1jU1Wns1HPnG8OCmdDFrEd+k9i2X25K
2EQyoZcZP6vHsH9lv2hgTGJCG5R9jAewu/9bE9MsZ0L39v9paMP+zFtcVzvH
hHI69rAVYr8+qCDUaMWMApyXjX1o1/U5vP7ZMqMQlYgZL+xRi8FxGXtmVPzv
5lNP7J2ekcW+TsyI8c9cszt2Ws2SKfqPGd1xW7zgip1uUBXzIYIZaS0v5V7H
zrA6szmulhkVcqhom2Hn+NzlvbybBf1QN65Sxp7RuODps5cFva5gy1TCVpg7
Npu0jwWxHsmN2Yedbb2p45cqC+Krmb6lgJ0JH2LOa7GgZ02/FHfT1l8iRfUt
WJCcyuRPKezEa47yyqEsaBtlbHQTdpCxzUnGeRaUWBocsECH92vQa263yILm
r8nF/cWuOmHsVPuPBWVf+JA+j71wUDs0kIEVWdy83zSLbS29q2vjBlaUPNoo
RmKrLMxYS+1iReHNndOj2IMxnq6aVqyIW89f4Tu2Wu/LN36NrGhtnE2gCnuz
vP3iuxZWpN7Md7kSe8ZdXru7jRXxiZUWVGCnS5YM7fzGithrx88T2IJX20Xr
h1nRiGdaWin24hJLFBcdG9IQkbUqwC4QcPQMVWRDdLOeRzKxwxwUvxYps6E2
X8eUDGynkkXRARU29ObWEBvN0hY+ZYrAhtwMHnxNx45KTVhsO8mGuiQ0HdKw
nZW/Om22Y0PXvpbnJGErndlv9iyaDQ2dXXsThz0x8kSH9Rkb2s7OxUfzK7ff
qrcT8PjJLNdYbN7UiC0nU9hQJluOXgz21OJMx3IOGzJNeb4ciZ2W8O7U+SY2
lGz45HoottD4Ti1BZnYk8x991WPs1oceyj5s7KgoKlmd5oCN3VJUTnaUkPIl
z4+2fw0/xjo+diQQk/TWF7s95HeFixg7av3k+NwbO1j5lXq3Oju6EDwf44HN
8EhIIfoWOwqX8P7jgt1d8khm9i47Enfpu0fzu78j4gb32VHhideMNJs75vKx
erCjwXcBwvew88/qzTk/YUeba73P3MV2kHcvMEljR/QOYx03sVu+Dxzc/IMd
ndRNkrmKnbg/XSfyBAcSOxOwcBF7f90FjwJdDqRnt+EVzU1mvPk9BhzI2XJQ
l+Y1DxfxbSYcyHTVKekCbf0vWoup1hxI5hS/kTn2VsvBlML/ONDfLTYfTbEj
/IXpezM50DEX5W4j7Me9wQUSfJxo9T1j40nsf+/bnjzm50Rp8pxeNDv5bbGd
2sKJKJ3nVWk2Uny1oViUE7UFfk3VwRZ7nOdwejcnSqZu8jlBq6d9vUIexzlR
v3OBvjb2cICMR99DTiR0I3rTUWxN1erjMROcqLuUaq6O7XrJxLx6ihPZL/RI
05wVPnqdpHKiofuzpBqt3qe4oo8vcqKjSUU+NA+/Mv69yMSFVtKevFel3T/X
yCPTbVwomCLPp4Jd/5O9ZOtpLlTbLvVXCVvf12D383wuNHeQA+2h1ZspeaKo
iAtdnmvjp3leLvRSRykXumrxcUIeO76tNZH7I56vgS+G5jExE76HzVxo1uzG
zG5s7xLzhYujXMjqLnuWHHYx6VAptpUbTee1giztfJh5Gyc/4EaPE/lrt2Mb
38znY3rEjVaGXF7R7O032mzjzY1+J68/oLn/g66OZCA3yue4p0xzPBc/vIrh
RtK57KlStPNQnrLzxQdu1CXw8okk9opY7b9nY9yI0ePDXXFavQ+zvwo35kHa
yymvRGj9x8g/vugcD0pk7PajOaeKLfqnGQ/6riNxjeawBNagXdY8yEl9/QDN
p02YnT868SDKse4mYVo9fqLTmfXjQeJyc3Q0NyUvUA2LeZA7+2HnrdjlfPf+
uJTxoLjG0xdpzvL4O5xQwYMOHXDRojnYfP77eA0P6s9gFqBZb9PsJ882HjRM
L14kiN3gNRWb84cHHQg+Tk9zvfXvw3yiFKQTgGMddh/T68VICQpyM1l7TDOZ
av9OUJqCDPZr3KSZf2JCWHw3BZU0rx+m2fL2zMIedQrSr00a2kzrt17rmXpn
KSiUWUeeZqkUwa3+IRR067ZT6ybsA9rfW7jCKYh0dCijWWcs3u9pFAXJJNxP
o/n6brH56OcUpGzY85Dm4jzpltS3eHxWuBzNp2r2+VbXUlDheH/gRmwb+3mN
418oOE9Ju9DszFEw+6WJgvrZ3W1pfqavZtXWQUHfva8epHm4E2kMDFIQ04a9
JB/2kgvDrN0IBY208fbRzCVU/WZsHK8/xFJPs6KFtgCVSkH742WTadakZ2+6
M09Be0VMQ2k+l1TvvbhIQWLP4x7SfEUzSN1thYK+sU1fpfnBiN7M+joFHdUz
MaX5f+3hKA8=
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     StyleBox[
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0.5, 0]], 
              Line[CompressedData["
1:eJwV13c8Vl8cB3B780RJQmaKpIiy6nsaKBkllCi7KGlLforMjMgeicpIQpK9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               "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{-1, 4}, {0.9567439541492286, 
              1.0719178987134164`}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0.9567439541492307}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0.5, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{-1, 4}, {0.9567439541492286, 
             1.0719178987134164`}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0.9567439541492307}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[1, 0.5, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}],
      Selectable->False]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[1, 0.5, 0]], 
          Line[CompressedData["
1:eJwV13c8Vl8cB3B780RJQmaKpIiy6nsaKBkllCi7KGlLforMjMgeicpIQpK9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           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PanelPlotLayout" -> <||>, 
        "PlotRange" -> {{-1, 4}, {0.9567439541492286, 1.0719178987134164`}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {0, 0.9567439541492307}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[1, 0.5, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.8557728449526506},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentPoint", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.949777304623678*^9, 3.949777327891892*^9}, {
   3.949777364904389*^9, 3.949777446488308*^9}, {3.9497774789008093`*^9, 
   3.949777495070642*^9}, 3.9551867504145947`*^9, 3.9551868006384497`*^9, 
   3.955186899728777*^9, 3.9551869502003527`*^9, 3.955187007958353*^9, 
   3.955187086627054*^9, {3.955187175068982*^9, 3.955187184356827*^9}, {
   3.955187536316428*^9, 3.955187546574353*^9}, {3.955187586520958*^9, 
   3.955187598703106*^9}, 3.955187702117742*^9, 3.9551878805880527`*^9},
 CellLabel->
  "Out[130]=",ExpressionUUID->"0dae9a66-f8c0-41ba-94b9-dfb91a8a6928"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Log10", "[", "lambdaRange", "]"}], ",", "numericDev"}], 
       "}"}], "//", "Transpose"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Log10", "[", "lambdaRange", "]"}], ",", "expansionDev"}], 
       "}"}], "//", "Transpose"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.949568626833379*^9, 3.949568629037711*^9}, {
  3.9495687092865543`*^9, 3.949568748277824*^9}, {3.949568803068736*^9, 
  3.9495688076613617`*^9}, {3.949568865036487*^9, 3.949568924452201*^9}, {
  3.955187775591372*^9, 3.955187778157524*^9}, {3.955187827768182*^9, 
  3.955187829995755*^9}},
 CellLabel->
  "In[140]:=",ExpressionUUID->"f9606913-cbd0-4d6b-888a-021cf65f8f09"],

Cell[BoxData[
 GraphicsBox[{{}, 
   InterpretationBox[{
     TagBox[{
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
         0.012833333333333334`], AbsoluteThickness[2], 
         PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf9lfHV33UMLphD+G/2H9U3HXOK/dnUP6D/Vfy
aoMswj9C+Rf2KzQWZxwI/moPM8HtY5+swNovMHl7ZrngIP7ATzD99re/v4ie
ww/T/8I+jsfJPr/7A5T/wf76hX3XjL1h/C/2m+7NFU/ShPF/2FvVqikwiMP4
f+yXTz7x+CYPjM/gwL9nRqYxO4zP5HBuy/12LhYYn8VBkiOPx5UJxmdzeLF7
/UQ3RhifwyH9L+vE7QwwPpcDZ+Bbk3Q4n8dBb+lqNis4n88hrXzaLAU4X8BB
Kak9WAjIBwCKzl5A
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ], 
       TagBox[
        {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
         0.012833333333333334`], AbsoluteThickness[2], 
         PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf9vPqme248UDhAIT/Yr96CeuPrr7v+yH8B/uf
3Z+wbGvqPXsI/8L+/tWaLZcU3tvDTGhdulY/QOIjTN6ev8O1IYUTxn9gn782
I9dg+wco/4X9+a3dGrsKYfwP9sUiE53CnGH8L/b5Yg2N79Vg/B/2hzb4rrIW
g/H/2JstX8o8hwfGZ3Co4rZ4Ks8O4zM5fPVgTWZhgfFZHNp2hmg7M8H4bA5x
nne+uTLC+BwO/hyHkrczwPhcDmkpq9TT4Xweh/rXoSxWcD6fwz+7EwsU4HwB
hw8sYZFCQD4A2XRfQQ==
          "]]},
        Annotation[#, "Charting`Private`Tag#2"]& ]},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
     StyleBox[
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf9lfHV33UMLphD+G/2H9U3HXOK/dnUP6D/Vfy
aoMswj9C+Rf2KzQWZxwI/moPM8HtY5+swNovMHl7ZrngIP7ATzD99re/v4ie
ww/T/8I+jsfJPr/7A5T/wf76hX3XjL1h/C/2m+7NFU/ShPF/2FvVqikwiMP4
f+yXTz7x+CYPjM/gwL9nRqYxO4zP5HBuy/12LhYYn8VBkiOPx5UJxmdzeLF7
/UQ3RhifwyH9L+vE7QwwPpcDZ+Bbk3Q4n8dBb+lqNis4n88hrXzaLAU4X8BB
Kak9WAjIBwCKzl5A
              "]]}, "Charting`Private`Tag#1"], 
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              RGBColor[0.880722, 0.611041, 0.142051], 
              AbsoluteThickness[2]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf9vPqme248UDhAIT/Yr96CeuPrr7v+yH8B/uf
3Z+wbGvqPXsI/8L+/tWaLZcU3tvDTGhdulY/QOIjTN6ev8O1IYUTxn9gn782
I9dg+wco/4X9+a3dGrsKYfwP9sUiE53CnGH8L/b5Yg2N79Vg/B/2hzb4rrIW
g/H/2JstX8o8hwfGZ3Co4rZ4Ks8O4zM5fPVgTWZhgfFZHNp2hmg7M8H4bA5x
nne+uTLC+BwO/hyHkrczwPhcDmkpq9TT4Xweh/rXoSxWcD6fwz+7EwsU4HwB
hw8sYZFCQD4A2XRfQQ==
              "]]}, "Charting`Private`Tag#2"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{-1., 4.}, {-8.439153439153438, 
             1.3329471664547512`}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[2]], 
              Directive[
               PointSize[0.012833333333333334`], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{-1., 4.}, {-8.439153439153438, 
            1.3329471664547512`}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              RGBColor[0.880722, 0.611041, 0.142051], 
              AbsoluteThickness[2]], 
             Directive[
              PointSize[0.012833333333333334`], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}],
      Selectable->False]},
    Annotation[{{
       Annotation[{
         Directive[
          PointSize[0.012833333333333334`], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Point[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf9lfHV33UMLphD+G/2H9U3HXOK/dnUP6D/Vfy
aoMswj9C+Rf2KzQWZxwI/moPM8HtY5+swNovMHl7ZrngIP7ATzD99re/v4ie
ww/T/8I+jsfJPr/7A5T/wf76hX3XjL1h/C/2m+7NFU/ShPF/2FvVqikwiMP4
f+yXTz7x+CYPjM/gwL9nRqYxO4zP5HBuy/12LhYYn8VBkiOPx5UJxmdzeLF7
/UQ3RhifwyH9L+vE7QwwPpcDZ+Bbk3Q4n8dBb+lqNis4n88hrXzaLAU4X8BB
Kak9WAjIBwCKzl5A
          "]]}, "Charting`Private`Tag#1"], 
       Annotation[{
         Directive[
          PointSize[0.012833333333333334`], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[2]], 
         Point[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf9vPqme248UDhAIT/Yr96CeuPrr7v+yH8B/uf
3Z+wbGvqPXsI/8L+/tWaLZcU3tvDTGhdulY/QOIjTN6ev8O1IYUTxn9gn782
I9dg+wco/4X9+a3dGrsKYfwP9sUiE53CnGH8L/b5Yg2N79Vg/B/2hzb4rrIW
g/H/2JstX8o8hwfGZ3Co4rZ4Ks8O4zM5fPVgTWZhgfFZHNp2hmg7M8H4bA5x
nne+uTLC+BwO/hyHkrczwPhcDmkpq9TT4Xweh/rXoSxWcD6fwz+7EwsU4HwB
hw8sYZFCQD4A2XRfQQ==
          "]]}, "Charting`Private`Tag#2"]}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
      "LayoutOptions" -> <|
       "PanelPlotLayout" -> <||>, 
        "PlotRange" -> {{-1., 4.}, {-8.439153439153438, 1.3329471664547512`}},
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           PointSize[0.012833333333333334`], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[2]], 
          Directive[
           PointSize[0.012833333333333334`], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        ListPlot, "GroupHighlight" -> False|>|>, 
     "DynamicHighlight"]], {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentPoint", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-1., 4.}, {-8.439153439153438, 1.3329471664547512`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.949568743038115*^9, 3.949568748860416*^9}, 
   3.949568808554163*^9, 3.949569009830348*^9, 3.9495714687032127`*^9, 
   3.949571565272131*^9, {3.9495871238631496`*^9, 3.949587151695096*^9}, 
   3.94958746190786*^9, 3.955186847257242*^9, 3.955187027714118*^9, 
   3.955187201530902*^9, 3.9551876177006207`*^9, 3.955187654646678*^9, 
   3.955187704971054*^9, {3.955187759060812*^9, 3.955187778823264*^9}, 
   3.955187831361752*^9, 3.955187877798519*^9, {3.9551879511845827`*^9, 
   3.955187991652377*^9}},
 CellLabel->
  "Out[140]=",ExpressionUUID->"0b034583-4627-4f90-b638-6740728a761b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"numericRUnnormed", "=", 
  RowBox[{"Transpose", "[", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Diagonal", "[", 
         RowBox[{"RotFromVec", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x", "*", "t"}], ",", 
            RowBox[{"y", "*", "t"}], ",", 
            RowBox[{"z", "*", "t"}]}], "}"}], "]"}], "]"}], "*", 
        RowBox[{"HaarMeasureVec", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x", "*", "t"}], ",", 
           RowBox[{"y", "*", "t"}], ",", 
           RowBox[{"z", "*", "t"}]}], "}"}], "]"}], "*", 
        RowBox[{"Exp", "[", "arg", "]"}]}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"t", "->", "1"}], ",", 
        RowBox[{"s1", "->", "tests1"}], ",", 
        RowBox[{"s2", "->", "tests2"}], ",", 
        RowBox[{"s3", "->", "tests3"}], ",", 
        RowBox[{"\[Lambda]", "->", "lambdaRange"}]}], "}"}]}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], "\[Element]", "region"}]}], 
    "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9495851685964193`*^9, 3.9495851748179293`*^9}, {
   3.949585272711298*^9, 3.9495852856240873`*^9}, 3.949585595449401*^9, {
   3.949585761166706*^9, 3.949585763322597*^9}, {3.9495858306682997`*^9, 
   3.9495858320380497`*^9}, {3.949585894963592*^9, 3.949585902776441*^9}, {
   3.949585953144472*^9, 3.9495859532916813`*^9}, {3.9495860994769993`*^9, 
   3.9495861400967607`*^9}, {3.9495862389694643`*^9, 3.949586243496478*^9}},
 CellLabel->
  "In[157]:=",ExpressionUUID->"2b2ca814-b3b4-4b89-b49e-254d0449f09d"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "slwcon", 
   "\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"", 2, 157, 30, 
   24800117104881129101, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9495857658197107`*^9, 3.949585835176077*^9, 
  3.949585907942449*^9, 3.949585967596553*^9, 3.9495861099043617`*^9, 
  3.949586154272079*^9, 3.949586249122081*^9, 3.9495866281833963`*^9, 
  3.949587166976366*^9, 3.949587470827861*^9, 3.955188033427883*^9, 
  3.955188181134721*^9},
 CellLabel->
  "During evaluation of \
In[157]:=",ExpressionUUID->"101e08fb-b1d4-45d0-9810-19ac71e702db"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "slwcon", 
   "\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"", 2, 157, 31, 
   24800117104881129101, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9495857658197107`*^9, 3.949585835176077*^9, 
  3.949585907942449*^9, 3.949585967596553*^9, 3.9495861099043617`*^9, 
  3.949586154272079*^9, 3.949586249122081*^9, 3.9495866281833963`*^9, 
  3.949587166976366*^9, 3.949587470827861*^9, 3.955188033427883*^9, 
  3.955188181679541*^9},
 CellLabel->
  "During evaluation of \
In[157]:=",ExpressionUUID->"613c8ec5-84cb-4c78-b46b-0c79dad02e07"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "slwcon", 
   "\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"", 2, 157, 32, 
   24800117104881129101, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9495857658197107`*^9, 3.949585835176077*^9, 
  3.949585907942449*^9, 3.949585967596553*^9, 3.9495861099043617`*^9, 
  3.949586154272079*^9, 3.949586249122081*^9, 3.9495866281833963`*^9, 
  3.949587166976366*^9, 3.949587470827861*^9, 3.955188033427883*^9, 
  3.9551881828863993`*^9},
 CellLabel->
  "During evaluation of \
In[157]:=",ExpressionUUID->"659a24e3-4586-4ae8-8bb3-7b7f59cd8a27"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"slwcon\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 157, 33, 24800117104881129101, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9495857658197107`*^9, 3.949585835176077*^9, 
  3.949585907942449*^9, 3.949585967596553*^9, 3.9495861099043617`*^9, 
  3.949586154272079*^9, 3.949586249122081*^9, 3.9495866281833963`*^9, 
  3.949587166976366*^9, 3.949587470827861*^9, 3.955188033427883*^9, 
  3.9551881828906193`*^9},
 CellLabel->
  "During evaluation of \
In[157]:=",ExpressionUUID->"e041c7dd-31b8-487e-b830-6ff05c8ca8b0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.06625685577934684`", ",", "0.03197229443538689`", ",", 
     RowBox[{"-", "0.013485682790961254`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.11826457097296095`", ",", "0.05568356505685221`", ",", 
     RowBox[{"-", "0.01987759446739463`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.21545335808784213`", ",", "0.0978582756275703`", ",", 
     RowBox[{"-", "0.023043699002163867`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.42082822999369623`", ",", "0.18417763542431`", ",", 
     RowBox[{"-", "0.0023264444370829436`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.0128339022917325`", ",", "0.449201426241129`", ",", 
     "0.15237768111301447`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4.22967664189818`", ",", "2.1919749138150446`", ",", 
     "1.5377613766065716`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "63.123871247376506`", ",", "42.9396210663467`", ",", 
     "38.41172137331451`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "12583.4193109728`", ",", "10575.806919381974`", ",", 
     "10139.275348336445`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2.997981701513786`*^8", ",", "2.7677517449256206`*^8", ",", 
     "2.713561524418416`*^8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "3.5762947219020652`*^16", ",", "3.4322662206401028`*^16", ",", 
     "3.3972432134429836`*^16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.6074724824056575`*^31", ",", "1.5722495398641921`*^31", ",", 
     "1.5635697816460879`*^31"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "3.5750361935489236`*^57", ",", "3.531742482773851`*^57", ",", 
     "3.521002785561405`*^57"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4.975922473108832`*^104", ",", "4.942355038202365`*^104", ",", 
     "4.933998944084216`*^104"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "6.64843666985707`*^188", ",", "6.623346749410232`*^188", ",", 
     "6.617089162588162`*^188"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "5.170735721925952105199270377078`15.954589770191005*^338", ",", 
     "5.15979470004593490488686445541`15.954589770191005*^338", ",", 
     "5.157062970475632433308412291378`15.954589770191005*^338"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "3.572964278681449971217966814`15.954589770191005*^605", ",", 
     "3.568719641446930282205510869`15.954589770191005*^605", ",", 
     "3.567659274674939945854552706`15.954589770191005*^605"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2.290547787209821657722922313542258558326`15.954589770191005*^1080", ",",
      "2.28901896870846122588325242805853158898`15.954589770191005*^1080", 
     ",", "2.288636924783653858322021692280443840065`15.\
954589770191005*^1080"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "9.797064352876361238146801975586746591`15.954589770191005*^1924", ",", 
     "9.793389083071477585182323620660454217`15.954589770191005*^1924", ",", 
     "9.792470479011139819487097696957864512`15.954589770191005*^1924"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.875498810300647113422025719474495922`15.954589770191005*^3427", ",", 
     "1.875103274507570029225749691053836478`15.954589770191005*^3427", ",", 
     "1.875004403597913864084708103386805307`15.954589770191005*^3427"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.101897201572859475389122844963`15.954589770191005*^6099", ",", 
     "1.101766542410103060395678217185`15.954589770191005*^6099", ",", 
     "1.101733880006425115394884512785`15.954589770191005*^6099"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "3.06077192946987188682309323374191944882624`15.954589770191005*^10850", 
     ",", "3.060567816528708632838670696067376073148348`15.\
954589770191005*^10850", ",", 
     "3.060516785488998779373653040393511380573379`15.954589770191005*^10850"}\
], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9495855835362787`*^9, 3.949585757776416*^9, {3.949585827702716*^9, 
   3.949585837735146*^9}, 3.9495859321431704`*^9, 3.949586044294395*^9, 
   3.9495861108956347`*^9, 3.949586190041492*^9, 3.9495862841569777`*^9, 
   3.949586722007999*^9, 3.949587190668233*^9, 3.949587606459558*^9, 
   3.955188058732213*^9, 3.955188320237508*^9},
 CellLabel->
  "Out[157]=",ExpressionUUID->"8afa0d37-a910-43bf-a223-1d57b138eaf0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"numericR", "=", 
  RowBox[{"numericRUnnormed", "/", "numericVals"}]}]], "Input",
 CellLabel->
  "In[158]:=",ExpressionUUID->"58cb79e3-8bcd-4fa3-bea6-322a64accaf6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.06566916127522342`", ",", "0.03168870202064164`", ",", 
     RowBox[{"-", "0.013366065559395155`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1149380203886231`", ",", "0.05411729551091831`", ",", 
     RowBox[{"-", "0.01931847669487203`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.19652908351332724`", ",", "0.08926292629627947`", ",", 
     RowBox[{"-", "0.02101966330831486`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3127606089791467`", ",", "0.1368812862590262`", ",", 
     RowBox[{"-", "0.0017290194122887357`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.3979757621933715`", ",", "0.17650601898510535`", ",", 
     "0.05987420409703386`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.291902797553997`", ",", "0.15127482871211784`", ",", 
     "0.10612557077188253`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.08734675036520156`", ",", "0.05941708402769129`", ",", 
     "0.05315166784914231`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.007730296023235416`", ",", "0.006496971622022807`", ",", 
     "0.006228799817183771`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.00009869995996981399`", ",", "0.000091120298130107`", ",", 
     "0.00008933624034479237`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4.162660287621772`*^-8", ",", "3.99501702298334`*^-8", ",", 
     "3.954251679925987`*^-8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4.090882545513197`*^-14", ",", "4.001243113161078`*^-14", ",", 
     "3.9791538570261434`*^-14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "8.414127888123388`*^-25", ",", "8.312232746510493`*^-25", ",", 
     "8.286956027357746`*^-25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "8.293508693549414`*^-44", ",", "8.237560914073057`*^-44", ",", 
     "8.223633579073867`*^-44"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.3154071237154895`*^-77", ",", "1.3104430303912862`*^-77", ",", 
     "1.3092049537287923`*^-77"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.030622508460523422795447780608962811`15.653559774527023*^-137", ",", 
     "1.028441762040378634240021097054265052`15.653559774527023*^-137", ",", 
     "1.027897278211850598145991176221417216`15.653559774527023*^-137"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.34127849758320798702390696`15.653559774527023*^-244", ",", 
     "1.33968507536886574953607287`15.653559774527023*^-244", ",", 
     "1.33928701733080800162948728`15.653559774527023*^-244"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.1346786006106639009992038904`15.653559774527023*^-434", ",", 
     "1.1339212631530488150737426428`15.653559774527023*^-434", ",", 
     "1.1337320083955655476964480034`15.653559774527023*^-434"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
    "1.1284353716064210941284502916066976054`15.653559774527023*^-772", ",", 
     "1.1280120504666747660191073413985406045`15.653559774527023*^-772", ",", 
     "1.1279062447603070132683179422545282529`15.653559774527023*^-772"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "9.76575336794156708307949988305667`15.653559774527023*^-1374", ",", 
     "9.76369380651600436967753539013151`15.653559774527023*^-1374", ",", 
     "9.76317898405188808413071602896638`15.653559774527023*^-1374"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "1.3555548528284932674222196729058368973768921`15.653559774527023*^-2442",
      ",", "1.3553941158179190055536599943655747668738119`15.653559774527023*^-\
2442", ",", 
     "1.3553539345017785507009433038112631589518205`15.653559774527023*^-\
2442"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2.53894303410422969273504979914`15.653559774527023*^-4343", ",", 
     "2.538773720237636983806784595435`15.653559774527023*^-4343", ",", 
     "2.538731389444693234636571576728`15.653559774527023*^-4343"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.949586209794285*^9, 3.949586301658153*^9, 
  3.949586730838491*^9, 3.9495872119756727`*^9, 3.9495876136824093`*^9, 
  3.955188062854363*^9, 3.9551881733398867`*^9, 3.955188320347274*^9},
 CellLabel->
  "Out[158]=",ExpressionUUID->"8745a192-f746-41c6-92e7-b6087a6e5e3d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"formulaR", "=", 
  RowBox[{"Transpose", "[", 
   RowBox[{"expectedR", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"s1", "->", "tests1"}], ",", 
      RowBox[{"s2", "->", "tests2"}], ",", 
      RowBox[{"s3", "->", "tests3"}], ",", 
      RowBox[{"\[Lambda]", "->", "lambdaRange"}]}], "}"}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.94958633606324*^9, 3.949586411442857*^9}},
 CellLabel->
  "In[159]:=",ExpressionUUID->"adf9e617-258e-48ef-bf96-21d42dce05e6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6.680157551400781`"}], ",", 
     RowBox[{"-", "46.48212621585415`"}], ",", 
     RowBox[{"-", "49.908323140544006`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3.40792490561033`"}], ",", 
     RowBox[{"-", "26.613581713092415`"}], ",", 
     RowBox[{"-", "28.59996565627263`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.6883636557802502`"}], ",", 
     RowBox[{"-", "17.47977885364486`"}], ",", 
     RowBox[{"-", "18.738338327751702`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3.5184437046600077`"}], ",", 
     RowBox[{"-", "52.28869331009765`"}], ",", 
     RowBox[{"-", "55.01522601413631`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.5983754450481719`", ",", "1.4652776343064133`", ",", 
     "1.367112231335523`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.7229126173849995`", ",", "0.49696082494425614`", ",", 
     "0.406982796224763`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.8397109843683441`", ",", "0.6359664085211835`", ",", 
     "0.5821789897284755`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9097762633321125`", ",", "0.7866012882857023`", ",", 
     "0.7562173256407411`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.949468540319032`", ",", "0.8800779798067916`", ",", 
     "0.8630996333161889`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9716929537373243`", ",", "0.9331094033607172`", ",", 
     "0.9236243539762828`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9841245051618386`", ",", "0.9626541720680412`", ",", 
     "0.9573454771802872`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9910875993072271`", ",", "0.9791018729418675`", ",", 
     "0.9761255131434471`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9949932264297767`", ",", "0.9882839029183491`", ",", 
     "0.9866131794914553`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9971861278114122`", ",", "0.9934234496322938`", ",", 
     "0.9924849160673999`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9984181721505372`", ",", "0.996305599315314`", ",", 
     "0.9957781398609764`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9991106416578777`", ",", "0.9979237266869575`", ",", 
     "0.9976272156446514`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9994999307273292`", ",", "0.9988328214116329`", ",", 
     "0.9986661131887685`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.999718807407697`", ",", "0.9993437729645732`", ",", 
     "0.9992500362538673`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9998418791779814`", ",", "0.9996310162796541`", ",", 
     "0.9995783074888125`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999110838344384`", ",", "0.9997925178293021`", ",", 
     "0.9997628785221405`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999499993057277`", ",", "0.9998833281964126`", ",", 
     "0.99986666111319`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.949586333585837*^9, 3.949586361993641*^9}, {
   3.9495863965509863`*^9, 3.949586412432082*^9}, 3.949586736158278*^9, 
   3.949587215843668*^9, 3.949587618993205*^9, 3.9551880655748987`*^9, 
   3.955188320466123*^9},
 CellLabel->
  "Out[159]=",ExpressionUUID->"101e0ee6-112d-45cf-abf3-12659d01a60c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"formulaR1", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Normal", "[", 
      RowBox[{"Series", "[", 
       RowBox[{"expectedR", ",", 
        RowBox[{"{", 
         RowBox[{"\[Lambda]", ",", "\[Infinity]", ",", "1"}], "}"}]}], "]"}], 
      "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"s1", "->", "tests1"}], ",", 
       RowBox[{"s2", "->", "tests2"}], ",", 
       RowBox[{"s3", "->", "tests3"}], ",", 
       RowBox[{"\[Lambda]", "->", "lambdaRange"}]}], "}"}]}], ")"}], "//", 
   "Transpose"}]}], "\[IndentingNewLine]", 
 RowBox[{"formulaR2", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Normal", "[", 
      RowBox[{"Series", "[", 
       RowBox[{"expectedR", ",", 
        RowBox[{"{", 
         RowBox[{"\[Lambda]", ",", "\[Infinity]", ",", "2"}], "}"}]}], "]"}], 
      "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"s1", "->", "tests1"}], ",", 
       RowBox[{"s2", "->", "tests2"}], ",", 
       RowBox[{"s3", "->", "tests3"}], ",", 
       RowBox[{"\[Lambda]", "->", "lambdaRange"}]}], "}"}]}], ")"}], "//", 
   "Transpose"}]}], "\[IndentingNewLine]", 
 RowBox[{"formulaR3", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Normal", "[", 
      RowBox[{"Series", "[", 
       RowBox[{"expectedR", ",", 
        RowBox[{"{", 
         RowBox[{"\[Lambda]", ",", "\[Infinity]", ",", "3"}], "}"}]}], "]"}], 
      "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"s1", "->", "tests1"}], ",", 
       RowBox[{"s2", "->", "tests2"}], ",", 
       RowBox[{"s3", "->", "tests3"}], ",", 
       RowBox[{"\[Lambda]", "->", "lambdaRange"}]}], "}"}]}], ")"}], "//", 
   "Transpose"}]}], "\[IndentingNewLine]", 
 RowBox[{"formulaR4", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Normal", "[", 
      RowBox[{"Series", "[", 
       RowBox[{"expectedR", ",", 
        RowBox[{"{", 
         RowBox[{"\[Lambda]", ",", "\[Infinity]", ",", "4"}], "}"}]}], "]"}], 
      "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"s1", "->", "tests1"}], ",", 
       RowBox[{"s2", "->", "tests2"}], ",", 
       RowBox[{"s3", "->", "tests3"}], ",", 
       RowBox[{"\[Lambda]", "->", "lambdaRange"}]}], "}"}]}], ")"}], "//", 
   "Transpose"}]}], "\[IndentingNewLine]", 
 RowBox[{"formulaR5", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Normal", "[", 
      RowBox[{"Series", "[", 
       RowBox[{"expectedR", ",", 
        RowBox[{"{", 
         RowBox[{"\[Lambda]", ",", "\[Infinity]", ",", "5"}], "}"}]}], "]"}], 
      "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"s1", "->", "tests1"}], ",", 
       RowBox[{"s2", "->", "tests2"}], ",", 
       RowBox[{"s3", "->", "tests3"}], ",", 
       RowBox[{"\[Lambda]", "->", "lambdaRange"}]}], "}"}]}], ")"}], "//", 
   "Transpose"}]}], "\[IndentingNewLine]", 
 RowBox[{"formulaR6", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Normal", "[", 
      RowBox[{"Series", "[", 
       RowBox[{"expectedR", ",", 
        RowBox[{"{", 
         RowBox[{"\[Lambda]", ",", "\[Infinity]", ",", "6"}], "}"}]}], "]"}], 
      "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"s1", "->", "tests1"}], ",", 
       RowBox[{"s2", "->", "tests2"}], ",", 
       RowBox[{"s3", "->", "tests3"}], ",", 
       RowBox[{"\[Lambda]", "->", "lambdaRange"}]}], "}"}]}], ")"}], "//", 
   "Transpose"}]}]}], "Input",
 CellChangeTimes->{{3.949587655135021*^9, 3.949587813570332*^9}, {
  3.949587846600709*^9, 3.949587907283367*^9}},
 CellLabel->
  "In[144]:=",ExpressionUUID->"d0d10491-4559-446b-b2f9-43047ac2dc4c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.666666666666667`"}], ",", 
     RowBox[{"-", "4.`"}], ",", 
     RowBox[{"-", "4.333333333333333`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0619181923646135`"}], ",", 
     RowBox[{"-", "1.8117066259517456`"}], ",", 
     RowBox[{"-", "1.9991537343485284`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.1595018087284059`"}], ",", 
     RowBox[{"-", "0.5811388300841898`"}], ",", 
     RowBox[{"-", "0.6865480854231356`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.3479642163190616`", ",", "0.11086029498053862`", ",", 
     "0.05158431464590785`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6333333333333333`", ",", "0.5`", ",", "0.4666666666666667`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.7938081807635387`", ",", "0.7188293374048255`", ",", 
     "0.7000846265651471`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.8840498191271594`", ",", "0.841886116991581`", ",", 
     "0.8313451914576864`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9347964216319061`", ",", "0.9110860294980538`", ",", 
     "0.9051584314645907`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9633333333333334`", ",", "0.95`", ",", "0.9466666666666667`"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9793808180763539`", ",", "0.9718829337404825`", ",", 
     "0.9700084626565147`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.988404981912716`", ",", "0.9841886116991581`", ",", 
     "0.9831345191457687`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9934796421631906`", ",", "0.9911086029498054`", ",", 
     "0.9905158431464591`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9963333333333333`", ",", "0.995`", ",", "0.9946666666666667`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9979380818076354`", ",", "0.9971882933740482`", ",", 
     "0.9970008462656514`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9988404981912716`", ",", "0.9984188611699158`", ",", 
     "0.9983134519145769`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9993479642163191`", ",", "0.9991108602949805`", ",", 
     "0.9990515843146459`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9996333333333334`", ",", "0.9995`", ",", "0.9994666666666666`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9997938081807636`", ",", "0.9997188293374049`", ",", 
     "0.9997000846265651`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9998840498191272`", ",", "0.9998418861169915`", ",", 
     "0.9998313451914577`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999347964216319`", ",", "0.9999110860294981`", ",", 
     "0.9999051584314645`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999633333333333`", ",", "0.99995`", ",", "0.9999466666666667`"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.949587652854713*^9, 3.949587709417006*^9}, {
   3.949587745146666*^9, 3.949587814031907*^9}, {3.949587850226172*^9, 
   3.949587907776931*^9}, 3.955188067299962*^9},
 CellLabel->
  "Out[144]=",ExpressionUUID->"3e027e62-3e05-4157-a3b8-dd82a38afa9a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6.055555555555555`"}], ",", 
     RowBox[{"-", "10.944444444444445`"}], ",", 
     RowBox[{"-", "11.88888888888889`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.1335789549772306`"}], ",", 
     RowBox[{"-", "4.007732778846453`"}], ",", 
     RowBox[{"-", "4.388430188697971`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.4983906976172947`"}], ",", 
     RowBox[{"-", "1.2755832745286342`"}], ",", 
     RowBox[{"-", "1.4421036409786911`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.24079814005779987`", ",", 
     RowBox[{"-", "0.10874232030893216`"}], ",", 
     RowBox[{"-", "0.18734333078903642`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.5994444444444444`", ",", "0.4305555555555556`", ",", 
     "0.3911111111111111`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.7830915731374125`", ",", "0.6968690758758784`", ",", 
     "0.6761918620216527`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.8806609302382705`", ",", "0.8349416725471366`", ",", 
     "0.8237896359021308`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9337247608692935`", ",", "0.9088900033451591`", ",", 
     "0.9027691550102414`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9629944444444445`", ",", "0.9493055555555555`", ",", 
     "0.9459111111111111`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9792736520000926`", ",", "0.9716633311251931`", ",", 
     "0.9697695350110798`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9883710930238271`", ",", "0.9841191672547136`", ",", 
     "0.983058963590213`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9934689255555645`", ",", "0.9910866426882765`", ",", 
     "0.9904919503819156`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9963299444444444`", ",", "0.9949930555555555`", ",", 
     "0.9946591111111112`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9979370101468729`", ",", "0.9971860973478953`", ",", 
     "0.9969984569891971`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9988401593023828`", ",", "0.9984181667254715`", ",", 
     "0.9983126963590213`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9993478570502429`", ",", "0.9991106406923652`", ",", 
     "0.9990513453870005`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9996332994444445`", ",", "0.9994999305555556`", ",", 
     "0.999466591111111`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.999793797464156`", ",", "0.9997188073771434`", ",", 
     "0.9997000607338006`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9998840464302383`", ",", "0.9998418791725471`", ",", 
     "0.9998313376359022`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999347953499711`", ",", "0.9999110838334719`", ",", 
     "0.9999051560421881`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999633329944444`", ",", "0.9999499993055556`", ",", 
     "0.9999466659111111`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.949587652854713*^9, 3.949587709417006*^9}, {
   3.949587745146666*^9, 3.949587814031907*^9}, {3.949587850226172*^9, 
   3.949587907776931*^9}, 3.955188067435137*^9},
 CellLabel->
  "Out[145]=",ExpressionUUID->"786eb380-8635-4ab0-97c6-7a24d6f07b5f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "36.22685185185185`", ",", "91.48611111111113`", ",", 
     "99.25925925925925`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "5.385414494969752`", ",", "14.207282011482793`", ",", 
     "15.376816142882795`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.8386964260085299`", ",", "1.9635553009910605`", ",", 
     "2.072709417601051`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.4785695901949971`", ",", "0.46726702320201574`", ",", 
     "0.4376886384317924`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.641726851851852`", ",", "0.5329861111111112`", ",", 
     "0.5022592592592593`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.7906105665873594`", ",", "0.7150840906662077`", ",", 
     "0.6959571083532334`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.8819980173618963`", ",", "0.8381808111226563`", ",", 
     "0.8273044489607106`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9339625323194307`", ",", "0.9094660126886701`", ",", 
     "0.9033941869794623`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9630367268518518`", ",", "0.949407986111111`", ",", 
     "0.9460222592592593`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9792811709935425`", ",", "0.9716815461399834`", ",", 
     "0.9697893002574114`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9883724301109508`", ",", "0.9841224063932892`", ",", 
     "0.9830624784032717`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9934691633270146`", ",", "0.99108721869762`", ",", 
     "0.9904925754138849`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9963299867268518`", ",", "0.9949931579861111`", ",", 
     "0.9946592222592594`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9979370176658662`", ",", "0.9971861155629101`", ",", 
     "0.9969984767544434`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9988401606394698`", ",", "0.9984181699646099`", ",", 
     "0.9983126998738344`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9993478572880141`", ",", "0.9991106412683745`", ",", 
     "0.9990513460120325`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9996332994867269`", ",", "0.999499930657986`", ",", 
     "0.9994665912222593`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.999793797471675`", ",", "0.9997188073953582`", ",", 
     "0.9997000607535659`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9998840464315755`", ",", "0.9998418791757864`", ",", 
     "0.9998313376394169`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999347953502089`", ",", "0.9999110838340479`", ",", 
     "0.9999051560428132`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999633329944866`", ",", "0.9999499993056579`", ",", 
     "0.9999466659112224`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.949587652854713*^9, 3.949587709417006*^9}, {
   3.949587745146666*^9, 3.949587814031907*^9}, {3.949587850226172*^9, 
   3.949587907776931*^9}, 3.9551880674369392`*^9},
 CellLabel->
  "Out[146]=",ExpressionUUID->"d6ff2352-e216-4baf-bfaa-a7f33ca67a60"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "71.01835317460319`"}], ",", 
     RowBox[{"-", "153.2793761022928`"}], ",", 
     RowBox[{"-", "166.6089065255732`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "5.339106007675752`"}], ",", 
     RowBox[{"-", "10.269266709857597`"}], ",", 
     RowBox[{"-", "11.210000435600453`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.2337556242560206`"}], ",", 
     RowBox[{"-", "0.4840995711429792`"}], ",", 
     RowBox[{"-", "0.5859722402472731`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.37132438516854194`", ",", "0.22250153598861178`", ",", 
     "0.17182047264695965`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.6310023313492064`", ",", "0.5085095623897706`", ",", 
     "0.475672442680776`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.7895381145370949`", ",", "0.7126364357940735`", ",", 
     "0.6932984266953852`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.88189077215687`", ",", "0.8379360456354428`", ",", 
     "0.8270385807949259`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9339518077989282`", ",", "0.9094415361399487`", ",", 
     "0.9033676001628838`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9630356543998015`", ",", "0.9494055384562389`", ",", 
     "0.9460196005776014`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9792810637483376`", ",", "0.9716813013744962`", ",", 
     "0.9697890343892455`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9883724193864302`", ",", "0.9841223819167404`", ",", 
     "0.9830624518164551`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9934691622545627`", ",", "0.991087216249965`", ",", 
     "0.9904925727552032`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9963299866196067`", ",", "0.9949931577413456`", ",", 
     "0.9946592219933912`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9979370176551416`", ",", "0.9971861155384335`", ",", 
     "0.9969984767278567`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9988401606383973`", ",", "0.9984181699621623`", ",", 
     "0.9983126998711757`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9993478572879069`", ",", "0.9991106412681298`", ",", 
     "0.9990513460117665`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9996332994867162`", ",", "0.9994999306579616`", ",", 
     "0.9994665912222327`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9997937974716739`", ",", "0.9997188073953558`", ",", 
     "0.9997000607535632`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9998840464315752`", ",", "0.9998418791757862`", ",", 
     "0.9998313376394167`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999347953502089`", ",", "0.9999110838340479`", ",", 
     "0.9999051560428132`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999633329944866`", ",", "0.9999499993056579`", ",", 
     "0.9999466659112224`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.949587652854713*^9, 3.949587709417006*^9}, {
   3.949587745146666*^9, 3.949587814031907*^9}, {3.949587850226172*^9, 
   3.949587907776931*^9}, 3.955188067439212*^9},
 CellLabel->
  "Out[147]=",ExpressionUUID->"4586f729-1f05-403b-9008-d9e2360bf3c8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "562.7308338844795`", ",", "1356.4289526381538`", ",", 
     "1472.0496399176952`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "30.299229761235352`", ",", "74.62787151362339`", ",", 
     "80.93854141853942`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.7703352721307883`", ",", "4.290017350203075`", ",", 
     "4.595921073814262`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.4840226982161494`", ",", "0.49096985960495276`", ",", 
     "0.46321974796939724`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.6373398232197971`", ",", "0.5236066456771751`", ",", 
     "0.4920590281452087`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.7898944978947842`", ",", "0.7134854071763084`", ",", 
     "0.6942199121139265`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.8819108130658337`", ",", "0.8379837868046563`", ",", 
     "0.8270903997280665`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9339529347820584`", ",", "0.909444220823185`", ",", 
     "0.903370514155637`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9630357177747202`", ",", "0.9494056894270719`", ",", 
     "0.946019764443456`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9792810673121711`", ",", "0.97168130986421`", ",", 
     "0.9697890436040998`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9883724195868392`", ",", "0.9841223823941522`", ",", 
     "0.9830624523346444`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9934691622658325`", ",", "0.9910872162768118`", ",", 
     "0.9904925727843432`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9963299866202403`", ",", "0.9949931577428552`", ",", 
     "0.9946592219950298`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9979370176551774`", ",", "0.9971861155385184`", ",", 
     "0.9969984767279487`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9988401606383993`", ",", "0.9984181699621671`", ",", 
     "0.9983126998711809`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9993478572879072`", ",", "0.99911064126813`", ",", 
     "0.9990513460117668`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9996332994867161`", ",", "0.9994999306579617`", ",", 
     "0.9994665912222327`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9997937974716739`", ",", "0.9997188073953559`", ",", 
     "0.9997000607535632`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9998840464315752`", ",", "0.999841879175786`", ",", 
     "0.9998313376394167`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999347953502089`", ",", "0.9999110838340479`", ",", 
     "0.9999051560428132`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999633329944867`", ",", "0.999949999305658`", ",", 
     "0.9999466659112223`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.949587652854713*^9, 3.949587709417006*^9}, {
   3.949587745146666*^9, 3.949587814031907*^9}, {3.949587850226172*^9, 
   3.949587907776931*^9}, 3.955188067524158*^9},
 CellLabel->
  "Out[148]=",ExpressionUUID->"daa8a8dd-b5d1-4eda-8ded-01c855f6c364"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1657.803236530594`"}], ",", 
     RowBox[{"-", "3818.7630395876176`"}], ",", 
     RowBox[{"-", "4147.274792401529`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "39.92022308392811`"}], ",", 
     RowBox[{"-", "89.0260687273551`"}], ",", 
     RowBox[{"-", "96.76009975707501`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.45019879828428544`"}], ",", 
     RowBox[{"-", "0.8851746420226962`"}], ",", 
     RowBox[{"-", "1.0234033585049598`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.4138032453709857`", ",", "0.3273159193639744`", ",", 
     "0.28552110679378295`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.6351192891493821`", ",", "0.5184314536849495`", ",", 
     "0.48643970371288947`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.7898242784419389`", ",", "0.7133217532360674`", ",", 
     "0.6940422134727511`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.8819085925317633`", ",", "0.8379786116126641`", ",", 
     "0.8270847804036341`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9339528645626057`", ",", "0.9094440571692446`", ",", 
     "0.9033703364569958`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9630357155541862`", ",", "0.9494056842518799`", ",", 
     "0.9460197588241317`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9792810672419515`", ",", "0.971681309700556`", ",", 
     "0.9697890434264012`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9883724195846187`", ",", "0.984122382388977`", ",", 
     "0.9830624523290251`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9934691622657622`", ",", "0.9910872162766483`", ",", 
     "0.9904925727841654`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9963299866202381`", ",", "0.9949931577428501`", ",", 
     "0.9946592219950241`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9979370176551772`", ",", "0.9971861155385184`", ",", 
     "0.9969984767279485`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9988401606383993`", ",", "0.998418169962167`", ",", 
     "0.9983126998711809`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9993478572879071`", ",", "0.9991106412681301`", ",", 
     "0.9990513460117669`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9996332994867161`", ",", "0.9994999306579617`", ",", 
     "0.9994665912222327`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9997937974716739`", ",", "0.9997188073953559`", ",", 
     "0.9997000607535632`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9998840464315752`", ",", "0.999841879175786`", ",", 
     "0.9998313376394167`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999347953502089`", ",", "0.9999110838340479`", ",", 
     "0.9999051560428132`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999633329944867`", ",", "0.999949999305658`", ",", 
     "0.9999466659112223`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.949587652854713*^9, 3.949587709417006*^9}, {
   3.949587745146666*^9, 3.949587814031907*^9}, {3.949587850226172*^9, 
   3.949587907776931*^9}, 3.955188067614019*^9},
 CellLabel->
  "Out[149]=",ExpressionUUID->"cabc10c3-3046-4195-b27b-77cbcf342932"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"index", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Log10", "[", "lambdaRange", "]"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"numericR", "//", "Transpose"}], ")"}], "[", 
         RowBox[{"[", "index", "]"}], "]"}]}], "}"}], "//", "Transpose"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Log10", "[", "lambdaRange", "]"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"formulaR1", "//", "Transpose"}], ")"}], "[", 
         RowBox[{"[", "index", "]"}], "]"}]}], "}"}], "//", "Transpose"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Log10", "[", "lambdaRange", "]"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"formulaR2", "//", "Transpose"}], ")"}], "[", 
         RowBox[{"[", "index", "]"}], "]"}]}], "}"}], "//", "Transpose"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Log10", "[", "lambdaRange", "]"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"formulaR3", "//", "Transpose"}], ")"}], "[", 
         RowBox[{"[", "index", "]"}], "]"}]}], "}"}], "//", "Transpose"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Log10", "[", "lambdaRange", "]"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"formulaR4", "//", "Transpose"}], ")"}], "[", 
         RowBox[{"[", "index", "]"}], "]"}]}], "}"}], "//", "Transpose"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Log10", "[", "lambdaRange", "]"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"formulaR5", "//", "Transpose"}], ")"}], "[", 
         RowBox[{"[", "index", "]"}], "]"}]}], "}"}], "//", "Transpose"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Log10", "[", "lambdaRange", "]"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"formulaR6", "//", "Transpose"}], ")"}], "[", 
         RowBox[{"[", "index", "]"}], "]"}]}], "}"}], "//", "Transpose"}]}], 
    "}"}], ",", 
   RowBox[{"PlotLegends", "->", 
    RowBox[{"{", 
     RowBox[{
     "\"\<numerical\>\"", ",", "\"\<1\>\"", ",", "\"\<2\>\"", ",", 
      "\"\<3\>\"", ",", "\"\<4\>\"", ",", "\"\<5\>\"", ",", "\"\<6\>\""}], 
     "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.94958676550366*^9, 3.949586778168655*^9}, {
  3.949586834517981*^9, 3.94958685381187*^9}, {3.949586886166807*^9, 
  3.94958704371618*^9}, {3.9495872994579563`*^9, 3.949587348285523*^9}, {
  3.9495876290720453`*^9, 3.94958763337276*^9}, {3.949587830787744*^9, 
  3.94958784281597*^9}, {3.949587918697123*^9, 3.949587929055917*^9}, {
  3.949588001762917*^9, 3.9495881025614653`*^9}, {3.949588160419648*^9, 
  3.949588167549952*^9}},
 CellLabel->
  "In[150]:=",ExpressionUUID->"f2a07ac8-6aba-4383-9c9a-bf2db7f86fd4"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, 
     InterpretationBox[{
       TagBox[{{}, {}, 
         TagBox[{
           RGBColor[0.368417, 0.506779, 0.709798], 
           PointSize[
            NCache[
             Rational[1, 72], 0.013888888888888888`]], 
           AbsoluteThickness[2], 
           LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf7E+WxM5Y93ahPYT/wv6b4tLK3s4NUP4D+4Tn
kjMnmu+H8i/Yq2izs1qInrOHmZAdn2XV+fM2TH7/r2iVTfnrnsL078846FLA
OO8VzPz9l9ve3Q4Segvlf9hv8XzLVMOEd1D+l/0qJ7irjou/h/J/7J936OCq
x7Uw/p/9t3bNmPlrG4zPcOCJAveE39dgfKYDM/fOOvPpBYzPckD5rfsKrs8w
PtuBuJL7D7b9gPE5DpQWO7g//w3jcx1QPHjXe9NfGJ/nwKvu9tQt/2B8vgNH
Lta3u/6H8QUOKNSIqUwH8gHFWHYG
            "]]}, Annotation[#, "Charting`Private`Tag#1"]& ], 
         TagBox[{
           RGBColor[0.880722, 0.611041, 0.142051], 
           PointSize[
            NCache[
             Rational[1, 72], 0.013888888888888888`]], 
           AbsoluteThickness[2], 
           LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQfT3ow4VFN67b/7j27bW8/dn9DGBwwX7C8VjZ8MQ9
9gwo4AGUf2H/x8cfE5cxPIfyH+zf8zZXffeHV1D+i/0SOhMfz1V/C+V/2J8G
Bu+g/C/7T0/7Z7NK8j2U/2O/zr8u2co6GP/P/syWvmTN7TA+w4Hriwtsua7D
+EwHHt6uz/n+AsZnOWDxrFeG5zOMz3ZgSfHBsO0/YHyOA9Ocu3Oe/4bxuQ6c
SloWvukvjM9z4FKyY+aWfzA+34HvH9d0uP6H8QUO9AeXqEwH8gHPo246
            "]]}, Annotation[#, "Charting`Private`Tag#2"]& ], 
         TagBox[{
           RGBColor[0.560181, 0.691569, 0.194885], 
           PointSize[
            NCache[
             Rational[1, 72], 0.013888888888888888`]], 
           AbsoluteThickness[2], 
           LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQbbB236bIJRftf1z79lre/ux+BjC4YJ/AnJ3aeW03
lM/A8MSi77FF3217qPz+jET/hAM+z6D8B/v1uExnXt/+Csp/sf/6a4baBaJv
ofwP+7m3JQDROyj/y/6j3/Zsuiv+Hsr/sT/M8nrV81oY/8/+Oeq7Q39vg/EZ
DvSVaa/9fQ3GZzowM6jl4qcXMD7LgTq9Xcu5PsP4bAea628/2PYDxuc4kPXE
yf35bxif68Bxgzvem/7C+DwHnn9uS93yD8bnO6ClUN/u+h/GFzjw46GIynQg
HwD2MXFj
            "]]}, Annotation[#, "Charting`Private`Tag#3"]& ], 
         TagBox[{
           RGBColor[0.922526, 0.385626, 0.209179], 
           PointSize[
            NCache[
             Rational[1, 72], 0.013888888888888888`]], 
           AbsoluteThickness[2], 
           LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQzaS+aX7i5Lv2ZtatMpKnftszgMEFe5udJz9ufn4X
ymdgeGLR99iC7yFMfv+7xS/Zfzx8BuU/2N/HVDsh4dIrKP/F/skeq8ojpN5C
+R/2/xSMvd2T+A7K/7L/YMfNp8wS76H8H/utuK67vquF8f/sX+v2s+vPNhif
4UBYpuaT39dgfKYDpce8b396AeOzHOiOLV/J9RnGZzvAuUrr4bYfMD7Hgdgf
Ae7Pf8P4XAdWbLznvekvjM9z4EFqe+qWfzA+34E8k/p21/8wvsCBiU9FVKYD
+QCOFm+X
            "]]}, Annotation[#, "Charting`Private`Tag#4"]& ], 
         TagBox[{
           RGBColor[0.528488, 0.470624, 0.701351], 
           PointSize[
            NCache[
             Rational[1, 72], 0.013888888888888888`]], 
           AbsoluteThickness[2], 
           LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQ/WTeJA5Ps1v2P659ey1vf3Y/AxhcsL+x30DrXdUZ
ewYouBTVemOr6wMo/8L+Hb2mb1+dfQblP9j/biaLY/yFV1D+i/0vuV4rqUq9
hfI/7Df95LmzPfEdlP9l/3GLwiRmifdQ/o/9VkybLd7Vwvh/9lfeX9H5ZxuM
z3Ag6yj7k9/XYHymA86ZHrc/vYDxWQ7kspev5PoM47MdyF2o9XDbDxif40Dj
9wD3579hfK4Dkzbe8970F8bnOXAvtT11yz8Yn+9Ankl9u+t/GF/gwMSnIirT
gXwAvmhvzw==
            "]]}, Annotation[#, "Charting`Private`Tag#5"]& ], 
         TagBox[{
           RGBColor[0.772079, 0.431554, 0.102387], 
           PointSize[
            NCache[
             Rational[1, 72], 0.013888888888888888`]], 
           AbsoluteThickness[2], 
           LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQXZZ3ncnR/qq9mXWrjOSp3/YMYHDBvuPMlBs8Ofeh
fAaGT7dSdiYdfACT38912z7y/pVnUP6D/fXv78QfvvAKyn+x/5qE/REtqbdQ
/of9OhbhXB2J76D8L/vZuRjSmSXeQ/k/9q+c/8XiXS2M/2e/wIQ1nX+2wfgM
Bzp+sT/5fQ3GZzrgkONx+9MLGJ/lwEz28pVcn2F8tgP5C7UebvsB43McaPoe
4P78N4zPdWDyxnvem/7C+DwH7qa2p275B+PzHcgzqW93/Q/jCxyY9FREZTqQ
DwDS62wl
            "]]}, Annotation[#, "Charting`Private`Tag#6"]& ], 
         TagBox[{
           RGBColor[0.363898, 0.618501, 0.782349], 
           PointSize[
            NCache[
             Rational[1, 72], 0.013888888888888888`]], 
           AbsoluteThickness[2], 
           LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQrVJ8pmlW6HX7H9e+vZa3P7ufAQwu2GdZeFTs+3TF
ngEKwnIj+/9OewDlX9h/ZrKpSsflZ1D+g/3nvxW37rjwCsp/sX/L6qQcLam3
UP6H/V6f+tk7Et9B+V/2f+9+mcYs8R7K/7F/8svPFu9qYfw/+/271nT+2Qbj
MxyI+sX+5Pc1GJ/pgEOOx+1PL2B8lgMz2MtXcn2G8dkOFCzUerjtB4zPcaDp
e4D7898wPteByRvveW/6C+PzHLib2p665R+Mz3cgz6S+3fU/jC9wYNJTEZXp
QD4ACgpx9Q==
            "]]}, Annotation[#, "Charting`Private`Tag#7"]& ]}, {
        "WolframDynamicHighlight", <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
       StyleBox[
        DynamicBox[
         (Charting`HighlightActionBox["DynamicHighlight", {}, 
          Slot["HighlightElements"], 
          Slot["LayoutOptions"], 
          Slot["Meta"], 
          Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
             Annotation[{
               Hue[0.67, 0.6, 0.6], 
               Directive[
                PointSize[
                 Rational[1, 72]], 
                RGBColor[0.368417, 0.506779, 0.709798], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf7E+WxM5Y93ahPYT/wv6b4tLK3s4NUP4D+4Tn
kjMnmu+H8i/Yq2izs1qInrOHmZAdn2XV+fM2TH7/r2iVTfnrnsL078846FLA
OO8VzPz9l9ve3Q4Segvlf9hv8XzLVMOEd1D+l/0qJ7irjou/h/J/7J936OCq
x7Uw/p/9t3bNmPlrG4zPcOCJAveE39dgfKYDM/fOOvPpBYzPckD5rfsKrs8w
PtuBuJL7D7b9gPE5DpQWO7g//w3jcx1QPHjXe9NfGJ/nwKvu9tQt/2B8vgNH
Lta3u/6H8QUOKNSIqUwH8gHFWHYG
                "]]}, "Charting`Private`Tag#1"], 
             Annotation[{
               Hue[0.9060679774997897, 0.6, 0.6], 
               Directive[
                PointSize[
                 Rational[1, 72]], 
                RGBColor[0.880722, 0.611041, 0.142051], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQfT3ow4VFN67b/7j27bW8/dn9DGBwwX7C8VjZ8MQ9
9gwo4AGUf2H/x8cfE5cxPIfyH+zf8zZXffeHV1D+i/0SOhMfz1V/C+V/2J8G
Bu+g/C/7T0/7Z7NK8j2U/2O/zr8u2co6GP/P/syWvmTN7TA+w4Hriwtsua7D
+EwHHt6uz/n+AsZnOWDxrFeG5zOMz3ZgSfHBsO0/YHyOA9Ocu3Oe/4bxuQ6c
SloWvukvjM9z4FKyY+aWfzA+34HvH9d0uP6H8QUO9AeXqEwH8gHPo246
                "]]}, "Charting`Private`Tag#2"], 
             Annotation[{
               Hue[0.1421359549995791, 0.6, 0.6], 
               Directive[
                PointSize[
                 Rational[1, 72]], 
                RGBColor[0.560181, 0.691569, 0.194885], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQbbB236bIJRftf1z79lre/ux+BjC4YJ/AnJ3aeW03
lM/A8MSi77FF3217qPz+jET/hAM+z6D8B/v1uExnXt/+Csp/sf/6a4baBaJv
ofwP+7m3JQDROyj/y/6j3/Zsuiv+Hsr/sT/M8nrV81oY/8/+Oeq7Q39vg/EZ
DvSVaa/9fQ3GZzowM6jl4qcXMD7LgTq9Xcu5PsP4bAea628/2PYDxuc4kPXE
yf35bxif68Bxgzvem/7C+DwHnn9uS93yD8bnO6ClUN/u+h/GFzjw46GIynQg
HwD2MXFj
                "]]}, "Charting`Private`Tag#3"], 
             Annotation[{
               Hue[0.37820393249936934`, 0.6, 0.6], 
               Directive[
                PointSize[
                 Rational[1, 72]], 
                RGBColor[0.922526, 0.385626, 0.209179], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQzaS+aX7i5Lv2ZtatMpKnftszgMEFe5udJz9ufn4X
ymdgeGLR99iC7yFMfv+7xS/Zfzx8BuU/2N/HVDsh4dIrKP/F/skeq8ojpN5C
+R/2/xSMvd2T+A7K/7L/YMfNp8wS76H8H/utuK67vquF8f/sX+v2s+vPNhif
4UBYpuaT39dgfKYDpce8b396AeOzHOiOLV/J9RnGZzvAuUrr4bYfMD7Hgdgf
Ae7Pf8P4XAdWbLznvekvjM9z4EFqe+qWfzA+34E8k/p21/8wvsCBiU9FVKYD
+QCOFm+X
                "]]}, "Charting`Private`Tag#4"], 
             Annotation[{
               Hue[0.6142719099991583, 0.6, 0.6], 
               Directive[
                PointSize[
                 Rational[1, 72]], 
                RGBColor[0.528488, 0.470624, 0.701351], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQ/WTeJA5Ps1v2P659ey1vf3Y/AxhcsL+x30DrXdUZ
ewYouBTVemOr6wMo/8L+Hb2mb1+dfQblP9j/biaLY/yFV1D+i/0vuV4rqUq9
hfI/7Df95LmzPfEdlP9l/3GLwiRmifdQ/o/9VkybLd7Vwvh/9lfeX9H5ZxuM
z3Ag6yj7k9/XYHymA86ZHrc/vYDxWQ7kspev5PoM47MdyF2o9XDbDxif40Dj
9wD3579hfK4Dkzbe8970F8bnOXAvtT11yz8Yn+9Ankl9u+t/GF/gwMSnIirT
gXwAvmhvzw==
                "]]}, "Charting`Private`Tag#5"], 
             Annotation[{
               Hue[0.8503398874989481, 0.6, 0.6], 
               Directive[
                PointSize[
                 Rational[1, 72]], 
                RGBColor[0.772079, 0.431554, 0.102387], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQXZZ3ncnR/qq9mXWrjOSp3/YMYHDBvuPMlBs8Ofeh
fAaGT7dSdiYdfACT38912z7y/pVnUP6D/fXv78QfvvAKyn+x/5qE/REtqbdQ
/of9OhbhXB2J76D8L/vZuRjSmSXeQ/k/9q+c/8XiXS2M/2e/wIQ1nX+2wfgM
Bzp+sT/5fQ3GZzrgkONx+9MLGJ/lwEz28pVcn2F8tgP5C7UebvsB43McaPoe
4P78N4zPdWDyxnvem/7C+DwH7qa2p275B+PzHcgzqW93/Q/jCxyY9FREZTqQ
DwDS62wl
                "]]}, "Charting`Private`Tag#6"], 
             Annotation[{
               Hue[0.08640786499873876, 0.6, 0.6], 
               Directive[
                PointSize[
                 Rational[1, 72]], 
                RGBColor[0.363898, 0.618501, 0.782349], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQrVJ8pmlW6HX7H9e+vZa3P7ufAQwu2GdZeFTs+3TF
ngEKwnIj+/9OewDlX9h/ZrKpSsflZ1D+g/3nvxW37rjwCsp/sX/L6qQcLam3
UP6H/V6f+tk7Et9B+V/2f+9+mcYs8R7K/7F/8svPFu9qYfw/+/271nT+2Qbj
MxyI+sX+5Pc1GJ/pgEOOx+1PL2B8lgMz2MtXcn2G8dkOFCzUerjtB4zPcaDp
e4D7898wPteByRvveW/6C+PzHLib2p665R+Mz3cgz6S+3fU/jC9wYNJTEZXp
QD4ACgpx9Q==
                "]]}, "Charting`Private`Tag#7"]}}, <|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, 
              "PlotRange" -> {{-4., 1.}, {-0.22848891278925243`, 
               1.736840354354809}}, 
              "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
              "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
              GoldenRatio^(-1), "DefaultStyle" -> {
                Directive[
                 PointSize[
                  Rational[1, 72]], 
                 RGBColor[0.363898, 0.618501, 0.782349], 
                 AbsoluteThickness[2]], 
                Directive[
                 PointSize[
                  Rational[1, 72]], 
                 RGBColor[0.772079, 0.431554, 0.102387], 
                 AbsoluteThickness[2]], 
                Directive[
                 PointSize[
                  Rational[1, 72]], 
                 RGBColor[0.528488, 0.470624, 0.701351], 
                 AbsoluteThickness[2]], 
                Directive[
                 PointSize[
                  Rational[1, 72]], 
                 RGBColor[0.922526, 0.385626, 0.209179], 
                 AbsoluteThickness[2]], 
                Directive[
                 PointSize[
                  Rational[1, 72]], 
                 RGBColor[0.560181, 0.691569, 0.194885], 
                 AbsoluteThickness[2]], 
                Directive[
                 PointSize[
                  Rational[1, 72]], 
                 RGBColor[0.880722, 0.611041, 0.142051], 
                 AbsoluteThickness[2]], 
                Directive[
                 PointSize[
                  Rational[1, 72]], 
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 AbsoluteThickness[2]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> ({
                  Identity[
                   Part[#, 1]], 
                  Identity[
                   Part[#, 2]]}& ), 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ListLinePlot, "GroupHighlight" -> False|>|>]]& )[<|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, 
             "PlotRange" -> {{-4., 1.}, {-0.22848891278925243`, 
              1.736840354354809}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
             GoldenRatio^(-1), "DefaultStyle" -> {
               Directive[
                PointSize[
                 Rational[1, 72]], 
                RGBColor[0.363898, 0.618501, 0.782349], 
                AbsoluteThickness[2]], 
               Directive[
                PointSize[
                 Rational[1, 72]], 
                RGBColor[0.772079, 0.431554, 0.102387], 
                AbsoluteThickness[2]], 
               Directive[
                PointSize[
                 Rational[1, 72]], 
                RGBColor[0.528488, 0.470624, 0.701351], 
                AbsoluteThickness[2]], 
               Directive[
                PointSize[
                 Rational[1, 72]], 
                RGBColor[0.922526, 0.385626, 0.209179], 
                AbsoluteThickness[2]], 
               Directive[
                PointSize[
                 Rational[1, 72]], 
                RGBColor[0.560181, 0.691569, 0.194885], 
                AbsoluteThickness[2]], 
               Directive[
                PointSize[
                 Rational[1, 72]], 
                RGBColor[0.880722, 0.611041, 0.142051], 
                AbsoluteThickness[2]], 
               Directive[
                PointSize[
                 Rational[1, 72]], 
                RGBColor[0.368417, 0.506779, 0.709798], 
                AbsoluteThickness[2]]}, 
             "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                 Identity[
                  Part[#, 1]], 
                 Identity[
                  Part[#, 2]]}& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ListLinePlot, "GroupHighlight" -> False|>|>], 
         ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
          4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
        False]}, 
      Annotation[{{{}, {}, 
         Annotation[{
           Hue[0.67, 0.6, 0.6], 
           Directive[
            PointSize[
             Rational[1, 72]], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf7E+WxM5Y93ahPYT/wv6b4tLK3s4NUP4D+4Tn
kjMnmu+H8i/Yq2izs1qInrOHmZAdn2XV+fM2TH7/r2iVTfnrnsL078846FLA
OO8VzPz9l9ve3Q4Segvlf9hv8XzLVMOEd1D+l/0qJ7irjou/h/J/7J936OCq
x7Uw/p/9t3bNmPlrG4zPcOCJAveE39dgfKYDM/fOOvPpBYzPckD5rfsKrs8w
PtuBuJL7D7b9gPE5DpQWO7g//w3jcx1QPHjXe9NfGJ/nwKvu9tQt/2B8vgNH
Lta3u/6H8QUOKNSIqUwH8gHFWHYG
            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Hue[0.9060679774997897, 0.6, 0.6], 
           Directive[
            PointSize[
             Rational[1, 72]], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQfT3ow4VFN67b/7j27bW8/dn9DGBwwX7C8VjZ8MQ9
9gwo4AGUf2H/x8cfE5cxPIfyH+zf8zZXffeHV1D+i/0SOhMfz1V/C+V/2J8G
Bu+g/C/7T0/7Z7NK8j2U/2O/zr8u2co6GP/P/syWvmTN7TA+w4Hriwtsua7D
+EwHHt6uz/n+AsZnOWDxrFeG5zOMz3ZgSfHBsO0/YHyOA9Ocu3Oe/4bxuQ6c
SloWvukvjM9z4FKyY+aWfzA+34HvH9d0uP6H8QUO9AeXqEwH8gHPo246
            "]]}, "Charting`Private`Tag#2"], 
         Annotation[{
           Hue[0.1421359549995791, 0.6, 0.6], 
           Directive[
            PointSize[
             Rational[1, 72]], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQbbB236bIJRftf1z79lre/ux+BjC4YJ/AnJ3aeW03
lM/A8MSi77FF3217qPz+jET/hAM+z6D8B/v1uExnXt/+Csp/sf/6a4baBaJv
ofwP+7m3JQDROyj/y/6j3/Zsuiv+Hsr/sT/M8nrV81oY/8/+Oeq7Q39vg/EZ
DvSVaa/9fQ3GZzowM6jl4qcXMD7LgTq9Xcu5PsP4bAea628/2PYDxuc4kPXE
yf35bxif68Bxgzvem/7C+DwHnn9uS93yD8bnO6ClUN/u+h/GFzjw46GIynQg
HwD2MXFj
            "]]}, "Charting`Private`Tag#3"], 
         Annotation[{
           Hue[0.37820393249936934`, 0.6, 0.6], 
           Directive[
            PointSize[
             Rational[1, 72]], 
            RGBColor[0.922526, 0.385626, 0.209179], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQzaS+aX7i5Lv2ZtatMpKnftszgMEFe5udJz9ufn4X
ymdgeGLR99iC7yFMfv+7xS/Zfzx8BuU/2N/HVDsh4dIrKP/F/skeq8ojpN5C
+R/2/xSMvd2T+A7K/7L/YMfNp8wS76H8H/utuK67vquF8f/sX+v2s+vPNhif
4UBYpuaT39dgfKYDpce8b396AeOzHOiOLV/J9RnGZzvAuUrr4bYfMD7Hgdgf
Ae7Pf8P4XAdWbLznvekvjM9z4EFqe+qWfzA+34E8k/p21/8wvsCBiU9FVKYD
+QCOFm+X
            "]]}, "Charting`Private`Tag#4"], 
         Annotation[{
           Hue[0.6142719099991583, 0.6, 0.6], 
           Directive[
            PointSize[
             Rational[1, 72]], 
            RGBColor[0.528488, 0.470624, 0.701351], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQ/WTeJA5Ps1v2P659ey1vf3Y/AxhcsL+x30DrXdUZ
ewYouBTVemOr6wMo/8L+Hb2mb1+dfQblP9j/biaLY/yFV1D+i/0vuV4rqUq9
hfI/7Df95LmzPfEdlP9l/3GLwiRmifdQ/o/9VkybLd7Vwvh/9lfeX9H5ZxuM
z3Ag6yj7k9/XYHymA86ZHrc/vYDxWQ7kspev5PoM47MdyF2o9XDbDxif40Dj
9wD3579hfK4Dkzbe8970F8bnOXAvtT11yz8Yn+9Ankl9u+t/GF/gwMSnIirT
gXwAvmhvzw==
            "]]}, "Charting`Private`Tag#5"], 
         Annotation[{
           Hue[0.8503398874989481, 0.6, 0.6], 
           Directive[
            PointSize[
             Rational[1, 72]], 
            RGBColor[0.772079, 0.431554, 0.102387], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQXZZ3ncnR/qq9mXWrjOSp3/YMYHDBvuPMlBs8Ofeh
fAaGT7dSdiYdfACT38912z7y/pVnUP6D/fXv78QfvvAKyn+x/5qE/REtqbdQ
/of9OhbhXB2J76D8L/vZuRjSmSXeQ/k/9q+c/8XiXS2M/2e/wIQ1nX+2wfgM
Bzp+sT/5fQ3GZzrgkONx+9MLGJ/lwEz28pVcn2F8tgP5C7UebvsB43McaPoe
4P78N4zPdWDyxnvem/7C+DwH7qa2p275B+PzHcgzqW93/Q/jCxyY9FREZTqQ
DwDS62wl
            "]]}, "Charting`Private`Tag#6"], 
         Annotation[{
           Hue[0.08640786499873876, 0.6, 0.6], 
           Directive[
            PointSize[
             Rational[1, 72]], 
            RGBColor[0.363898, 0.618501, 0.782349], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQrVJ8pmlW6HX7H9e+vZa3P7ufAQwu2GdZeFTs+3TF
ngEKwnIj+/9OewDlX9h/ZrKpSsflZ1D+g/3nvxW37rjwCsp/sX/L6qQcLam3
UP6H/V6f+tk7Et9B+V/2f+9+mcYs8R7K/7F/8svPFu9qYfw/+/271nT+2Qbj
MxyI+sX+5Pc1GJ/pgEOOx+1PL2B8lgMz2MtXcn2G8dkOFCzUerjtB4zPcaDp
e4D7898wPteByRvveW/6C+PzHLib2p665R+Mz3cgz6S+3fU/jC9wYNJTEZXp
QD4ACgpx9Q==
            "]]}, "Charting`Private`Tag#7"]}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{-4., 1.}, {-0.22848891278925243`, 
           1.736840354354809}}, "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
          "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
          GoldenRatio^(-1), "DefaultStyle" -> {
            Directive[
             PointSize[
              Rational[1, 72]], 
             RGBColor[0.363898, 0.618501, 0.782349], 
             AbsoluteThickness[2]], 
            Directive[
             PointSize[
              Rational[1, 72]], 
             RGBColor[0.772079, 0.431554, 0.102387], 
             AbsoluteThickness[2]], 
            Directive[
             PointSize[
              Rational[1, 72]], 
             RGBColor[0.528488, 0.470624, 0.701351], 
             AbsoluteThickness[2]], 
            Directive[
             PointSize[
              Rational[1, 72]], 
             RGBColor[0.922526, 0.385626, 0.209179], 
             AbsoluteThickness[2]], 
            Directive[
             PointSize[
              Rational[1, 72]], 
             RGBColor[0.560181, 0.691569, 0.194885], 
             AbsoluteThickness[2]], 
            Directive[
             PointSize[
              Rational[1, 72]], 
             RGBColor[0.880722, 0.611041, 0.142051], 
             AbsoluteThickness[2]], 
            Directive[
             PointSize[
              Rational[1, 72]], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          ListLinePlot, "GroupHighlight" -> False|>|>, 
       "DynamicHighlight"]], {{}, {}}}, AspectRatio -> 
    NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
    AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
    Identity, Frame -> {{False, False}, {False, False}}, 
    FrameLabel -> {{None, None}, {None, None}}, 
    FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    GridLines -> {None, None}, GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], ImageSize -> {1272., Automatic}, 
    Method -> {
     "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
        Directive[
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.647624, 0.37816, 0.614037], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.571589, 0.586483, 0.], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.915, 0.3325, 0.2125], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
         AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
      "RangePadding" -> Scaled[0.05], "OptimizePlotMarkers" -> True, 
      "IncludeHighlighting" -> "CurrentSet", "HighlightStyle" -> Automatic, 
      "OptimizePlotMarkers" -> True, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          Identity[
           Part[#, 1]], 
          Identity[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          Identity[
           Part[#, 1]], 
          Identity[
           Part[#, 2]]}& )}}, 
    PlotRange -> {{-4., 1.}, {-0.22848891278925243`, 1.736840354354809}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"numerical\"", "\"1\"", "\"2\"", "\"3\"", "\"4\"", "\"5\"", "\"6\""}, 
      "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #6}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.363898, 0.618501, 0.782349], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.363898, 0.618501, 0.782349], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #7}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.922526, 0.385626, 0.209179]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.528488, 0.470624, 0.701351]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.772079, 0.431554, 0.102387]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.363898, 0.618501, 0.782349]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, 
               ",", #7}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True", 
                 ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.9495868481361027`*^9, 3.949586855646915*^9}, 
   3.949586901399838*^9, {3.949586975807193*^9, 3.9495870112039957`*^9}, 
   3.949587044270183*^9, 3.9495872214893503`*^9, {3.949587313949127*^9, 
   3.9495873489315243`*^9}, {3.949587622327195*^9, 3.949587633971587*^9}, 
   3.949587929795082*^9, {3.949588058853023*^9, 3.949588103459638*^9}, {
   3.949588161259995*^9, 3.949588168094748*^9}, 3.9551880871925993`*^9},
 CellLabel->
  "Out[151]=",ExpressionUUID->"98b5b342-dfbb-4302-bc9e-6cbb93fac901"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{2875.5, 1575},
WindowMargins->{{14.25, -14.25}, {-45.75, 66.}},
FrontEndVersion->"14.1 for Linux x86 (64-bit) (July 16, 2024)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a0be492e-25f4-4566-8c90-59780940a369"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[576, 22, 196, 3, 96, "Title",ExpressionUUID->"65571dda-a78f-4253-81c7-6fc46cd0f2cf"],
Cell[CellGroupData[{
Cell[797, 29, 287, 4, 65, "Section",ExpressionUUID->"15821792-2a6f-4042-9730-43868f841535"],
Cell[1087, 35, 2742, 64, 357, "Input",ExpressionUUID->"1f0b8c2e-e327-4cb0-8ec4-a69c4f9d557a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3866, 104, 238, 3, 65, "Section",ExpressionUUID->"e4ff8eb2-42ae-410c-a2c9-3cb3f1517c8f"],
Cell[4107, 109, 12795, 339, 261, "Text",ExpressionUUID->"19831b70-a0bd-483d-bb15-17dec9451b09"],
Cell[16905, 450, 2405, 60, 129, "Input",ExpressionUUID->"84b5851d-6681-4e0d-94e4-78ca64eb0659"],
Cell[19313, 512, 3710, 93, 102, "Text",ExpressionUUID->"380894f6-e983-4edc-bbf0-f6197b1174ed"],
Cell[CellGroupData[{
Cell[23048, 609, 1086, 31, 30, "Input",ExpressionUUID->"2fd5f3ae-5ce1-41f7-8c28-d98d0c320131"],
Cell[24137, 642, 753, 21, 60, "Output",ExpressionUUID->"491a304f-8505-4eed-9998-5c5ae2b1a381"]
}, Open  ]],
Cell[24905, 666, 1288, 35, 49, "Text",ExpressionUUID->"252cf1c3-48e4-453e-9520-4fb2dd00b6a0"],
Cell[26196, 703, 652, 15, 29, "Input",ExpressionUUID->"185149fc-acd5-4ff7-852f-ad6fad984e6f"],
Cell[CellGroupData[{
Cell[26873, 722, 188, 3, 29, "Input",ExpressionUUID->"9b7e0c93-48ec-4460-9cef-423eb13fb446"],
Cell[27064, 727, 9129, 249, 128, "Output",ExpressionUUID->"8787f395-f0a3-4be1-922b-935f2828dd81"]
}, Open  ]],
Cell[36208, 979, 1142, 28, 49, "Text",ExpressionUUID->"6af9bfc7-8501-4190-8432-b933a557f1c1"],
Cell[CellGroupData[{
Cell[37375, 1011, 1220, 30, 29, "Input",ExpressionUUID->"3ec77093-6a38-4d9f-ad18-653f78bf497e"],
Cell[38598, 1043, 16536, 422, 191, "Output",ExpressionUUID->"2e58ca00-9221-4478-a8c7-7c236e339308"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55171, 1470, 858, 21, 49, "Input",ExpressionUUID->"cdbcc8b8-6d76-45a6-be22-0be958a235d9"],
Cell[56032, 1493, 5840, 164, 108, "Output",ExpressionUUID->"741aa644-db2d-47f8-a97a-f01da353847a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61909, 1662, 184, 3, 29, "Input",ExpressionUUID->"3729e6b5-6391-453d-880f-68c1f4bb0396"],
Cell[62096, 1667, 16175, 417, 172, "Output",ExpressionUUID->"c7cae22e-77b8-4ae3-87d9-936a2a11be62"]
}, Open  ]],
Cell[78286, 2087, 357, 7, 49, "Text",ExpressionUUID->"97c9c57e-ef45-4c90-8a17-4fb09ec9776d"],
Cell[78646, 2096, 1377, 37, 29, "Input",ExpressionUUID->"5decfcee-a4f5-44d8-bc14-fbbb7c383bcd"],
Cell[80026, 2135, 1060, 27, 29, "Input",ExpressionUUID->"330a868e-28a5-4232-8f5f-7f42822ee8b6"],
Cell[CellGroupData[{
Cell[81111, 2166, 215, 4, 29, "Input",ExpressionUUID->"7a4912fd-4e01-447a-80b5-83eaceca661f"],
Cell[81329, 2172, 25761, 598, 192, "Output",ExpressionUUID->"b43e8ec6-fd1c-4e37-8246-1d93b7b8f372"]
}, Open  ]],
Cell[CellGroupData[{
Cell[107127, 2775, 504, 12, 29, "Input",ExpressionUUID->"5fab89f3-ade1-48ff-b97a-9b3a0f7c95f9"],
Cell[107634, 2789, 1440, 31, 34, "Output",ExpressionUUID->"86a06b0c-6565-484d-baed-12c5065db219"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[109123, 2826, 176, 3, 65, "Section",ExpressionUUID->"3e788e49-ce48-4ecf-88fe-ba9ef51e07f9"],
Cell[109302, 2831, 421, 9, 71, "Text",ExpressionUUID->"990b261c-bafc-443d-b4d0-40f2ba940581"],
Cell[109726, 2842, 5206, 125, 769, "Input",ExpressionUUID->"2eb26d9d-8944-44d6-b258-52b9995d112b"],
Cell[114935, 2969, 1144, 22, 49, "Input",ExpressionUUID->"baff9253-97b3-4afc-9cd2-e6a4f16af816"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116116, 2996, 219, 4, 65, "Section",ExpressionUUID->"79674b73-5a96-4a9c-8572-ac89011add26"],
Cell[CellGroupData[{
Cell[116360, 3004, 1213, 33, 51, "Input",ExpressionUUID->"bf287cb9-ef86-4554-a9ee-89932bdd07c9"],
Cell[117576, 3039, 386, 5, 33, "Output",ExpressionUUID->"a14ebf68-52be-46f6-a74d-4318e265f0ff"]
}, Open  ]],
Cell[117977, 3047, 1476, 28, 89, "Input",ExpressionUUID->"b6a7c1fd-8556-4949-9a83-86ece6247313"],
Cell[CellGroupData[{
Cell[119478, 3079, 939, 27, 29, "Input",ExpressionUUID->"7fc33ee8-3e79-4ecd-91f3-a325df861ef7"],
Cell[120420, 3108, 535, 12, 26, "Message",ExpressionUUID->"d0bcd6fd-ffb3-4463-bd5c-37ffa6068ba9"],
Cell[120958, 3122, 535, 12, 26, "Message",ExpressionUUID->"deef273b-dd63-462a-8594-d1507569eaff"],
Cell[121496, 3136, 1419, 25, 34, "Output",ExpressionUUID->"cbddd351-3020-4f2e-b549-9668c5e67bb0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[122952, 3166, 582, 15, 29, "Input",ExpressionUUID->"10d7fc81-400d-47cc-9856-d73ed0f7a7f0"],
Cell[123537, 3183, 1386, 24, 33, "Output",ExpressionUUID->"ea7bf538-3260-4a3b-9330-353e0704f567"]
}, Open  ]],
Cell[CellGroupData[{
Cell[124960, 3212, 982, 22, 29, "Input",ExpressionUUID->"7f1af074-8863-4c08-a8c5-ecd2175a9eb5"],
Cell[125945, 3236, 1463, 25, 33, "Output",ExpressionUUID->"7ba27a8d-9eb5-4fb6-9855-580064d8b5f5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[127445, 3266, 387, 9, 29, "Input",ExpressionUUID->"5d50381f-9a28-4ef7-a187-59eddf30237f"],
Cell[127835, 3277, 702, 19, 56, "Output",ExpressionUUID->"3aebd244-9110-4287-aa9b-377daa05c3e9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[128574, 3301, 1369, 37, 89, "Input",ExpressionUUID->"4bf96461-8fbc-4c73-8277-4936b57cb23f"],
Cell[129946, 3340, 38457, 729, 240, "Output",ExpressionUUID->"0dae9a66-f8c0-41ba-94b9-dfb91a8a6928"]
}, Open  ]],
Cell[CellGroupData[{
Cell[168440, 4074, 875, 22, 29, "Input",ExpressionUUID->"f9606913-cbd0-4d6b-888a-021cf65f8f09"],
Cell[169318, 4098, 11806, 272, 240, "Output",ExpressionUUID->"0b034583-4627-4f90-b638-6740728a761b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[181161, 4375, 1676, 40, 29, "Input",ExpressionUUID->"2b2ca814-b3b4-4b89-b49e-254d0449f09d"],
Cell[182840, 4417, 746, 15, 26, "Message",ExpressionUUID->"101e08fb-b1d4-45d0-9810-19ac71e702db"],
Cell[183589, 4434, 746, 15, 26, "Message",ExpressionUUID->"613c8ec5-84cb-4c78-b46b-0c79dad02e07"],
Cell[184338, 4451, 748, 15, 26, "Message",ExpressionUUID->"659a24e3-4586-4ae8-8bb3-7b7f59cd8a27"],
Cell[185089, 4468, 721, 14, 26, "Message",ExpressionUUID->"e041c7dd-31b8-487e-b830-6ff05c8ca8b0"],
Cell[185813, 4484, 4360, 103, 101, "Output",ExpressionUUID->"8afa0d37-a910-43bf-a223-1d57b138eaf0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[190210, 4592, 187, 4, 29, "Input",ExpressionUUID->"58cb79e3-8bcd-4fa3-bea6-322a64accaf6"],
Cell[190400, 4598, 4231, 101, 101, "Output",ExpressionUUID->"8745a192-f746-41c6-92e7-b6087a6e5e3d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[194668, 4704, 494, 13, 29, "Input",ExpressionUUID->"adf9e617-258e-48ef-bf96-21d42dce05e6"],
Cell[195165, 4719, 3382, 96, 97, "Output",ExpressionUUID->"101e0ee6-112d-45cf-abf3-12659d01a60c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[198584, 4820, 3631, 106, 129, "Input",ExpressionUUID->"d0d10491-4559-446b-b2f9-43047ac2dc4c"],
Cell[202218, 4928, 3195, 92, 53, "Output",ExpressionUUID->"3e027e62-3e05-4157-a3b8-dd82a38afa9a"],
Cell[205416, 5022, 3321, 94, 53, "Output",ExpressionUUID->"786eb380-8635-4ab0-97c6-7a24d6f07b5f"],
Cell[208740, 5118, 3130, 91, 53, "Output",ExpressionUUID->"d6ff2352-e216-4baf-bfaa-a7f33ca67a60"],
Cell[211873, 5211, 3289, 94, 53, "Output",ExpressionUUID->"4586f729-1f05-403b-9008-d9e2360bf3c8"],
Cell[215165, 5307, 3126, 91, 53, "Output",ExpressionUUID->"daa8a8dd-b5d1-4eda-8ded-01c855f6c364"],
Cell[218294, 5400, 3286, 94, 53, "Output",ExpressionUUID->"cabc10c3-3046-4195-b27b-77cbcf342932"]
}, Open  ]],
Cell[CellGroupData[{
Cell[221617, 5499, 3357, 91, 169, "Input",ExpressionUUID->"f2a07ac8-6aba-4383-9c9a-bf2db7f86fd4"],
Cell[224977, 5592, 38366, 878, 803, "Output",ExpressionUUID->"98b5b342-dfbb-4302-bc9e-6cbb93fac901"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

