import argparse


parser = argparse.ArgumentParser()
parser.add_argument('--txt', type=str, required=True)
args = parser.parse_args()

with open(args.txt, 'r') as f:
    lines = f.readlines()
    
is_deploy = True # NOTE: change this

if not is_deploy:
    all_leaf_impurity = []
    all_mig = []
    all_modularity = []

    n_lines_in_block = 6
    assert len(lines) % n_lines_in_block == 0
    for block_i in range(len(lines) // n_lines_in_block):
        base_i = block_i * n_lines_in_block
        leaf_impurity = float(lines[base_i + 2].split(' ')[-1].split('\n')[0])
        mig = float(lines[base_i + 4].split(':')[-1].split(' ')[2])
        modularity = float(lines[base_i + 5].split(':')[-1].split(' ')[2])
        
        all_leaf_impurity.append(leaf_impurity)
        all_mig.append(mig)
        all_modularity.append(modularity)

    n_runs = 5
    col_name = 'Q' # NOTE: change this
    assert len(all_modularity) % n_runs == 0
    def print_avg_code(i):
        row_start = (i // n_runs - 1) * (n_runs + 1) + 2
        row_end = row_start + (n_runs - 1)
        print(f'=AVERAGE({col_name}{row_start}:{col_name}{row_end})')
    for ad_i, all_data in enumerate([all_leaf_impurity, all_mig, all_modularity]):
        print(['var', 'mig', 'modularity'][ad_i])
        for i, data in enumerate(all_data):
            if (i != 0) and (i % n_runs == 0):
                print_avg_code(i)
            print(data)
        print_avg_code(i + n_runs)
        print('\n\n')
else:
    all_dp_acc = []
    all_logic_conflict = []
    
    n_lines_in_block = 3
    assert len(lines) % n_lines_in_block == 0
    for block_i in range(len(lines) // n_lines_in_block):
        base_i = block_i * n_lines_in_block
        dp_acc = float(lines[base_i + 1].split('/')[-1])
        logic_conflict = float(lines[base_i + 2].split(':')[-1])
        
        all_dp_acc.append(dp_acc)
        all_logic_conflict.append(logic_conflict)
        
    n_runs = 5
    col_name = 'AA' # NOTE: change this
    assert len(all_dp_acc) % n_runs == 0
    def print_avg_code(i):
        row_start = (i // n_runs - 1) * (n_runs + 1) + 2
        row_end = row_start + (n_runs - 1)
        print(f'=AVERAGE({col_name}{row_start}:{col_name}{row_end})')
    for ad_i, all_data in enumerate([all_dp_acc, all_logic_conflict]):
        print(['dp_acc', 'logic_conflict'][ad_i])
        for i, data in enumerate(all_data):
            if (i != 0) and (i % n_runs == 0):
                print_avg_code(i)
            print(data)
        print_avg_code(i + n_runs)
        print('\n\n')
