# Stable Flight

## Setup

Install packages (TBU).
- Python3.8
- torch
- ray[rllib]==1.11.0
- opencv
- scikit-video
- mlagents_envs==0.28.0
- keras-ncp==2.0.0
- cvxpy
- qpth
- gym==0.15.3
- mlagents_envs==0.28.0

## Usage

Run simple example.
```
$ python envs/example.py --video-path <path-to-save-video> --add-descriptions --use-clf
```

Training.
```
$ export LOCAL_DIR=<dir-to-save-results>
$ python train.py -f ./config/canyonrun-base.yaml --temp-dir <some-place-to-save-dummy>
```

Training with pretrained model (Make sure the pretrained model is a "subset" of the newly-trained model).
```
$ export LOCAL_DIR=<dir-to-save-results>
$ python train.py -f ./config/canyonrun-base.yaml --temp-dir <some-place-to-save-dummy> --restore <path-to-checkpoint>
```

Evaluation.
```
$ python eval.py <path-to-checkpoint> --use-graphics --episodes 3
```

Run policy, collect data, and extract decision tree.
```
$ python eval.py <path-to-checkpoint> --episodes <N> --save-rollout --save-all --out <output-path>
$ python -m misc.extract_decision_tree --pkl-path <path-to-pickle-file> --out-dir <output-directory>
```

Deploy decision tree (need to run `extract_decision_tree` first).
```
$ python -m misc.deploy_decision_tree --results-path <path-to-result-pkl> --dt-path <path-to-dt-pkl> --out-dir <output-directory> --mode action_to_neuron_to_action 
```

Plot NCP.
```
$ python -m misc.plot_ncp <path-to-checkpoint> --out <path-to-saving-plot>
```

Debugging with single process. Also remember to set in the config yaml file `num_workers: 0` and `train_batch_size: 64, sgd_minibatch_size: 64` for faster debugging.
```
$ export LOCAL_DIR=<dir-to-save-results>
$ python train.py -f ./config/canyonrun-base.yaml --temp-dir <some-place-to-save-dummy> --local-mode -vv
```
