import g4f

model = "gpt-4o"  # find models at https://github.com/xtekky/gpt4free/blob/main/g4f/models.py
print(f"querying {model}")


template = "This is a template of clinical findings: \
            \n\nThe patient's cardiac monitoring showed a minimum heart rate of 29 bpm, a maximum of 212 bpm, and an average of 72 bpm. The predominant underlying rhythm was sinus rhythm with first-degree AV block present. 192 episodes of second-degree AV block (Mobitz II) occurred, lasting a total of 1 day 4 hours. There were 4 ventricular tachycardia runs, with the fastest lasting 7 beats at a max rate of 182 bpm, and the longest lasting 16 beats with an average rate of 135 bpm. 5871 supraventricular tachycardia (SVT) runs were recorded, the fastest lasting 12 beats with a max rate of 187 bpm, and the longest lasting 35.3 seconds with an average rate of 133 bpm. Atrial fibrillation occurred with a 12% burden, ranging from 45-212 bpm (average 84 bpm). Three pauses occurred, the longest lasting 5.4 seconds (11 bpm). Supraventricular tachycardia, pauses, AV block, and atrial fibrillation were detected within 45 seconds of patient-triggered/diary events. Isolated SVEs were frequent (5.4%, 76752), SVE couplets were occasional (3.7%, 26323), and SVE triplets were occasional (1.7%, 7781). Isolated VEs were rare (0 to <1.0%, 5154), VE couplets were rare (0 to <1.0%, 19), and VE triplets were rare (0 to <1.0%, 1). Ventricular bigeminy and trigeminy were present. MD notification criteria for rapid atrial fibrillation and AV block were met, and the RN was notified on 03/15/2013 at 12:00 pm CST. \
            \n\nRephrase the following information in same format of findings\n\n"
            
metrics = "test_duration: 21:38\noverall_average_hr: 63\nhrv_sdnn: 997\nbeats_count: 79620\noverall_min_hr: 35\noverall_min_hr_time: 01:03\nhrv_sdnn_index: 234\npace_beats_count: 0\noverall_max_hr: 129\noverall_max_hr_time: 11:13\nhrv_rmssd: 122\nveb_count: 2\nveb_burden: <1%\nminute_min_hr: 44\nminute_min_hr_time: 01:08\nhrv_pnn50: 66\nsveb_count: 0\nsveb_burden: \nminute_max_hr: 100\nminute_max_hr_time: 11:14\nhrv_triangular_index: 26\nbbb_count: 0\nsinus_tachy_count: 0\nsinus_tachy_burden: \nhrv_hf: 4496.4\nother_beats_count: 0\nsinus_brady_count: 0\nsinus_brady_burden: \nhrv_lf: 2628.6\nafib_burden: 100.0%\nlongest_pause_duration: 3.38\nlongest_pause_start_time: 22:58\nhrv_vlf: 874.5\nveb_isolated_count: 2\nsveb_isolated_count: 0\npause_count: 675\nveb_couplet_pairs: 0\nveb_couplet_count: 0\nsveb_couplet_pairs: 0\nsveb_couplet_count: 0\nveb_bigeminy_episodes: 0\nveb_bigeminy_beats_count: 0\nsveb_bigeminy_episodes: 0\nsveb_bigeminy_beats_count: 0\nveb_trigeminy_episodes: 0\nveb_trigeminy_beats_count: 0\nsveb_trigeminy_episodes: 0\nsveb_trigeminy_beats_count: 0\nmax_qt: 416\nvt_count: 0\nvt_beats_count: 0\nsvt_count: 0\nsvt_beats_count: 0\nmax_qtc: 416\nmean_qt: 364\nmean_qtc: 378\nslowest_vt_hr: \nslowest_vt_start_time: \nafib_total_time: 21:41:03"

response = g4f.ChatCompletion.create(
    model=model,
    messages=[
    {
        "role": "user",
        "content": template + metrics
    }
    ],
    temperature=0,
    max_tokens=4096,
    top_p=0,
    frequency_penalty=0,
    presence_penalty=0
)

print()
print(response)
