from transformers import pipeline, set_seed
from transformers import BioGptTokenizer, BioGptForCausalLM

model_name_or_path = "../../../huggingface/BioGPT-Large"

model = BioGptForCausalLM.from_pretrained(model_name_or_path)
tokenizer = BioGptTokenizer.from_pretrained(model_name_or_path)
generator = pipeline('text-generation', model=model, tokenizer=tokenizer, device='cuda:1')
set_seed(42)
rst = generator("COVID-19 is", max_length=1024, num_return_sequences=1, do_sample=True)
print(rst)
