# The augmented image prior: Distilling 1000 classes by extrapolating from a single image
---

## Running the experiments

### Installation
In each folder `cifar\in1k\video` you will find a requirements.txt file. Install packages as follows:
```
pip3 install -r requirements.txt
```

### 1. Prepare Dataset: 
To generate single image data, we refer to the [data_generation folder](data_generation)

### 2. Run Experiments:
There is a main "distill.py" file for each experiment type: small-scale and large-scale images and video.
Note: 2a uses tensorflow and 2b, 2c use pytorch.

#### 2a. Run distillation experiments for *CIFAR-10/100*
e.g. with Animal single-image dataset as follows:
```sh
# in cifar folder:
python3 distill.py --dataset=cifar10 --image=/path/to/single_image_dataset/ \
                   --student=wrn_16_4 --teacher=wrn_40_4 
```
Note that we provide a pretrained teacher model for reproducibility.

#### 2b. Run distillation experiments for *ImageNet* with single-image dataset as follows:
```sh
# in in1k folder:
python3 distill.py --dataset=in1k --testdir /ILSVRC12/val/ \
                   --traindir=/path/to/dataset/ --student_arch=resnet50 --teacher_arch=resnet18 
```
Note that teacher models are automatically downloaded from torchvision or timm. 


#### 2c. Run distillation experiments for *Kinetics* with single-image-created video dataset as follows:
```sh
# in video folder:
python3 distill.py --dataset=k400 --traindir=/dataset/with/vids --test_data_path /path/to/k400/val 
```
Note that teacher models are automatically downloaded from torchvideo when you distill a K400 model.