'''
create_seed.py


input:
evaluation metrics of 200 population in the final generation

output:
A combined file seed.mot containing muscle parameters with its associated metrics
'''

import os
from pathlib import Path

# If seed.mot exists, delete it 
if os.path.exists('seed.mot'):
    os.remove('seed.mot')

fw = open('seed.mot','w')

# Get all rmse*.mot files
rmse_files = Path('.').rglob('rmse*.mot')
for file in rmse_files:
    f = open(file,'r')
    lines = f.readlines()
    msg = ''
    for line in lines:
        temp_split = line.split()
        for tmp in temp_split:
            msg = msg+tmp+'\t'
    fw.write(msg+'\n')
    f.close()
fw.close()
