# Optimization of muscle parameters with GeatPY

## Introduction

This folder contains scripts to find optimized muscle parameters around their physiologically determined initial values. The FeTi folder contained a fully working example for the FeTi joint with 2 muscles. The CoTr and ThCo folder contained optimization codes for CoTr joint with 6 muscles and ThCo joint with 7 muscles. The models for the above two joints were not released at the time.

## Walkthrough
To run the optimization pipeline, first launch the parent script to evoke child thread for optimzation with background mode:

For warm-start with more aggresive hyper-parameters, ensure `seed.txt` with last generation parameters is within log folder.
```
cd FeTi
nohup python tibia_opt.py > terminal.log &
```

In case an early termination is needed, record the pid of process and use `kill -9`

```
ps ax | grep _opt.py_
kill -9
```

After optimization ended, combine the parameters and metrics of last generation population with

```
python create_seed.py
```

A filtering involving human effort is needed on the generated `seed.txt` file to remove worse individuals. The filtered individuals are used to update the model file with

```
python parameter2osim.py {base osim file} seed.mot {target osim file}
```

A validation with SO-FD pipeline could then be excuted on the resulting model for a sanity check of selected muscle parameters.