# Data-driven Hill-type muscle modeling for _Drosophila_ leg control

This repository contains the code and data for optimization of muscle parameters in OpenSim.

This repository hosts:

- Optimizes unknown parameters of Hill-type muscle models.
- Models front-leg muscles and validates them with open-loop control of grooming behaviors (no residual actuators needed).
- Converts OpenSim models with muscles into MuJoCo and validates consistency (see `models/Myoconverter_report.pdf`).
- Analyzes muscle function during fly behaviors.

## Dependencies

| **Tested on**   |**Dependent on** |
| -- | -- |
|![Ubuntu-22.04](https://img.shields.io/badge/Ubuntu-22.04-blue.svg) |![OpenSim](https://img.shields.io/badge/OpenSim-4.4-green.svg) ![MuJoCo](https://img.shields.io/badge/MuJoCo-2.3.5-green.svg) ![GeatPy](https://img.shields.io/badge/GeatPy-2.7.0-green.svg)|


| **Enviroment**   | **Python** | **Usage** |
| -- | -- | -- |
| `optimization_env.txt` | 3.8.10 | optimize OpenSim muscle parameters |


## Repository Structure

```
├── data
│   ├── kinematics       # Joint tracking & motion files
├── models               # Final OpenSim and MuJoCo models
├── optimization
│   ├── OpenSim          # Parameter optimization scripts/files, a working example is provided for Femur-Tibia joint muscles
├── scripts
│   ├── catmaid scripts         # scripts to extract from catmaid micro-scan muscle parameters
│   ├── conversion scripts       # scripts to convert pickle files to in data/kinematics/ to motion
├── optimization_env.txt
```
