/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.lmdbjni;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public enum ByteUnit {
    BYTES{

        @Override
        public long convert(long sourceCount, ByteUnit sourceUnit) {
            return sourceUnit.toBytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return count;
        }

        @Override
        public long toKibibytes(long count) {
            return count / 1024L;
        }

        @Override
        public long toMebibytes(long count) {
            return count / 0x100000L;
        }

        @Override
        public long toGibibytes(long count) {
            return count / 0x40000000L;
        }

        @Override
        public long toTebibytes(long count) {
            return count / 0x10000000000L;
        }

        @Override
        public long toPebibytes(long count) {
            return count / 0x4000000000000L;
        }
    }
    ,
    KIBIBYTES{

        @Override
        public long convert(long sourceCount, ByteUnit sourceUnit) {
            return sourceUnit.toKibibytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return ByteUnit.multiply(count, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toKibibytes(long count) {
            return count;
        }

        @Override
        public long toMebibytes(long count) {
            return count / 1024L;
        }

        @Override
        public long toGibibytes(long count) {
            return count / 0x100000L;
        }

        @Override
        public long toTebibytes(long count) {
            return count / 0x40000000L;
        }

        @Override
        public long toPebibytes(long count) {
            return count / 0x10000000000L;
        }
    }
    ,
    MEBIBYTES{

        @Override
        public long convert(long sourceCount, ByteUnit sourceUnit) {
            return sourceUnit.toMebibytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return ByteUnit.multiply(count, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toKibibytes(long count) {
            return ByteUnit.multiply(count, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toMebibytes(long count) {
            return count;
        }

        @Override
        public long toGibibytes(long count) {
            return count / 1024L;
        }

        @Override
        public long toTebibytes(long count) {
            return count / 0x100000L;
        }

        @Override
        public long toPebibytes(long count) {
            return count / 0x40000000L;
        }
    }
    ,
    GIBIBYTES{

        @Override
        public long convert(long sourceCount, ByteUnit sourceUnit) {
            return sourceUnit.toGibibytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return ByteUnit.multiply(count, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toKibibytes(long count) {
            return ByteUnit.multiply(count, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toMebibytes(long count) {
            return ByteUnit.multiply(count, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toGibibytes(long count) {
            return count;
        }

        @Override
        public long toTebibytes(long count) {
            return count / 1024L;
        }

        @Override
        public long toPebibytes(long count) {
            return count / 0x100000L;
        }
    }
    ,
    TEBIBYTES{

        @Override
        public long convert(long sourceCount, ByteUnit sourceUnit) {
            return sourceUnit.toTebibytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return ByteUnit.multiply(count, 0x10000000000L, 0x7FFFFFL);
        }

        @Override
        public long toKibibytes(long count) {
            return ByteUnit.multiply(count, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toMebibytes(long count) {
            return ByteUnit.multiply(count, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toGibibytes(long count) {
            return ByteUnit.multiply(count, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toTebibytes(long count) {
            return count;
        }

        @Override
        public long toPebibytes(long count) {
            return count / 1024L;
        }
    }
    ,
    PEBIBYTES{

        @Override
        public long convert(long sourceCount, ByteUnit sourceUnit) {
            return sourceUnit.toPebibytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return ByteUnit.multiply(count, 0x4000000000000L, 8191L);
        }

        @Override
        public long toKibibytes(long count) {
            return ByteUnit.multiply(count, 0x10000000000L, 0x7FFFFFL);
        }

        @Override
        public long toMebibytes(long count) {
            return ByteUnit.multiply(count, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toGibibytes(long count) {
            return ByteUnit.multiply(count, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toTebibytes(long count) {
            return ByteUnit.multiply(count, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toPebibytes(long count) {
            return count;
        }
    };

    private static final long B = 1L;
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final long TB = 0x10000000000L;
    private static final long PB = 0x4000000000000L;
    private static final long MAX = Long.MAX_VALUE;
    private static final String[] UNITS;
    static final String DEFAULT_FORMAT_PATTERN = "#,##0.#";

    public long toBytes(long count) {
        throw new AbstractMethodError();
    }

    public long convert(long sourceCount, ByteUnit sourceUnit) {
        throw new AbstractMethodError();
    }

    public long toKibibytes(long count) {
        throw new AbstractMethodError();
    }

    public long toMebibytes(long count) {
        throw new AbstractMethodError();
    }

    public long toGibibytes(long count) {
        throw new AbstractMethodError();
    }

    public long toTebibytes(long count) {
        throw new AbstractMethodError();
    }

    public long toPebibytes(long count) {
        throw new AbstractMethodError();
    }

    public static String format(long bytes) {
        return ByteUnit.format(bytes, new DecimalFormat(DEFAULT_FORMAT_PATTERN));
    }

    public static String format(long bytes, String pattern) {
        return ByteUnit.format(bytes, new DecimalFormat(pattern));
    }

    public static String format(long bytes, NumberFormat format) {
        double count;
        if (bytes < 0L) {
            throw new IllegalArgumentException("bytes < 0: " + bytes);
        }
        int unitIndex = 0;
        for (count = (double)bytes; count >= 1024.0 && unitIndex < UNITS.length - 1; count /= 1024.0, ++unitIndex) {
        }
        return format.format(count) + ' ' + UNITS[unitIndex];
    }

    private static long multiply(long size, long factor, long over) {
        if (size > over) {
            return Long.MAX_VALUE;
        }
        if (size < -over) {
            return Long.MIN_VALUE;
        }
        return size * factor;
    }

    static {
        UNITS = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB"};
    }
}

